<?php  
/******* CUSTOM POST TYPE: JOBS *********/

add_action('init', 'job_register');

function job_register() {
	$args = array(
		'label' => __('Jobs'),
		'singular_label' => __('Job'),
		'public' => true,
		'show_ui' => true,
		'capability_type' => 'post',
		'hierarchical' => false,
		'rewrite' => true,
		'supports' => array('title', 'editor')
	);

	register_post_type( 'job' , $args );
}

	add_action("admin_init", "job_admin_init");
	add_action('save_post', 'save_job_meta');

	function job_admin_init(){
		add_meta_box("job_meta", "Job Options", "job_meta_options", "job", "normal", "core");
	}

	function job_meta_options(){
		global $post;
		$custom = get_post_custom($post->ID);
		$job_clinic = $custom["job_clinic"][0];
		$job_supervisor = $custom["job_supervisor"][0];
		$job_type = $custom["job_type"][0];
		$job_hours = $custom["job_hours"][0];
		$job_salary = $custom["job_salary"][0];
		$job_salarytype = $custom["job_salarytype"][0];
	
?>
	<h2 style="clear:left;margin:20px 0 0 15px;">Location</h2>
	<div style="float:left;padding:5px 15px;">
		<label for="job_clinic">Clinic </label>
		<input type="text" name="job_clinic" size="30" autocomplete="on" value="<?php echo $job_clinic; ?>">
	</div>
	<div style="float:left;padding:5px 15px;">
		<label for="job_supervisor">Supervisor </label>
		<input type="text" name="job_supervisor" size="30" autocomplete="on" value="<?php echo $job_supervisor; ?>">
	</div>
	<div style="float:left;clear:left;">
		<h2 style="clear:left;margin:20px 0 0 15px;">Details</h2>
		<div style="float:left;padding:5px 15px;">
			<label for="job_type">Type </label>
			<select name="job_type" id="job_type">
				<option value="">Select one</option>
				<option value="Full Time"<?php if ($job_type=="Full Time") echo " selected" ?>>Full Time</option>
				<option value="Part Time"<?php if ($job_type=="Part Time") echo " selected" ?>>Part Time</option>
				<option value="Temporary Full Time"<?php if ($job_type=="Temporary Full Time") echo " selected" ?>>Temporary Full Time</option>
				<option value="Temporary Part Time"<?php if ($job_type=="Temporary Part Time") echo " selected" ?>>Temporary Part Time</option>
			</select>
		</div>
		<div style="float:left;padding:5px 15px;">
			<label for="job_hours">Hours </label>
			<input type="text" name="job_hours" size="5" autocomplete="on" value="<?php echo $job_hours; ?>">
		</div>
		<div style="float:left;padding:5px 15px;">
			<label for="job_salary">Salary $</label>
			<input type="text" name="job_salary" size="10" autocomplete="on" value="<?php echo $job_salary; ?>">
			<select name="job_salarytype" id="job_salarytype">
				<option value="">Select one</option>
				<option value="per Hour"<?php if ($job_salarytype=="per Hour") echo " selected" ?>>per Hour</option>
				<option value="per Week"<?php if ($job_salarytype=="per Week") echo " selected" ?>>per Week</option>
				<option value="per Year"<?php if ($job_salarytype=="per Year") echo " selected" ?>>per Year</option>
			</select>
		</div>
	</div>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
	<p>&nbsp;</p>
<?php
	}

function save_job_meta(){
	global $post;
	update_post_meta($post->ID, "job_clinic", $_POST["job_clinic"]);
	update_post_meta($post->ID, "job_supervisor", $_POST["job_supervisor"]);
	update_post_meta($post->ID, "job_type", $_POST["job_type"]);
	update_post_meta($post->ID, "job_hours", $_POST["job_hours"]);
	update_post_meta($post->ID, "job_salary", $_POST["job_salary"]);
	update_post_meta($post->ID, "job_salarytype", $_POST["job_salarytype"]);
}

add_filter("manage_edit-job_columns", "job_edit_columns");
add_action("manage_posts_custom_column",  "job_custom_columns");

function job_edit_columns($columns){
		$columns = array(
			"cb" => "<input type=\"checkbox\" />",
			"title" => "Name",
			"job_clinic" => "Clinic",
			"job_supervisor" => "Supervisor",
			"job_type" => "Type",
			"job_hours" => "Hours",
			"job_salary" => "Salary",
		);

		return $columns;
}

function job_custom_columns($column){
		global $post;
		switch ($column)
		{
			case "job_clinic":
				$custom = get_post_custom();
				echo $custom["job_clinic"][0];
				break;
			case "job_supervisor":
				$custom = get_post_custom();
				echo $custom["job_supervisor"][0];
				break;
			case "job_type":
				$custom = get_post_custom();
				echo $custom["job_type"][0];
				break;
			case "job_hours":
				$custom = get_post_custom();
				echo $custom["job_hours"][0];
				break;
			case "job_salary":
				$custom = get_post_custom();
				$test=$custom["job_salary"][0]; if(!empty($test)): echo "$ " . $custom["job_salary"][0]; endif;
				echo " " . $custom["job_salarytype"][0];
				break;
		}
}
?>