<?php // Set default paths for our function files
$functions_path = TEMPLATEPATH . '/functions/';

// Create main Company Information panel
require_once ($functions_path . 'company-info.php');

// CUSTOM WIDGETS require_once ($functions_path . 'widgets.php');
// JOBS POST TYPE require_once ($functions_path . 'post_types.php');
// SITE INSTRUCTIONS PANEL require_once ($functions_path . 'site-instructions.php');
?>
<?php 
// adds do shortcode function to allow for nesting of shortcodes	
	add_filter('the_content', 'do_shortcode'); 
?>
<?php
        add_filter('admin_user_info_links','not_howdy');
 
        function not_howdy($links) {
                $greeting = 'Welcome';
                $links['5'] = str_replace('Howdy',$greeting, $links['5']);
                return $links;
        }
?>
<?php //hook the administrative header output
add_action('admin_head', 'my_custom_logo');

function my_custom_logo() {
   echo '
      <style type="text/css">
         #header-logo { background-image: url('.get_bloginfo('template_directory').'/images/altra-admin-logo.png) !important; width:75px!important; height: 50px!important; }
      </style>';
	}; 
?>
<?php include(TEMPLATEPATH."/tools/breadcrumb-navigation-xt.php");?>
<?php 
	if ( function_exists('register_sidebars') )  
	register_sidebars(1, array(
        'before_widget' => '<div id="%1$s" class="sidebar_wrap">',
		'before_title' => '<div class="side-heading"><h3>',
        'after_title' => '</h3></div><div class="sidebar_content_padding">',
		'after_widget' => '<div class="clearboth"></div></div></div>',
       ));
?>
<?php
// adds support for post thumbnails default settings 
	add_theme_support( 'post-thumbnails' ); 
?>
<?php function the_content_limit($max_char, $more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {
    $content = get_the_content($more_link_text, $stripteaser, $more_file);
    $content = apply_filters('the_content', $content);
    $content = str_replace(']]>', ']]&gt;', $content);
    $content = strip_tags($content);

   if (strlen($_GET['p']) > 0) {
      echo "<p>";
      echo $content;
      echo "&nbsp;<a href='";
      the_permalink();
      echo "'>"."Read More &rarr;</a>";
      echo "</p>";
   }
   else if ((strlen($content)>$max_char) && ($espacio = strpos($content, " ", $max_char ))) {
        $content = substr($content, 0, $espacio);
        $content = $content;
        echo "<p>";
        echo $content;
        echo "...";
        echo "&nbsp;<a class='more-link' href='";
        the_permalink();
        echo "'>".$more_link_text."</a>";
        echo "</p>";
   }
   else {
      echo "<p>";
      echo $content;
      echo "&nbsp;<a href='";
      the_permalink();
      echo "'>"."Read More &rarr;</a>";
      echo "</p>";
   }
}
?>
<?php function catch_that_image() {
  global $post, $posts;
  $first_img = '';
  ob_start();
  ob_end_clean();
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  $first_img = $matches [1] [0];

  if(empty($first_img)){ //Defines a default image
    $first_img = "wp-content/themes/altra2_0/images/default.jpg";
  }
  return $first_img;
}
?>
<?php 
	function slide($atts, $content = null) {
	extract(shortcode_atts(array(
	"title" => ''), 
	$atts));
	return '<a class="slide">'.$title.'</a><p class="slide-next">'.$content.'</p>';

	}
	add_shortcode('slide', 'slide');
//Google Maps Shortcode
	function fn_googleMaps($atts, $content = null) {
   	extract(shortcode_atts(array(
    "width" => '640',
    "height" => '480',
    "src" => ''
   	), $atts));
   	return '<div class="google-map"><iframe width="'.$width.'" height="'.$height.'" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="'.$src.'&amp;output=embed"></iframe></div>';
	}
	add_shortcode("googlemap", "fn_googleMaps");
// adds the a style sheet reference to the content editor (uses editor-style.css)
	add_editor_style(); 
//[checklist] shortcode adds checklist div to content contained inside
	function checklist($atts, $content = null) {
	return '<div class="checklist">'.$content.'</div>';
	}
	add_shortcode('checklist', 'checklist');
//[floatright ] adds special div to put content into a div useful for right/left floating a group of photos or text
	function floatright($atts, $content = null) {
	return '<div class="floatright">'.$content.'</div>';
	}
	add_shortcode('floatright', 'floatright');
//[floatleft]adds special div to put content into a div useful for right/left floating a group of photos or text
	function floatleft($atts, $content = null) {
	return '
	<div class="floatleft">'.$content.'</div>';
	}
	add_shortcode('floatleft', 'floatleft');
//[listtreatment] shortcode adds a class of checklist to a list of the services pages
	function listtreatment() {
	$list = wp_list_pages("title_li=&child_of=33&depth=1&echo=0");
    return '<div class="checklist"><ul>'.$list.'</ul></div>';
	}
	add_shortcode('listtreatment', 'listtreatment');
//[servicedropdown] shortcode allows a pulldown menu of just the services pages.
	function servicedropdown() { 
	$dropdown = wp_dropdown_pages("child_of=18&echo=0");
	return '<div><p>Choose a service page:</p><form action="<?php bloginfo("url"); ?>'.$dropdown.'<input type="submit" name="submit" value="Go" /></form></div>';
	}
	add_shortcode('servicedropdown', 'servicedropdown');
// [infobox] shortcode allows contents to be surrounded by a div named infobox
 	function infobox($atts, $content = null){
	return '<div class="infobox">'.$content.'</div>';
	}
	add_shortcode('infobox', 'infobox');
// [requestquote] shortcode inserts text and a button to request a quote 
	function requestquote(){
	$templatelink = get_bloginfo("template_url");
	return '<div class="requestquote"><a href="request-a-quote" /><img src="'.$templatelink.'/images/request-a-quote.png" width="159" height="62"></a></div>';
	}	
	add_shortcode('requestquote', 'requestquote')
?>
<?php 
//adds [thirdbox] shortcode to add one-third sized columns shortcode
	function one_third_columns($atts, $content = null){
	return '<div class="thirdbox">'.$content.'</div>';
	}
	add_shortcode('thirdbox', 'one_third_columns');
//adds [thirdbox-last] shortcode to one-third sized columns
	function one_third_columns_last($atts, $content = null){
	return '<div class="thirdboxlast thirdbox">'.$content.'</div>';
	}
	add_shortcode('thirdboxlast', 'one_third_columns_last');
?>
<?php  
// [divider] shortcode adds a custom divider on the page
	function divider($atts, $content = null){
	return '<hr class="divider"/>';
	}
	add_shortcode('divider', 'divider');
// replace the ... in an excerpt with text	
	function replace_excerpt($content) {
       return str_replace('[...]',
               '<span class="more">[More...]</span>',
               $content
       );
}
add_filter('the_excerpt', 'replace_excerpt');
### remove unwanted items from head
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_generator');
?>
