DROP TABLE IF EXISTS wp_blc_filters;

CREATE TABLE `wp_blc_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS wp_blc_instances;

CREATE TABLE `wp_blc_instances` (
  `instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int(10) unsigned NOT NULL,
  `container_id` int(10) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL DEFAULT 'post',
  `link_text` varchar(250) NOT NULL DEFAULT '',
  `parser_type` varchar(40) NOT NULL DEFAULT 'link',
  `container_field` varchar(250) NOT NULL DEFAULT '',
  `link_context` varchar(250) NOT NULL DEFAULT '',
  `raw_url` text NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=MyISAM AUTO_INCREMENT=862 DEFAULT CHARSET=utf8;

INSERT INTO wp_blc_instances VALUES('462', '26', '35', 'page', 'The role of TNF-alpha signaling pathway on COX-2 upregulation and cognitive decline induced by beta-amyloid peptide.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20122965');
INSERT INTO wp_blc_instances VALUES('461', '25', '35', 'page', 'An association study of 21 potential Alzheimer\'s disease risk genes in a Finnish population.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20693638');
INSERT INTO wp_blc_instances VALUES('460', '24', '35', 'page', 'The roles of TNF in brain dysfunction and disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20813131');
INSERT INTO wp_blc_instances VALUES('459', '23', '35', 'page', 'Tumor necrosis factor-alpha mediated signaling in neuronal homeostasis and dysfunction.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20096353');
INSERT INTO wp_blc_instances VALUES('855', '114', '6', 'page', 'Download a copy of Dr Tobinick\'s Curriculum Vitae PDF Here', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/about-the-institute/attachment/cv-et_-sept2010-final2_/');
INSERT INTO wp_blc_instances VALUES('801', '78', '37', 'page', '', 'image', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/traumatic-brain-injury-photo-300x300.jpg');
INSERT INTO wp_blc_instances VALUES('800', '69', '37', 'page', 'visit the INR Stroke website', 'link', 'post_content', '', 'http://www.painbreakthrough.com');
INSERT INTO wp_blc_instances VALUES('458', '12', '35', 'page', 'Intrathecal inflammation precedes development of Alzheimer\'s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12933918');
INSERT INTO wp_blc_instances VALUES('457', '11', '35', 'page', 'Systemic inflammation and disease progression in Alzheimer disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19738171');
INSERT INTO wp_blc_instances VALUES('456', '10', '35', 'page', 'Inflammation and anti-inflammatory strategies for Alzheimer\'s disease--a mini-review.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19752507');
INSERT INTO wp_blc_instances VALUES('455', '15', '35', 'page', 'Rapid intracerebroventricular delivery of Cu-DOTA-etanercept after peripheral administration demonstrated by PET imaging.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19284700');
INSERT INTO wp_blc_instances VALUES('454', '22', '35', 'page', 'Perispinal etanercept: potential as an Alzheimer therapeutic.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18186919');
INSERT INTO wp_blc_instances VALUES('453', '21', '35', 'page', 'TNF-alpha modulation for treatment of Alzheimer’s disease: a 6-month pilot study.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/16926764');
INSERT INTO wp_blc_instances VALUES('452', '20', '35', 'page', 'Rapid cognitive improvement in Alzheimer’s disease following perispinal etanercept administration.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18184433');
INSERT INTO wp_blc_instances VALUES('451', '19', '35', 'page', 'Perispinal etanercept for treatment of Alzheimer’s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18220520');
INSERT INTO wp_blc_instances VALUES('450', '18', '35', 'page', 'Rapid improvement in verbal fluency and aphasia following perispinal etanercept in Alzheimer’s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18644112');
INSERT INTO wp_blc_instances VALUES('449', '17', '35', 'page', 'Perispinal etanercept produces rapid improvement in primary progressive aphasia: identification of a novel, rapidly reversible TNF-mediated pathophysiologic mechanism.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18679537');
INSERT INTO wp_blc_instances VALUES('314', '67', '473', 'page', 'Anti-TNF-alpha reduces amyloid plaques and tau phosphorylation and induces CD11c-positive dendritic-like cell in the APP/PS1 transgenic mouse brains', 'link', 'post_content', '', 'http://www.sciencedirect.com/science?_ob=ArticleURL&_udi=B6SYR-519218J-5&_user=4423&_coverDate=10%2F21%2F2010&_rdoc=70&_fmt=high&_orig=browse&_origin=browse&_zone=rslt_list_item&_srch=doc-info(%23toc%234841%239999%23999999999%2399999%23FLA%23display%23Articles)&_cdi=4841&_sort=d&_docanchor=&_ct=177&_acct=C000059605&_version=1&_urlVersion=0&_userid=4423&md5=70889cbb3dd55c11347394bacde45b6f&searchtype=a');
INSERT INTO wp_blc_instances VALUES('448', '16', '35', 'page', 'Perispinal etanercept for neuroinflammatory disorders.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19027875');
INSERT INTO wp_blc_instances VALUES('447', '14', '35', 'page', 'Tumour necrosis factor modulation for treatment of Alzheimer’s disease: rationale and current evidence.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19689163');
INSERT INTO wp_blc_instances VALUES('446', '13', '35', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('445', '80', '35', 'page', 'To get started, you can complete the form at this page.', 'link', 'post_content', '', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_blc_instances VALUES('858', '104', '60', 'page', 'Map &amp; Directions', 'link', 'post_content', '', 'http://www.strokebreakthrough.com/contact/orange-county-office/');
INSERT INTO wp_blc_instances VALUES('601', '44', '63', 'page', '', 'image', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small2-240x300.jpg');
INSERT INTO wp_blc_instances VALUES('768', '16', '65', 'page', 'Perispinal etanercept for neuroinflammatory disorders.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19027875');
INSERT INTO wp_blc_instances VALUES('769', '17', '65', 'page', 'Perispinal etanercept produces rapid improvement in primary progressive aphasia: identification of a novel, rapidly reversible TNF-mediated pathophysiologic mechanism.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18679537');
INSERT INTO wp_blc_instances VALUES('770', '18', '65', 'page', 'Rapid improvement in verbal fluency and aphasia following perispinal etanercept in Alzheimer\'s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18644112');
INSERT INTO wp_blc_instances VALUES('771', '46', '65', 'page', 'Re: Inflammatory markers and the risk of Alzheimer disease: the Framingham Study.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18378889');
INSERT INTO wp_blc_instances VALUES('772', '19', '65', 'page', 'Perispinal etanercept for treatment of Alzheimer\'s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18220520');
INSERT INTO wp_blc_instances VALUES('773', '47', '65', 'page', 'A critique of intradiscal administration for treatment of radiculopathy.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18212586');
INSERT INTO wp_blc_instances VALUES('774', '20', '65', 'page', 'Rapid cognitive improvement in Alzheimer\'s disease following perispinal etanercept administration.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18184433');
INSERT INTO wp_blc_instances VALUES('775', '48', '65', 'page', 'Spinal delivery of p38: TNF-alpha inhibitors.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/17132064');
INSERT INTO wp_blc_instances VALUES('776', '21', '65', 'page', 'TNF-alpha modulation for treatment of Alzheimer\'s disease: a 6-month pilot study.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/16926764');
INSERT INTO wp_blc_instances VALUES('777', '49', '65', 'page', 'The cerebrospinal venous system: anatomy, physiology, and clinical implications.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/16915183');
INSERT INTO wp_blc_instances VALUES('778', '50', '65', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('794', '11', '65', 'page', 'Systemic inflammation and disease progression in Alzheimer disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19738171');
INSERT INTO wp_blc_instances VALUES('795', '28', '65', 'page', 'Paths to acceptance. The advancement of scientific knowledge is an uphill struggle against \'accepted wisdom\'.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765');
INSERT INTO wp_blc_instances VALUES('793', '10', '65', 'page', 'Inflammation and anti-inflammatory strategies for Alzheimer\'s disease--a mini-review.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19752507');
INSERT INTO wp_blc_instances VALUES('312', '57', '254', 'page', 'Higher Serum sTNFR1 Level Predicts Conversion from Mild Cognitive Impairment to Alzheimer\'s Disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20930310');
INSERT INTO wp_blc_instances VALUES('611', '54', '30', 'page', '', 'image', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small-240x300.jpg');
INSERT INTO wp_blc_instances VALUES('610', '71', '30', 'page', '', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small.jpg');
INSERT INTO wp_blc_instances VALUES('311', '25', '254', 'page', 'An association study of 21 potential Alzheimer\'s disease risk genes in a Finnish population.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20693638');
INSERT INTO wp_blc_instances VALUES('310', '32', '254', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('309', '56', '254', 'page', 'Anti-TNF-alpha  reduces amyloid plaques and tau phosphorylation and induces  CD11c-positive dendritic-like cell in the APP/PS1 transgenic mouse  brains.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20971085');
INSERT INTO wp_blc_instances VALUES('318', '57', '306', 'post', 'Higher Serum sTNFR1 Level Predicts Conversion from Mild Cognitive Impairment to Alzheimer\'s Disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20930310');
INSERT INTO wp_blc_instances VALUES('317', '25', '306', 'post', 'An association study of 21 potential Alzheimer\'s disease risk genes in a Finnish population.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20693638');
INSERT INTO wp_blc_instances VALUES('316', '32', '306', 'post', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('315', '56', '306', 'post', 'Anti-TNF-alpha    reduces amyloid plaques and tau phosphorylation and induces    CD11c-positive dendritic-like cell in the APP/PS1 transgenic mouse    brains.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20971085');
INSERT INTO wp_blc_instances VALUES('324', '59', '2', 'blogroll', 'WordPress Blog', 'url_field', 'link_url', '', 'http://wordpress.org/development/');
INSERT INTO wp_blc_instances VALUES('323', '60', '3', 'blogroll', 'Suggest Ideas', 'url_field', 'link_url', '', 'http://wordpress.org/extend/ideas/');
INSERT INTO wp_blc_instances VALUES('322', '61', '4', 'blogroll', 'Support Forum', 'url_field', 'link_url', '', 'http://wordpress.org/support/');
INSERT INTO wp_blc_instances VALUES('321', '62', '5', 'blogroll', 'Plugins', 'url_field', 'link_url', '', 'http://wordpress.org/extend/plugins/');
INSERT INTO wp_blc_instances VALUES('320', '63', '6', 'blogroll', 'Themes', 'url_field', 'link_url', '', 'http://wordpress.org/extend/themes/');
INSERT INTO wp_blc_instances VALUES('319', '64', '7', 'blogroll', 'WordPress Planet', 'url_field', 'link_url', '', 'http://planet.wordpress.org/');
INSERT INTO wp_blc_instances VALUES('854', '88', '6', 'page', 'collaborative research with scientists from Stanford University School of Medicine', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/tobinick.stanford.pdf');
INSERT INTO wp_blc_instances VALUES('427', '50', '33', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('426', '13', '33', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('425', '66', '33', 'page', '', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481.jpg');
INSERT INTO wp_blc_instances VALUES('792', '27', '65', 'page', 'Soluble TNF receptors are associated with A-beta metabolism and conversion to dementia in subjects with mild cognitive impairment.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19070941');
INSERT INTO wp_blc_instances VALUES('444', '90', '35', 'page', 'Click here to visit our Alzheimer\'s Breakthrough website', 'link', 'post_content', '', 'http://www.nrimed.com');
INSERT INTO wp_blc_instances VALUES('852', '86', '6', 'page', 'Nature Clinical Practice Neurology', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/ncpn.pdf');
INSERT INTO wp_blc_instances VALUES('853', '87', '6', 'page', 'F1000 Biology', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/tobinick.f1000.pdf');
INSERT INTO wp_blc_instances VALUES('851', '85', '6', 'page', ' publications', 'link', 'post_content', '', 'http://scholar.google.com/scholar?hl=en&q=tobinick&as_sdt=1%2C5&as_ylo=&as_vis=0');
INSERT INTO wp_blc_instances VALUES('850', '85', '6', 'page', 'INR', 'link', 'post_content', '', 'http://scholar.google.com/scholar?hl=en&q=tobinick&as_sdt=1%2C5&as_ylo=&as_vis=0');
INSERT INTO wp_blc_instances VALUES('791', '26', '65', 'page', 'The role of TNF-alpha signaling pathway on COX-2 upregulation and cognitive decline induced by beta-amyloid peptide.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20122965');
INSERT INTO wp_blc_instances VALUES('788', '23', '65', 'page', 'Tumor necrosis factor-alpha mediated signaling in neuronal homeostasis and dysfunction.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20096353');
INSERT INTO wp_blc_instances VALUES('789', '24', '65', 'page', 'The roles of TNF in brain dysfunction and disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20813131');
INSERT INTO wp_blc_instances VALUES('790', '25', '65', 'page', 'An association study of 21 potential Alzheimer\'s disease risk genes in a Finnish population.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20693638');
INSERT INTO wp_blc_instances VALUES('313', '69', '462', 'page', 'www.painbreakthrough.com', 'link', 'post_content', '', 'http://www.painbreakthrough.com');
INSERT INTO wp_blc_instances VALUES('442', '90', '35', 'page', 'INR Alzheimer website', 'link', 'post_content', '', 'http://www.nrimed.com');
INSERT INTO wp_blc_instances VALUES('443', '90', '35', 'page', 'INR Alzheimer treatment program', 'link', 'post_content', '', 'http://www.nrimed.com');
INSERT INTO wp_blc_instances VALUES('441', '79', '35', 'page', '', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/2010/10/bigstock_Elder_Man_Sitting_On_A_Wheelch_6065535.jpg');
INSERT INTO wp_blc_instances VALUES('787', '22', '65', 'page', 'Perispinal etanercept: potential as an Alzheimer therapeutic.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18186919');
INSERT INTO wp_blc_instances VALUES('861', '84', '67', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients', 'link', 'post_content', '', 'http://www.painbreakthrough.com/');
INSERT INTO wp_blc_instances VALUES('860', '13', '67', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('859', '83', '67', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('779', '51', '65', 'page', 'Targeted etanercept for treatment-refractory pain due to bone metastasis: two case reports.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134');
INSERT INTO wp_blc_instances VALUES('686', '70', '47', 'page', 'Rapid improvement of chronic stroke deficits after perispinal etanercept: three consecutive cases', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21254790');
INSERT INTO wp_blc_instances VALUES('848', '85', '6', 'page', '500 scientific citations', 'link', 'post_content', '', 'http://scholar.google.com/scholar?hl=en&q=tobinick&as_sdt=1%2C5&as_ylo=&as_vis=0');
INSERT INTO wp_blc_instances VALUES('849', '85', '6', 'page', ' to ', 'link', 'post_content', '', 'http://scholar.google.com/scholar?hl=en&q=tobinick&as_sdt=1%2C5&as_ylo=&as_vis=0');
INSERT INTO wp_blc_instances VALUES('847', '32', '6', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('845', '75', '6', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('846', '76', '6', 'page', 'Direct application of the tumor necrosis factor-alpha inhibitor, etanercept, into a punctured intervertebral disc decreases calcitonin gene-related peptide expression in rat dorsal root ganglion neurons.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386');
INSERT INTO wp_blc_instances VALUES('428', '51', '33', 'page', 'Targeted etanercept for treatment-refractory pain due to bone metastasis: two case reports.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134');
INSERT INTO wp_blc_instances VALUES('429', '72', '33', 'page', 'Perispinal TNF-alpha inhibition for discogenic pain', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('430', '73', '33', 'page', 'Randomized, double-blind, placebo-controlled, dose-response, and preclinical safety study of transforaminal epidural etanercept for the treatment of sciatica.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('431', '74', '33', 'page', 'Tumor Necrosis Factor-Alpha Antagonist Reduces Apoptosis of Neurons and Oligodendroglia in Rat Spinal Cord Injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756');
INSERT INTO wp_blc_instances VALUES('432', '75', '33', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('433', '76', '33', 'page', 'Direct application of the tumor necrosis factor-alpha inhibitor, etanercept, into a punctured intervertebral disc decreases calcitonin gene-related peptide expression in rat dorsal root ganglion neurons.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386');
INSERT INTO wp_blc_instances VALUES('434', '32', '33', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('435', '28', '33', 'page', 'Paths to acceptance. The advancement of scientific knowledge is an uphill struggle against ‘accepted wisdom’.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765');
INSERT INTO wp_blc_instances VALUES('436', '83', '33', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('437', '40', '33', 'page', '', 'image', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481-201x300.jpg');
INSERT INTO wp_blc_instances VALUES('799', '77', '37', 'page', '', 'link', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/traumatic-brain-injury-photo.jpg');
INSERT INTO wp_blc_instances VALUES('463', '27', '35', 'page', 'Soluble TNF receptors are associated with A? metabolism and conversion to dementia in subjects with mild cognitive impairment.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19070941');
INSERT INTO wp_blc_instances VALUES('464', '28', '35', 'page', 'Paths to acceptance. The advancement of scientific knowledge is an uphill struggle against \'accepted wisdom\'.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765');
INSERT INTO wp_blc_instances VALUES('465', '81', '35', 'page', 'FDA, off-label use, and informed consent: debunking myths and misconceptions.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/11795338');
INSERT INTO wp_blc_instances VALUES('466', '82', '35', 'page', '', 'image', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/2010/10/bigstock_Elder_Man_Sitting_On_A_Wheelch_6065535-300x200.jpg');
INSERT INTO wp_blc_instances VALUES('467', '91', '627', 'page', 'video', 'link', 'post_content', '', 'http://www.painbreakthrough.com/videos/improvement-within-minutes-in-neck-pain-and-cervical-radiculopathy/');
INSERT INTO wp_blc_instances VALUES('468', '13', '627', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('469', '50', '627', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('470', '92', '627', 'page', 'Targeted etanercept for discogenic neck pain: uncontrolled, open-label results in two adults.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12809967');
INSERT INTO wp_blc_instances VALUES('471', '51', '627', 'page', 'Targeted etanercept for treatment-refractory pain due to bone metastasis: two case reports.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134');
INSERT INTO wp_blc_instances VALUES('472', '72', '627', 'page', 'Perispinal TNF-alpha inhibition for discogenic pain', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('473', '73', '627', 'page', 'Randomized, double-blind, placebo-controlled, dose-response, and preclinical safety study of transforaminal epidural etanercept for the treatment of sciatica.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('474', '74', '627', 'page', 'Tumor Necrosis Factor-Alpha Antagonist Reduces Apoptosis of Neurons and Oligodendroglia in Rat Spinal Cord Injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756');
INSERT INTO wp_blc_instances VALUES('475', '75', '627', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('476', '76', '627', 'page', 'Direct application of the tumor necrosis factor-alpha inhibitor, etanercept, into a punctured intervertebral disc decreases calcitonin gene-related peptide expression in rat dorsal root ganglion neurons.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386');
INSERT INTO wp_blc_instances VALUES('477', '32', '627', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('478', '28', '627', 'page', 'Paths to acceptance. The advancement of scientific knowledge is an uphill struggle against ‘accepted wisdom’.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765');
INSERT INTO wp_blc_instances VALUES('479', '83', '627', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('639', '28', '624', 'page', 'Paths to acceptance. The advancement of scientific knowledge is an uphill struggle against ‘accepted wisdom’.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765');
INSERT INTO wp_blc_instances VALUES('638', '32', '624', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('637', '76', '624', 'page', 'Direct application of the tumor necrosis factor-alpha inhibitor, etanercept, into a punctured intervertebral disc decreases calcitonin gene-related peptide expression in rat dorsal root ganglion neurons.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386');
INSERT INTO wp_blc_instances VALUES('636', '75', '624', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('635', '74', '624', 'page', 'Tumor Necrosis Factor-Alpha Antagonist Reduces Apoptosis of Neurons and Oligodendroglia in Rat Spinal Cord Injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756');
INSERT INTO wp_blc_instances VALUES('634', '73', '624', 'page', 'Randomized, double-blind, placebo-controlled, dose-response, and preclinical safety study of transforaminal epidural etanercept for the treatment of sciatica.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('632', '51', '624', 'page', 'Targeted etanercept for treatment-refractory pain due to bone metastasis: two case reports.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134');
INSERT INTO wp_blc_instances VALUES('633', '72', '624', 'page', 'Perispinal TNF-alpha inhibition for discogenic pain', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('631', '50', '624', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('630', '13', '624', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('491', '13', '621', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('492', '50', '621', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('493', '51', '621', 'page', 'Targeted etanercept for treatment-refractory pain due to bone metastasis: two case reports.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134');
INSERT INTO wp_blc_instances VALUES('494', '72', '621', 'page', 'Perispinal TNF-alpha inhibition for discogenic pain', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('495', '73', '621', 'page', 'Randomized, double-blind, placebo-controlled, dose-response, and preclinical safety study of transforaminal epidural etanercept for the treatment of sciatica.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('496', '74', '621', 'page', 'Tumor Necrosis Factor-Alpha Antagonist Reduces Apoptosis of Neurons and Oligodendroglia in Rat Spinal Cord Injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756');
INSERT INTO wp_blc_instances VALUES('497', '75', '621', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('498', '76', '621', 'page', 'Direct application of the tumor necrosis factor-alpha inhibitor, etanercept, into a punctured intervertebral disc decreases calcitonin gene-related peptide expression in rat dorsal root ganglion neurons.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386');
INSERT INTO wp_blc_instances VALUES('499', '32', '621', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('500', '28', '621', 'page', 'Paths to acceptance. The advancement of scientific knowledge is an uphill struggle against ‘accepted wisdom’.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765');
INSERT INTO wp_blc_instances VALUES('501', '83', '621', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('786', '12', '65', 'page', 'Intrathecal inflammation precedes development of Alzheimer\'s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12933918');
INSERT INTO wp_blc_instances VALUES('785', '95', '65', 'page', 'Attenuation of Inflammatory Events in Human Intervertebral Disc Cells with a Tumor Necrosis Factor Antagonist.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21217452');
INSERT INTO wp_blc_instances VALUES('784', '56', '65', 'page', 'Anti-TNF-alpha reduces amyloid plaques and tau phosphorylation and induces CD11c-positive dendritic-like cell in the APP/PS1 transgenic mouse brains.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20971085');
INSERT INTO wp_blc_instances VALUES('782', '94', '65', 'page', 'Anti-TNF therapy in the injured spinal cord.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21185611');
INSERT INTO wp_blc_instances VALUES('783', '75', '65', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('780', '32', '65', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('781', '93', '65', 'page', 'Targeting TNF-Alpha to Elucidate and Ameliorate Neuroinflammation in Neurodegenerative Diseases.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21288189');
INSERT INTO wp_blc_instances VALUES('766', '45', '65', 'page', 'The value of drug repositioning in the current pharmaceutical market.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19330170');
INSERT INTO wp_blc_instances VALUES('767', '15', '65', 'page', 'Rapid intracerebroventricular delivery of Cu-DOTA-etanercept after peripheral administration demonstrated by PET imaging.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19284700');
INSERT INTO wp_blc_instances VALUES('541', '83', '619', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('689', '40', '47', 'page', '', 'image', 'post_content', '', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481-201x300.jpg');
INSERT INTO wp_blc_instances VALUES('652', '76', '675', 'page', 'Direct application of the tumor necrosis factor-alpha inhibitor, etanercept, into a punctured intervertebral disc decreases calcitonin gene-related peptide expression in rat dorsal root ganglion neurons.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386');
INSERT INTO wp_blc_instances VALUES('651', '75', '675', 'page', 'Etanercept restores the antinociceptive effect of morphine and suppresses spinal neuroinflammation in morphine-tolerant rats.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778');
INSERT INTO wp_blc_instances VALUES('650', '74', '675', 'page', 'Tumor Necrosis Factor-Alpha Antagonist Reduces Apoptosis of Neurons and Oligodendroglia in Rat Spinal Cord Injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756');
INSERT INTO wp_blc_instances VALUES('649', '73', '675', 'page', 'Randomized, double-blind, placebo-controlled, dose-response, and preclinical safety study of transforaminal epidural etanercept for the treatment of sciatica.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('648', '72', '675', 'page', 'Perispinal TNF-alpha inhibition for discogenic pain', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('646', '18', '675', 'page', 'Rapid improvement in verbal fluency and aphasia following perispinal etanercept in Alzheimer\'s disease.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/18644112');
INSERT INTO wp_blc_instances VALUES('647', '50', '675', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('645', '16', '675', 'page', 'Perispinal etanercept for neuroinflammatory disorders.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19027875');
INSERT INTO wp_blc_instances VALUES('644', '14', '675', 'page', 'Tumour necrosis factor modulation for treatment of Alzheimer\'s disease: rationale and current evidence.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19689163');
INSERT INTO wp_blc_instances VALUES('643', '13', '675', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('641', '96', '675', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('642', '70', '675', 'page', 'Rapid improvement of chronic stroke deficits after perispinal etanercept: three consecutive cases', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21254790');
INSERT INTO wp_blc_instances VALUES('857', '103', '60', 'page', 'Map &amp; Directions', 'link', 'post_content', '', 'http://www.strokebreakthrough.com/contact/ucla-medical-plaza-office/');
INSERT INTO wp_blc_instances VALUES('600', '100', '63', 'page', 'Rapid intracerebroventricular delivery of Cu-DOTA-etanercept after peripheral administration demonstrated by PET imaging', 'link', 'post_content', '', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.bmcrn_.pdf');
INSERT INTO wp_blc_instances VALUES('599', '99', '63', 'page', 'Rapid cognitive improvement in Alzheimer\'s disease following perispinal etanercept administration', 'link', 'post_content', '', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.jni_.rapid_.pdf');
INSERT INTO wp_blc_instances VALUES('598', '98', '63', 'page', 'click to download a full-text formatted copy of the published, peer-reviewed article', 'link', 'post_content', '', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.neurology.pdf');
INSERT INTO wp_blc_instances VALUES('844', '74', '6', 'page', 'Tumor Necrosis Factor-Alpha Antagonist Reduces Apoptosis of Neurons and Oligodendroglia in Rat Spinal Cord Injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756');
INSERT INTO wp_blc_instances VALUES('842', '72', '6', 'page', 'Perispinal TNF-alpha inhibition for discogenic pain', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('843', '73', '6', 'page', 'Randomized, double-blind, placebo-controlled, dose-response, and preclinical safety study of transforaminal epidural etanercept for the treatment of sciatica.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('586', '101', '753', 'post', 'The new study, published ahead-of-print in the leading journal Spine', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/22020607');
INSERT INTO wp_blc_instances VALUES('587', '50', '753', 'post', 'our work with etanercept for sciatica', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('588', '72', '753', 'post', '2003', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286');
INSERT INTO wp_blc_instances VALUES('589', '50', '753', 'post', '2004', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('590', '73', '753', 'post', 'favorable randomized, placebo-controlled study', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178');
INSERT INTO wp_blc_instances VALUES('591', '102', '758', 'post', 'http://sixtyminutes.ninemsn.com.au/stories/8360210/a-new-shot-at-life', 'link', 'post_content', '', 'http://sixtyminutes.ninemsn.com.au/stories/8360210/a-new-shot-at-life');
INSERT INTO wp_blc_instances VALUES('597', '98', '63', 'page', 'Rapid improvement in verbal fluency and aphasia following perispinal etanercept in Alzheimer\'s disease', 'link', 'post_content', '', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.neurology.pdf');
INSERT INTO wp_blc_instances VALUES('856', '106', '60', 'page', 'Map &amp; Directions', 'link', 'post_content', '', 'http://www.painbreakthrough.com/contact/boca-raton-florida/');
INSERT INTO wp_blc_instances VALUES('841', '51', '6', 'page', 'Targeted etanercept for treatment-refractory pain due to bone metastasis: two case reports.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134');
INSERT INTO wp_blc_instances VALUES('840', '50', '6', 'page', 'Efficacy of etanercept delivered by perispinal administration for chronic back and/or neck disc-related pain: a study of clinical observations in 143 patients.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252');
INSERT INTO wp_blc_instances VALUES('640', '83', '624', 'page', 'Terms of Use', 'link', 'post_content', '', 'http://www.painbreakthrough.com/about/terms-of-use/');
INSERT INTO wp_blc_instances VALUES('653', '32', '675', 'page', 'Therapeutic evaluation of etanercept in a model of traumatic brain injury.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174');
INSERT INTO wp_blc_instances VALUES('672', '107', '783', 'page', 'nrimed@gmail.com', 'link', 'post_content', '', 'mailto:nrimed@gmail.com');
INSERT INTO wp_blc_instances VALUES('673', '108', '783', 'page', '(310) 824-6199', 'link', 'post_content', '', 'tel:%28310%29%20824-6199');
INSERT INTO wp_blc_instances VALUES('688', '109', '47', 'page', 'www.strokebreakthrough.com', 'link', 'post_content', '', 'http://www.strokebreakthrough.com');
INSERT INTO wp_blc_instances VALUES('687', '109', '47', 'page', 'INR Stroke website', 'link', 'post_content', '', 'http://www.strokebreakthrough.com');
INSERT INTO wp_blc_instances VALUES('764', '13', '65', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');
INSERT INTO wp_blc_instances VALUES('765', '14', '65', 'page', 'Tumour necrosis factor modulation for treatment of Alzheimer\'s disease: rationale and current evidence.', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/19689163');
INSERT INTO wp_blc_instances VALUES('763', '70', '65', 'page', 'Rapid improvement of chronic stroke deficits after perispinal etanercept: three consecutive cases', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/21254790');
INSERT INTO wp_blc_instances VALUES('761', '112', '65', 'page', 'Selective TNF Inhibition for Chronic Stroke and Traumatic Brain Injury - An Observational Study Involving 629 Consecutive Patients Treated with Perispinal Etanercept', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/23100196');
INSERT INTO wp_blc_instances VALUES('762', '111', '65', 'page', 'Deciphering the physiology underlying the rapid clinical effects of perispinal etanercept in Alzheimer\'s disease', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/22191562');
INSERT INTO wp_blc_instances VALUES('838', '101', '6', 'page', 'Epidural Administration of Spinal Nerves with the Tumor Necrosis Factor-Alpha Inhibitor, Etanercept, Compared with Dexamethasone for Treatment of Sciatica in Patients with Lumbar Spinal Stenosis: A Prospective Randomized Study', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/22020607');
INSERT INTO wp_blc_instances VALUES('839', '13', '6', 'page', 'Perispinal etanercept: a new therapeutic paradigm in neurology', 'link', 'post_content', '', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613');



DROP TABLE IF EXISTS wp_blc_links;

CREATE TABLE `wp_blc_links` (
  `link_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `first_failure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_success` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `check_count` int(4) unsigned NOT NULL DEFAULT '0',
  `final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `redirect_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `log` text NOT NULL,
  `http_code` smallint(6) NOT NULL DEFAULT '0',
  `status_code` varchar(100) DEFAULT '',
  `status_text` varchar(250) DEFAULT '',
  `request_duration` float NOT NULL DEFAULT '0',
  `timeout` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `broken` tinyint(1) NOT NULL DEFAULT '0',
  `may_recheck` tinyint(1) NOT NULL DEFAULT '1',
  `being_checked` tinyint(1) NOT NULL DEFAULT '0',
  `result_hash` varchar(200) NOT NULL DEFAULT '',
  `false_positive` tinyint(1) NOT NULL DEFAULT '0',
  `dismissed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  KEY `url` (`url`(150)),
  KEY `final_url` (`final_url`(150)),
  KEY `http_code` (`http_code`),
  KEY `broken` (`broken`)
) ENGINE=MyISAM AUTO_INCREMENT=115 DEFAULT CHARSET=utf8;

INSERT INTO wp_blc_links VALUES('10', 'http://www.ncbi.nlm.nih.gov/pubmed/19752507', '0000-00-00 00:00:00', '2013-05-08 09:40:30', '2013-05-08 09:40:30', '2013-05-08 09:40:30', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19752507', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:31 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396C5E0E18A1D8F1_0128SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396C5E0E18A1D8F1_0128SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:31 GMT
\nSet-Cookie: WebEnv=1ZWmgeV0lC3XNPbKUUbXkucquzLMV798SyNs-v4cv5Ka7kis-v2Y0ZykW69XDZ70xOjAVh3ZSGdZfs02zJ0y72Ney2YdelJf3Da5B%40396C5E0E18A1D8F1_0128SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:31 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.854802', '0', '0', '1', '0', '200|0|0|39b93ea85a35db8afd42f4cf4d2834eb', '0', '0');
INSERT INTO wp_blc_links VALUES('11', 'http://www.ncbi.nlm.nih.gov/pubmed/19738171', '0000-00-00 00:00:00', '2013-05-08 09:40:31', '2013-05-08 09:40:31', '2013-05-08 09:40:31', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19738171', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:31 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 39695AB818A1D8F1_0008SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=39695AB818A1D8F1_0008SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:31 GMT
\nSet-Cookie: WebEnv=1LydvwC9YCv-67iUvnPcOSivySRYx6Dhq4ARahGPzqm_37RDCkIc88QXXtrkvI3dqxPBURbNXlc-CJQCdESd9pnu9fn4ERLwuF4%4039695AB818A1D8F1_0008SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:32 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.703922', '0', '0', '1', '0', '200|0|0|9f983f0dc93001995d0c036fb5d6adad', '0', '0');
INSERT INTO wp_blc_links VALUES('12', 'http://www.ncbi.nlm.nih.gov/pubmed/12933918', '0000-00-00 00:00:00', '2013-05-08 09:40:32', '2013-05-08 09:40:32', '2013-05-08 09:40:32', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/12933918', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:32 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396F7EC018A1D901_0103SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396F7EC018A1D901_0103SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:32 GMT
\nSet-Cookie: WebEnv=1vC9kbCRL50WnnsIjYrnBYHoRD5HnswUM6rTxQL6SFLaCLkP4faE2AVxgdKFHXFRAhCxdD2MNClzjz5yY6_baetqI82t7-mQlO%40396F7EC018A1D901_0103SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:33 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.857064', '0', '0', '1', '0', '200|0|0|13be43c1f0deaeea604f9e9e5e0febcb', '0', '0');
INSERT INTO wp_blc_links VALUES('13', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613', '0000-00-00 00:00:00', '2013-05-08 09:40:33', '2013-05-08 09:40:33', '2013-05-08 09:40:33', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20518613', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:33 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8B419C18A1D911_0026SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8B419C18A1D911_0026SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:33 GMT
\nSet-Cookie: WebEnv=12gQhCo_ejPM_tmEKR2l0NVSYdhxZEDOZI4iWb_kFdBGEBJDirg0DzaQllAm69gW1BvLL0RSZEaJM4lnUlhe9kkR8s2RlcEMi-%40CE8B419C18A1D911_0026SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:33 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.636486', '0', '0', '1', '0', '200|0|0|813ab07707d4af7526e646d8ebea9632', '0', '0');
INSERT INTO wp_blc_links VALUES('14', 'http://www.ncbi.nlm.nih.gov/pubmed/19689163', '0000-00-00 00:00:00', '2013-05-08 09:40:33', '2013-05-08 09:40:33', '2013-05-08 09:40:33', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19689163', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:33 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8D176418A1D911_0121SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8D176418A1D911_0121SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:33 GMT
\nSet-Cookie: WebEnv=1Nyezmxw-Cpe_6zVoUFgxhmECunDTAtLSu0cqcdXEkovSm0n0IdStVP-GvxnxARhOLUw70KA3dED7nUAETf9tZONoFEo8Um7O6_%40CE8D176418A1D911_0121SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:35 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '1.36805', '0', '0', '1', '0', '200|0|0|4c2db8759468bab35c7ee33748af09c5', '0', '0');
INSERT INTO wp_blc_links VALUES('15', 'http://www.ncbi.nlm.nih.gov/pubmed/19284700', '0000-00-00 00:00:00', '2013-05-08 09:40:35', '2013-05-08 09:40:35', '2013-05-08 09:40:35', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19284700', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:35 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE883D6018A1D931_0031SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE883D6018A1D931_0031SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:35 GMT
\nSet-Cookie: WebEnv=18575BYz3wCpqgbGyQTQmyAzIZRAxizpYPSDWmzsZyl3xUYQjaXdE6Q13MEg19DKZDJF48NMAkHokYrpz1RHQH0ryp4SJgCs6q%40CE883D6018A1D931_0031SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:35 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.634745', '0', '0', '1', '0', '200|0|0|3706d2051288b268a9dbba99a640d7af', '0', '0');
INSERT INTO wp_blc_links VALUES('16', 'http://www.ncbi.nlm.nih.gov/pubmed/19027875', '0000-00-00 00:00:00', '2013-05-08 09:40:35', '2013-05-08 09:40:35', '2013-05-08 09:40:35', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19027875', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:35 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE89456718A1D931_0029SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE89456718A1D931_0029SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:35 GMT
\nSet-Cookie: WebEnv=1dkRs_hi3PYwBTIGqHGKwPFagBsppPdpQO7Y8Kb14dvSxix9ATN1rTvb9kdDfP9G4o-9CAvSFKiGvksUgLj6sejwradt1BFo_E%40CE89456718A1D931_0029SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:36 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.481311', '0', '0', '1', '0', '200|0|0|008419df61ee28a52655a472e0134d56', '0', '0');
INSERT INTO wp_blc_links VALUES('17', 'http://www.ncbi.nlm.nih.gov/pubmed/18679537', '0000-00-00 00:00:00', '2013-05-08 09:40:36', '2013-05-08 09:40:36', '2013-05-08 09:40:36', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18679537', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:36 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8944E418A1D941_0036SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8944E418A1D941_0036SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:36 GMT
\nSet-Cookie: WebEnv=1zCweYkk90Zl7A34_lwmXOEYTUXhv2UV-rhB73i6XacDvb4BwYjosexNnezzq1cwSYk0sPAzHPl33vud0-3jxk7QMkbl2LIIUY%40CE8944E418A1D941_0036SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:37 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.912378', '0', '0', '1', '0', '200|0|0|aa9fc906f9a3c70f0113f8f04d5e46d9', '0', '0');
INSERT INTO wp_blc_links VALUES('18', 'http://www.ncbi.nlm.nih.gov/pubmed/18644112', '0000-00-00 00:00:00', '2013-05-08 09:40:41', '2013-05-08 09:40:41', '2013-05-08 09:40:41', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18644112', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:41 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8A58F318A1D991_0031SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8A58F318A1D991_0031SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:41 GMT
\nSet-Cookie: WebEnv=1-gkH_-gKZZmE-NRun9ys9b7s4FgO_0N-xsCtPJAnzMkZSsklmrHO08gYX_e5u6GufS_4ZOBM0hIrxQtlA_YvYTUIhpdApTUHB%40CE8A58F318A1D991_0031SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:42 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.665064', '0', '0', '1', '0', '200|0|0|cf285ea39c5c736eddc2596b72c2ba6a', '0', '0');
INSERT INTO wp_blc_links VALUES('19', 'http://www.ncbi.nlm.nih.gov/pubmed/18220520', '0000-00-00 00:00:00', '2013-05-08 09:40:44', '2013-05-08 09:40:44', '2013-05-08 09:40:44', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18220520', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:44 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396D14F318A1D9C1_0165SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396D14F318A1D9C1_0165SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:44 GMT
\nSet-Cookie: WebEnv=1-c_9O8OOZok6IeRIWUw7JlC7wOqZp_wnSuu8mn-YHCPKLDFLkYQaeZv1YfwQLFvgrWsu1aBXtfKV-59U9CeWbtwgvfPI7En33z%40396D14F318A1D9C1_0165SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:45 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.649069', '0', '0', '1', '0', '200|0|0|e4b1feaf45ad6720c22db69862677c9a', '0', '0');
INSERT INTO wp_blc_links VALUES('20', 'http://www.ncbi.nlm.nih.gov/pubmed/18184433', '0000-00-00 00:00:00', '2013-05-08 09:40:45', '2013-05-08 09:40:45', '2013-05-08 09:40:45', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18184433', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:45 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8E01D718A1D9D1_0145SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8E01D718A1D9D1_0145SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:45 GMT
\nSet-Cookie: WebEnv=1te5OPde_8Af_bblycyUOMkGvL_TFS1JC4BYxQ78DVwOzgs9vnaccCzoLZ5O9vw8ald3a--n3Qrw1J57V9hB8pyyXEWF-TpojnN5Y%40CE8E01D718A1D9D1_0145SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:45 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.572802', '0', '0', '1', '0', '200|0|0|5df3e6114fa271160f617f393235d3d3', '0', '0');
INSERT INTO wp_blc_links VALUES('21', 'http://www.ncbi.nlm.nih.gov/pubmed/16926764', '0000-00-00 00:00:00', '2013-05-08 09:40:45', '2013-05-08 09:40:45', '2013-05-08 09:40:45', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/16926764', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:45 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8C51EB18A1D9D1_0102SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8C51EB18A1D9D1_0102SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:45 GMT
\nSet-Cookie: WebEnv=1PC-pGPpwjBi6PM7We1mgkwX9-8nqWvivV1F5i_d7tH6BWmJHB4HVQifZi8bUI7QzQg2ZH_G11Tf72A1OYleARxW6X657L11U0%40CE8C51EB18A1D9D1_0102SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:46 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.761084', '0', '0', '1', '0', '200|0|0|9681d6eae3ed680991f616789947ddb3', '0', '0');
INSERT INTO wp_blc_links VALUES('22', 'http://www.ncbi.nlm.nih.gov/pubmed/18186919', '0000-00-00 00:00:00', '2013-05-08 09:40:47', '2013-05-08 09:40:47', '2013-05-08 09:40:47', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18186919', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:47 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8E078E18A1D9F1_0024SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8E078E18A1D9F1_0024SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:47 GMT
\nSet-Cookie: WebEnv=1rCAw1myYAjjjUEeNq4f-w2V5eaJRp3p0FqGlZPPERSksm2szrqct6uXQYeAsOoQjDOXFpjOZRkQApwXNsGfluguBd28rO6obmZ%40CE8E078E18A1D9F1_0024SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:47 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.530775', '0', '0', '1', '0', '200|0|0|7e2f5ebf03af4a34b4141f84944e429d', '0', '0');
INSERT INTO wp_blc_links VALUES('23', 'http://www.ncbi.nlm.nih.gov/pubmed/20096353', '0000-00-00 00:00:00', '2013-05-08 09:40:49', '2013-05-08 09:40:49', '2013-05-08 09:40:49', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20096353', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:49 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396E7D1018A1DA11_0050SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396E7D1018A1DA11_0050SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:49 GMT
\nSet-Cookie: WebEnv=1nOBmniwjPoTGvmlmif-deZQ-58pQ6e8j02MmhPgAa14N-i-7-lfEQwnucoB9YOmn8nn86Iik7OVsleDs_C0rkcABldZrvllKL8%40396E7D1018A1DA11_0050SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:49 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.949984', '0', '0', '1', '0', '200|0|0|531ffdaf36dc78c571b2e77c47290ba9', '0', '0');
INSERT INTO wp_blc_links VALUES('24', 'http://www.ncbi.nlm.nih.gov/pubmed/20813131', '0000-00-00 00:00:00', '2013-05-08 09:40:50', '2013-05-08 09:40:50', '2013-05-08 09:40:50', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20813131', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:51 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8C548E18A1DA31_0031SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8C548E18A1DA31_0031SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:51 GMT
\nSet-Cookie: WebEnv=1NWe8nby98uCqCa4WRiidBwOQQ_JBi5KXNNb6A5No8G0w-xZbuKuEMbPsKvkqfDY6n3fsuBr2htyFgzpN5k6WPf2uopopNDI22p%40CE8C548E18A1DA31_0031SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:51 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.91413', '0', '0', '1', '0', '200|0|0|9b219886ebe3c69bb53b629f301f2613', '0', '0');
INSERT INTO wp_blc_links VALUES('25', 'http://www.ncbi.nlm.nih.gov/pubmed/20693638', '0000-00-00 00:00:00', '2013-05-08 09:40:51', '2013-05-08 09:40:51', '2013-05-08 09:40:51', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20693638', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:51 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396B382E18A1DA31_0009SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396B382E18A1DA31_0009SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:51 GMT
\nSet-Cookie: WebEnv=1H3Z5oLohz4zVXavhrrEVqkcvVtEh96TNKVdTMUenxkm8Gv_mer5-XsQmc-oYn5GmlPGnf0Dr5XNpymXh8UfTO6ehLNsaZJvR1wAU%40396B382E18A1DA31_0009SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:52 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.884652', '0', '0', '1', '0', '200|0|0|3d3a874a069b7d3a0ef749251cc647a2', '0', '0');
INSERT INTO wp_blc_links VALUES('26', 'http://www.ncbi.nlm.nih.gov/pubmed/20122965', '0000-00-00 00:00:00', '2013-05-08 09:40:52', '2013-05-08 09:40:52', '2013-05-08 09:40:52', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20122965', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:52 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8E03BA18A1DA41_0114SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8E03BA18A1DA41_0114SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:52 GMT
\nSet-Cookie: WebEnv=1TMzkgcTOx7MPwHvyQgPIM0j7G0-UARx8coRVm48FUJULuFxeTk1T4-b-b6L86nTrWVi9trPh22QW81Hi1O22RaFKLNYh7EgOzE%40CE8E03BA18A1DA41_0114SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:53 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.973432', '0', '0', '1', '0', '200|0|0|c737d6056614c1375b23cd3ef1de8f3b', '0', '0');
INSERT INTO wp_blc_links VALUES('27', 'http://www.ncbi.nlm.nih.gov/pubmed/19070941', '0000-00-00 00:00:00', '2013-05-08 09:40:53', '2013-05-08 09:40:53', '2013-05-08 09:40:53', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19070941', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:53 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396A602E18A1DA51_0045SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396A602E18A1DA51_0045SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:53 GMT
\nSet-Cookie: WebEnv=1ZMkxp-R_3uVc6dIT7B4ZlvyTw6avAOqugvNUtHkXpjvIgL-uMY_QtfYIlIq95mBzGb2EkaWaaWnpi-bmixror2Uhn9awPKM7b%40396A602E18A1DA51_0045SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:54 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '1.05434', '0', '0', '1', '0', '200|0|0|d2101389ff1d100a6d90dbde1de3b53b', '0', '0');
INSERT INTO wp_blc_links VALUES('28', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765', '0000-00-00 00:00:00', '2013-05-08 09:40:54', '2013-05-08 09:40:54', '2013-05-08 09:40:54', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18451765', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:54 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 3969585618A1DA61_0070SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=3969585618A1DA61_0070SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:54 GMT
\nSet-Cookie: WebEnv=18eIWD9xO_urb-s9kgVudw_VLA3rPRhaOcot-HJuXI5BvGbbszS66YBUIS5Nthdj3i1cAUgdNBQUokvA_vku5jvX4B1YfA6kv5%403969585618A1DA61_0070SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:55 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.505073', '0', '0', '1', '0', '200|0|0|41c3abb0f2de63051a0e0b9c7b09c48a', '0', '0');
INSERT INTO wp_blc_links VALUES('72', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286', '0000-00-00 00:00:00', '2013-05-08 09:40:55', '2013-05-08 09:40:55', '2013-05-08 09:40:55', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/12715286', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:55 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396A595A18A1DA71_0118SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396A595A18A1DA71_0118SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:55 GMT
\nSet-Cookie: WebEnv=1futS9Ugi0OKO2pCtnm98lUMel3T_dW3VQ_IfFUx2XDuF0Ky0fFXbg5XNtZol52PUWgzewE1sZxOvPKocGmlTL10ZTpMNuegBH%40396A595A18A1DA71_0118SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:55 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.743024', '0', '0', '1', '0', '200|0|0|24020ab0a67d056f7479352095239a6d', '0', '0');
INSERT INTO wp_blc_links VALUES('73', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178', '0000-00-00 00:00:00', '2013-05-08 09:40:56', '2013-05-08 09:40:56', '2013-05-08 09:40:56', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19387178', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:56 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8A56D518A1DA81_0085SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8A56D518A1DA81_0085SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:56 GMT
\nSet-Cookie: WebEnv=14I8q8J9DJmn6YDwfe0HGYTZ4Z-1zIMfWIZAdFJvGLDVHuXf4qLnvveQwHrP32nx3v9eahx43kKPFp8MI4tRgAMrDDPEkRPI2J%40CE8A56D518A1DA81_0085SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:56 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.773904', '0', '0', '1', '0', '200|0|0|66ee282e65333a488cd95bac49178011', '0', '0');
INSERT INTO wp_blc_links VALUES('74', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756', '0000-00-00 00:00:00', '2013-05-08 09:40:56', '2013-05-08 09:40:56', '2013-05-08 09:40:56', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21224756', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:56 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8943A818A1DA81_0089SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8943A818A1DA81_0089SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:56 GMT
\nSet-Cookie: WebEnv=1-IS_nEG8U7uYmKZebOy3pse5ueDKeYUnwZ4Sdrqx8NYH5G_wwGHYuaOd6EfY_pGHn0QaXzJQzWKeucIR_-y1tYytF-ZXXfA4%40CE8943A818A1DA81_0089SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:57 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.634493', '0', '0', '1', '0', '200|0|0|3e1dda563f61f7480ad94af95cbab12f', '0', '0');
INSERT INTO wp_blc_links VALUES('75', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778', '0000-00-00 00:00:00', '2013-05-08 09:40:57', '2013-05-08 09:40:57', '2013-05-08 09:40:57', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21081778', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:57 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 39695AEF18A1DA91_0016SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=39695AEF18A1DA91_0016SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:57 GMT
\nSet-Cookie: WebEnv=1RYBfFVcTEAmpk10bZBgZwlza6QvQf_mCP5LhQPuVfe8X0TsUXRbS0c02IzUkMT0k55mdjFqpWWVg8-ugbcO8Bw0ihpIcodjSMZA6%4039695AEF18A1DA91_0016SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:58 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.832703', '0', '0', '1', '0', '200|0|0|570d97be37b460d9c35043ddf6094616', '0', '0');
INSERT INTO wp_blc_links VALUES('76', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386', '0000-00-00 00:00:00', '2013-05-08 09:40:58', '2013-05-08 09:40:58', '2013-05-08 09:40:58', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21057386', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:58 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8D1AC118A1DAA1_0055SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8D1AC118A1DAA1_0055SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:58 GMT
\nSet-Cookie: WebEnv=1T145sglMUv9gCh0vAEjSu0-0wJB7FXnZCpC-hnVrf78Bwkerim3oHRjesDfrt-6jKYgZJKrTseNYgudV7aJ2amgNyoipa8uPX35q%40CE8D1AC118A1DAA1_0055SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:59 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.887056', '0', '0', '1', '0', '200|0|0|4b7d95bb1d0b97644435f1b4730e5943', '0', '0');
INSERT INTO wp_blc_links VALUES('77', 'http://www.painbreakthrough.com/wp-content/uploads/traumatic-brain-injury-photo.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/wp-content/uploads/traumatic-brain-injury-photo.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:38 GMT
\nAccept-Ranges: bytes
\nContent-Length: 108367
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.003014', '0', '0', '1', '0', '200|0|0|66f98efc2ac8d7c55e9fc0320530b50b', '0', '0');
INSERT INTO wp_blc_links VALUES('78', 'http://www.painbreakthrough.com/wp-content/uploads/traumatic-brain-injury-photo-300x300.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/wp-content/uploads/traumatic-brain-injury-photo-300x300.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:38 GMT
\nAccept-Ranges: bytes
\nContent-Length: 21228
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.028539', '0', '0', '1', '0', '200|0|0|2f9870fbaa570437e9f6776c43bb2c6d', '0', '0');
INSERT INTO wp_blc_links VALUES('79', 'http://www.painbreakthrough.com/wp-content/uploads/2010/10/bigstock_Elder_Man_Sitting_On_A_Wheelch_6065535.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/wp-content/uploads/2010/10/bigstock_Elder_Man_Sitting_On_A_Wheelch_6065535.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:33 GMT
\nAccept-Ranges: bytes
\nContent-Length: 350170
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.011333', '0', '0', '1', '0', '200|0|0|fc3e5e4f1c34e3e38349d34fc402af8d', '0', '0');
INSERT INTO wp_blc_links VALUES('80', 'http://www.painbreakthrough.com/request-consultation/', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/request-consultation/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Wed, 23 Jan 2013 17:18:08 GMT
\nAccept-Ranges: bytes
\nContent-Length: 24944
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:41:02 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.016808', '0', '0', '1', '0', '200|0|0|4a161cf7b85f98cf75df0949c7fa655f', '0', '0');
INSERT INTO wp_blc_links VALUES('81', 'http://www.ncbi.nlm.nih.gov/pubmed/11795338', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/11795338', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE89455518A1DAB1_0045SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE89455518A1DAB1_0045SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:59 GMT
\nSet-Cookie: WebEnv=1vW9qrm0TpeyvAfKrUWnLxMoQQQnu3LpcDwREVfc11kMIi5HflIRNZuCX3MQr8n6DHIksw5DZC8roul6zgpHNCMJVddAX0rKcuE%40CE89455518A1DAB1_0045SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:59 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.542962', '0', '0', '1', '0', '200|0|0|805ab5a6467c9ce0f96a86b18d5b46bf', '0', '0');
INSERT INTO wp_blc_links VALUES('82', 'http://www.painbreakthrough.com/wp-content/uploads/2010/10/bigstock_Elder_Man_Sitting_On_A_Wheelch_6065535-300x200.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/wp-content/uploads/2010/10/bigstock_Elder_Man_Sitting_On_A_Wheelch_6065535-300x200.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:31 GMT
\nAccept-Ranges: bytes
\nContent-Length: 14456
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.002438', '0', '0', '1', '0', '200|0|0|6329abe25dc2414af84afff80815064b', '0', '0');
INSERT INTO wp_blc_links VALUES('83', 'http://www.painbreakthrough.com/about/terms-of-use/', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/about/terms-of-use/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Thu, 24 Jan 2013 01:08:37 GMT
\nAccept-Ranges: bytes
\nContent-Length: 20636
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:41:02 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.004424', '0', '0', '1', '0', '200|0|0|f89b85de252f6b7bc2e6b3b2576c753b', '0', '0');
INSERT INTO wp_blc_links VALUES('84', 'http://www.painbreakthrough.com/', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.painbreakthrough.com/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nLast-Modified: Tue, 09 Apr 2013 14:04:39 GMT
\nAccept-Ranges: bytes
\nContent-Length: 31239
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:41:02 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.009378', '0', '0', '1', '0', '200|0|0|a826e18825aaec25015f8fae1176d830', '0', '0');
INSERT INTO wp_blc_links VALUES('32', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174', '0000-00-00 00:00:00', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '2013-05-08 09:40:59', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20796174', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:59 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE89408918A1DAB1_0188SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE89408918A1DAB1_0188SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:59 GMT
\nSet-Cookie: WebEnv=1HCn8Owq11xpjsa0v09aOFHcEX8d8fHjzKeWl1EXF4gY4NhsBST5OVWmnRLwM1F0J85q8fddO2GNzIBpeOF20yioWm14aiHoMB%40CE89408918A1DAB1_0188SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:41:00 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.808707', '0', '0', '1', '0', '200|0|0|848ee6a116d8f01f764928f98b76dc12', '0', '0');
INSERT INTO wp_blc_links VALUES('40', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481-201x300.jpg', '0000-00-00 00:00:00', '2013-05-08 09:41:00', '2013-05-08 09:41:00', '2013-05-08 09:41:00', '0', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481-201x300.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:00 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:31 GMT
\nAccept-Ranges: bytes
\nContent-Length: 17079
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.00556', '0', '0', '1', '0', '200|0|0|24b38add8f05e9625b80af9c41a1b093', '0', '0');
INSERT INTO wp_blc_links VALUES('106', 'http://www.painbreakthrough.com/contact/boca-raton-florida/', '0000-00-00 00:00:00', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '0', 'http://www.painbreakthrough.com/contact/boca-raton-florida/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Thu, 09 May 2013 09:31:37 GMT
\nServer: Apache
\nLast-Modified: Fri, 08 Feb 2013 20:02:38 GMT
\nAccept-Ranges: bytes
\nContent-Length: 14180
\nCache-Control: max-age=3, must-revalidate
\nExpires: Thu, 09 May 2013 09:31:40 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.013761', '0', '0', '1', '0', '200|0|0|b18dbf5de4a51719900a4375fe571af6', '0', '0');
INSERT INTO wp_blc_links VALUES('44', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small2-240x300.jpg', '0000-00-00 00:00:00', '2013-05-08 09:41:00', '2013-05-08 09:41:00', '2013-05-08 09:41:00', '0', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small2-240x300.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:00 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:31 GMT
\nAccept-Ranges: bytes
\nContent-Length: 15345
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.00843', '0', '0', '1', '0', '200|0|0|6c70da7bd6278f5a0b733952897810b6', '0', '0');
INSERT INTO wp_blc_links VALUES('45', 'http://www.ncbi.nlm.nih.gov/pubmed/19330170', '0000-00-00 00:00:00', '2013-05-08 09:41:00', '2013-05-08 09:41:00', '2013-05-08 09:41:00', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/19330170', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:41:00 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396E7C4618A1DAC1_0085SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396E7C4618A1DAC1_0085SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:41:00 GMT
\nSet-Cookie: WebEnv=1VGBez9nI-ZbjtRLthGVrFTVR4VeiAqhEU-8HL0s7qFQpBQU5fWoKX-C4XjBA2C-tPRqFT_WeyNXgpJVULYWuu4FgUNLVrjU_O%40396E7C4618A1DAC1_0085SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:41:01 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.55651', '0', '0', '1', '0', '200|0|0|202ce10cd64ee200149b228067a6cdef', '0', '0');
INSERT INTO wp_blc_links VALUES('46', 'http://www.ncbi.nlm.nih.gov/pubmed/18378889', '0000-00-00 00:00:00', '2013-05-08 09:40:37', '2013-05-08 09:40:37', '2013-05-08 09:40:37', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18378889', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:37 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396E78E618A1D951_0147SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396E78E618A1D951_0147SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:37 GMT
\nSet-Cookie: WebEnv=1fm0X5WgqyOcoTBeE_yMfN7E8FpP-4ZHROviz714bZbkCrKUhDlX0LZpDQsoFdL-oM-xPnSqRpggPLVi0W5ZZMHn28Sgi6k9YM%40396E78E618A1D951_0147SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:37 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.615676', '0', '0', '1', '0', '200|0|0|feb3c237c5293e2068d419e2356f57a0', '0', '0');
INSERT INTO wp_blc_links VALUES('47', 'http://www.ncbi.nlm.nih.gov/pubmed/18212586', '0000-00-00 00:00:00', '2013-05-08 09:40:37', '2013-05-08 09:40:37', '2013-05-08 09:40:37', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/18212586', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:37 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396D1A1A18A1D951_0030SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396D1A1A18A1D951_0030SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:37 GMT
\nSet-Cookie: WebEnv=1JMsyz6nCnYMvotEOgnhjNjsZohAtCAWzucPY-6VDuGgIaZLoTL32-dSQlGrZpFUEe7wVJFTDXzbcJEEqKfnjAomxtmdsKBHCGfkz%40396D1A1A18A1D951_0030SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:38 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.908295', '0', '0', '1', '0', '200|0|0|b848f46d392c3d46c0a52c45592e2f80', '0', '0');
INSERT INTO wp_blc_links VALUES('48', 'http://www.ncbi.nlm.nih.gov/pubmed/17132064', '0000-00-00 00:00:00', '2013-05-08 09:40:38', '2013-05-08 09:40:38', '2013-05-08 09:40:38', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/17132064', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:38 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396F7B4A18A1D961_0178SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396F7B4A18A1D961_0178SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:38 GMT
\nSet-Cookie: WebEnv=18E5iKur2a8r1KXMhGTscac42329ON1CAl2TPEPYLMrBXS_NlASBjAcyYoBNDn1_GjQQhW2LpYrqvDqAbLNDpKey5bQCBV68PqD5N%40396F7B4A18A1D961_0178SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:39 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '1.04181', '0', '0', '1', '0', '200|0|0|f01a38a03de63867d8d37dafff3684f5', '0', '0');
INSERT INTO wp_blc_links VALUES('49', 'http://www.ncbi.nlm.nih.gov/pubmed/16915183', '0000-00-00 00:00:00', '2013-05-08 09:40:39', '2013-05-08 09:40:39', '2013-05-08 09:40:39', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/16915183', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:39 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396E79E518A1D971_0127SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396E79E518A1D971_0127SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:39 GMT
\nSet-Cookie: WebEnv=18SKb4jxM2u4nkmOK5jSZPGXNnH8UapYzeJ2MHo09WOLCMlbBE1JEz6332LF2qEmfLo_fUoLndX3xBDaYr0w9efDopSXq9J3K2skf%40396E79E518A1D971_0127SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:40 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.413235', '0', '0', '1', '0', '200|0|0|59f795128485f666fbecfbb19776daa8', '0', '0');
INSERT INTO wp_blc_links VALUES('50', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252', '0000-00-00 00:00:00', '2013-05-08 09:40:40', '2013-05-08 09:40:40', '2013-05-08 09:40:40', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/15265252', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:40 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396F7F2618A1D981_0102SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396F7F2618A1D981_0102SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:40 GMT
\nSet-Cookie: WebEnv=1po1rWpZjNbNTnL3fOwHwsyMq4iICKr8_EqgTpHbKy3uVwxVcb9fyoI3QxgIF_1lxeIv45WNUi6RuZuiD4YFxZXunVerWXXRj3b%40396F7F2618A1D981_0102SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:40 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.603832', '0', '0', '1', '0', '200|0|0|421d3e320c42a11834ad7262bd407d38', '0', '0');
INSERT INTO wp_blc_links VALUES('51', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134', '0000-00-00 00:00:00', '2013-05-08 09:40:40', '2013-05-08 09:40:40', '2013-05-08 09:40:40', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/14512134', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:40 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 3969584218A1D981_0073SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=3969584218A1D981_0073SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:40 GMT
\nSet-Cookie: WebEnv=1-KY4s9a-QR_CxRlHMXWPG9IPwNUgZoEogdWhNp5ebpmoEHQPzWPnnpi6m87P4G0bJWuV_wL8byIezCgnGbFtHUiq_jPe_NTInt%403969584218A1D981_0073SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:41 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.629121', '0', '0', '1', '0', '200|0|0|a6f0d4bb955613a3aa02c5ed4441ed0d', '0', '0');
INSERT INTO wp_blc_links VALUES('54', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small-240x300.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '0', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small-240x300.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:42 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:37 GMT
\nAccept-Ranges: bytes
\nContent-Length: 15345
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.010945', '0', '0', '1', '0', '200|0|0|a7b7d48e7bf296b8e7c23f9a9aa2420e', '0', '0');
INSERT INTO wp_blc_links VALUES('71', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '0', 'http://www.painbreakthrough.com/wp-content/uploads/Ed-small.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:42 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:38 GMT
\nAccept-Ranges: bytes
\nContent-Length: 72160
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.005032', '0', '0', '1', '0', '200|0|0|076a47ce0eff81ca91c103b4c4cea78c', '0', '0');
INSERT INTO wp_blc_links VALUES('56', 'http://www.ncbi.nlm.nih.gov/pubmed/20971085', '0000-00-00 00:00:00', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20971085', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:42 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396F013718A1D9A1_0081SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396F013718A1D9A1_0081SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:42 GMT
\nSet-Cookie: WebEnv=1N3AbnHq6kc5gEjxPjRMRdbOodWF44j0PEQTcjhMHiMO5i3aSZis6WxPjqW_N-17TTzdH0ej0lJ6at7pCLxVkgX1H-rcMwk1wYzkk%40396F013718A1D9A1_0081SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:42 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.628851', '0', '0', '1', '0', '200|0|0|3b221af09cfbf4ced4de21504f6caf0c', '0', '0');
INSERT INTO wp_blc_links VALUES('57', 'http://www.ncbi.nlm.nih.gov/pubmed/20930310', '0000-00-00 00:00:00', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '2013-05-08 09:40:42', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/20930310', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:42 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8B3E5618A1D9A1_0100SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8B3E5618A1D9A1_0100SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:42 GMT
\nSet-Cookie: WebEnv=1RGJu9TeGJoSxwmvEP5OM5VXQL_JFdRO4J82TGsTGcDdAENS_CYScT8aVAuDPcCWvZRkCUPE89vcYe4xG8RlSn7jC0Xpg-5QQ%40CE8B3E5618A1D9A1_0100SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:43 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.461032', '0', '0', '1', '0', '200|0|0|500c786800937a96fd8ee4881d9eb68e', '0', '0');
INSERT INTO wp_blc_links VALUES('59', 'http://wordpress.org/development/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://wordpress.org/news/', '1', '=== HTTP code : 200 ===\n\nHTTP/1.1 301 Moved Permanently
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html
\nContent-Length: 178
\nConnection: close
\nLocation: http://wordpress.org/news/
\nX-nc: HIT lax 249
\n
\nHTTP/1.1 200 OK
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html; charset=utf-8
\nConnection: close
\nVary: Accept-Encoding
\nX-Pingback: http://wordpress.org/news/xmlrpc.php
\nLink: <http://wp.me/ZhYe>; rel=shortlink
\nX-nc: HIT lax 249
\n
\n\nLink is valid.', '200', '', '', '0.005619', '0', '0', '1', '0', '200|0|0|fa02148807c8b091f77c60ef1e78fed0', '0', '0');
INSERT INTO wp_blc_links VALUES('60', 'http://wordpress.org/extend/ideas/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://wordpress.org/extend/ideas/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html; charset=utf-8
\nConnection: close
\nVary: Accept-Encoding
\nX-nc: EXPIRED lax 249
\n
\n\nLink is valid.', '200', '', '', '0.344468', '0', '0', '1', '0', '200|0|0|e8c3ed9b14697d598db49bec46b1b346', '0', '0');
INSERT INTO wp_blc_links VALUES('61', 'http://wordpress.org/support/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://wordpress.org/support/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html; charset=utf-8
\nConnection: close
\nVary: Accept-Encoding
\nX-nc: HIT lax 249
\n
\n\nLink is valid.', '200', '', '', '0.001279', '0', '0', '1', '0', '200|0|0|1456808f2203afff679945a4720401b1', '0', '0');
INSERT INTO wp_blc_links VALUES('62', 'http://wordpress.org/extend/plugins/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://wordpress.org/extend/plugins/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html; charset=utf-8
\nConnection: close
\nVary: Accept-Encoding
\nX-nc: HIT lax 249
\n
\n\nLink is valid.', '200', '', '', '0.001178', '0', '0', '1', '0', '200|0|0|c523ef557a5346199cecd3f1fcdfcb7e', '0', '0');
INSERT INTO wp_blc_links VALUES('63', 'http://wordpress.org/extend/themes/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://wordpress.org/extend/themes/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html; charset=utf-8
\nConnection: close
\nVary: Accept-Encoding
\nX-nc: HIT lax 249
\n
\n\nLink is valid.', '200', '', '', '0.001178', '0', '0', '1', '0', '200|0|0|04d5d2af50159ffcdf98e68d75daa4fd', '0', '0');
INSERT INTO wp_blc_links VALUES('64', 'http://planet.wordpress.org/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://planet.wordpress.org/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nServer: nginx
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nContent-Type: text/html
\nContent-Length: 71634
\nConnection: close
\nVary: Accept-Encoding
\nLast-Modified: Wed, 08 May 2013 09:30:27 GMT
\nX-nc: HIT lax 250
\nAccept-Ranges: bytes
\n
\n\nLink is valid.', '200', '', '', '0.007042', '0', '0', '1', '0', '200|0|0|63ea7fc1950318b883a7f367b25e8a37', '0', '0');
INSERT INTO wp_blc_links VALUES('66', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481.jpg', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.painbreakthrough.com/wp-content/uploads/bigstock_A_male_nurse_2928361-e1288287101481.jpg', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:38 GMT
\nAccept-Ranges: bytes
\nContent-Length: 97409
\nContent-Type: image/jpeg
\n
\n\nLink is valid.', '200', '', '', '0.002363', '0', '0', '1', '0', '200|0|0|30a64aedfe45e5e4ff559d43366f99fa', '0', '0');
INSERT INTO wp_blc_links VALUES('67', 'http://www.sciencedirect.com/science?_ob=ArticleURL&_udi=B6SYR-519218J-5&_user=4423&_coverDate=10%2F21%2F2010&_rdoc=70&_fmt=high&_orig=browse&_origin=browse&_zone=rslt_list_item&_srch=doc-info(%23toc%234841%239999%23999999999%2399999%23FLA%23display%23Articles)&_cdi=4841&_sort=d&_docanchor=&_ct=177&_acct=C000059605&_version=1&_urlVersion=0&_userid=4423&md5=70889cbb3dd55c11347394bacde45b6f&searchtype=a', '0000-00-00 00:00:00', '2013-05-08 17:31:25', '2013-05-08 17:31:25', '2013-05-08 17:31:25', '0', 'http://www.sciencedirect.com/science/article/pii/S000689931002322X', '2', '=== HTTP code : 200 ===\n\nHTTP/1.0 301 Moved Permanently
\nLocation: http://www.sciencedirect.com/science?_ob=ArticleURL&_udi=B6SYR-519218J-5&_user=4423&_coverDate=10%2F21%2F2010&_rdoc=70&_fmt=high&_orig=browse&_origin=browse&_zone=rslt_list_item&_srch=doc-info(%23toc%234841%239999%23999999999%2399999%23FLA%23display%23Articles)&_cdi=4841&_sort=d&_docanchor=&_ct=177&_acct=C000059605&_version=1&_urlVersion=0&_userid=4423&md5=70889cbb3dd55c11347394bacde45b6f&searchtype=a&ccp=y
\nSet-Cookie: EUID=1bbf7180-b805-11e2-91ea-00000aab0f26; expires=Tue, 03 May 2033 17:31:25 GMT; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: MIAMISESSION=1bbf3cec-b805-11e2-91ea-00000aab0f26:3545487085; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: USER_STATE_COOKIE=346fa8c434beaa18dbb50e2b7e6f20803c2c344c39e22674; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: MIAMIAUTH=fcf973efc7eed323dc587b229d851e756a17d68d29bf0c91f8ab1db13fe4046be5039da8871a6c0ed55b548b7499a183de3ee40c38742e9919c6080c7529ca027d40422370f074622d5e246e0c98a3fb0678cfa670ebafef75e3bcdd4540b6e99f1bdfe00e1493b7241d7415536cc6dafd050886778d8536543a8c25f235c177c2fe51e56bdddad72bc8d614d1065887062e743bb472a0408768b44b99ad7b080b3471e7eb4776d83a0c7a251f897cc6f2d3807635e30a82dcce7fadbdec0feb538f2c5c0802d01eb246b7e1b2e5a72c33d0343940329afd72c377101b527c2b1c1478981a2c5bf752885f0ad30ec796422fcb7703b928a6c21062e782ffe59983a2ee4232637b66d7f8a6f4ccc372e2ae037c88e52615bbaefd0999622fabca6d9f2451659d7a82; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: TARGET_URL=fcf74dd786744d87fbaaaf8652a764ab4a79b0d3ed681139e91069237606310567c0829015f2c9dd1e7f53b901efb30857b2a7556bf3ebf37f620254e716b81cf122d4ccec2478094372b4d2caf36ecd08b1381cc1b18cc7588ffbac292b7cb5eef1b9a51975fa047363e02d4c82e64b7757c9b42c9179bb1dca03cc3ff5dfe4f3e5ce66eba7c9714279bdd744cb0c383ab890cf9850e785d34d7addd5215dec592a5df43b67f1711f2e29c544c97662f4d2ba7a492d7ac0db2ea4854f852cafb63f62b5aa49f876df31d23d0f0aeaa2fbcf366a0bc52a6651ce0d32cbd775fa710d5bd1a3899c2dd47642be200a635916f4111188ac3f3184f3ca8d41eeaecd1966ce523dc48e4409acacbb894be20aaf5386f731080f87250496a1b7f35d9b6b616b73d505f21c89c8a9b0083be5ded870d52710e6c0479a3bc5d7a82eb5b775a0fa1eb922eac68352d73618ccfff3cc77e1f8a977d07275d024eee87f2bbe3645e70b065df2bafe675af7f3b62a6922e7287117430f49933b83e044ee21d09aa44f9b9d0eccf5e27e23c4a9953fe9b478bbaad43a7daa; path=/; domain=.sciencedirect.com; 
\nContent-Type: text/html
\nExpires: Tue, 01 Jan 1980 04:00:00 GMT
\nX-RE-Ref: 0 1302312516
\nServer: www.sciencedirect.com
\nP3P: CP=\"IDC DSP LAW ADM DEV TAI PSA PSD IVA IVD CON HIS TEL OUR DEL SAM OTR IND OTC\"
\nVary: Accept-Encoding, User-Agent
\n
\nHTTP/1.0 301 Moved Permanently
\nLocation: http://www.sciencedirect.com/science/article/pii/S000689931002322X
\nSet-Cookie: EUID=1be6be84-b805-11e2-bde2-00000aab0f02; expires=Tue, 03 May 2033 17:31:25 GMT; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: MIAMISESSION=1be681da-b805-11e2-bde2-00000aab0f02:3545487085; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: USER_STATE_COOKIE=346fa8c434beaa18dbb50e2b7e6f20803c2c344c39e22674; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: MIAMIAUTH=5141805bdefc0c17fcd4dff8d0c14042caba3fdba41ccec0fdbaa68b4009344e7a0278bce5a34f40c02b8ad392a5770f6e0f606bd436b9936c5053fab4309a98be236c68813b077953a13566017b6accf0421703cd83187e32dafa0cbad9e841235791304c6da35c90850ec8f65620d8b80c46bc14824ca4134a43658bdc8c39deae7848efad429aca7f6c9e047adfcdb7ebf3ce17ccc3cea060529c27c0e977ab5528ce42bd7361c6b1f6c80410d2e39baa4ddf6c39e8b80765d3985c65f5588fc8a6a1681eb38702af5a4f0fec872c2df4d764fa45220f19c2680e4097b71f314c3524b20468b11795a507d2d65ea29b09c798d93239505a482c0649dcb82d2c674d0084b64f22f9a948de6c571668b3096500f26355eb8fc24987d1f00fc7ec843182e0c197e6; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: TARGET_URL=fcf74dd786744d87fbaaaf8652a764ab4a79b0d3ed681139e91069237606310567c0829015f2c9dd1e7f53b901efb30857b2a7556bf3ebf37f620254e716b81cf122d4ccec2478094372b4d2caf36ecd08b1381cc1b18cc7588ffbac292b7cb5eef1b9a51975fa047363e02d4c82e64b7757c9b42c9179bb1dca03cc3ff5dfe4f3e5ce66eba7c9714279bdd744cb0c383ab890cf9850e785d34d7addd5215dec592a5df43b67f1711f2e29c544c97662f4d2ba7a492d7ac0db2ea4854f852cafb63f62b5aa49f876df31d23d0f0aeaa2fbcf366a0bc52a6651ce0d32cbd775fa710d5bd1a3899c2dd47642be200a635916f4111188ac3f3184f3ca8d41eeaecd1966ce523dc48e4409acacbb894be20aaf5386f731080f87250496a1b7f35d9b6b616b73d505f21c89c8a9b0083be5ded870d52710e6c0479a3bc5d7a82eb5b775a0fa1eb922eac68352d73618ccfff3cc77e1f8a977d07275d024eee87f2bbe3645e70b065df2bafe675af7f3b62a6922e7287117430f49933b83e044ee21d09aa44f9b9d0eccf5e27e23c4a9953fe9ac3e0bb301bfa55016e064994c21dd71; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: SD_ART_LINK_STATE=ee96b6ae97b6e58a527a9f33c7be0332fd9abb836624110fa0a21bbd6da57278fb338f7449cf65a5325b38e81d2b9aa091244f2f099e4ff994eca63d3c212fce6b31ee8661b174470355713b837b667872450fb67a71d65773ad424e5a7f5b192797243a8682f0ef3cf9c6da4e5616e658c39eec3f46ae9d8e4d4f77b60794dd21c28ffa171a437dee08c57026b75df842f19c11f9402430e764fd77731a3af52e943c406cd6d75446a0eb2ad05b6877c0e87ba829054ff2297c0d828cd05884030e2537e85f4ae63f16a1b91d01ee11ec787af87fabd99b6a14e7ecb4528d09154bcfc4113281b7dbe7cf2013911220da71d8b8d58e4ab509766395fbb43ea86901377c8ded9787c1a4a46ca70e3a45; path=/; domain=.sciencedirect.com; 
\nContent-Type: text/html
\nExpires: Tue, 01 Jan 1980 04:00:00 GMT
\nConnection: close
\nX-RE-Ref: 0 1302570538
\nServer: www.sciencedirect.com
\nP3P: CP=\"IDC DSP LAW ADM DEV TAI PSA PSD IVA IVD CON HIS TEL OUR DEL SAM OTR IND OTC\"
\nVary: Accept-Encoding, User-Agent
\n
\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 17:31:25 GMT
\nLast-Modified: Wed, 08 May 2013 17:31:25 GMT
\nSet-Cookie: EUID=1c0ef3ea-b805-11e2-b3a6-00000aab0f6c; expires=Tue, 03 May 2033 17:31:25 GMT; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: MIAMISESSION=1c0dc6fa-b805-11e2-b3a6-00000aab0f6c:3545487085; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: USER_STATE_COOKIE=346fa8c434beaa18dbb50e2b7e6f20803c2c344c39e22674; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: TARGET_URL=fcf74dd786744d87fbaaaf8652a764ab4a79b0d3ed681139e910692376063105cac4b68b9ec80cda83e0305080161614adcf3744387f6e9bebb7db6919b04f4496eaed9925974355; path=/; domain=.sciencedirect.com; 
\nSet-Cookie: MIAMIAUTH=edbde2b831fa02059884d7316ea930104ea350a5905d376e8777442ce6b0c2d12d20c4d7b7aba090aa3ed2b74ab08afd35618af609594d8531eb28f678bb406784f043cd5dcf70e6c291751f28d2ed0d3e03bb312c05bcb4abc5086c4b11b8f525a73fef332b2f62b6b27ff042ab8e207153dbc773dad4320910f072f4d3029105e775ef62878a025e126b242f1ba1e88137569cba72db0ace5c235932726a9a13170a04d132a2005d6e583c38e768392a451a24e14de76ffa35602aa469a1e018f50ae8b2f0d4db71bce679f674eb15dd41e0b47a978d52604eea08aadaa8fe651cb1ed5b6943c54b35339877e5b4247612077f4d8e16b83a11e82b13d06bae5cb79db1577a46886e88ef780864112bb5d07e3d5a7316f95167b70335957013; path=/; domain=.sciencedirect.com; 
\nContent-Type: text/html
\nExpires: Tue, 01 Jan 1980 04:00:00 GMT
\nConnection: close
\nX-RE-Ref: 0 1302827264
\nServer: www.sciencedirect.com
\nP3P: CP=\"IDC DSP LAW ADM DEV TAI PSA PSD IVA IVD CON HIS TEL OUR DEL SAM OTR IND OTC\"
\nVary: Accept-Encoding, User-Agent
\n
\n\nLink is valid.', '200', '', '', '1.16412', '0', '0', '1', '0', '200|0|0|5732796a9ad52222ccb6760e8f289365', '0', '0');
INSERT INTO wp_blc_links VALUES('69', 'http://www.painbreakthrough.com', '0000-00-00 00:00:00', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '0', 'http://www.painbreakthrough.com', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:01 GMT
\nServer: Apache
\nLast-Modified: Tue, 09 Apr 2013 14:04:39 GMT
\nAccept-Ranges: bytes
\nContent-Length: 31239
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:41:04 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.002831', '0', '0', '1', '0', '200|0|0|0f9c9641531822ca686410c83da3bb12', '0', '0');
INSERT INTO wp_blc_links VALUES('70', 'http://www.ncbi.nlm.nih.gov/pubmed/21254790', '0000-00-00 00:00:00', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21254790', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:41:01 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8D161E18A1DAD1_0164SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8D161E18A1DAD1_0164SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:41:01 GMT
\nSet-Cookie: WebEnv=1dEZaSaES0GyNnXaEYR7ntQMjgfxm6uEfTzJLZlParQHstqvbc-8JkCuzvgr5FflvTr9SaIsUVxguPooDxGgh0ZLHrZ5ydON0lW%40CE8D161E18A1DAD1_0164SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:41:01 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.664565', '0', '0', '1', '0', '200|0|0|fac582c7c05b48f2f47fba1585bbd935', '0', '0');
INSERT INTO wp_blc_links VALUES('85', 'http://scholar.google.com/scholar?hl=en&q=tobinick&as_sdt=1%2C5&as_ylo=&as_vis=0', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://scholar.google.com/scholar?hl=en&q=tobinick&as_sdt=1%2C5&as_ylo=&as_vis=0', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: GSP=ID=a98d689d0288698f:S=-Dxo53KfKSqa-mUq; expires=Sun, 17-Jan-2038 19:14:07 GMT; path=/; domain=.scholar.google.com
\nSet-Cookie: PREF=ID=a98d689d0288698f:TM=1368006043:LM=1368006043:S=hwneMoDOOeI-zipu; expires=Fri, 08-May-2015 09:40:43 GMT; path=/; domain=.google.com
\nX-Content-Type-Options: nosniff
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: scholar
\nCache-Control: private
\nX-XSS-Protection: 1; mode=block
\nX-Frame-Options: SAMEORIGIN
\nTransfer-Encoding: chunked
\nExpires: Wed, 08 May 2013 09:40:43 GMT
\n
\n\nLink is valid.', '200', '', '', '0.185935', '0', '0', '1', '0', '200|0|0|112d1d690e7d656c522ad3fcc8b99c34', '0', '0');
INSERT INTO wp_blc_links VALUES('86', 'http://www.painbreakthrough.com/wp-content/uploads/ncpn.pdf', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.painbreakthrough.com/wp-content/uploads/ncpn.pdf', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:31 GMT
\nAccept-Ranges: bytes
\nContent-Length: 102330
\nContent-Type: application/pdf
\n
\n\nLink is valid.', '200', '', '', '0.020502', '0', '0', '1', '0', '200|0|0|fc918ed7a0120e30d6403a6313cf7613', '0', '0');
INSERT INTO wp_blc_links VALUES('87', 'http://www.painbreakthrough.com/wp-content/uploads/tobinick.f1000.pdf', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.painbreakthrough.com/wp-content/uploads/tobinick.f1000.pdf', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:31 GMT
\nAccept-Ranges: bytes
\nContent-Length: 82711
\nContent-Type: application/pdf
\n
\n\nLink is valid.', '200', '', '', '0.010399', '0', '0', '1', '0', '200|0|0|f72cf137e4389b96ff74e978855328ea', '0', '0');
INSERT INTO wp_blc_links VALUES('88', 'http://www.painbreakthrough.com/wp-content/uploads/tobinick.stanford.pdf', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.painbreakthrough.com/wp-content/uploads/tobinick.stanford.pdf', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: Apache
\nLast-Modified: Tue, 01 Mar 2011 15:19:38 GMT
\nAccept-Ranges: bytes
\nContent-Length: 480214
\nContent-Type: application/pdf
\n
\n\nLink is valid.', '200', '', '', '0.004719', '0', '0', '1', '0', '200|0|0|f4093e578785428a572387ffd9981665', '0', '0');
INSERT INTO wp_blc_links VALUES('114', 'http://www.painbreakthrough.com/about/about-the-institute/attachment/cv-et_-sept2010-final2_/', '0000-00-00 00:00:00', '2013-05-06 19:30:19', '2013-05-06 19:30:19', '2013-05-06 19:30:19', '0', 'http://www.painbreakthrough.com/about/about-the-institute/attachment/cv-et_-sept2010-final2_/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Mon, 06 May 2013 19:30:19 GMT
\nServer: Apache
\nLast-Modified: Wed, 23 Jan 2013 17:50:08 GMT
\nAccept-Ranges: bytes
\nContent-Length: 13292
\nCache-Control: max-age=3, must-revalidate
\nExpires: Mon, 06 May 2013 19:30:22 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.042596', '0', '0', '1', '0', '200|0|0|72ae09ff71516d9ca4c33809c25ee58b', '0', '0');
INSERT INTO wp_blc_links VALUES('90', 'http://www.nrimed.com', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.nrimed.com', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: Apache
\nLast-Modified: Thu, 25 Apr 2013 20:48:35 GMT
\nAccept-Ranges: bytes
\nContent-Length: 27191
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:40:46 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.011614', '0', '0', '1', '0', '200|0|0|4acc15a0916fe057ad0f29441dd55f05', '0', '0');
INSERT INTO wp_blc_links VALUES('91', 'http://www.painbreakthrough.com/videos/improvement-within-minutes-in-neck-pain-and-cervical-radiculopathy/', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.painbreakthrough.com/videos/improvement-within-minutes-in-neck-pain-and-cervical-radiculopathy/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:43 GMT
\nServer: Apache
\nLast-Modified: Tue, 09 Apr 2013 16:47:09 GMT
\nAccept-Ranges: bytes
\nContent-Length: 14290
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:40:46 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.016733', '0', '0', '1', '0', '200|0|0|d6478b33b3fce29e9028e97ea5213404', '0', '0');
INSERT INTO wp_blc_links VALUES('92', 'http://www.ncbi.nlm.nih.gov/pubmed/12809967', '0000-00-00 00:00:00', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '2013-05-08 09:40:43', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/12809967', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:44 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8A53FC18A1D9C1_0101SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8A53FC18A1D9C1_0101SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:44 GMT
\nSet-Cookie: WebEnv=1dutc-h9wsXWn7PMc2WIV1fgAUQT4ZTFRhs4yEKx_Hu-hTYSMSjU505HcBiGTarsil4kFSpaFxvONk5avoIlfnd3UfuLs7IAA%40CE8A53FC18A1D9C1_0101SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:44 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.4946', '0', '0', '1', '0', '200|0|0|8976fca9c961fe19066a870d7bfb27ec', '0', '0');
INSERT INTO wp_blc_links VALUES('93', 'http://www.ncbi.nlm.nih.gov/pubmed/21288189', '0000-00-00 00:00:00', '2013-05-08 09:40:46', '2013-05-08 09:40:46', '2013-05-08 09:40:46', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21288189', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:46 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396D19D318A1D9E1_0043SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396D19D318A1D9E1_0043SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:46 GMT
\nSet-Cookie: WebEnv=1V1LbtoloR0FT0BfptyVwpnXQm2PEp9YH0yBPr3peNSFZnlDXW262PNp8wOx7jtuW1i399dUaIcXg3b3TdhOxKu-JlwbxkGt5tp%40396D19D318A1D9E1_0043SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:47 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.921167', '0', '0', '1', '0', '200|0|0|cf80d9b8b9970e84b1470fb01d395168', '0', '0');
INSERT INTO wp_blc_links VALUES('94', 'http://www.ncbi.nlm.nih.gov/pubmed/21185611', '0000-00-00 00:00:00', '2013-05-08 09:40:47', '2013-05-08 09:40:47', '2013-05-08 09:40:47', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21185611', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:48 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396953F218A1DA01_0185SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396953F218A1DA01_0185SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:48 GMT
\nSet-Cookie: WebEnv=1XaKa5iLHtg4hyj0Ys4VGsbaKNMYtFZNCtZ1sGvUaYqbK6LhYQ7rkGnwN5LNxgXUKeINwBv4k7KZFKqAlf6RX9OQh59e9GZEMP%40396953F218A1DA01_0185SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:48 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.422155', '0', '0', '1', '0', '200|0|0|8c42575d9cd4e4ce6575a34c73d25836', '0', '0');
INSERT INTO wp_blc_links VALUES('95', 'http://www.ncbi.nlm.nih.gov/pubmed/21217452', '0000-00-00 00:00:00', '2013-05-08 09:40:48', '2013-05-08 09:40:48', '2013-05-08 09:40:48', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/21217452', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:40:48 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE8B40F118A1DA01_0047SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE8B40F118A1DA01_0047SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:40:48 GMT
\nSet-Cookie: WebEnv=1piw8JrRqLkPehnUf9h-SBkaaVRq09f9SuJJ03EswkxhqTvCx4mq5F5BQFLxI8KgbG2Ean7k7GcidBgHRwmFWUtSC4zpUM4RL-r%40CE8B40F118A1DA01_0047SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:40:48 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.625493', '0', '0', '1', '0', '200|0|0|7bb47210958b34be29253fd6f2fd721e', '0', '0');
INSERT INTO wp_blc_links VALUES('96', 'http://painbreakthrough.com/about/terms-of-use/', '0000-00-00 00:00:00', '2013-05-08 09:40:49', '2013-05-08 09:40:49', '2013-05-08 09:40:49', '0', 'http://www.painbreakthrough.com/about/terms-of-use/', '1', '=== HTTP code : 200 ===\n\nHTTP/1.1 301 Moved Permanently
\nDate: Wed, 08 May 2013 09:40:49 GMT
\nServer: Apache
\nVary: Cookie
\nX-Pingback: http://www.painbreakthrough.com/xmlrpc.php
\nLocation: http://www.painbreakthrough.com/about/terms-of-use/
\nContent-Type: text/html; charset=UTF-8
\n
\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:40:50 GMT
\nServer: Apache
\nLast-Modified: Thu, 24 Jan 2013 01:08:37 GMT
\nAccept-Ranges: bytes
\nContent-Length: 20636
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:40:53 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.952085', '0', '0', '1', '0', '200|0|0|f89b85de252f6b7bc2e6b3b2576c753b', '0', '0');
INSERT INTO wp_blc_links VALUES('98', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.neurology.pdf', '0000-00-00 00:00:00', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '0', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.neurology.pdf', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:01 GMT
\nServer: Apache
\nLast-Modified: Sun, 15 May 2011 01:08:56 GMT
\nAccept-Ranges: bytes
\nContent-Length: 501113
\nContent-Type: application/pdf
\n
\n\nLink is valid.', '200', '', '', '0.016946', '0', '0', '1', '0', '200|0|0|aa36a97d13ecec480d01b3e3473e5bbe', '0', '0');
INSERT INTO wp_blc_links VALUES('99', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.jni_.rapid_.pdf', '0000-00-00 00:00:00', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '0', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.jni_.rapid_.pdf', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:01 GMT
\nServer: Apache
\nLast-Modified: Sun, 15 May 2011 00:51:54 GMT
\nAccept-Ranges: bytes
\nContent-Length: 1611837
\nContent-Type: application/pdf
\n
\n\nLink is valid.', '200', '', '', '0.017584', '0', '0', '1', '0', '200|0|0|9bae06f4c3196985302292e796d5ef74', '0', '0');
INSERT INTO wp_blc_links VALUES('100', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.bmcrn_.pdf', '0000-00-00 00:00:00', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '0', 'http://www.strokebreakthrough.com/wp-content/uploads/tobinick.bmcrn_.pdf', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:01 GMT
\nServer: Apache
\nLast-Modified: Sat, 14 May 2011 17:44:18 GMT
\nAccept-Ranges: bytes
\nContent-Length: 597648
\nContent-Type: application/pdf
\n
\n\nLink is valid.', '200', '', '', '0.006663', '0', '0', '1', '0', '200|0|0|6fd285ec21c2b54bb1789e8513ce78f8', '0', '0');
INSERT INTO wp_blc_links VALUES('101', 'http://www.ncbi.nlm.nih.gov/pubmed/22020607', '0000-00-00 00:00:00', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '2013-05-08 09:41:01', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/22020607', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Wed, 08 May 2013 09:41:02 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: 396C636B18A1DAE1_0009SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=396C636B18A1DAE1_0009SID; domain=.nih.gov; path=/; expires=Thu, 08 May 2014 09:41:02 GMT
\nSet-Cookie: WebEnv=1dYRCNEEvM2yolAadbacJl4MAJuEoJnFsqdysRX_SrkQP1HMKQbdqrCkybXrOygylt7358_IqqxTS_KZUJUns_mB-FEG08t5GV%40396C636B18A1DAE1_0009SID; domain=.nlm.nih.gov; path=/; expires=Wed, 08 May 2013 17:41:02 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.704294', '0', '0', '1', '0', '200|0|0|3e95c872485dcd702eb18db096ff2cd6', '0', '0');
INSERT INTO wp_blc_links VALUES('102', 'http://sixtyminutes.ninemsn.com.au/stories/8360210/a-new-shot-at-life', '0000-00-00 00:00:00', '2013-05-08 09:41:02', '2013-05-08 09:41:02', '2013-05-08 09:41:02', '0', 'http://sixtyminutes.ninemsn.com.au/stories/8360210/a-new-shot-at-life', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nCache-Control: private
\nContent-Length: 77779
\nContent-Type: text/html; charset=utf-8
\nServer: Microsoft-IIS/7.5
\nX-AspNet-Version: 2.0.50727
\nX-Powered-By: ASP.NET
\nP3P: CP=\"BUS CUR CONi FIN IVDi ONL OUR PHY SAMo\"
\nX-ServerName: WEBDYN15
\nDate: Wed, 08 May 2013 09:41:03 GMT
\n
\n\nLink is valid.', '200', '', '', '0.989465', '0', '0', '1', '0', '200|0|0|749bbea72b15fc72952bebb2d2e2514a', '0', '0');
INSERT INTO wp_blc_links VALUES('103', 'http://www.strokebreakthrough.com/contact/ucla-medical-plaza-office/', '0000-00-00 00:00:00', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '0', 'http://www.strokebreakthrough.com/contact/ucla-medical-plaza-office/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Thu, 09 May 2013 09:31:37 GMT
\nServer: Apache
\nLast-Modified: Wed, 08 May 2013 21:31:20 GMT
\nAccept-Ranges: bytes
\nContent-Length: 14681
\nCache-Control: max-age=3, must-revalidate
\nExpires: Thu, 09 May 2013 09:31:40 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.006449', '0', '0', '1', '0', '200|0|0|3a2559ad66034d76a313a6463b11a226', '0', '0');
INSERT INTO wp_blc_links VALUES('104', 'http://www.strokebreakthrough.com/contact/orange-county-office/', '0000-00-00 00:00:00', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '0', 'http://www.strokebreakthrough.com/contact/orange-county-office/', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Thu, 09 May 2013 09:31:37 GMT
\nServer: Apache
\nLast-Modified: Thu, 09 May 2013 02:14:41 GMT
\nAccept-Ranges: bytes
\nContent-Length: 14447
\nCache-Control: max-age=3, must-revalidate
\nExpires: Thu, 09 May 2013 09:31:40 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.015383', '0', '0', '1', '0', '200|0|0|2bc8d981cfab282c7b30e2aa9938eb7d', '0', '0');
INSERT INTO wp_blc_links VALUES('108', 'tel:%28310%29%20824-6199', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-05-08 02:44:13', '140', '', '0', 'The plugin doesn\'t know how to check this type of link.', '0', '', '', '0', '0', '0', '1', '0', '', '0', '0');
INSERT INTO wp_blc_links VALUES('107', 'mailto:nrimed@gmail.com', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2013-05-08 02:44:13', '140', '', '0', 'The plugin doesn\'t know how to check this type of link.', '0', '', '', '0', '0', '0', '1', '0', '', '0', '0');
INSERT INTO wp_blc_links VALUES('109', 'http://www.strokebreakthrough.com', '0000-00-00 00:00:00', '2013-05-08 09:41:03', '2013-05-08 09:41:03', '2013-05-08 09:41:03', '0', 'http://www.strokebreakthrough.com', '0', '=== HTTP code : 200 ===\n\nHTTP/1.1 200 OK
\nDate: Wed, 08 May 2013 09:41:03 GMT
\nServer: Apache
\nLast-Modified: Wed, 08 May 2013 00:46:14 GMT
\nAccept-Ranges: bytes
\nContent-Length: 15828
\nCache-Control: max-age=3, must-revalidate
\nExpires: Wed, 08 May 2013 09:41:06 GMT
\nVary: Accept-Encoding,Cookie
\nContent-Type: text/html; charset=UTF-8
\n
\n\nLink is valid.', '200', '', '', '0.005167', '0', '0', '1', '0', '200|0|0|c1e49c28c0ca044b4d2573ed5838a137', '0', '0');
INSERT INTO wp_blc_links VALUES('111', 'http://www.ncbi.nlm.nih.gov/pubmed/22191562', '0000-00-00 00:00:00', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/22191562', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Thu, 09 May 2013 09:31:37 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE89091818B6CF91_0090SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE89091818B6CF91_0090SID; domain=.nih.gov; path=/; expires=Fri, 09 May 2014 09:31:37 GMT
\nSet-Cookie: WebEnv=169UrLx1UrOj1jKrVSUVwCTcVMqP34gXb_6yHYG-21qlol46xGqQb_ELzkH42usPTg5UiM4r7l_ypUcWVBW8y0iha1--2_cQju%40CE89091818B6CF91_0090SID; domain=.nlm.nih.gov; path=/; expires=Thu, 09 May 2013 17:31:37 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.781999', '0', '0', '1', '0', '200|0|0|ad4f2c3e3f3c5a6a627559f52d043f65', '0', '0');
INSERT INTO wp_blc_links VALUES('112', 'http://www.ncbi.nlm.nih.gov/pubmed/23100196', '0000-00-00 00:00:00', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '2013-05-09 09:31:37', '0', 'http://www.ncbi.nlm.nih.gov/pubmed/23100196', '0', '=== HTTP code : 200 ===\n\nHTTP/1.0 200 OK
\nDate: Thu, 09 May 2013 09:31:38 GMT
\nServer: Apache
\nCache-Control: private
\nNCBI-SID: CE890AC418B6CFA1_0051SID
\nContent-Type: text/html; charset=UTF-8
\nSet-Cookie: ncbi_sid=CE890AC418B6CFA1_0051SID; domain=.nih.gov; path=/; expires=Fri, 09 May 2014 09:31:38 GMT
\nSet-Cookie: WebEnv=1J9Q8sstEzTO8ESOwzeHzqxYH7L9rsjUWqSs8cpI2zMYP3pyD5i6dk8-AT-cm0b1pxYT2JSgp-eS7H6plJ9Fk6POZTV7LQeMR9L%40CE890AC418B6CFA1_0051SID; domain=.nlm.nih.gov; path=/; expires=Thu, 09 May 2013 17:31:38 GMT
\nVary: Accept-Encoding
\nConnection: close
\n
\n\nLink is valid.', '200', '', '', '0.616173', '0', '0', '1', '0', '200|0|0|54df2ca73d8fd79db4013acf6d4b9e3a', '0', '0');



DROP TABLE IF EXISTS wp_blc_synch;

CREATE TABLE `wp_blc_synch` (
  `container_id` int(20) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL,
  `synched` tinyint(3) unsigned NOT NULL,
  `last_synch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`container_type`,`container_id`),
  KEY `synched` (`synched`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO wp_blc_synch VALUES('2', 'page', '1', '2011-02-27 03:19:12');
INSERT INTO wp_blc_synch VALUES('6', 'page', '1', '2012-12-18 10:20:54');
INSERT INTO wp_blc_synch VALUES('33', 'page', '1', '2011-03-12 02:52:31');
INSERT INTO wp_blc_synch VALUES('37', 'page', '1', '2012-11-02 10:08:38');
INSERT INTO wp_blc_synch VALUES('35', 'page', '1', '2011-03-12 02:52:31');
INSERT INTO wp_blc_synch VALUES('627', 'page', '1', '2011-03-12 02:52:31');
INSERT INTO wp_blc_synch VALUES('624', 'page', '1', '2012-01-17 06:07:48');
INSERT INTO wp_blc_synch VALUES('621', 'page', '1', '2011-03-12 02:52:31');
INSERT INTO wp_blc_synch VALUES('58', 'page', '1', '2011-03-12 02:52:31');
INSERT INTO wp_blc_synch VALUES('60', 'page', '1', '2013-02-07 14:06:15');
INSERT INTO wp_blc_synch VALUES('63', 'page', '1', '2011-12-29 12:07:31');
INSERT INTO wp_blc_synch VALUES('65', 'page', '1', '2012-10-27 12:13:51');
INSERT INTO wp_blc_synch VALUES('67', 'page', '1', '2013-04-09 06:45:30');
INSERT INTO wp_blc_synch VALUES('30', 'page', '1', '2012-01-10 23:08:41');
INSERT INTO wp_blc_synch VALUES('619', 'page', '1', '2011-03-12 02:52:31');
INSERT INTO wp_blc_synch VALUES('145', 'page', '1', '2011-12-25 09:01:01');
INSERT INTO wp_blc_synch VALUES('254', 'page', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('345', 'page', '1', '2013-02-07 14:04:10');
INSERT INTO wp_blc_synch VALUES('347', 'page', '1', '2013-02-07 14:05:37');
INSERT INTO wp_blc_synch VALUES('306', 'post', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('7', 'blogroll', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('6', 'blogroll', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('5', 'blogroll', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('4', 'blogroll', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('3', 'blogroll', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('2', 'blogroll', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('462', 'page', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('473', 'page', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('480', 'post', '1', '2011-02-06 04:29:48');
INSERT INTO wp_blc_synch VALUES('47', 'page', '1', '2012-10-20 09:57:26');
INSERT INTO wp_blc_synch VALUES('675', 'page', '1', '2012-01-17 06:08:42');
INSERT INTO wp_blc_synch VALUES('724', 'page', '1', '2011-12-29 20:48:53');
INSERT INTO wp_blc_synch VALUES('753', 'post', '1', '2011-11-26 22:29:45');
INSERT INTO wp_blc_synch VALUES('758', 'post', '1', '2011-11-26 22:29:45');
INSERT INTO wp_blc_synch VALUES('783', 'page', '1', '2012-03-13 08:42:40');
INSERT INTO wp_blc_synch VALUES('787', 'page', '1', '2012-05-16 15:27:30');



DROP TABLE IF EXISTS wp_cformsdata;

CREATE TABLE `wp_cformsdata` (
  `f_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `sub_id` int(11) unsigned NOT NULL,
  `field_name` varchar(100) NOT NULL DEFAULT '',
  `field_val` text,
  PRIMARY KEY (`f_id`)
) ENGINE=MyISAM AUTO_INCREMENT=76302 DEFAULT CHARSET=utf8;

INSERT INTO wp_cformsdata VALUES('1', '1', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2', '1', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3', '1', 'Name', 'Larry Tartisel');
INSERT INTO wp_cformsdata VALUES('4', '1', 'City/State', 'Camarillo, CA');
INSERT INTO wp_cformsdata VALUES('5', '1', 'Phone', '805-760-6200');
INSERT INTO wp_cformsdata VALUES('6', '1', 'Email', 'larry@altramarketing.com');
INSERT INTO wp_cformsdata VALUES('7', '1', 'How did you hear about us?', 'Website');
INSERT INTO wp_cformsdata VALUES('8', '1', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('9', '1', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease,Annular tear');
INSERT INTO wp_cformsdata VALUES('10', '1', 'If yes, when did this occur?', ' 2 years ago');
INSERT INTO wp_cformsdata VALUES('11', '1', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('12', '1', 'Date of most recent scan', '2 years ago');
INSERT INTO wp_cformsdata VALUES('13', '1', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('14', '1', 'When did the pain begin?', '2 years ago');
INSERT INTO wp_cformsdata VALUES('15', '1', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('16', '1', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('17', '1', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('18', '1', 'If no, number of hours in pain', '10 hours');
INSERT INTO wp_cformsdata VALUES('19', '1', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('20', '1', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('21', '1', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('22', '1', 'Date of onset of pain?', '2 years ago');
INSERT INTO wp_cformsdata VALUES('23', '1', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('24', '1', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('25', '1', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('26', '1', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('27', '1', 'Comments, Questions', 'This is the comments, question area.  No need to reply or send back.\n\nThanks, Larry');
INSERT INTO wp_cformsdata VALUES('28', '2', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('29', '2', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('30', '2', 'Name', 'James Minx');
INSERT INTO wp_cformsdata VALUES('31', '2', 'City/State', 'Anaheim, CSA');
INSERT INTO wp_cformsdata VALUES('32', '2', 'Phone', '714 630 0201');
INSERT INTO wp_cformsdata VALUES('33', '2', 'Email', 'mnxbx2@att.netI');
INSERT INTO wp_cformsdata VALUES('34', '2', 'How did you hear about us?', 'Internet Search for Sciatica Relief');
INSERT INTO wp_cformsdata VALUES('35', '2', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('36', '2', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('37', '2', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('38', '2', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('39', '2', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('40', '2', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('41', '2', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('42', '2', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('43', '2', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('44', '2', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('45', '2', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('46', '2', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('47', '2', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('48', '2', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('49', '2', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('50', '2', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('51', '2', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('52', '2', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('53', '2', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('54', '2', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('55', '3', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('56', '3', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('57', '3', 'Name', 'James Minx');
INSERT INTO wp_cformsdata VALUES('58', '3', 'City/State', 'Anaheim, CA');
INSERT INTO wp_cformsdata VALUES('59', '3', 'Phone', '714 630 0201');
INSERT INTO wp_cformsdata VALUES('60', '3', 'Email', 'mnxbx2@clear.net');
INSERT INTO wp_cformsdata VALUES('61', '3', 'How did you hear about us?', 'Internet Search for Sciatica Relief');
INSERT INTO wp_cformsdata VALUES('62', '3', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('63', '3', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('64', '3', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('65', '3', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('66', '3', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('67', '3', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('68', '3', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('69', '3', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('70', '3', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('71', '3', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('72', '3', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('73', '3', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('74', '3', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('75', '3', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('76', '3', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('77', '3', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('78', '3', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('79', '3', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('80', '3', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('81', '3', 'Comments, Questions', 'This message is a correction to another just sent containing an incorrect email address.\nI am awaiting the results of e-xrays taken last Friday for my primary care Doctor, but I have looked at your videos and have read much about etanercept.  I am very interested in learning more about your treatment.\n\nThank you\nJim Minx\n\nFYI: I\'m 75 yrs old and otherwise in good health');
INSERT INTO wp_cformsdata VALUES('82', '4', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('83', '4', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('84', '4', 'Name', 'Patrick Scott');
INSERT INTO wp_cformsdata VALUES('85', '4', 'City/State', 'Lompoc,CA');
INSERT INTO wp_cformsdata VALUES('86', '4', 'Phone', '8057417327');
INSERT INTO wp_cformsdata VALUES('87', '4', 'Email', '1scottenterprises@gmail.com');
INSERT INTO wp_cformsdata VALUES('88', '4', 'How did you hear about us?', 'AM Radio');
INSERT INTO wp_cformsdata VALUES('89', '4', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('90', '4', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('91', '4', 'If yes, when did this occur?', 'approx 1984');
INSERT INTO wp_cformsdata VALUES('92', '4', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('93', '4', 'Date of most recent scan', 'Oct/Nov2010');
INSERT INTO wp_cformsdata VALUES('94', '4', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('95', '4', 'When did the pain begin?', '1984');
INSERT INTO wp_cformsdata VALUES('96', '4', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('97', '4', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('98', '4', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('99', '4', 'If no, number of hours in pain', 'early am and on & off in the day ');
INSERT INTO wp_cformsdata VALUES('100', '4', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs');
INSERT INTO wp_cformsdata VALUES('101', '4', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('102', '4', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('103', '4', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('104', '4', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('105', '4', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('106', '4', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('107', '4', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('108', '4', 'Comments, Questions', 'The pain is a result of L3-L$ and L$ L5. Pinched nerve, prolonged sitting stiffens. Having frequent re-occurrances monthly and is causing me to miss work. Only one occurrence when the pain traveled from my lower back[right side] sharp pain around the hip to the top and inside on my thigh down the inside of the knee to the outside below the knee. I\'ve experienced numbness in the right thigh [slight] top and inner areas. the pain was frequent to the left now both left side and right side are experiencing pain. Times it takes me down where i have to lay down for a few days. The pain level ranges daily from moderate mostly to severe once twice a month. Over the last 2 years the frequency of severe occurrences has increased to at least 1x month,');
INSERT INTO wp_cformsdata VALUES('109', '5', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('110', '5', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('111', '5', 'Name', 'Franca Villamaina');
INSERT INTO wp_cformsdata VALUES('112', '5', 'City/State', 'Frosinone    ITALIA');
INSERT INTO wp_cformsdata VALUES('113', '5', 'Phone', '3737204351');
INSERT INTO wp_cformsdata VALUES('114', '5', 'Email', 'pestenera98@libero.it');
INSERT INTO wp_cformsdata VALUES('115', '5', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('116', '5', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('117', '5', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('118', '5', 'If yes, when did this occur?', '2004');
INSERT INTO wp_cformsdata VALUES('119', '5', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('120', '5', 'Date of most recent scan', 'agosto 2010');
INSERT INTO wp_cformsdata VALUES('121', '5', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('122', '5', 'When did the pain begin?', 'giugno2010');
INSERT INTO wp_cformsdata VALUES('123', '5', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('124', '5', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('125', '5', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('126', '5', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('127', '5', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('128', '5', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('129', '5', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('130', '5', 'Date of onset of pain?', 'giugno 2010');
INSERT INTO wp_cformsdata VALUES('131', '5', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('132', '5', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('133', '5', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('134', '5', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('135', '5', 'Comments, Questions', 'ho protusioni da L2 a S1 con listesi di L5 su S1 e dolore sciatalgico continuo e violento da giugno 2010 Sono in terapia con LYRICA 150mg e CONTRAMAL 20 gtth ho eseguito in agosto terapia antalgica.Da ottobre fino a tutto gennaio ho eseguito fisioterapia e da febbraio eseguo sedute di osteopatia con scarsi benefici');
INSERT INTO wp_cformsdata VALUES('136', '6', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('137', '6', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('138', '6', 'Name', 'Hamid Yamotahari');
INSERT INTO wp_cformsdata VALUES('139', '6', 'City/State', 'Alhambra, CA');
INSERT INTO wp_cformsdata VALUES('140', '6', 'Phone', '310-309-0396');
INSERT INTO wp_cformsdata VALUES('141', '6', 'Email', 'hamdam2003@yahoo.com');
INSERT INTO wp_cformsdata VALUES('142', '6', 'How did you hear about us?', 'WebMD');
INSERT INTO wp_cformsdata VALUES('143', '6', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('144', '6', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('145', '6', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('146', '6', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('147', '6', 'Date of most recent scan', 'Jan. 2011');
INSERT INTO wp_cformsdata VALUES('148', '6', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('149', '6', 'When did the pain begin?', 'Late November 2010');
INSERT INTO wp_cformsdata VALUES('150', '6', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('151', '6', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('152', '6', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('153', '6', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('154', '6', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('155', '6', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('156', '6', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('157', '6', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('158', '6', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('159', '6', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('160', '6', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('161', '6', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('162', '6', 'Comments, Questions', 'The level of pain at times is about 9+ I have almost lost the use of my right leg and am schedule for Physical Therapy.\nCan stress cause this pain and scyatica?');
INSERT INTO wp_cformsdata VALUES('163', '7', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('164', '7', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('165', '7', 'Name', 'Mary Baldwin');
INSERT INTO wp_cformsdata VALUES('166', '7', 'City/State', 'Melbourne Victoria Australia');
INSERT INTO wp_cformsdata VALUES('167', '7', 'Phone', '0411277366');
INSERT INTO wp_cformsdata VALUES('168', '7', 'Email', 'mary.baldwin@bigpond.com');
INSERT INTO wp_cformsdata VALUES('169', '7', 'How did you hear about us?', 'Youtube and web site');
INSERT INTO wp_cformsdata VALUES('170', '7', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('171', '7', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('172', '7', 'If yes, when did this occur?', '5 months ago');
INSERT INTO wp_cformsdata VALUES('173', '7', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('174', '7', 'Date of most recent scan', '24/02/2011');
INSERT INTO wp_cformsdata VALUES('175', '7', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('176', '7', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('177', '7', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('178', '7', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('179', '7', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('180', '7', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('181', '7', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('182', '7', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('183', '7', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('184', '7', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('185', '7', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('186', '7', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('187', '7', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('188', '7', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('189', '7', 'Comments, Questions', 'Where can I get the same treatment in Australia PLEASE PLEASE...');
INSERT INTO wp_cformsdata VALUES('190', '8', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('191', '8', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('192', '8', 'Name', 'Kimberly Lindsay ');
INSERT INTO wp_cformsdata VALUES('193', '8', 'City/State', 'Long Beach, CA');
INSERT INTO wp_cformsdata VALUES('194', '8', 'Phone', '562-310-3741');
INSERT INTO wp_cformsdata VALUES('195', '8', 'Email', 'klindsay333@gmail.com');
INSERT INTO wp_cformsdata VALUES('196', '8', 'How did you hear about us?', 'internet google search');
INSERT INTO wp_cformsdata VALUES('197', '8', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('198', '8', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('199', '8', 'If yes, when did this occur?', 'cumulative throughout 3 years of driving 6 to 8 hours a day');
INSERT INTO wp_cformsdata VALUES('200', '8', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('201', '8', 'Date of most recent scan', 'october of 2010');
INSERT INTO wp_cformsdata VALUES('202', '8', 'Is there pain in:', 'Back,Neck,Arm');
INSERT INTO wp_cformsdata VALUES('203', '8', 'When did the pain begin?', 'Severe pain began around Aug 09');
INSERT INTO wp_cformsdata VALUES('204', '8', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('205', '8', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('206', '8', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('207', '8', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('208', '8', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('209', '8', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('210', '8', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('211', '8', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('212', '8', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('213', '8', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('214', '8', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('215', '8', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('216', '8', 'Comments, Questions', 'I have cervical disc buldges and would like to find out more about what this injection is and how it works. Thanks, Kimberly Lindsay 562-310-3741');
INSERT INTO wp_cformsdata VALUES('217', '9', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('218', '9', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('219', '9', 'Name', 'C. Eugene Vaughn');
INSERT INTO wp_cformsdata VALUES('220', '9', 'City/State', 'Menifee, Ca');
INSERT INTO wp_cformsdata VALUES('221', '9', 'Phone', '941 616-8745');
INSERT INTO wp_cformsdata VALUES('222', '9', 'Email', 'eugene.vaughn70@yahoo.com');
INSERT INTO wp_cformsdata VALUES('223', '9', 'How did you hear about us?', 'advertisement on KFI radio');
INSERT INTO wp_cformsdata VALUES('224', '9', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('225', '9', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('226', '9', 'If yes, when did this occur?', 'since around 1995 been progressive');
INSERT INTO wp_cformsdata VALUES('227', '9', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('228', '9', 'Date of most recent scan', '2008');
INSERT INTO wp_cformsdata VALUES('229', '9', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('230', '9', 'When did the pain begin?', 'around 1995');
INSERT INTO wp_cformsdata VALUES('231', '9', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('232', '9', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('233', '9', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('234', '9', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('235', '9', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('236', '9', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('237', '9', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('238', '9', 'Date of onset of pain?', '1995');
INSERT INTO wp_cformsdata VALUES('239', '9', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('240', '9', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('241', '9', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('242', '9', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('243', '9', 'Comments, Questions', 'JHave had 5 back surgeries including a 5 vertebrae spinal fision in June 2008');
INSERT INTO wp_cformsdata VALUES('244', '10', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('245', '10', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('246', '10', 'Name', 'Brent Poss');
INSERT INTO wp_cformsdata VALUES('247', '10', 'City/State', 'Spring Branch, Tx');
INSERT INTO wp_cformsdata VALUES('248', '10', 'Phone', '210-355-4672');
INSERT INTO wp_cformsdata VALUES('249', '10', 'Email', 'bposs@gvtc.com');
INSERT INTO wp_cformsdata VALUES('250', '10', 'How did you hear about us?', 'friend');
INSERT INTO wp_cformsdata VALUES('251', '10', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('252', '10', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('253', '10', 'If yes, when did this occur?', '?');
INSERT INTO wp_cformsdata VALUES('254', '10', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('255', '10', 'Date of most recent scan', '2-25-11');
INSERT INTO wp_cformsdata VALUES('256', '10', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('257', '10', 'When did the pain begin?', '5 weeks ago');
INSERT INTO wp_cformsdata VALUES('258', '10', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('259', '10', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('260', '10', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('261', '10', 'If no, number of hours in pain', 'anytime standing or walking');
INSERT INTO wp_cformsdata VALUES('262', '10', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('263', '10', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('264', '10', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('265', '10', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('266', '10', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('267', '10', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('268', '10', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('269', '10', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('270', '10', 'Comments, Questions', 'Have had one ESI about 4 days ago.  Partially better but still painful..');
INSERT INTO wp_cformsdata VALUES('271', '11', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('272', '11', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('273', '11', 'Name', 'Allen Marks');
INSERT INTO wp_cformsdata VALUES('274', '11', 'City/State', 'Westchester');
INSERT INTO wp_cformsdata VALUES('275', '11', 'Phone', '310.658.8375');
INSERT INTO wp_cformsdata VALUES('276', '11', 'Email', 'allenlmarks@gmail.com');
INSERT INTO wp_cformsdata VALUES('277', '11', 'How did you hear about us?', 'From a Friend and the website');
INSERT INTO wp_cformsdata VALUES('278', '11', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('279', '11', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('280', '11', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('281', '11', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('282', '11', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('283', '11', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('284', '11', 'When did the pain begin?', 'Years ago');
INSERT INTO wp_cformsdata VALUES('285', '11', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('286', '11', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('287', '11', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('288', '11', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('289', '11', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('290', '11', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('291', '11', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('292', '11', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('293', '11', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('294', '11', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('295', '11', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('296', '11', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('297', '11', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('298', '12', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('299', '12', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('300', '12', 'Name', 'Mike Aicher');
INSERT INTO wp_cformsdata VALUES('301', '12', 'City/State', 'Pacific Palisades, CA');
INSERT INTO wp_cformsdata VALUES('302', '12', 'Phone', '310-573-4180');
INSERT INTO wp_cformsdata VALUES('303', '12', 'Email', 'maicher@ngi.com');
INSERT INTO wp_cformsdata VALUES('304', '12', 'How did you hear about us?', 'KNX 1070');
INSERT INTO wp_cformsdata VALUES('305', '12', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('306', '12', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('307', '12', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('308', '12', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('309', '12', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('310', '12', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('311', '12', 'When did the pain begin?', '2/27/2011');
INSERT INTO wp_cformsdata VALUES('312', '12', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('313', '12', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('314', '12', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('315', '12', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('316', '12', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves');
INSERT INTO wp_cformsdata VALUES('317', '12', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('318', '12', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('319', '12', 'Date of onset of pain?', '2/27/2011');
INSERT INTO wp_cformsdata VALUES('320', '12', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('321', '12', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('322', '12', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('323', '12', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('324', '12', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('325', '13', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('326', '13', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('327', '13', 'Name', 'Virgil Royer');
INSERT INTO wp_cformsdata VALUES('328', '13', 'City/State', 'Salem, OR');
INSERT INTO wp_cformsdata VALUES('329', '13', 'Phone', '503-851-1923');
INSERT INTO wp_cformsdata VALUES('330', '13', 'Email', 'vroyer@willamette.edu');
INSERT INTO wp_cformsdata VALUES('331', '13', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('332', '13', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('333', '13', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('334', '13', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('335', '13', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('336', '13', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('337', '13', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('338', '13', 'When did the pain begin?', 'October, 2010');
INSERT INTO wp_cformsdata VALUES('339', '13', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('340', '13', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('341', '13', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('342', '13', 'If no, number of hours in pain', 'painful to sit and lie down');
INSERT INTO wp_cformsdata VALUES('343', '13', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('344', '13', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('345', '13', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('346', '13', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('347', '13', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('348', '13', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('349', '13', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('350', '13', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('351', '13', 'Comments, Questions', 'I\'m hoping there is a trained Dr in Oregon that can do the PSE treatment for my chronic Sciatica...  Thanks!');
INSERT INTO wp_cformsdata VALUES('352', '14', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('353', '14', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('354', '14', 'Name', 'Randy');
INSERT INTO wp_cformsdata VALUES('355', '14', 'City/State', 'Bryant');
INSERT INTO wp_cformsdata VALUES('356', '14', 'Phone', '530-919-2551');
INSERT INTO wp_cformsdata VALUES('357', '14', 'Email', 'bryntchy@hughes.net');
INSERT INTO wp_cformsdata VALUES('358', '14', 'How did you hear about us?', 'brother');
INSERT INTO wp_cformsdata VALUES('359', '14', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('360', '14', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('361', '14', 'If yes, when did this occur?', '6 years ago');
INSERT INTO wp_cformsdata VALUES('362', '14', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('363', '14', 'Date of most recent scan', 'lower back 2 years  ago neck 2 years');
INSERT INTO wp_cformsdata VALUES('364', '14', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('365', '14', 'When did the pain begin?', '6 years ago');
INSERT INTO wp_cformsdata VALUES('366', '14', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('367', '14', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('368', '14', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('369', '14', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('370', '14', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('371', '14', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('372', '14', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('373', '14', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('374', '14', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('375', '14', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('376', '14', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('377', '14', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('378', '14', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('379', '15', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('380', '15', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('381', '15', 'Name', 'bob burke');
INSERT INTO wp_cformsdata VALUES('382', '15', 'City/State', 'eastvale ca');
INSERT INTO wp_cformsdata VALUES('383', '15', 'Phone', '9517907393');
INSERT INTO wp_cformsdata VALUES('384', '15', 'Email', 'burke.r.a@hotmail.com');
INSERT INTO wp_cformsdata VALUES('385', '15', 'How did you hear about us?', 'kfi radio');
INSERT INTO wp_cformsdata VALUES('386', '15', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('387', '15', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('388', '15', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('389', '15', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('390', '15', 'Date of most recent scan', 'august 2010');
INSERT INTO wp_cformsdata VALUES('391', '15', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('392', '15', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('393', '15', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('394', '15', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('395', '15', 'Is there pain 24 hours a day?', '');
INSERT INTO wp_cformsdata VALUES('396', '15', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('397', '15', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('398', '15', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('399', '15', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('400', '15', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('401', '15', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('402', '15', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('403', '15', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('404', '15', 'Does the patient have difficulty walking?', '');
INSERT INTO wp_cformsdata VALUES('405', '15', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('406', '16', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('407', '16', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('408', '16', 'Name', 'bob burke');
INSERT INTO wp_cformsdata VALUES('409', '16', 'City/State', 'eastvale ca');
INSERT INTO wp_cformsdata VALUES('410', '16', 'Phone', '9517907393');
INSERT INTO wp_cformsdata VALUES('411', '16', 'Email', 'burke.r.a@hotmail.com');
INSERT INTO wp_cformsdata VALUES('412', '16', 'How did you hear about us?', 'kfi radio');
INSERT INTO wp_cformsdata VALUES('413', '16', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('414', '16', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('415', '16', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('416', '16', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('417', '16', 'Date of most recent scan', 'august 2010');
INSERT INTO wp_cformsdata VALUES('418', '16', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('419', '16', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('420', '16', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('421', '16', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('422', '16', 'Is there pain 24 hours a day?', '');
INSERT INTO wp_cformsdata VALUES('423', '16', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('424', '16', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('425', '16', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('426', '16', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('427', '16', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('428', '16', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('429', '16', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('430', '16', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('431', '16', 'Does the patient have difficulty walking?', '');
INSERT INTO wp_cformsdata VALUES('432', '16', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('433', '17', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('434', '17', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('435', '17', 'Name', 'Kelly Nicholson');
INSERT INTO wp_cformsdata VALUES('436', '17', 'City/State', 'Los Angeles/CA');
INSERT INTO wp_cformsdata VALUES('437', '17', 'Phone', '213 3670588');
INSERT INTO wp_cformsdata VALUES('438', '17', 'Email', 'kelly.nicholson@ladwp.com');
INSERT INTO wp_cformsdata VALUES('439', '17', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('440', '17', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('441', '17', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('442', '17', 'If yes, when did this occur?', '2003');
INSERT INTO wp_cformsdata VALUES('443', '17', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('444', '17', 'Date of most recent scan', '12/2010');
INSERT INTO wp_cformsdata VALUES('445', '17', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('446', '17', 'When did the pain begin?', '2003');
INSERT INTO wp_cformsdata VALUES('447', '17', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('448', '17', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('449', '17', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('450', '17', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('451', '17', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,hands');
INSERT INTO wp_cformsdata VALUES('452', '17', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('453', '17', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('454', '17', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('455', '17', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('456', '17', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('457', '17', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('458', '17', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('459', '17', 'Comments, Questions', 'able to walk short distances, can not walk long distances without experiencing pain; cannot stand for more than 5-10 minutes, or sit for more than 20-30 minutes w/out experiencing pain.  I can no longer sleep in my bed - I sleep on a little couch with my legs and feet propped up over the armrest.  Herniated disc in both the cervical and lumbar spine.  Currently seeing Dr. Rosensweig in LA.
\n
\nI would like to know how long your medication lasts?
\nHow does it compare to an epidural - which is currently being considered?
\nWhat are the possible short- and long-term side effects?
\nCan this treatment be covered under Worker\'s Compensation - (I was awarded life-time medical circa 2004)
\n');
INSERT INTO wp_cformsdata VALUES('460', '18', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('461', '18', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('462', '18', 'Name', 'Kerry');
INSERT INTO wp_cformsdata VALUES('463', '18', 'City/State', 'corcoran');
INSERT INTO wp_cformsdata VALUES('464', '18', 'Phone', '3236467567');
INSERT INTO wp_cformsdata VALUES('465', '18', 'Email', 'kc2zero7@yahoo.com');
INSERT INTO wp_cformsdata VALUES('466', '18', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('467', '18', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('468', '18', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('469', '18', 'If yes, when did this occur?', '15 yrs');
INSERT INTO wp_cformsdata VALUES('470', '18', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('471', '18', 'Date of most recent scan', '2-11');
INSERT INTO wp_cformsdata VALUES('472', '18', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('473', '18', 'When did the pain begin?', 'Had for yrs');
INSERT INTO wp_cformsdata VALUES('474', '18', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('475', '18', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('476', '18', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('477', '18', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('478', '18', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('479', '18', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('480', '18', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('481', '18', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('482', '18', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('483', '18', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('484', '18', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('485', '18', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('486', '18', 'Comments, Questions', 'Sore achey');
INSERT INTO wp_cformsdata VALUES('487', '19', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('488', '19', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('489', '19', 'Name', 'Henrik Westrell');
INSERT INTO wp_cformsdata VALUES('490', '19', 'City/State', 'Santa Ana, CA');
INSERT INTO wp_cformsdata VALUES('491', '19', 'Phone', '949-293 6755');
INSERT INTO wp_cformsdata VALUES('492', '19', 'Email', 'HENRIK.WESTRELL@PACIFICLIFE.COM');
INSERT INTO wp_cformsdata VALUES('493', '19', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('494', '19', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('495', '19', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('496', '19', 'If yes, when did this occur?', 'About 3 years ago.');
INSERT INTO wp_cformsdata VALUES('497', '19', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('498', '19', 'Date of most recent scan', 'February 2011');
INSERT INTO wp_cformsdata VALUES('499', '19', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('500', '19', 'When did the pain begin?', 'About 3 years ago');
INSERT INTO wp_cformsdata VALUES('501', '19', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('502', '19', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('503', '19', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('504', '19', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('505', '19', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('506', '19', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('507', '19', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('508', '19', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('509', '19', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('510', '19', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('511', '19', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('512', '19', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('513', '19', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('514', '20', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('515', '20', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('516', '20', 'Name', 'Humberto Mani');
INSERT INTO wp_cformsdata VALUES('517', '20', 'City/State', 'Hickory Hills, IL');
INSERT INTO wp_cformsdata VALUES('518', '20', 'Phone', '708-822-3993');
INSERT INTO wp_cformsdata VALUES('519', '20', 'Email', 'tasmani1018@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('520', '20', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('521', '20', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('522', '20', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('523', '20', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('524', '20', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('525', '20', 'Date of most recent scan', 'MRI- over a year ago');
INSERT INTO wp_cformsdata VALUES('526', '20', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('527', '20', 'When did the pain begin?', 'Over a year ago');
INSERT INTO wp_cformsdata VALUES('528', '20', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('529', '20', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('530', '20', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('531', '20', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('532', '20', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('533', '20', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('534', '20', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('535', '20', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('536', '20', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('537', '20', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('538', '20', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('539', '20', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('540', '20', 'Comments, Questions', 'I have been to a doctor who perscribes pain killers that do nothing for me. I have been to the ER many times, and they just give me pain killers also and all they do is make me sick to the point of vomiting. I have lost over 20 Lbs due to this siatic nerve. For they say that\'s what I have. I have been in this pain for a little over a year now and I can not take the pain any more. Thank You for your time and look forward to speaking with you. ');
INSERT INTO wp_cformsdata VALUES('541', '21', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('542', '21', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('543', '21', 'Name', 'Bill Kissick');
INSERT INTO wp_cformsdata VALUES('544', '21', 'City/State', 'Leawood, ks');
INSERT INTO wp_cformsdata VALUES('545', '21', 'Phone', '913-897-0835');
INSERT INTO wp_cformsdata VALUES('546', '21', 'Email', 'Blkissick@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('547', '21', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('548', '21', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('549', '21', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('550', '21', 'If yes, when did this occur?', 'Three yrs this past Oct.');
INSERT INTO wp_cformsdata VALUES('551', '21', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('552', '21', 'Date of most recent scan', 'March 2009');
INSERT INTO wp_cformsdata VALUES('553', '21', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('554', '21', 'When did the pain begin?', 'Approx 3 yes ago');
INSERT INTO wp_cformsdata VALUES('555', '21', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('556', '21', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('557', '21', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('558', '21', 'If no, number of hours in pain', 'Every hr except went I\'m sleeping');
INSERT INTO wp_cformsdata VALUES('559', '21', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('560', '21', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('561', '21', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('562', '21', 'Date of onset of pain?', 'Oct 2009');
INSERT INTO wp_cformsdata VALUES('563', '21', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('564', '21', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('565', '21', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('566', '21', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('567', '21', 'Comments, Questions', 'I was operated on Aug 7, 2009, Laminectomy  I had pain within two weeks of my followup visit with the Surgeon.   Jan 7th 2011 I had a Micro Discectomy.   I had an epidural on Mar 4th, 2011 and I still have bad leg pain.  \n\nI\'m looking for some relief, this is wearing me down.\n\nThank You,\n\nBill Kissick');
INSERT INTO wp_cformsdata VALUES('568', '22', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('569', '22', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('570', '22', 'Name', 'Angelique Coca');
INSERT INTO wp_cformsdata VALUES('571', '22', 'City/State', 'Norwalk, CA');
INSERT INTO wp_cformsdata VALUES('572', '22', 'Phone', '(562)4094135');
INSERT INTO wp_cformsdata VALUES('573', '22', 'Email', 'aycoca.7@gmail.com');
INSERT INTO wp_cformsdata VALUES('574', '22', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('575', '22', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('576', '22', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('577', '22', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('578', '22', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('579', '22', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('580', '22', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('581', '22', 'When did the pain begin?', '08/01/2010');
INSERT INTO wp_cformsdata VALUES('582', '22', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('583', '22', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('584', '22', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('585', '22', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('586', '22', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('587', '22', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('588', '22', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('589', '22', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('590', '22', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('591', '22', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('592', '22', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('593', '22', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('594', '22', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('595', '23', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('596', '23', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('597', '23', 'Name', 'Justin McMillin');
INSERT INTO wp_cformsdata VALUES('598', '23', 'City/State', 'Merced Ca');
INSERT INTO wp_cformsdata VALUES('599', '23', 'Phone', '209-947-5624');
INSERT INTO wp_cformsdata VALUES('600', '23', 'Email', 'cookiecutter3@yahoo.com');
INSERT INTO wp_cformsdata VALUES('601', '23', 'How did you hear about us?', 'youtube search');
INSERT INTO wp_cformsdata VALUES('602', '23', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('603', '23', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('604', '23', 'If yes, when did this occur?', 'dont know my exact diagnosis');
INSERT INTO wp_cformsdata VALUES('605', '23', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('606', '23', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('607', '23', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('608', '23', 'When did the pain begin?', '4 or 5 years ago');
INSERT INTO wp_cformsdata VALUES('609', '23', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('610', '23', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('611', '23', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('612', '23', 'If no, number of hours in pain', '16 hours');
INSERT INTO wp_cformsdata VALUES('613', '23', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('614', '23', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('615', '23', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('616', '23', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('617', '23', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('618', '23', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('619', '23', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('620', '23', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('621', '23', 'Comments, Questions', 'constant shooting burning pain and tension from my buttocks down the back of my left thigh to my knee. Can\'t stand for long periods without having to use ice packs, heat rub or stretching excercises. Very uncomfortable daily pain that interferes with my normal lifestyle.');
INSERT INTO wp_cformsdata VALUES('622', '24', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('623', '24', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('624', '24', 'Name', 'Kelly Szewczuk');
INSERT INTO wp_cformsdata VALUES('625', '24', 'City/State', 'Twin Lakes WI');
INSERT INTO wp_cformsdata VALUES('626', '24', 'Phone', '262-877-9509');
INSERT INTO wp_cformsdata VALUES('627', '24', 'Email', 'szewczuk5@aol.com');
INSERT INTO wp_cformsdata VALUES('628', '24', 'How did you hear about us?', 'utube');
INSERT INTO wp_cformsdata VALUES('629', '24', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('630', '24', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('631', '24', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('632', '24', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('633', '24', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('634', '24', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('635', '24', 'When did the pain begin?', 'about two months ago');
INSERT INTO wp_cformsdata VALUES('636', '24', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('637', '24', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('638', '24', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('639', '24', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('640', '24', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('641', '24', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('642', '24', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('643', '24', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('644', '24', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('645', '24', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('646', '24', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('647', '24', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('648', '24', 'Comments, Questions', 'I was told at the walk in clinic that this is sciatica, and there is nothing that will help until the swelling goes down, so I am on an antiinflamitory med and 300 mg of ibrurphem.  NOT HELPING I work on my feet every day and the pain and spasms just get worse and worse as the day goes on.  Today I didn\'t work and have been off my feet most of the day and I am still in alot of pain. Hope you can help about how much will it cost?');
INSERT INTO wp_cformsdata VALUES('649', '25', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('650', '25', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('651', '25', 'Name', 'burl Cohen');
INSERT INTO wp_cformsdata VALUES('652', '25', 'City/State', 'pasadena, ca');
INSERT INTO wp_cformsdata VALUES('653', '25', 'Phone', '626 712 9835');
INSERT INTO wp_cformsdata VALUES('654', '25', 'Email', 'bcohen2@earthlink.net');
INSERT INTO wp_cformsdata VALUES('655', '25', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('656', '25', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('657', '25', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('658', '25', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('659', '25', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('660', '25', 'Date of most recent scan', 'march 2011');
INSERT INTO wp_cformsdata VALUES('661', '25', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('662', '25', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('663', '25', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('664', '25', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('665', '25', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('666', '25', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('667', '25', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('668', '25', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('669', '25', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('670', '25', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('671', '25', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('672', '25', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('673', '25', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('674', '25', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('675', '25', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('676', '26', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('677', '26', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('678', '26', 'Name', 'Christopher Knell');
INSERT INTO wp_cformsdata VALUES('679', '26', 'City/State', 'Seal Beach, CA');
INSERT INTO wp_cformsdata VALUES('680', '26', 'Phone', '562-225-8727');
INSERT INTO wp_cformsdata VALUES('681', '26', 'Email', 'chris.e.knell@gmail.com');
INSERT INTO wp_cformsdata VALUES('682', '26', 'How did you hear about us?', 'KFI AM 640');
INSERT INTO wp_cformsdata VALUES('683', '26', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('684', '26', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('685', '26', 'If yes, when did this occur?', '07/13/2008');
INSERT INTO wp_cformsdata VALUES('686', '26', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('687', '26', 'Date of most recent scan', '10/2008');
INSERT INTO wp_cformsdata VALUES('688', '26', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('689', '26', 'When did the pain begin?', '07/13/2008');
INSERT INTO wp_cformsdata VALUES('690', '26', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('691', '26', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('692', '26', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('693', '26', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('694', '26', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('695', '26', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('696', '26', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('697', '26', 'Date of onset of pain?', '07/13/08');
INSERT INTO wp_cformsdata VALUES('698', '26', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('699', '26', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('700', '26', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('701', '26', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('702', '26', 'Comments, Questions', 'L4/L5 disc protrusion, two series of epidural steroid injections with Dr. Van Vu Huntington Beach Pain Management group (3 shots each).  Has been 8 months since last shot.  Pain been getting worse.  Decompression helpful, but results very limited in time.\n\nHave watched videos and done a little research with pbt, Interested in scheduling consultation / injection as soon as possible (Monday is only weekday work schedule can accommodate.');
INSERT INTO wp_cformsdata VALUES('703', '27', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('704', '27', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('705', '27', 'Name', 'elizabeth lambey');
INSERT INTO wp_cformsdata VALUES('706', '27', 'City/State', 'inglewood/ca');
INSERT INTO wp_cformsdata VALUES('707', '27', 'Phone', '3233961556');
INSERT INTO wp_cformsdata VALUES('708', '27', 'Email', 'elizabeth.lambety@yahoo.com');
INSERT INTO wp_cformsdata VALUES('709', '27', 'How did you hear about us?', 'saw your ad');
INSERT INTO wp_cformsdata VALUES('710', '27', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('711', '27', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('712', '27', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('713', '27', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('714', '27', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('715', '27', 'Is there pain in:', 'Arm');
INSERT INTO wp_cformsdata VALUES('716', '27', 'When did the pain begin?', 'after my car accident');
INSERT INTO wp_cformsdata VALUES('717', '27', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('718', '27', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('719', '27', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('720', '27', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('721', '27', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('722', '27', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('723', '27', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('724', '27', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('725', '27', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('726', '27', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('727', '27', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('728', '27', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('729', '27', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('730', '28', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('731', '28', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('732', '28', 'Name', 'Christopher Yonavich');
INSERT INTO wp_cformsdata VALUES('733', '28', 'City/State', 'san Antonio Texas');
INSERT INTO wp_cformsdata VALUES('734', '28', 'Phone', '2108859074');
INSERT INTO wp_cformsdata VALUES('735', '28', 'Email', 'chris@internationalcardexchange.com');
INSERT INTO wp_cformsdata VALUES('736', '28', 'How did you hear about us?', 'friend');
INSERT INTO wp_cformsdata VALUES('737', '28', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('738', '28', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('739', '28', 'If yes, when did this occur?', '1988');
INSERT INTO wp_cformsdata VALUES('740', '28', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('741', '28', 'Date of most recent scan', '2005');
INSERT INTO wp_cformsdata VALUES('742', '28', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('743', '28', 'When did the pain begin?', '1988');
INSERT INTO wp_cformsdata VALUES('744', '28', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('745', '28', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('746', '28', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('747', '28', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('748', '28', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('749', '28', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('750', '28', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('751', '28', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('752', '28', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('753', '28', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('754', '28', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('755', '28', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('756', '28', 'Comments, Questions', 'I function well daily on hydrocodone 7.5/500 and muscle relaxer. Have L4/L5 disc disease. Fusion surgery was scheduled in 2005 but I elected to wait. I\'ve gained 60 lbs approximately past 3 years and do not want to remain on pain meds. I have not had  insurance since 2005 or would have had fusion done. I\'m 39, want to get back to active lifestyle. Used to play basketball daily until pain, even with meds prevented much excersise of any kind. My muscles are very tight from years of spasms. Just want desperately to get off meds and have relief. I\'m at my worst now, 6\'2 300 lbs, nearly no physical activity. Medication works less and addiction really scares me. I would greatly appreciate feedback if my condition may be helped. ');
INSERT INTO wp_cformsdata VALUES('757', '29', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('758', '29', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('759', '29', 'Name', 'GV LAKSHMAN');
INSERT INTO wp_cformsdata VALUES('760', '29', 'City/State', 'Greenville SC');
INSERT INTO wp_cformsdata VALUES('761', '29', 'Phone', '864-593-5891');
INSERT INTO wp_cformsdata VALUES('762', '29', 'Email', 'lakshmanjana@yahoo.com');
INSERT INTO wp_cformsdata VALUES('763', '29', 'How did you hear about us?', 'on the web');
INSERT INTO wp_cformsdata VALUES('764', '29', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('765', '29', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('766', '29', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('767', '29', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('768', '29', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('769', '29', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('770', '29', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('771', '29', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('772', '29', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('773', '29', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('774', '29', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('775', '29', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('776', '29', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('777', '29', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('778', '29', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('779', '29', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('780', '29', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('781', '29', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('782', '29', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('783', '29', 'Comments, Questions', 'Start having the pain on the lower back to upper back thigh. \nOn the siting position, lowering the chin and lifting the left leg hurts the most.  \nHaving pain while doing any stretch exercise, like yoga. \nUsed to do Yoga for several years, but now it\'s getting difficult.\n');
INSERT INTO wp_cformsdata VALUES('784', '30', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('785', '30', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('786', '30', 'Name', 'Gil Denis');
INSERT INTO wp_cformsdata VALUES('787', '30', 'City/State', 'Jackson, Wyoming');
INSERT INTO wp_cformsdata VALUES('788', '30', 'Phone', '307-733-7265');
INSERT INTO wp_cformsdata VALUES('789', '30', 'Email', 'mountainfinish@bresnan.net');
INSERT INTO wp_cformsdata VALUES('790', '30', 'How did you hear about us?', 'Spine Site ADR Support.com');
INSERT INTO wp_cformsdata VALUES('791', '30', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('792', '30', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('793', '30', 'If yes, when did this occur?', '1995-2007-2009-2010-');
INSERT INTO wp_cformsdata VALUES('794', '30', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('795', '30', 'Date of most recent scan', 'April 2010');
INSERT INTO wp_cformsdata VALUES('796', '30', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('797', '30', 'When did the pain begin?', 'years ');
INSERT INTO wp_cformsdata VALUES('798', '30', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('799', '30', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('800', '30', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('801', '30', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('802', '30', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,fingers');
INSERT INTO wp_cformsdata VALUES('803', '30', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('804', '30', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('805', '30', 'Date of onset of pain?', 'sept 2010');
INSERT INTO wp_cformsdata VALUES('806', '30', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('807', '30', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('808', '30', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('809', '30', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('810', '30', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('811', '31', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('812', '31', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('813', '31', 'Name', 'fatma');
INSERT INTO wp_cformsdata VALUES('814', '31', 'City/State', 'egypt');
INSERT INTO wp_cformsdata VALUES('815', '31', 'Phone', '0020122886024');
INSERT INTO wp_cformsdata VALUES('816', '31', 'Email', 'ehab_algaml@yahoo.com');
INSERT INTO wp_cformsdata VALUES('817', '31', 'How did you hear about us?', 'youtube.com');
INSERT INTO wp_cformsdata VALUES('818', '31', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('819', '31', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('820', '31', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('821', '31', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('822', '31', 'Date of most recent scan', '12-2010');
INSERT INTO wp_cformsdata VALUES('823', '31', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('824', '31', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('825', '31', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('826', '31', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('827', '31', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('828', '31', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('829', '31', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('830', '31', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('831', '31', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('832', '31', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('833', '31', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('834', '31', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('835', '31', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('836', '31', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('837', '31', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('838', '32', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('839', '32', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('840', '32', 'Name', 'John Crain');
INSERT INTO wp_cformsdata VALUES('841', '32', 'City/State', '9762 Royal Palm Blvd.');
INSERT INTO wp_cformsdata VALUES('842', '32', 'Phone', '714-530-1642');
INSERT INTO wp_cformsdata VALUES('843', '32', 'Email', 'skipmo69@netzero.net');
INSERT INTO wp_cformsdata VALUES('844', '32', 'How did you hear about us?', 'KFI 640 Radio');
INSERT INTO wp_cformsdata VALUES('845', '32', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('846', '32', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('847', '32', 'If yes, when did this occur?', '2 years ago');
INSERT INTO wp_cformsdata VALUES('848', '32', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('849', '32', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('850', '32', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('851', '32', 'When did the pain begin?', '2007');
INSERT INTO wp_cformsdata VALUES('852', '32', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('853', '32', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('854', '32', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('855', '32', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('856', '32', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('857', '32', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('858', '32', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('859', '32', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('860', '32', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('861', '32', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('862', '32', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('863', '32', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('864', '32', 'Comments, Questions', 'Please Help!!');
INSERT INTO wp_cformsdata VALUES('865', '33', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('866', '33', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('867', '33', 'Name', 'fatma');
INSERT INTO wp_cformsdata VALUES('868', '33', 'City/State', 'egypt');
INSERT INTO wp_cformsdata VALUES('869', '33', 'Phone', '000000000000');
INSERT INTO wp_cformsdata VALUES('870', '33', 'Email', 'ehab_algaml@yahoo.com');
INSERT INTO wp_cformsdata VALUES('871', '33', 'How did you hear about us?', 'youtube.com');
INSERT INTO wp_cformsdata VALUES('872', '33', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('873', '33', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('874', '33', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('875', '33', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('876', '33', 'Date of most recent scan', '12-2010');
INSERT INTO wp_cformsdata VALUES('877', '33', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('878', '33', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('879', '33', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('880', '33', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('881', '33', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('882', '33', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('883', '33', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('884', '33', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('885', '33', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('886', '33', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('887', '33', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('888', '33', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('889', '33', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('890', '33', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('891', '33', 'Comments, Questions', 'I am arabian woman from egypt\n\nand i have a severe  pain because of sciatica\n\nUnfortunately, there was person called me from your Institute but i can\'t understand what she said because i can understand Written words only\n\nplease, please, i want to contact with me by e-mail\n\nthanks\n');
INSERT INTO wp_cformsdata VALUES('892', '34', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('893', '34', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('894', '34', 'Name', 'Al Sanada');
INSERT INTO wp_cformsdata VALUES('895', '34', 'City/State', 'Yacca Valley, CA');
INSERT INTO wp_cformsdata VALUES('896', '34', 'Phone', '760.363.7137');
INSERT INTO wp_cformsdata VALUES('897', '34', 'Email', 'alsanada@verizon.net');
INSERT INTO wp_cformsdata VALUES('898', '34', 'How did you hear about us?', 'Website Search');
INSERT INTO wp_cformsdata VALUES('899', '34', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('900', '34', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('901', '34', 'If yes, when did this occur?', '25 years ago');
INSERT INTO wp_cformsdata VALUES('902', '34', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('903', '34', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('904', '34', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('905', '34', 'When did the pain begin?', '30 years ago');
INSERT INTO wp_cformsdata VALUES('906', '34', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('907', '34', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('908', '34', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('909', '34', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('910', '34', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('911', '34', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('912', '34', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('913', '34', 'Date of onset of pain?', '?');
INSERT INTO wp_cformsdata VALUES('914', '34', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('915', '34', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('916', '34', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('917', '34', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('918', '34', 'Comments, Questions', 'Walking, Sitting, or Driving for more then 15 minutes, gives me pain.
\n
\nI also have 2 Fracture Vertebrates of the lower Lumbar, connected to the Pelvic,
\nfor more then 40 years.');
INSERT INTO wp_cformsdata VALUES('919', '35', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('920', '35', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('921', '35', 'Name', 'Daniel  Flores');
INSERT INTO wp_cformsdata VALUES('922', '35', 'City/State', 'Los Angeles  CA');
INSERT INTO wp_cformsdata VALUES('923', '35', 'Phone', '323-387-0840');
INSERT INTO wp_cformsdata VALUES('924', '35', 'Email', 'dflores48@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('925', '35', 'How did you hear about us?', 'Internet search');
INSERT INTO wp_cformsdata VALUES('926', '35', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('927', '35', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('928', '35', 'If yes, when did this occur?', 'September, 2010');
INSERT INTO wp_cformsdata VALUES('929', '35', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('930', '35', 'Date of most recent scan', 'not sure');
INSERT INTO wp_cformsdata VALUES('931', '35', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('932', '35', 'When did the pain begin?', 'around six months ago');
INSERT INTO wp_cformsdata VALUES('933', '35', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('934', '35', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('935', '35', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('936', '35', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('937', '35', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('938', '35', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('939', '35', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('940', '35', 'Date of onset of pain?', 'September 2010');
INSERT INTO wp_cformsdata VALUES('941', '35', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('942', '35', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('943', '35', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('944', '35', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('945', '35', 'Comments, Questions', 'Siactic Nerve Pain');
INSERT INTO wp_cformsdata VALUES('946', '36', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('947', '36', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('948', '36', 'Name', 'Matt Smith');
INSERT INTO wp_cformsdata VALUES('949', '36', 'City/State', 'Birmingham, England');
INSERT INTO wp_cformsdata VALUES('950', '36', 'Phone', '0758668542');
INSERT INTO wp_cformsdata VALUES('951', '36', 'Email', 'cowley321@live.co.uk');
INSERT INTO wp_cformsdata VALUES('952', '36', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('953', '36', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('954', '36', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('955', '36', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('956', '36', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('957', '36', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('958', '36', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('959', '36', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('960', '36', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('961', '36', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('962', '36', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('963', '36', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('964', '36', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('965', '36', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('966', '36', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('967', '36', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('968', '36', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('969', '36', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('970', '36', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('971', '36', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('972', '36', 'Comments, Questions', 'poor posture driving/at desk = severe sciatica');
INSERT INTO wp_cformsdata VALUES('973', '37', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('974', '37', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('975', '37', 'Name', 'Stephan Touizer');
INSERT INTO wp_cformsdata VALUES('976', '37', 'City/State', 'Miami, FL');
INSERT INTO wp_cformsdata VALUES('977', '37', 'Phone', '646-322-2453');
INSERT INTO wp_cformsdata VALUES('978', '37', 'Email', 'stephan@equityfeed.com');
INSERT INTO wp_cformsdata VALUES('979', '37', 'How did you hear about us?', 'Internet searching');
INSERT INTO wp_cformsdata VALUES('980', '37', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('981', '37', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('982', '37', 'If yes, when did this occur?', 'March 15, 2011');
INSERT INTO wp_cformsdata VALUES('983', '37', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('984', '37', 'Date of most recent scan', 'March 26, 2011');
INSERT INTO wp_cformsdata VALUES('985', '37', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('986', '37', 'When did the pain begin?', 'March 15, 2011');
INSERT INTO wp_cformsdata VALUES('987', '37', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('988', '37', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('989', '37', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('990', '37', 'If no, number of hours in pain', 'all day except when lying flat on back');
INSERT INTO wp_cformsdata VALUES('991', '37', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('992', '37', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('993', '37', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('994', '37', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('995', '37', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('996', '37', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('997', '37', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('998', '37', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('999', '37', 'Comments, Questions', 'I am completing my final week (20 sessions) of spinal decompression using a non-invasive technology called DRX 9000. It is a machine that stretches the spine and realigns/regenerates the disc. I have definitely had improvement and decrease in pain, however it is lingering (still quite painful) and I would like it gone completely.');
INSERT INTO wp_cformsdata VALUES('1000', '38', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1001', '38', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1002', '38', 'Name', 'Sharon');
INSERT INTO wp_cformsdata VALUES('1003', '38', 'City/State', 'Lopez');
INSERT INTO wp_cformsdata VALUES('1004', '38', 'Phone', '646-257-0210');
INSERT INTO wp_cformsdata VALUES('1005', '38', 'Email', 'gclef913@gmail.com');
INSERT INTO wp_cformsdata VALUES('1006', '38', 'How did you hear about us?', 'radio commercial');
INSERT INTO wp_cformsdata VALUES('1007', '38', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1008', '38', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1009', '38', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1010', '38', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1011', '38', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1012', '38', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('1013', '38', 'When did the pain begin?', 'May 2009');
INSERT INTO wp_cformsdata VALUES('1014', '38', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1015', '38', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1016', '38', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1017', '38', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1018', '38', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1019', '38', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1020', '38', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1021', '38', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1022', '38', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1023', '38', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1024', '38', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1025', '38', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1026', '38', 'Comments, Questions', 'I\'ve experiences lower back pain since approximately May of 2009 when I moved to Los Angeles. My back is constantly \"popping\" and it often feels better and less stiff. My main issue is the pain in my lower back that shoots to my hips. I\'ve purchased a new bed and a knee spacer pillow but nothing helps. During my last physical, my doctor expressed that I need to be more physical. This pain however is why I am not. I mo longer am as active as I was when I lived in NYC. I\'m 43yrs old and want to feel normal again. I\'m not sure if CIGNA covers this, so that would be a factor in my treatment. Thank you.');
INSERT INTO wp_cformsdata VALUES('1027', '39', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1028', '39', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1029', '39', 'Name', 'Ben Zavorka');
INSERT INTO wp_cformsdata VALUES('1030', '39', 'City/State', 'Cheyenne/wyoming');
INSERT INTO wp_cformsdata VALUES('1031', '39', 'Phone', '307-514-4111');
INSERT INTO wp_cformsdata VALUES('1032', '39', 'Email', 'nemesis@bresnan.net');
INSERT INTO wp_cformsdata VALUES('1033', '39', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1034', '39', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1035', '39', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1036', '39', 'If yes, when did this occur?', '20 years ago');
INSERT INTO wp_cformsdata VALUES('1037', '39', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1038', '39', 'Date of most recent scan', '3-15-2011');
INSERT INTO wp_cformsdata VALUES('1039', '39', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1040', '39', 'When did the pain begin?', 'flare up 2 months ago');
INSERT INTO wp_cformsdata VALUES('1041', '39', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1042', '39', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1043', '39', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1044', '39', 'If no, number of hours in pain', 'standing or walking');
INSERT INTO wp_cformsdata VALUES('1045', '39', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1046', '39', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1047', '39', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1048', '39', 'Date of onset of pain?', 'off and on for 20 years');
INSERT INTO wp_cformsdata VALUES('1049', '39', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1050', '39', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('1051', '39', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1052', '39', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1053', '39', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1054', '40', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1055', '40', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1056', '40', 'Name', 'gildardo valles');
INSERT INTO wp_cformsdata VALUES('1057', '40', 'City/State', 'tijuana bc');
INSERT INTO wp_cformsdata VALUES('1058', '40', 'Phone', '011 52 664 400 0065');
INSERT INTO wp_cformsdata VALUES('1059', '40', 'Email', 'gvalles1@prodigy.net.mx');
INSERT INTO wp_cformsdata VALUES('1060', '40', 'How did you hear about us?', '950 am radio');
INSERT INTO wp_cformsdata VALUES('1061', '40', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1062', '40', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1063', '40', 'If yes, when did this occur?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('1064', '40', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1065', '40', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1066', '40', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('1067', '40', 'When did the pain begin?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('1068', '40', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1069', '40', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1070', '40', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1071', '40', 'If no, number of hours in pain', 'while awake');
INSERT INTO wp_cformsdata VALUES('1072', '40', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,arms,hands');
INSERT INTO wp_cformsdata VALUES('1073', '40', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1074', '40', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1075', '40', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1076', '40', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1077', '40', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1078', '40', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1079', '40', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1080', '40', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1081', '41', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1082', '41', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1083', '41', 'Name', 'Raul Santana');
INSERT INTO wp_cformsdata VALUES('1084', '41', 'City/State', 'Castaic CA');
INSERT INTO wp_cformsdata VALUES('1085', '41', 'Phone', '(818) 414-4798');
INSERT INTO wp_cformsdata VALUES('1086', '41', 'Email', 'century21raul@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1087', '41', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1088', '41', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1089', '41', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1090', '41', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1091', '41', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1092', '41', 'Date of most recent scan', '17 yers ago');
INSERT INTO wp_cformsdata VALUES('1093', '41', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('1094', '41', 'When did the pain begin?', '18yr ago');
INSERT INTO wp_cformsdata VALUES('1095', '41', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('1096', '41', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1097', '41', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1098', '41', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1099', '41', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('1100', '41', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1101', '41', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1102', '41', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1103', '41', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1104', '41', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('1105', '41', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1106', '41', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1107', '41', 'Comments, Questions', 'since one accident lifting a handycap more than 18yr every time I lift something hevy I mess up my lower back and my asianerve tense hard and it hurts until I rest with hot pilow or my wife massage it');
INSERT INTO wp_cformsdata VALUES('1108', '42', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1109', '42', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1110', '42', 'Name', 'Mario Arroyo');
INSERT INTO wp_cformsdata VALUES('1111', '42', 'City/State', '10357 pico Vista Rd Downey Ca 90241');
INSERT INTO wp_cformsdata VALUES('1112', '42', 'Phone', '(562)712-7585');
INSERT INTO wp_cformsdata VALUES('1113', '42', 'Email', 'm2000arr@aol.com');
INSERT INTO wp_cformsdata VALUES('1114', '42', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1115', '42', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1116', '42', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1117', '42', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1118', '42', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1119', '42', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1120', '42', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1121', '42', 'When did the pain begin?', 'october 2010');
INSERT INTO wp_cformsdata VALUES('1122', '42', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1123', '42', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1124', '42', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1125', '42', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1126', '42', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,calves');
INSERT INTO wp_cformsdata VALUES('1127', '42', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1128', '42', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1129', '42', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1130', '42', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1131', '42', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('1132', '42', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1133', '42', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1134', '42', 'Comments, Questions', 'when I\'m on a chair or when I\'m getting out of my car i get a pain on my left side by my waist the pain feels like small shocks or like electricity id going through my leg.');
INSERT INTO wp_cformsdata VALUES('1135', '43', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1136', '43', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1137', '43', 'Name', 'Marco A. Perez');
INSERT INTO wp_cformsdata VALUES('1138', '43', 'City/State', 'San Diego CA.');
INSERT INTO wp_cformsdata VALUES('1139', '43', 'Phone', '619-5719425');
INSERT INTO wp_cformsdata VALUES('1140', '43', 'Email', 'markko_61@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1141', '43', 'How did you hear about us?', 'Inernet');
INSERT INTO wp_cformsdata VALUES('1142', '43', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1143', '43', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('1144', '43', 'If yes, when did this occur?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('1145', '43', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1146', '43', 'Date of most recent scan', 'at that time');
INSERT INTO wp_cformsdata VALUES('1147', '43', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1148', '43', 'When did the pain begin?', '2 mounths ago');
INSERT INTO wp_cformsdata VALUES('1149', '43', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1150', '43', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1151', '43', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1152', '43', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1153', '43', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('1154', '43', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1155', '43', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1156', '43', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1157', '43', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1158', '43', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1159', '43', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1160', '43', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1161', '43', 'Comments, Questions', 'my problem end constant pain is more in my right leg all the way down (sciatica pain)');
INSERT INTO wp_cformsdata VALUES('1162', '44', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1163', '44', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1164', '44', 'Name', 'Timothy Brownlee');
INSERT INTO wp_cformsdata VALUES('1165', '44', 'City/State', 'San Diego CA');
INSERT INTO wp_cformsdata VALUES('1166', '44', 'Phone', '858-225-4429');
INSERT INTO wp_cformsdata VALUES('1167', '44', 'Email', 'timbrownlee@japan.com');
INSERT INTO wp_cformsdata VALUES('1168', '44', 'How did you hear about us?', 'On Line');
INSERT INTO wp_cformsdata VALUES('1169', '44', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1170', '44', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1171', '44', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1172', '44', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1173', '44', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1174', '44', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('1175', '44', 'When did the pain begin?', '1998');
INSERT INTO wp_cformsdata VALUES('1176', '44', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1177', '44', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1178', '44', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1179', '44', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1180', '44', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1181', '44', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1182', '44', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1183', '44', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1184', '44', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1185', '44', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1186', '44', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1187', '44', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1188', '44', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1189', '45', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1190', '45', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1191', '45', 'Name', 'Terence');
INSERT INTO wp_cformsdata VALUES('1192', '45', 'City/State', 'Bakersfield,ca.');
INSERT INTO wp_cformsdata VALUES('1193', '45', 'Phone', '661.932.1340');
INSERT INTO wp_cformsdata VALUES('1194', '45', 'Email', 'tstron@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1195', '45', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1196', '45', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1197', '45', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1198', '45', 'If yes, when did this occur?', '9/01/01');
INSERT INTO wp_cformsdata VALUES('1199', '45', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1200', '45', 'Date of most recent scan', '12/10');
INSERT INTO wp_cformsdata VALUES('1201', '45', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1202', '45', 'When did the pain begin?', '2001');
INSERT INTO wp_cformsdata VALUES('1203', '45', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1204', '45', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1205', '45', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1206', '45', 'If no, number of hours in pain', '6-8 hours');
INSERT INTO wp_cformsdata VALUES('1207', '45', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1208', '45', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1209', '45', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1210', '45', 'Date of onset of pain?', '4/08');
INSERT INTO wp_cformsdata VALUES('1211', '45', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1212', '45', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1213', '45', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1214', '45', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1215', '45', 'Comments, Questions', 'I have worked in construction for the last 20 + years and have been dealing with 2 degenerative discs/1 herniated disc pressing on nerve.Doctor suggested spinal fusion but fear it will actually worsen my condition.');
INSERT INTO wp_cformsdata VALUES('1216', '46', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1217', '46', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1218', '46', 'Name', 'Drena Marson');
INSERT INTO wp_cformsdata VALUES('1219', '46', 'City/State', 'Pasadena, CA');
INSERT INTO wp_cformsdata VALUES('1220', '46', 'Phone', '303-870-2888');
INSERT INTO wp_cformsdata VALUES('1221', '46', 'Email', 'drenamarson@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1222', '46', 'How did you hear about us?', 'radio ad');
INSERT INTO wp_cformsdata VALUES('1223', '46', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1224', '46', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1225', '46', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1226', '46', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1227', '46', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1228', '46', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1229', '46', 'When did the pain begin?', 'used to come and go for a few years, but intensive pain approximately 4 weeks ago');
INSERT INTO wp_cformsdata VALUES('1230', '46', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1231', '46', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1232', '46', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1233', '46', 'If no, number of hours in pain', 'severe-moderate, mostly at night and upon arising, but twinges throughout the day');
INSERT INTO wp_cformsdata VALUES('1234', '46', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('1235', '46', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1236', '46', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1237', '46', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1238', '46', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1239', '46', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1240', '46', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1241', '46', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1242', '46', 'Comments, Questions', 'I believe this to be sciatica but I have never been to a doctor about it.  I was under the impression sciatica would require back surgery and I was attempting to manage it without surgery.');
INSERT INTO wp_cformsdata VALUES('1243', '47', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1244', '47', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1245', '47', 'Name', 'Erika Britton');
INSERT INTO wp_cformsdata VALUES('1246', '47', 'City/State', 'Tualatin, Oregon');
INSERT INTO wp_cformsdata VALUES('1247', '47', 'Phone', '503 793-2770');
INSERT INTO wp_cformsdata VALUES('1248', '47', 'Email', 'erika@farrell-associates.com');
INSERT INTO wp_cformsdata VALUES('1249', '47', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1250', '47', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1251', '47', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease,Annular tear');
INSERT INTO wp_cformsdata VALUES('1252', '47', 'If yes, when did this occur?', '5-7 years');
INSERT INTO wp_cformsdata VALUES('1253', '47', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1254', '47', 'Date of most recent scan', '3/15/11');
INSERT INTO wp_cformsdata VALUES('1255', '47', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('1256', '47', 'When did the pain begin?', '2/15/11 (severe episode)');
INSERT INTO wp_cformsdata VALUES('1257', '47', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1258', '47', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1259', '47', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1260', '47', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1261', '47', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,calves');
INSERT INTO wp_cformsdata VALUES('1262', '47', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1263', '47', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1264', '47', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1265', '47', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1266', '47', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1267', '47', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1268', '47', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1269', '47', 'Comments, Questions', 'I am desparately seeking treatment options for my chronic low back pain. I\'ve had it for the past 5-7 years but approx. 1 month ago, my symptoms became so bad; I can barely work at a carreer I love. I have both primary and secondary insurance and I can travel (at least for awhile) to California for treatment. Thank you!  I look forward to hearing from you!  ');
INSERT INTO wp_cformsdata VALUES('1270', '48', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1271', '48', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1272', '48', 'Name', 'Test Test');
INSERT INTO wp_cformsdata VALUES('1273', '48', 'City/State', 'Woodland Hills, CA');
INSERT INTO wp_cformsdata VALUES('1274', '48', 'Phone', '877-318-2180');
INSERT INTO wp_cformsdata VALUES('1275', '48', 'Email', 'rtktest@rtrk.com');
INSERT INTO wp_cformsdata VALUES('1276', '48', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('1277', '48', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1278', '48', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('1279', '48', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1280', '48', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('1281', '48', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1282', '48', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('1283', '48', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('1284', '48', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('1285', '48', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('1286', '48', 'Is there pain 24 hours a day?', '');
INSERT INTO wp_cformsdata VALUES('1287', '48', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1288', '48', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1289', '48', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('1290', '48', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('1291', '48', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1292', '48', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('1293', '48', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('1294', '48', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('1295', '48', 'Does the patient have difficulty walking?', '');
INSERT INTO wp_cformsdata VALUES('1296', '48', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1297', '49', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('1298', '49', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1299', '49', 'Name', 'Lynda Farley');
INSERT INTO wp_cformsdata VALUES('1300', '49', 'City/State', 'Carlsbad CA');
INSERT INTO wp_cformsdata VALUES('1301', '49', 'Phone', '760-807-3081');
INSERT INTO wp_cformsdata VALUES('1302', '49', 'Email', 'mountianmamma54@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1303', '49', 'How did you hear about us?', 'web search');
INSERT INTO wp_cformsdata VALUES('1304', '49', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1305', '49', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1306', '49', 'If yes, when did this occur?', 'over the years since 1984');
INSERT INTO wp_cformsdata VALUES('1307', '49', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1308', '49', 'Date of most recent scan', '2/2007');
INSERT INTO wp_cformsdata VALUES('1309', '49', 'Is there pain in:', 'Neck');
INSERT INTO wp_cformsdata VALUES('1310', '49', 'When did the pain begin?', '1984');
INSERT INTO wp_cformsdata VALUES('1311', '49', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1312', '49', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1313', '49', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1314', '49', 'If no, number of hours in pain', '6 hours');
INSERT INTO wp_cformsdata VALUES('1315', '49', 'Is there pain, tingling, numbness, or weakness in your:', 'hands');
INSERT INTO wp_cformsdata VALUES('1316', '49', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1317', '49', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1318', '49', 'Date of onset of pain?', '1984');
INSERT INTO wp_cformsdata VALUES('1319', '49', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1320', '49', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1321', '49', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1322', '49', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1323', '49', 'Comments, Questions', 'I have had a lipoma removed twice now at the C7-T1 area of my spine. The first time it grew and was removed in 1988. The second time I had it removed was 1/2009 and it was huge.');
INSERT INTO wp_cformsdata VALUES('1324', '50', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1325', '50', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1326', '50', 'Name', 'Ben Zavorka');
INSERT INTO wp_cformsdata VALUES('1327', '50', 'City/State', 'Cheyenne/ Wy.');
INSERT INTO wp_cformsdata VALUES('1328', '50', 'Phone', 'email me');
INSERT INTO wp_cformsdata VALUES('1329', '50', 'Email', 'nemesis@bresnan.net');
INSERT INTO wp_cformsdata VALUES('1330', '50', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1331', '50', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1332', '50', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1333', '50', 'If yes, when did this occur?', '20 years ago');
INSERT INTO wp_cformsdata VALUES('1334', '50', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1335', '50', 'Date of most recent scan', '3/15/2011');
INSERT INTO wp_cformsdata VALUES('1336', '50', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1337', '50', 'When did the pain begin?', '20 years ago');
INSERT INTO wp_cformsdata VALUES('1338', '50', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1339', '50', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1340', '50', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1341', '50', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1342', '50', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1343', '50', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('1344', '50', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1345', '50', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1346', '50', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1347', '50', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('1348', '50', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1349', '50', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1350', '50', 'Comments, Questions', 'I just want to know what percentage of success you have with Sciatica leg and foot pain and what it costs????????');
INSERT INTO wp_cformsdata VALUES('1351', '51', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1352', '51', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1353', '51', 'Name', 'Bob Boloury');
INSERT INTO wp_cformsdata VALUES('1354', '51', 'City/State', 'Studio City, CA');
INSERT INTO wp_cformsdata VALUES('1355', '51', 'Phone', '818-380-0225');
INSERT INTO wp_cformsdata VALUES('1356', '51', 'Email', 'bboloury@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1357', '51', 'How did you hear about us?', 'knx radio');
INSERT INTO wp_cformsdata VALUES('1358', '51', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1359', '51', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1360', '51', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1361', '51', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1362', '51', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('1363', '51', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1364', '51', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('1365', '51', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1366', '51', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1367', '51', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1368', '51', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1369', '51', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1370', '51', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1371', '51', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('1372', '51', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1373', '51', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1374', '51', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('1375', '51', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1376', '51', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1377', '51', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1378', '52', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1379', '52', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1380', '52', 'Name', 'Travis Cutter');
INSERT INTO wp_cformsdata VALUES('1381', '52', 'City/State', 'Van Nuys, CA');
INSERT INTO wp_cformsdata VALUES('1382', '52', 'Phone', '(818) 200-4509');
INSERT INTO wp_cformsdata VALUES('1383', '52', 'Email', 'TravisCutter@gmx.com');
INSERT INTO wp_cformsdata VALUES('1384', '52', 'How did you hear about us?', 'Google search for non-surgical back pain treatments');
INSERT INTO wp_cformsdata VALUES('1385', '52', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1386', '52', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('1387', '52', 'If yes, when did this occur?', 'appx. 6 years ago');
INSERT INTO wp_cformsdata VALUES('1388', '52', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1389', '52', 'Date of most recent scan', '11-15-10');
INSERT INTO wp_cformsdata VALUES('1390', '52', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1391', '52', 'When did the pain begin?', 'Appx. 6 years ago');
INSERT INTO wp_cformsdata VALUES('1392', '52', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1393', '52', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1394', '52', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1395', '52', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1396', '52', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1397', '52', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1398', '52', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1399', '52', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1400', '52', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1401', '52', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1402', '52', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1403', '52', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1404', '52', 'Comments, Questions', 'Hi,\n\nI watched the videos but I have a question: Do the injections cure\\treat the underlying cause?\n\nThe reason I ask is that if the injections take care of the pain (like the videos show), but the \"problem\" (herniated disk) is still there, wouldn\'t that cause further damage to the disks by not treating the cause? \n\nLike if you\'ve got a broken leg and are in pain, the pain is treated with Anti-TNF but the leg is still broken and walking\\running will compound the broken bone damage.');
INSERT INTO wp_cformsdata VALUES('1405', '53', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1406', '53', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1407', '53', 'Name', 'Carrie Larson');
INSERT INTO wp_cformsdata VALUES('1408', '53', 'City/State', 'Hughson, CA');
INSERT INTO wp_cformsdata VALUES('1409', '53', 'Phone', '209-985-1811');
INSERT INTO wp_cformsdata VALUES('1410', '53', 'Email', 'larsoncarrie@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1411', '53', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('1412', '53', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1413', '53', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('1414', '53', 'If yes, when did this occur?', '9/94 (2 disc) and 1 disc just resently');
INSERT INTO wp_cformsdata VALUES('1415', '53', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1416', '53', 'Date of most recent scan', '2/28/11');
INSERT INTO wp_cformsdata VALUES('1417', '53', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1418', '53', 'When did the pain begin?', '12/10');
INSERT INTO wp_cformsdata VALUES('1419', '53', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1420', '53', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1421', '53', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1422', '53', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1423', '53', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1424', '53', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1425', '53', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1426', '53', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1427', '53', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1428', '53', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1429', '53', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1430', '53', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1431', '53', 'Comments, Questions', 'I have been taken off work, I can hardly walk, I can hardly stand up after sitting.  I hurt all the time, I taking vicodin (10-325), lyrica, soma, and ibprofen. I am scheduled for an epidural on Wednesday 3/30.  I have been referred to a surgeon for back surgery - that appt. is May 2.  The pain is horrible, its all the time and I just want my life back.');
INSERT INTO wp_cformsdata VALUES('1432', '54', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1433', '54', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1434', '54', 'Name', 'Manny Sanchez');
INSERT INTO wp_cformsdata VALUES('1435', '54', 'City/State', 'Las Vegas, Nv');
INSERT INTO wp_cformsdata VALUES('1436', '54', 'Phone', '702-340-7696');
INSERT INTO wp_cformsdata VALUES('1437', '54', 'Email', 'msanchez015@gmail.com');
INSERT INTO wp_cformsdata VALUES('1438', '54', 'How did you hear about us?', 'radio ad [coasttocoastam program]');
INSERT INTO wp_cformsdata VALUES('1439', '54', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1440', '54', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1441', '54', 'If yes, when did this occur?', '07/07');
INSERT INTO wp_cformsdata VALUES('1442', '54', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1443', '54', 'Date of most recent scan', '3/11');
INSERT INTO wp_cformsdata VALUES('1444', '54', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('1445', '54', 'When did the pain begin?', '11/10');
INSERT INTO wp_cformsdata VALUES('1446', '54', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1447', '54', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1448', '54', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1449', '54', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1450', '54', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('1451', '54', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('1452', '54', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1453', '54', 'Date of onset of pain?', '07/2007');
INSERT INTO wp_cformsdata VALUES('1454', '54', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1455', '54', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1456', '54', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1457', '54', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1458', '54', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1459', '55', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1460', '55', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1461', '55', 'Name', 'Joseph Mark Roth');
INSERT INTO wp_cformsdata VALUES('1462', '55', 'City/State', 'Hacienda Heights, CA');
INSERT INTO wp_cformsdata VALUES('1463', '55', 'Phone', '626 216 5730');
INSERT INTO wp_cformsdata VALUES('1464', '55', 'Email', 'Jmarkroth@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1465', '55', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('1466', '55', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1467', '55', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1468', '55', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1469', '55', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('1470', '55', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1471', '55', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('1472', '55', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('1473', '55', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('1474', '55', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('1475', '55', 'Is there pain 24 hours a day?', '');
INSERT INTO wp_cformsdata VALUES('1476', '55', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1477', '55', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1478', '55', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('1479', '55', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('1480', '55', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1481', '55', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('1482', '55', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('1483', '55', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('1484', '55', 'Does the patient have difficulty walking?', '');
INSERT INTO wp_cformsdata VALUES('1485', '55', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1486', '56', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1487', '56', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1488', '56', 'Name', 'jose i munoz');
INSERT INTO wp_cformsdata VALUES('1489', '56', 'City/State', 'orange ca  92868');
INSERT INTO wp_cformsdata VALUES('1490', '56', 'Phone', '1-714-932-4981');
INSERT INTO wp_cformsdata VALUES('1491', '56', 'Email', 'joseimunoz64@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1492', '56', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1493', '56', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1494', '56', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('1495', '56', 'If yes, when did this occur?', '10 or 15 years ago');
INSERT INTO wp_cformsdata VALUES('1496', '56', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1497', '56', 'Date of most recent scan', '3-12-2011');
INSERT INTO wp_cformsdata VALUES('1498', '56', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('1499', '56', 'When did the pain begin?', '10 or 15 years ');
INSERT INTO wp_cformsdata VALUES('1500', '56', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1501', '56', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1502', '56', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1503', '56', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1504', '56', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1505', '56', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1506', '56', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1507', '56', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1508', '56', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1509', '56', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1510', '56', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1511', '56', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1512', '56', 'Comments, Questions', 'how much a consultation will cost or a treatment for  herniated disc  call  me at  anytime at  my  cell  number tanks');
INSERT INTO wp_cformsdata VALUES('1513', '57', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1514', '57', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1515', '57', 'Name', 'Donna Martin');
INSERT INTO wp_cformsdata VALUES('1516', '57', 'City/State', 'Oxnard, CA');
INSERT INTO wp_cformsdata VALUES('1517', '57', 'Phone', '805-263-6607');
INSERT INTO wp_cformsdata VALUES('1518', '57', 'Email', 'classicbrat@roadrunner.com');
INSERT INTO wp_cformsdata VALUES('1519', '57', 'How did you hear about us?', 'son heard ad on radio');
INSERT INTO wp_cformsdata VALUES('1520', '57', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1521', '57', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1522', '57', 'If yes, when did this occur?', 'Auto accident in 1981');
INSERT INTO wp_cformsdata VALUES('1523', '57', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1524', '57', 'Date of most recent scan', 'Rods and screws placed in back in 1993');
INSERT INTO wp_cformsdata VALUES('1525', '57', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('1526', '57', 'When did the pain begin?', '1981');
INSERT INTO wp_cformsdata VALUES('1527', '57', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1528', '57', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1529', '57', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1530', '57', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1531', '57', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1532', '57', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('1533', '57', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('1534', '57', 'Date of onset of pain?', '1981');
INSERT INTO wp_cformsdata VALUES('1535', '57', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('1536', '57', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('1537', '57', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('1538', '57', 'Does the patient have difficulty walking?', '');
INSERT INTO wp_cformsdata VALUES('1539', '57', 'Comments, Questions', 'I have rods on each side of my spine and screws in L3,4 and 5.   I have to take heavy pain medcations on a regular basis.  What can be done to help me.');
INSERT INTO wp_cformsdata VALUES('1540', '58', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('1541', '58', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1542', '58', 'Name', 'v');
INSERT INTO wp_cformsdata VALUES('1543', '58', 'City/State', 'v');
INSERT INTO wp_cformsdata VALUES('1544', '58', 'Phone', 'v');
INSERT INTO wp_cformsdata VALUES('1545', '58', 'Email', 'v@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1546', '58', 'How did you hear about us?', 'f');
INSERT INTO wp_cformsdata VALUES('1547', '58', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1548', '58', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1549', '58', 'If yes, when did this occur?', 'over last 26 years');
INSERT INTO wp_cformsdata VALUES('1550', '58', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1551', '58', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('1552', '58', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1553', '58', 'When did the pain begin?', 'at age 13ish');
INSERT INTO wp_cformsdata VALUES('1554', '58', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1555', '58', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1556', '58', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1557', '58', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1558', '58', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,hands,fingers');
INSERT INTO wp_cformsdata VALUES('1559', '58', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1560', '58', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1561', '58', 'Date of onset of pain?', 'around age 13ish');
INSERT INTO wp_cformsdata VALUES('1562', '58', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1563', '58', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1564', '58', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1565', '58', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1566', '58', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1567', '59', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1568', '59', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1569', '59', 'Name', 'Tom Woodbeck');
INSERT INTO wp_cformsdata VALUES('1570', '59', 'City/State', 'Fairfield');
INSERT INTO wp_cformsdata VALUES('1571', '59', 'Phone', 'California');
INSERT INTO wp_cformsdata VALUES('1572', '59', 'Email', 'TomWoodbeck@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1573', '59', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('1574', '59', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1575', '59', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1576', '59', 'If yes, when did this occur?', 'Siatica Pain');
INSERT INTO wp_cformsdata VALUES('1577', '59', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1578', '59', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1579', '59', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('1580', '59', 'When did the pain begin?', 'Years ago.');
INSERT INTO wp_cformsdata VALUES('1581', '59', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1582', '59', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1583', '59', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1584', '59', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1585', '59', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('1586', '59', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1587', '59', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1588', '59', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1589', '59', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1590', '59', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1591', '59', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1592', '59', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1593', '59', 'Comments, Questions', 'Usually, My back pain is what wakes me up. Across my back, down my left thigh sometimes to my calve. When I lay, I have to lay on my right side, my left is the painful side. When I walk, I can feel my hip push out to relieve the pain. Standing makes my left leg go numb in the thigh. If you have something to help me, please contact me immediately. 925-628-4066 Tom');
INSERT INTO wp_cformsdata VALUES('1594', '60', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1595', '60', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1596', '60', 'Name', 'zarmina');
INSERT INTO wp_cformsdata VALUES('1597', '60', 'City/State', 'mississauga Ontario');
INSERT INTO wp_cformsdata VALUES('1598', '60', 'Phone', '416-273-3936');
INSERT INTO wp_cformsdata VALUES('1599', '60', 'Email', 'zarkahassan@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1600', '60', 'How did you hear about us?', 'from the web');
INSERT INTO wp_cformsdata VALUES('1601', '60', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1602', '60', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('1603', '60', 'If yes, when did this occur?', 'it\'s been a year and half ');
INSERT INTO wp_cformsdata VALUES('1604', '60', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1605', '60', 'Date of most recent scan', '29 may 2010');
INSERT INTO wp_cformsdata VALUES('1606', '60', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1607', '60', 'When did the pain begin?', 'september 13 2009');
INSERT INTO wp_cformsdata VALUES('1608', '60', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1609', '60', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1610', '60', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1611', '60', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1612', '60', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('1613', '60', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1614', '60', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1615', '60', 'Date of onset of pain?', '29 of may 2010');
INSERT INTO wp_cformsdata VALUES('1616', '60', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1617', '60', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1618', '60', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1619', '60', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1620', '60', 'Comments, Questions', 'actually this pain occure during my school time when i was pushing a double stroller with my two doughter. i felt a little pain at that time and i thought it will gone by the time, but when i slept at night and in the next morning i couldn\'t wake up and when i went to do MRI i found out that i have a boulging disc which is pressing my nerve and it\'s hurting me. i had that pain for a year and half and one day i was cleaning my room and suddenly i felt something happened to my leg. i just sat down and massage my leg and tried to ralex it but it didn\'t work, so i called the ambolance and went to the hospital. there doctor checked me and suggest me to do the  surgery. and i went for surgery. i felt better after doing the surgery. the surgery worked for 10 months but now i have the same problem which occure 5 days a go . now i\'m trying to contact you to get some advise. and tell me what sould i do. i should come to you or tell me if you have anyone in Toronto who is prescribing the same injection which you do. and tell me how long i can be release from the pain. and what is the side effect of it. thanks. i have one more case which is strok .my sister is 34 years old and she is suffering from strok for 12 years. i have seen your video and i\'m interested about the prosedure which is very fast and affective. so please tell me the best advise if you can.best regards . zarmina');
INSERT INTO wp_cformsdata VALUES('1621', '61', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1622', '61', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1623', '61', 'Name', 'Rhonda Leon');
INSERT INTO wp_cformsdata VALUES('1624', '61', 'City/State', 'Ladera Ranch, CA');
INSERT INTO wp_cformsdata VALUES('1625', '61', 'Phone', '949-429-6768');
INSERT INTO wp_cformsdata VALUES('1626', '61', 'Email', 'mojocricket@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1627', '61', 'How did you hear about us?', 'ad on KFI AM 640 radio station');
INSERT INTO wp_cformsdata VALUES('1628', '61', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1629', '61', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1630', '61', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1631', '61', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1632', '61', 'Date of most recent scan', 'Oct 10, 2010');
INSERT INTO wp_cformsdata VALUES('1633', '61', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1634', '61', 'When did the pain begin?', '10 years ago');
INSERT INTO wp_cformsdata VALUES('1635', '61', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1636', '61', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1637', '61', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1638', '61', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1639', '61', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('1640', '61', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1641', '61', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1642', '61', 'Date of onset of pain?', 'the year 2000?');
INSERT INTO wp_cformsdata VALUES('1643', '61', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1644', '61', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1645', '61', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1646', '61', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1647', '61', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1648', '62', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1649', '62', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1650', '62', 'Name', 'Carlos DeAlba');
INSERT INTO wp_cformsdata VALUES('1651', '62', 'City/State', 'Fontana, CA');
INSERT INTO wp_cformsdata VALUES('1652', '62', 'Phone', '909-471-9991');
INSERT INTO wp_cformsdata VALUES('1653', '62', 'Email', 'carlosdealbam@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1654', '62', 'How did you hear about us?', 'KFI Radio');
INSERT INTO wp_cformsdata VALUES('1655', '62', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1656', '62', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1657', '62', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1658', '62', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1659', '62', 'Date of most recent scan', '3/10/11');
INSERT INTO wp_cformsdata VALUES('1660', '62', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1661', '62', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('1662', '62', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1663', '62', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1664', '62', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1665', '62', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1666', '62', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('1667', '62', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1668', '62', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1669', '62', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1670', '62', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1671', '62', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1672', '62', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1673', '62', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1674', '62', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1675', '63', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1676', '63', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1677', '63', 'Name', 'Brenda C. White');
INSERT INTO wp_cformsdata VALUES('1678', '63', 'City/State', 'Riverside, CA');
INSERT INTO wp_cformsdata VALUES('1679', '63', 'Phone', '951-7855664');
INSERT INTO wp_cformsdata VALUES('1680', '63', 'Email', 'brnwht04@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1681', '63', 'How did you hear about us?', 'KFI radio');
INSERT INTO wp_cformsdata VALUES('1682', '63', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1683', '63', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('1684', '63', 'If yes, when did this occur?', '1974');
INSERT INTO wp_cformsdata VALUES('1685', '63', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1686', '63', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1687', '63', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1688', '63', 'When did the pain begin?', 'this episode - August 2010');
INSERT INTO wp_cformsdata VALUES('1689', '63', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1690', '63', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1691', '63', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1692', '63', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1693', '63', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('1694', '63', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1695', '63', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1696', '63', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1697', '63', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1698', '63', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1699', '63', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1700', '63', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('1701', '63', 'Comments, Questions', 'I have had bouts of severe sciatica over the years.  Usually, with rest and NSAIDS I have recovered.  This bout has continured after changing NSAID to Meloxicam, a course of steroids and muscle relaxants and several hundred dollars at the chiropractor.  I am an RN, Nurse Practitioner and have seen the variable outcomes with spinal surgery and have said since 1974 that unless I absolutely cannot walk, I WILL NOT have surgery. 
\nI  Have days that it does not hurt but most days I am in moderate to severe pain..
\nI also LOVE to run. I  usually have not had trouble running 3mi a day but since this bout with sciatica I am in pain when I run but don\'t want to stop so I run w/the pain.
\nOF COURSE,  my biggest question is the cost??');
INSERT INTO wp_cformsdata VALUES('1702', '64', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1703', '64', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1704', '64', 'Name', 'ahsan');
INSERT INTO wp_cformsdata VALUES('1705', '64', 'City/State', 'barcelona');
INSERT INTO wp_cformsdata VALUES('1706', '64', 'Phone', '0034687057066');
INSERT INTO wp_cformsdata VALUES('1707', '64', 'Email', 'hsnaslam@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1708', '64', 'How did you hear about us?', 'on youtube');
INSERT INTO wp_cformsdata VALUES('1709', '64', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1710', '64', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1711', '64', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1712', '64', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('1713', '64', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1714', '64', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1715', '64', 'When did the pain begin?', 'octuber');
INSERT INTO wp_cformsdata VALUES('1716', '64', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1717', '64', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1718', '64', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1719', '64', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1720', '64', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('1721', '64', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1722', '64', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1723', '64', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1724', '64', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1725', '64', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1726', '64', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1727', '64', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1728', '64', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1729', '65', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1730', '65', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1731', '65', 'Name', 'Barbara  Kotowitz');
INSERT INTO wp_cformsdata VALUES('1732', '65', 'City/State', 'San Clemente, CA');
INSERT INTO wp_cformsdata VALUES('1733', '65', 'Phone', '949 369 1844');
INSERT INTO wp_cformsdata VALUES('1734', '65', 'Email', 'bkotowitz@cox.net');
INSERT INTO wp_cformsdata VALUES('1735', '65', 'How did you hear about us?', 'radio advertisement');
INSERT INTO wp_cformsdata VALUES('1736', '65', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1737', '65', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1738', '65', 'If yes, when did this occur?', 'on going for years');
INSERT INTO wp_cformsdata VALUES('1739', '65', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1740', '65', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1741', '65', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('1742', '65', 'When did the pain begin?', 'on going for years');
INSERT INTO wp_cformsdata VALUES('1743', '65', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1744', '65', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1745', '65', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1746', '65', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1747', '65', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('1748', '65', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1749', '65', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1750', '65', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1751', '65', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1752', '65', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1753', '65', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1754', '65', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1755', '65', 'Comments, Questions', 'I recently fell at home and aggravated an already problematic back and sciatica problems.  I have been taking some pain medication as well as physical therapy; however I feel I need to go to the next step to help my back heal quicker.
\n
\nThank You');
INSERT INTO wp_cformsdata VALUES('1756', '66', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1757', '66', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1758', '66', 'Name', 'Robert Braddock');
INSERT INTO wp_cformsdata VALUES('1759', '66', 'City/State', 'Puyallup, WA');
INSERT INTO wp_cformsdata VALUES('1760', '66', 'Phone', '253-770-3148');
INSERT INTO wp_cformsdata VALUES('1761', '66', 'Email', 'RB45357@msn.com');
INSERT INTO wp_cformsdata VALUES('1762', '66', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('1763', '66', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1764', '66', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1765', '66', 'If yes, when did this occur?', '1994');
INSERT INTO wp_cformsdata VALUES('1766', '66', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1767', '66', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('1768', '66', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1769', '66', 'When did the pain begin?', '1994');
INSERT INTO wp_cformsdata VALUES('1770', '66', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1771', '66', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1772', '66', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1773', '66', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1774', '66', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1775', '66', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1776', '66', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1777', '66', 'Date of onset of pain?', '1994');
INSERT INTO wp_cformsdata VALUES('1778', '66', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1779', '66', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1780', '66', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1781', '66', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1782', '66', 'Comments, Questions', 'My Son-in-law had L5-S1 surgically fused together after injury in 1994.   He continues to have chronic pain.  Can this procedure possibly help?
\nThanks;
\nBob');
INSERT INTO wp_cformsdata VALUES('1783', '67', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('1784', '67', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1785', '67', 'Name', 'Debi Snyder');
INSERT INTO wp_cformsdata VALUES('1786', '67', 'City/State', 'Yucaipa CA');
INSERT INTO wp_cformsdata VALUES('1787', '67', 'Phone', '909 790-3265');
INSERT INTO wp_cformsdata VALUES('1788', '67', 'Email', 'debi_snyder40@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1789', '67', 'How did you hear about us?', 'youtube.com');
INSERT INTO wp_cformsdata VALUES('1790', '67', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1791', '67', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1792', '67', 'If yes, when did this occur?', '3 years ago');
INSERT INTO wp_cformsdata VALUES('1793', '67', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1794', '67', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1795', '67', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('1796', '67', 'When did the pain begin?', 'left buttocks');
INSERT INTO wp_cformsdata VALUES('1797', '67', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1798', '67', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1799', '67', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1800', '67', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1801', '67', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1802', '67', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1803', '67', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1804', '67', 'Date of onset of pain?', '3/11/11 from evacuating hawaii tsunami');
INSERT INTO wp_cformsdata VALUES('1805', '67', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1806', '67', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1807', '67', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1808', '67', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1809', '67', 'Comments, Questions', 'for the last few months my butt to my knee have been hurting a little bit i didn\'t think anything of it, i was on my honeymoon in hawaii when the tsunami hit japan and we were forced to evacuate and we slept in our rental overnight.  the next morning i was very sore and took a hot shower, that was it, i started crying and had to go to the ER, doc gave me a shot in my hip, I pretty much have been beridden, i use crutches to walk to the bathroom.  the pain shoots from my butt all the way to my toes, my foot is numb and i can\'t stand on it.  i need relief please help me.');
INSERT INTO wp_cformsdata VALUES('1810', '68', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1811', '68', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1812', '68', 'Name', 'gabriel angel orozco');
INSERT INTO wp_cformsdata VALUES('1813', '68', 'City/State', 'cd juarez chihuahua mexico');
INSERT INTO wp_cformsdata VALUES('1814', '68', 'Phone', '011526562077403');
INSERT INTO wp_cformsdata VALUES('1815', '68', 'Email', 'gabriel-angel55@hotmail.com');
INSERT INTO wp_cformsdata VALUES('1816', '68', 'How did you hear about us?', 'ceatica pain u tube');
INSERT INTO wp_cformsdata VALUES('1817', '68', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1818', '68', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1819', '68', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1820', '68', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1821', '68', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1822', '68', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1823', '68', 'When did the pain begin?', 'january 11 2011');
INSERT INTO wp_cformsdata VALUES('1824', '68', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1825', '68', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1826', '68', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1827', '68', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1828', '68', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1829', '68', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1830', '68', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1831', '68', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1832', '68', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1833', '68', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1834', '68', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1835', '68', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1836', '68', 'Comments, Questions', 'i trying to keep myself on good shape by runnig or walking 7km a day and 10kms on weekends i miss my workouts allot  i know thats its kind crazy but do you have somebody in texas my job is in heavy construcion big cranes please let me know as soon as possible the cost of treatment thank you very much .gabriel angel orozco');
INSERT INTO wp_cformsdata VALUES('1837', '69', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_3');
INSERT INTO wp_cformsdata VALUES('1838', '69', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1839', '69', 'Name', 'Megan Mc Gee');
INSERT INTO wp_cformsdata VALUES('1840', '69', 'City/State', 'Brookings, SD');
INSERT INTO wp_cformsdata VALUES('1841', '69', 'Phone', '605-690-2655');
INSERT INTO wp_cformsdata VALUES('1842', '69', 'Email', 'topnotchfive@gmail.com');
INSERT INTO wp_cformsdata VALUES('1843', '69', 'How did you hear about us?', 'k101 radio');
INSERT INTO wp_cformsdata VALUES('1844', '69', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1845', '69', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1846', '69', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1847', '69', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1848', '69', 'Date of most recent scan', 'March 2011');
INSERT INTO wp_cformsdata VALUES('1849', '69', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1850', '69', 'When did the pain begin?', 'back');
INSERT INTO wp_cformsdata VALUES('1851', '69', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1852', '69', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('1853', '69', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('1854', '69', 'If no, number of hours in pain', '12-16');
INSERT INTO wp_cformsdata VALUES('1855', '69', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1856', '69', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1857', '69', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1858', '69', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1859', '69', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1860', '69', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1861', '69', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1862', '69', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1863', '69', 'Comments, Questions', 'spinal stenosis at L4 - L5, with spondyla and facet joint involvement. ');
INSERT INTO wp_cformsdata VALUES('1864', '70', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1865', '70', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1866', '70', 'Name', 'Salvador Ibarrola');
INSERT INTO wp_cformsdata VALUES('1867', '70', 'City/State', 'Mexico City');
INSERT INTO wp_cformsdata VALUES('1868', '70', 'Phone', '0115215543290602');
INSERT INTO wp_cformsdata VALUES('1869', '70', 'Email', 'salvadoribarrola@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1870', '70', 'How did you hear about us?', 'Internet search');
INSERT INTO wp_cformsdata VALUES('1871', '70', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1872', '70', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('1873', '70', 'If yes, when did this occur?', '3 weeks ago');
INSERT INTO wp_cformsdata VALUES('1874', '70', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1875', '70', 'Date of most recent scan', '03/29/11');
INSERT INTO wp_cformsdata VALUES('1876', '70', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('1877', '70', 'When did the pain begin?', '03/20/11');
INSERT INTO wp_cformsdata VALUES('1878', '70', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1879', '70', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1880', '70', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1881', '70', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1882', '70', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('1883', '70', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1884', '70', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1885', '70', 'Date of onset of pain?', '03/20/11');
INSERT INTO wp_cformsdata VALUES('1886', '70', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1887', '70', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1888', '70', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1889', '70', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1890', '70', 'Comments, Questions', 'I am 68 years old and would like to evaluate your procedure prior to undergoing surgery to relieve radiculopathy of the sciatic nerve ');
INSERT INTO wp_cformsdata VALUES('1891', '71', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1892', '71', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1893', '71', 'Name', 'Michael Nezi');
INSERT INTO wp_cformsdata VALUES('1894', '71', 'City/State', 'Questa, NM');
INSERT INTO wp_cformsdata VALUES('1895', '71', 'Phone', '575-770-1915');
INSERT INTO wp_cformsdata VALUES('1896', '71', 'Email', 'nezi@redmountainmedia.com');
INSERT INTO wp_cformsdata VALUES('1897', '71', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('1898', '71', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1899', '71', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1900', '71', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1901', '71', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1902', '71', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1903', '71', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('1904', '71', 'When did the pain begin?', 'November 4, 2010');
INSERT INTO wp_cformsdata VALUES('1905', '71', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1906', '71', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1907', '71', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1908', '71', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1909', '71', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('1910', '71', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1911', '71', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1912', '71', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1913', '71', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1914', '71', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1915', '71', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('1916', '71', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1917', '71', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('1918', '72', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1919', '72', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1920', '72', 'Name', 'Claudia Benfeito');
INSERT INTO wp_cformsdata VALUES('1921', '72', 'City/State', 'Palm Bay Florida');
INSERT INTO wp_cformsdata VALUES('1922', '72', 'Phone', '321-409-8464');
INSERT INTO wp_cformsdata VALUES('1923', '72', 'Email', 'cab1408@msn.com');
INSERT INTO wp_cformsdata VALUES('1924', '72', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('1925', '72', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1926', '72', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('1927', '72', 'If yes, when did this occur?', 'approx.6 years ago');
INSERT INTO wp_cformsdata VALUES('1928', '72', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1929', '72', 'Date of most recent scan', '07-29-2010');
INSERT INTO wp_cformsdata VALUES('1930', '72', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('1931', '72', 'When did the pain begin?', 'left buttock');
INSERT INTO wp_cformsdata VALUES('1932', '72', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1933', '72', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1934', '72', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1935', '72', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1936', '72', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('1937', '72', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1938', '72', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1939', '72', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1940', '72', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1941', '72', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1942', '72', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1943', '72', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1944', '72', 'Comments, Questions', 'Sciatica nerve is unbearable all the time  injections don\'t work anymore  have to use a walker when out of the house very painful all day long sometimes I  can\'t walk 10 feet with out sitting down and waiting for the pain to subside.\nI read about  the treatment in Boca Raton Florida and would appreciate it if I could go there I\'ve been on  line all morning reading this article.\nI really need this pain relief.  Riding in a car is painful have to stop and walk about every 50 miles I don\'t like going out of the house. my activities ( I had to give up ) Please help me.\n\nThank You');
INSERT INTO wp_cformsdata VALUES('1945', '73', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1946', '73', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1947', '73', 'Name', 'Hinelda Apelizan');
INSERT INTO wp_cformsdata VALUES('1948', '73', 'City/State', 'Los Angeles, California 90004');
INSERT INTO wp_cformsdata VALUES('1949', '73', 'Phone', '3236812160');
INSERT INTO wp_cformsdata VALUES('1950', '73', 'Email', 'nhel_apelizan@yahoo.com');
INSERT INTO wp_cformsdata VALUES('1951', '73', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('1952', '73', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1953', '73', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1954', '73', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('1955', '73', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('1956', '73', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('1957', '73', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('1958', '73', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('1959', '73', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('1960', '73', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1961', '73', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1962', '73', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1963', '73', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('1964', '73', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1965', '73', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1966', '73', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1967', '73', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1968', '73', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1969', '73', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1970', '73', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1971', '73', 'Comments, Questions', 'Mild atherosclerotic vascular calcification in the abdominal aorta is the finding 
\non my lumbar sacral x-ray');
INSERT INTO wp_cformsdata VALUES('1972', '74', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('1973', '74', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('1974', '74', 'Name', 'Michael Lewis');
INSERT INTO wp_cformsdata VALUES('1975', '74', 'City/State', 'Bonita, CA');
INSERT INTO wp_cformsdata VALUES('1976', '74', 'Phone', '619-813-6815');
INSERT INTO wp_cformsdata VALUES('1977', '74', 'Email', 'Mikkylewis@cox.net');
INSERT INTO wp_cformsdata VALUES('1978', '74', 'How did you hear about us?', 'Google');
INSERT INTO wp_cformsdata VALUES('1979', '74', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('1980', '74', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('1981', '74', 'If yes, when did this occur?', 'One year ago');
INSERT INTO wp_cformsdata VALUES('1982', '74', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('1983', '74', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('1984', '74', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('1985', '74', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('1986', '74', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1987', '74', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('1988', '74', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1989', '74', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('1990', '74', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('1991', '74', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('1992', '74', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('1993', '74', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('1994', '74', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('1995', '74', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1996', '74', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1997', '74', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('1998', '74', 'Comments, Questions', 'I have been told that I have sciatica ');
INSERT INTO wp_cformsdata VALUES('1999', '75', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2000', '75', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2001', '75', 'Name', 'Bonnie kamp');
INSERT INTO wp_cformsdata VALUES('2002', '75', 'City/State', 'Thousand Oaks, CA  ');
INSERT INTO wp_cformsdata VALUES('2003', '75', 'Phone', '805-807-4504');
INSERT INTO wp_cformsdata VALUES('2004', '75', 'Email', 'bm_kamp@msn.com');
INSERT INTO wp_cformsdata VALUES('2005', '75', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2006', '75', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2007', '75', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2008', '75', 'If yes, when did this occur?', '5 years or so ago');
INSERT INTO wp_cformsdata VALUES('2009', '75', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2010', '75', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2011', '75', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('2012', '75', 'When did the pain begin?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('2013', '75', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2014', '75', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2015', '75', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2016', '75', 'If no, number of hours in pain', '16');
INSERT INTO wp_cformsdata VALUES('2017', '75', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('2018', '75', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2019', '75', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2020', '75', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2021', '75', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2022', '75', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('2023', '75', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2024', '75', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('2025', '75', 'Comments, Questions', 'I have arthritis in my neck and in the middle of my back.  Cervical fusion has been recommended. I have gotten many shots in my neck as well as injections in my spine for this without any real success.');
INSERT INTO wp_cformsdata VALUES('2026', '76', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('2027', '76', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2028', '76', 'Name', 'samuel w babayan');
INSERT INTO wp_cformsdata VALUES('2029', '76', 'City/State', 'glendale ca.');
INSERT INTO wp_cformsdata VALUES('2030', '76', 'Phone', '818 244 0574');
INSERT INTO wp_cformsdata VALUES('2031', '76', 'Email', 'samibabayan31@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2032', '76', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2033', '76', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2034', '76', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2035', '76', 'If yes, when did this occur?', '2001');
INSERT INTO wp_cformsdata VALUES('2036', '76', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2037', '76', 'Date of most recent scan', '2001');
INSERT INTO wp_cformsdata VALUES('2038', '76', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2039', '76', 'When did the pain begin?', '2011');
INSERT INTO wp_cformsdata VALUES('2040', '76', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2041', '76', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('2042', '76', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2043', '76', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2044', '76', 'Is there pain, tingling, numbness, or weakness in your:', 'feet');
INSERT INTO wp_cformsdata VALUES('2045', '76', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2046', '76', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2047', '76', 'Date of onset of pain?', '2001');
INSERT INTO wp_cformsdata VALUES('2048', '76', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2049', '76', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('2050', '76', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2051', '76', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('2052', '76', 'Comments, Questions', 'SWELL IN BOTH FEETS , BUT NO PAIN. THIS STARTED JUST FOUR MONTHS AGO.');
INSERT INTO wp_cformsdata VALUES('2053', '77', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2054', '77', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2055', '77', 'Name', 'Betty Gabriel');
INSERT INTO wp_cformsdata VALUES('2056', '77', 'City/State', 'Sac, Ca');
INSERT INTO wp_cformsdata VALUES('2057', '77', 'Phone', '916424-1989');
INSERT INTO wp_cformsdata VALUES('2058', '77', 'Email', 'baggab@att.net');
INSERT INTO wp_cformsdata VALUES('2059', '77', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2060', '77', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2061', '77', 'Does the patient have', 'Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2062', '77', 'If yes, when did this occur?', '10 years ago');
INSERT INTO wp_cformsdata VALUES('2063', '77', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2064', '77', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('2065', '77', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('2066', '77', 'When did the pain begin?', 'back');
INSERT INTO wp_cformsdata VALUES('2067', '77', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2068', '77', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2069', '77', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2070', '77', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2071', '77', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('2072', '77', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2073', '77', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2074', '77', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2075', '77', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2076', '77', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2077', '77', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2078', '77', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2079', '77', 'Comments, Questions', 'I have had epidural injections,phy therapy,cortisone injections, exercises, numerous pain pills with no relief.  Now since the pain has moved into my buttocks I have a very difficult time walking, or sitting.  Lyin in a certain position helps to relieve it at times.  Three weeks ago the tpain dominated the left side of my body; today the pain hasaggressively moved to my right side including my toes and knee.  I will start therapy again next week as the doctor thinks this will help my sciatia pain. I am unab le to walk and exercise much. I see a chiropractic monthly and get massages, but not change in my pain level. The lyrica does not help, but have caused me to gain a lot of weight.  I need help.   ');
INSERT INTO wp_cformsdata VALUES('2080', '78', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2081', '78', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2082', '78', 'Name', 'Hia Huynh');
INSERT INTO wp_cformsdata VALUES('2083', '78', 'City/State', 'Alhambra, California');
INSERT INTO wp_cformsdata VALUES('2084', '78', 'Phone', '626-570-8377');
INSERT INTO wp_cformsdata VALUES('2085', '78', 'Email', 'hgtran10@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2086', '78', 'How did you hear about us?', 'yahoo search');
INSERT INTO wp_cformsdata VALUES('2087', '78', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2088', '78', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2089', '78', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2090', '78', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2091', '78', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2092', '78', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2093', '78', 'When did the pain begin?', 'one month ago');
INSERT INTO wp_cformsdata VALUES('2094', '78', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2095', '78', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2096', '78', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2097', '78', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2098', '78', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('2099', '78', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2100', '78', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2101', '78', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2102', '78', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2103', '78', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2104', '78', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2105', '78', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2106', '78', 'Comments, Questions', ' patient fell on her butts, no broken bone occur.');
INSERT INTO wp_cformsdata VALUES('2107', '79', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2108', '79', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2109', '79', 'Name', 'Tanya Smit');
INSERT INTO wp_cformsdata VALUES('2110', '79', 'City/State', 'Burbank, CA');
INSERT INTO wp_cformsdata VALUES('2111', '79', 'Phone', '386-295-5065');
INSERT INTO wp_cformsdata VALUES('2112', '79', 'Email', 'tjsmit@msn.com');
INSERT INTO wp_cformsdata VALUES('2113', '79', 'How did you hear about us?', 'radio add');
INSERT INTO wp_cformsdata VALUES('2114', '79', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2115', '79', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('2116', '79', 'If yes, when did this occur?', '15 years ago and has progressed');
INSERT INTO wp_cformsdata VALUES('2117', '79', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2118', '79', 'Date of most recent scan', '2008');
INSERT INTO wp_cformsdata VALUES('2119', '79', 'Is there pain in:', 'Neck');
INSERT INTO wp_cformsdata VALUES('2120', '79', 'When did the pain begin?', '15 years ago after 2 car accidents');
INSERT INTO wp_cformsdata VALUES('2121', '79', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2122', '79', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2123', '79', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2124', '79', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2125', '79', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('2126', '79', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2127', '79', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2128', '79', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2129', '79', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2130', '79', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2131', '79', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2132', '79', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('2133', '79', 'Comments, Questions', 'I also have tingling in upper back, neck and to upper part of shoulders by neck');
INSERT INTO wp_cformsdata VALUES('2134', '80', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2135', '80', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2136', '80', 'Name', 'Derek');
INSERT INTO wp_cformsdata VALUES('2137', '80', 'City/State', 'Los Angeles California ');
INSERT INTO wp_cformsdata VALUES('2138', '80', 'Phone', '3108061856');
INSERT INTO wp_cformsdata VALUES('2139', '80', 'Email', 'Essexcountymedia@gmail.com');
INSERT INTO wp_cformsdata VALUES('2140', '80', 'How did you hear about us?', 'Research');
INSERT INTO wp_cformsdata VALUES('2141', '80', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2142', '80', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2143', '80', 'If yes, when did this occur?', '6 months ago');
INSERT INTO wp_cformsdata VALUES('2144', '80', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2145', '80', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2146', '80', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('2147', '80', 'When did the pain begin?', 'Carrying groceries. Pinched nerve from disk');
INSERT INTO wp_cformsdata VALUES('2148', '80', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2149', '80', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2150', '80', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2151', '80', 'If no, number of hours in pain', 'Heel pain in morning. After exercise. ');
INSERT INTO wp_cformsdata VALUES('2152', '80', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('2153', '80', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2154', '80', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2155', '80', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2156', '80', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2157', '80', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2158', '80', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2159', '80', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2160', '80', 'Comments, Questions', 'I found your website and live in la, \nI\'m a 34 year old canadian citizen living in los angeles and had a back injury, Pinched sciatic nerve and was in sever pain. With stretching and rest Thought it would go away, but I still get heel pain every morning and have a weak leg and after exercise it feels inflamed and painful and weak. It\'s been many months now and I\'m beginning to think it will never heal.. I do not have medical insurance in the US yet, but thought it would be worth reaching out to a professional to see if there is a solution, how I could do it and how many dollars in America treatment would cost.  If u have any solutions for me I would love to hear. My email is Essexcountymedia@gmail.com, thanks for your time ;) ');
INSERT INTO wp_cformsdata VALUES('2161', '81', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2162', '81', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2163', '81', 'Name', 'katie scott');
INSERT INTO wp_cformsdata VALUES('2164', '81', 'City/State', 'nsw');
INSERT INTO wp_cformsdata VALUES('2165', '81', 'Phone', '0413 395 414');
INSERT INTO wp_cformsdata VALUES('2166', '81', 'Email', 'don3key@yahoo.com.au');
INSERT INTO wp_cformsdata VALUES('2167', '81', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2168', '81', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2169', '81', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('2170', '81', 'If yes, when did this occur?', '2008');
INSERT INTO wp_cformsdata VALUES('2171', '81', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2172', '81', 'Date of most recent scan', 'august 09');
INSERT INTO wp_cformsdata VALUES('2173', '81', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2174', '81', 'When did the pain begin?', 'july 2008');
INSERT INTO wp_cformsdata VALUES('2175', '81', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2176', '81', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2177', '81', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2178', '81', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2179', '81', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('2180', '81', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2181', '81', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2182', '81', 'Date of onset of pain?', '3rd july 2008');
INSERT INTO wp_cformsdata VALUES('2183', '81', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2184', '81', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2185', '81', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2186', '81', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2187', '81', 'Comments, Questions', 'i live in australia, i am happy to travel as i am desperate to get my quality of life back . i am 30 years old');
INSERT INTO wp_cformsdata VALUES('2188', '82', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2189', '82', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2190', '82', 'Name', 'Hector  Rosales');
INSERT INTO wp_cformsdata VALUES('2191', '82', 'City/State', 'La Mirada  CA ');
INSERT INTO wp_cformsdata VALUES('2192', '82', 'Phone', '562-233-5128');
INSERT INTO wp_cformsdata VALUES('2193', '82', 'Email', 'HECTECH68@YAHOO.COM');
INSERT INTO wp_cformsdata VALUES('2194', '82', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2195', '82', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2196', '82', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2197', '82', 'If yes, when did this occur?', 'Feb 2011');
INSERT INTO wp_cformsdata VALUES('2198', '82', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2199', '82', 'Date of most recent scan', 'March 31, 2011');
INSERT INTO wp_cformsdata VALUES('2200', '82', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2201', '82', 'When did the pain begin?', 'feb 4 2011');
INSERT INTO wp_cformsdata VALUES('2202', '82', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2203', '82', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2204', '82', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2205', '82', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2206', '82', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('2207', '82', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2208', '82', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2209', '82', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2210', '82', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2211', '82', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2212', '82', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2213', '82', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2214', '82', 'Comments, Questions', 'Wanted more info I\'m currently on Workers Comp but need to find my alternatives to surgery');
INSERT INTO wp_cformsdata VALUES('2215', '83', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2216', '83', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2217', '83', 'Name', 'Alfonso Turrubiartes');
INSERT INTO wp_cformsdata VALUES('2218', '83', 'City/State', 'South Gate/CA');
INSERT INTO wp_cformsdata VALUES('2219', '83', 'Phone', '323-567-8378');
INSERT INTO wp_cformsdata VALUES('2220', '83', 'Email', 'chiquisyalfonso@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2221', '83', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('2222', '83', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2223', '83', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2224', '83', 'If yes, when did this occur?', 'in 2006');
INSERT INTO wp_cformsdata VALUES('2225', '83', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2226', '83', 'Date of most recent scan', '06/10');
INSERT INTO wp_cformsdata VALUES('2227', '83', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('2228', '83', 'When did the pain begin?', '2006');
INSERT INTO wp_cformsdata VALUES('2229', '83', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2230', '83', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2231', '83', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2232', '83', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2233', '83', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands');
INSERT INTO wp_cformsdata VALUES('2234', '83', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2235', '83', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2236', '83', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2237', '83', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2238', '83', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2239', '83', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2240', '83', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2241', '83', 'Comments, Questions', 'Do you have a spanish translator?');
INSERT INTO wp_cformsdata VALUES('2242', '84', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2243', '84', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2244', '84', 'Name', 'Derek yankoff');
INSERT INTO wp_cformsdata VALUES('2245', '84', 'City/State', 'San Juan Capistrano, ca');
INSERT INTO wp_cformsdata VALUES('2246', '84', 'Phone', '9494564000');
INSERT INTO wp_cformsdata VALUES('2247', '84', 'Email', 'Dyankoff@gmail.com');
INSERT INTO wp_cformsdata VALUES('2248', '84', 'How did you hear about us?', 'Web. YouTube ');
INSERT INTO wp_cformsdata VALUES('2249', '84', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2250', '84', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2251', '84', 'If yes, when did this occur?', '2000 to present');
INSERT INTO wp_cformsdata VALUES('2252', '84', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2253', '84', 'Date of most recent scan', '5 year ago or more ');
INSERT INTO wp_cformsdata VALUES('2254', '84', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2255', '84', 'When did the pain begin?', '2000');
INSERT INTO wp_cformsdata VALUES('2256', '84', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2257', '84', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2258', '84', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2259', '84', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2260', '84', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,feet,hands');
INSERT INTO wp_cformsdata VALUES('2261', '84', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2262', '84', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2263', '84', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2264', '84', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2265', '84', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2266', '84', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2267', '84', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2268', '84', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('2269', '85', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2270', '85', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2271', '85', 'Name', 'Jeanine Turner');
INSERT INTO wp_cformsdata VALUES('2272', '85', 'City/State', 'Baltimore, MD');
INSERT INTO wp_cformsdata VALUES('2273', '85', 'Phone', '443-253-3954');
INSERT INTO wp_cformsdata VALUES('2274', '85', 'Email', 'Jeanine@turnerdevelopment.com');
INSERT INTO wp_cformsdata VALUES('2275', '85', 'How did you hear about us?', 'You tube');
INSERT INTO wp_cformsdata VALUES('2276', '85', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2277', '85', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('2278', '85', 'If yes, when did this occur?', '2 years ago');
INSERT INTO wp_cformsdata VALUES('2279', '85', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2280', '85', 'Date of most recent scan', '2 years ago');
INSERT INTO wp_cformsdata VALUES('2281', '85', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('2282', '85', 'When did the pain begin?', '2 years ago');
INSERT INTO wp_cformsdata VALUES('2283', '85', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2284', '85', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2285', '85', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2286', '85', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2287', '85', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('2288', '85', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2289', '85', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2290', '85', 'Date of onset of pain?', '2008');
INSERT INTO wp_cformsdata VALUES('2291', '85', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2292', '85', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2293', '85', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2294', '85', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2295', '85', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('2296', '86', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2297', '86', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2298', '86', 'Name', 'David');
INSERT INTO wp_cformsdata VALUES('2299', '86', 'City/State', 'Navarre, Florida');
INSERT INTO wp_cformsdata VALUES('2300', '86', 'Phone', '850-313-2004');
INSERT INTO wp_cformsdata VALUES('2301', '86', 'Email', 'daviddegraaf@hotmail.com');
INSERT INTO wp_cformsdata VALUES('2302', '86', 'How did you hear about us?', 'You Tube video');
INSERT INTO wp_cformsdata VALUES('2303', '86', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2304', '86', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2305', '86', 'If yes, when did this occur?', 'October 2010');
INSERT INTO wp_cformsdata VALUES('2306', '86', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2307', '86', 'Date of most recent scan', '3/2011');
INSERT INTO wp_cformsdata VALUES('2308', '86', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2309', '86', 'When did the pain begin?', 'October 2010');
INSERT INTO wp_cformsdata VALUES('2310', '86', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2311', '86', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2312', '86', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2313', '86', 'If no, number of hours in pain', '15');
INSERT INTO wp_cformsdata VALUES('2314', '86', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('2315', '86', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2316', '86', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2317', '86', 'Date of onset of pain?', 'October 2010');
INSERT INTO wp_cformsdata VALUES('2318', '86', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2319', '86', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('2320', '86', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2321', '86', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2322', '86', 'Comments, Questions', 'I\'m undergoing spinal decompression on a LORDEX machine.  Is this the right thing to do and is it safe?');
INSERT INTO wp_cformsdata VALUES('2323', '87', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2324', '87', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2325', '87', 'Name', 'mary barnett');
INSERT INTO wp_cformsdata VALUES('2326', '87', 'City/State', 'biloxi,ms 39532');
INSERT INTO wp_cformsdata VALUES('2327', '87', 'Phone', '228-392-6086');
INSERT INTO wp_cformsdata VALUES('2328', '87', 'Email', 'jcmbarnett@gmail.com');
INSERT INTO wp_cformsdata VALUES('2329', '87', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2330', '87', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2331', '87', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2332', '87', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2333', '87', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2334', '87', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2335', '87', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2336', '87', 'When did the pain begin?', '1 month ago');
INSERT INTO wp_cformsdata VALUES('2337', '87', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2338', '87', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2339', '87', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2340', '87', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2341', '87', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('2342', '87', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2343', '87', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2344', '87', 'Date of onset of pain?', 'march 1,2011');
INSERT INTO wp_cformsdata VALUES('2345', '87', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2346', '87', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2347', '87', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2348', '87', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2349', '87', 'Comments, Questions', 'i have been to medical dr a nd chiropractor and had exrays they both said it was my sciatica nerve, ihave had no relief yet i would like to know if there is a dr that can give the perispinal etanercept shot near me in mississippi t');
INSERT INTO wp_cformsdata VALUES('2350', '88', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2351', '88', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2352', '88', 'Name', 'george hanold');
INSERT INTO wp_cformsdata VALUES('2353', '88', 'City/State', 'newport beach, CA');
INSERT INTO wp_cformsdata VALUES('2354', '88', 'Phone', '9499298686');
INSERT INTO wp_cformsdata VALUES('2355', '88', 'Email', 'info@hanoldproperties.com');
INSERT INTO wp_cformsdata VALUES('2356', '88', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('2357', '88', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2358', '88', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2359', '88', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2360', '88', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('2361', '88', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2362', '88', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2363', '88', 'When did the pain begin?', '6 months');
INSERT INTO wp_cformsdata VALUES('2364', '88', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2365', '88', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2366', '88', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2367', '88', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2368', '88', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('2369', '88', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2370', '88', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2371', '88', 'Date of onset of pain?', 'july 2010');
INSERT INTO wp_cformsdata VALUES('2372', '88', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2373', '88', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2374', '88', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2375', '88', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2376', '88', 'Comments, Questions', 'Do you take health insurance? Have Medficare and United Health');
INSERT INTO wp_cformsdata VALUES('2377', '89', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('2378', '89', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2379', '89', 'Name', 'Merilyn Lucas');
INSERT INTO wp_cformsdata VALUES('2380', '89', 'City/State', 'Compton California');
INSERT INTO wp_cformsdata VALUES('2381', '89', 'Phone', '(310) 631-3343');
INSERT INTO wp_cformsdata VALUES('2382', '89', 'Email', 'lonzosr42@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2383', '89', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2384', '89', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2385', '89', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2386', '89', 'If yes, when did this occur?', '5 yers ago');
INSERT INTO wp_cformsdata VALUES('2387', '89', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2388', '89', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('2389', '89', 'Is there pain in:', 'Back,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('2390', '89', 'When did the pain begin?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('2391', '89', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2392', '89', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2393', '89', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2394', '89', 'If no, number of hours in pain', '23');
INSERT INTO wp_cformsdata VALUES('2395', '89', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,arms');
INSERT INTO wp_cformsdata VALUES('2396', '89', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2397', '89', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2398', '89', 'Date of onset of pain?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('2399', '89', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2400', '89', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2401', '89', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2402', '89', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2403', '89', 'Comments, Questions', 'I had a fall in 2000 and my back has been painful every since, I need help with this pain which persists on a constant basis every day.  Please help me!');
INSERT INTO wp_cformsdata VALUES('2404', '90', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2405', '90', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2406', '90', 'Name', 'Merilyn Lucas');
INSERT INTO wp_cformsdata VALUES('2407', '90', 'City/State', 'Compton/ California');
INSERT INTO wp_cformsdata VALUES('2408', '90', 'Phone', '(310) 631-3343');
INSERT INTO wp_cformsdata VALUES('2409', '90', 'Email', 'lonzosr42@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2410', '90', 'How did you hear about us?', 'the internet');
INSERT INTO wp_cformsdata VALUES('2411', '90', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2412', '90', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2413', '90', 'If yes, when did this occur?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('2414', '90', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2415', '90', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('2416', '90', 'Is there pain in:', 'Back,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('2417', '90', 'When did the pain begin?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('2418', '90', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2419', '90', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2420', '90', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2421', '90', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2422', '90', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,arms');
INSERT INTO wp_cformsdata VALUES('2423', '90', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2424', '90', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2425', '90', 'Date of onset of pain?', '5 years ago');
INSERT INTO wp_cformsdata VALUES('2426', '90', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2427', '90', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2428', '90', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2429', '90', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2430', '90', 'Comments, Questions', 'I injured my back in 2000 and I have constant excruitiating pain, all day every day,
\nPlease help me.');
INSERT INTO wp_cformsdata VALUES('2431', '91', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2432', '91', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2433', '91', 'Name', 'cathy');
INSERT INTO wp_cformsdata VALUES('2434', '91', 'City/State', 'rancho cucamonga');
INSERT INTO wp_cformsdata VALUES('2435', '91', 'Phone', '951-532-4387');
INSERT INTO wp_cformsdata VALUES('2436', '91', 'Email', 'twoweavers@earthlink.net');
INSERT INTO wp_cformsdata VALUES('2437', '91', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('2438', '91', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2439', '91', 'Does the patient have', 'Annular tear');
INSERT INTO wp_cformsdata VALUES('2440', '91', 'If yes, when did this occur?', 'long time, but lifted heavy box august 2010');
INSERT INTO wp_cformsdata VALUES('2441', '91', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2442', '91', 'Date of most recent scan', 'march 7, 2011');
INSERT INTO wp_cformsdata VALUES('2443', '91', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2444', '91', 'When did the pain begin?', 'years ago, most recent lifted box august 2010');
INSERT INTO wp_cformsdata VALUES('2445', '91', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2446', '91', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2447', '91', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2448', '91', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2449', '91', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('2450', '91', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2451', '91', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2452', '91', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2453', '91', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2454', '91', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2455', '91', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2456', '91', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2457', '91', 'Comments, Questions', 'Pain left buttocks,, down left leg, and sometimes below knee. Been going to pain management doctor for a long time.  Have had three MRI recently and doctor does not know what is wrong. He suggested I go to a large hospital where this type of pain may have been seen before.  Pain was so bad I had to go to the ER this past Wednesday, April 6, 2011.  Got two pain shots at the ER and oxycontin for home. Pain is starting again.  Have pain at rest more often than not.  Please call me as soon as possible.  I would like to come in today, April 11. Because of traffic, I believe your Newport Beach office would be better than your L.A. office.');
INSERT INTO wp_cformsdata VALUES('2458', '92', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2459', '92', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2460', '92', 'Name', 'Carol Vedder');
INSERT INTO wp_cformsdata VALUES('2461', '92', 'City/State', 'San Pedro, California');
INSERT INTO wp_cformsdata VALUES('2462', '92', 'Phone', '310-221-0362');
INSERT INTO wp_cformsdata VALUES('2463', '92', 'Email', 'cv1818@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('2464', '92', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('2465', '92', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2466', '92', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2467', '92', 'If yes, when did this occur?', 'Unknown');
INSERT INTO wp_cformsdata VALUES('2468', '92', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2469', '92', 'Date of most recent scan', '9/1/10');
INSERT INTO wp_cformsdata VALUES('2470', '92', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2471', '92', 'When did the pain begin?', '2001');
INSERT INTO wp_cformsdata VALUES('2472', '92', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2473', '92', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2474', '92', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2475', '92', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2476', '92', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('2477', '92', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2478', '92', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2479', '92', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2480', '92', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2481', '92', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('2482', '92', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2483', '92', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2484', '92', 'Comments, Questions', 'I have pain whn standing & walking. I had spinal decompression with little response.');
INSERT INTO wp_cformsdata VALUES('2485', '93', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2486', '93', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2487', '93', 'Name', 'Helene Taylor ');
INSERT INTO wp_cformsdata VALUES('2488', '93', 'City/State', 'Newport beach ca');
INSERT INTO wp_cformsdata VALUES('2489', '93', 'Phone', '760 831-1162');
INSERT INTO wp_cformsdata VALUES('2490', '93', 'Email', 'helenejtaylor@Gmail.com');
INSERT INTO wp_cformsdata VALUES('2491', '93', 'How did you hear about us?', 'radio ad');
INSERT INTO wp_cformsdata VALUES('2492', '93', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2493', '93', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2494', '93', 'If yes, when did this occur?', '1975');
INSERT INTO wp_cformsdata VALUES('2495', '93', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2496', '93', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('2497', '93', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('2498', '93', 'When did the pain begin?', '1945');
INSERT INTO wp_cformsdata VALUES('2499', '93', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2500', '93', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2501', '93', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2502', '93', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2503', '93', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('2504', '93', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2505', '93', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2506', '93', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2507', '93', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2508', '93', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2509', '93', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2510', '93', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('2511', '93', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('2512', '94', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2513', '94', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2514', '94', 'Name', 'Karl Tautfest');
INSERT INTO wp_cformsdata VALUES('2515', '94', 'City/State', 'Long beach, Calif.');
INSERT INTO wp_cformsdata VALUES('2516', '94', 'Phone', '562-843-3067');
INSERT INTO wp_cformsdata VALUES('2517', '94', 'Email', 'cdfkarl@netscape.net');
INSERT INTO wp_cformsdata VALUES('2518', '94', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('2519', '94', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2520', '94', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2521', '94', 'If yes, when did this occur?', '3years ');
INSERT INTO wp_cformsdata VALUES('2522', '94', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2523', '94', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2524', '94', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('2525', '94', 'When did the pain begin?', 'middle of lower back');
INSERT INTO wp_cformsdata VALUES('2526', '94', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2527', '94', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2528', '94', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2529', '94', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2530', '94', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('2531', '94', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2532', '94', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2533', '94', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2534', '94', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2535', '94', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2536', '94', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2537', '94', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2538', '94', 'Comments, Questions', 'Sometimes it feels like an electric shock going into my back and my knees just give out.');
INSERT INTO wp_cformsdata VALUES('2539', '95', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2540', '95', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2541', '95', 'Name', 'Amador Arredondo');
INSERT INTO wp_cformsdata VALUES('2542', '95', 'City/State', 'Anaheim California');
INSERT INTO wp_cformsdata VALUES('2543', '95', 'Phone', '714-307-6728');
INSERT INTO wp_cformsdata VALUES('2544', '95', 'Email', 'arredondoanhm@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('2545', '95', 'How did you hear about us?', 'YouTube video');
INSERT INTO wp_cformsdata VALUES('2546', '95', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2547', '95', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2548', '95', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2549', '95', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2550', '95', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2551', '95', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2552', '95', 'When did the pain begin?', 'January 21 2011');
INSERT INTO wp_cformsdata VALUES('2553', '95', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2554', '95', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2555', '95', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2556', '95', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2557', '95', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('2558', '95', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2559', '95', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2560', '95', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2561', '95', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2562', '95', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2563', '95', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2564', '95', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2565', '95', 'Comments, Questions', 'I have severe pain in lower Back/upper buttocks that radiates down my leg.');
INSERT INTO wp_cformsdata VALUES('2566', '96', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2567', '96', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2568', '96', 'Name', 'Billie Carey');
INSERT INTO wp_cformsdata VALUES('2569', '96', 'City/State', 'Ontario, California');
INSERT INTO wp_cformsdata VALUES('2570', '96', 'Phone', '909-391-6059');
INSERT INTO wp_cformsdata VALUES('2571', '96', 'Email', 'Lautenslager@charter.net');
INSERT INTO wp_cformsdata VALUES('2572', '96', 'How did you hear about us?', 'Friend');
INSERT INTO wp_cformsdata VALUES('2573', '96', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2574', '96', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2575', '96', 'If yes, when did this occur?', '1996');
INSERT INTO wp_cformsdata VALUES('2576', '96', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2577', '96', 'Date of most recent scan', '2008');
INSERT INTO wp_cformsdata VALUES('2578', '96', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2579', '96', 'When did the pain begin?', '1996');
INSERT INTO wp_cformsdata VALUES('2580', '96', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2581', '96', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2582', '96', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2583', '96', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2584', '96', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('2585', '96', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2586', '96', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2587', '96', 'Date of onset of pain?', 'June 1996');
INSERT INTO wp_cformsdata VALUES('2588', '96', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2589', '96', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2590', '96', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2591', '96', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2592', '96', 'Comments, Questions', 'Thank you!');
INSERT INTO wp_cformsdata VALUES('2593', '97', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2594', '97', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2595', '97', 'Name', 'Renee Nathanson');
INSERT INTO wp_cformsdata VALUES('2596', '97', 'City/State', 'San Pedro, CA');
INSERT INTO wp_cformsdata VALUES('2597', '97', 'Phone', '(310) 519-8867');
INSERT INTO wp_cformsdata VALUES('2598', '97', 'Email', 'forerenee@aol.com');
INSERT INTO wp_cformsdata VALUES('2599', '97', 'How did you hear about us?', 'Radio ');
INSERT INTO wp_cformsdata VALUES('2600', '97', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2601', '97', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2602', '97', 'If yes, when did this occur?', 'Probably with injury in 1978');
INSERT INTO wp_cformsdata VALUES('2603', '97', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2604', '97', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('2605', '97', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2606', '97', 'When did the pain begin?', 'Present problem - Jan. 2009');
INSERT INTO wp_cformsdata VALUES('2607', '97', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2608', '97', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2609', '97', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2610', '97', 'If no, number of hours in pain', 'Anytime I walk');
INSERT INTO wp_cformsdata VALUES('2611', '97', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('2612', '97', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2613', '97', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2614', '97', 'Date of onset of pain?', 'Latest episode - Jan. 2009');
INSERT INTO wp_cformsdata VALUES('2615', '97', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2616', '97', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2617', '97', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2618', '97', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2619', '97', 'Comments, Questions', 'My physician feels this condition is neurologic claudication.  I have had one epidural and am waiting for a year for an ok for a second one.  My legs go into a static contraction when I walk more than 1/2 block and they lock up going up stairs or inclines.  My question is: Will the INR treatment help this condition?
\nAlso, what is the cost?  I do plan to discuss this with my orthopedic physician.');
INSERT INTO wp_cformsdata VALUES('2620', '98', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2621', '98', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2622', '98', 'Name', 'Tim Dwyer');
INSERT INTO wp_cformsdata VALUES('2623', '98', 'City/State', 'Temecula, CA');
INSERT INTO wp_cformsdata VALUES('2624', '98', 'Phone', '(951)492-5917');
INSERT INTO wp_cformsdata VALUES('2625', '98', 'Email', 'timpdwyer@msn.com');
INSERT INTO wp_cformsdata VALUES('2626', '98', 'How did you hear about us?', 'internet search');
INSERT INTO wp_cformsdata VALUES('2627', '98', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2628', '98', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('2629', '98', 'If yes, when did this occur?', '2/10/11');
INSERT INTO wp_cformsdata VALUES('2630', '98', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2631', '98', 'Date of most recent scan', '3/3/11');
INSERT INTO wp_cformsdata VALUES('2632', '98', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2633', '98', 'When did the pain begin?', 'low back');
INSERT INTO wp_cformsdata VALUES('2634', '98', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2635', '98', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2636', '98', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2637', '98', 'If no, number of hours in pain', '16 hours. Whenever I\'m awake');
INSERT INTO wp_cformsdata VALUES('2638', '98', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('2639', '98', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2640', '98', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2641', '98', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2642', '98', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2643', '98', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2644', '98', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2645', '98', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2646', '98', 'Comments, Questions', 'The MRI report shows L5- S1 , there is disc desiccation.  There is a 1 mm cirumferentialdisc bulgle with a focal left paracentral disc protrusion measuring 6-7mm.  This impresses on the exiting left S1 nerve root.  At L4-L5 there is disc desiccation and a 1mm disc bulge.');
INSERT INTO wp_cformsdata VALUES('2647', '99', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2648', '99', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2649', '99', 'Name', 'Rachel Baum');
INSERT INTO wp_cformsdata VALUES('2650', '99', 'City/State', 'Gardena, CA');
INSERT INTO wp_cformsdata VALUES('2651', '99', 'Phone', '424-477-6564');
INSERT INTO wp_cformsdata VALUES('2652', '99', 'Email', 'cbetsy4health@gmail.com');
INSERT INTO wp_cformsdata VALUES('2653', '99', 'How did you hear about us?', 'a friend who listens to Rush Limbaugh');
INSERT INTO wp_cformsdata VALUES('2654', '99', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2655', '99', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2656', '99', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2657', '99', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2658', '99', 'Date of most recent scan', '11/19/07');
INSERT INTO wp_cformsdata VALUES('2659', '99', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2660', '99', 'When did the pain begin?', 'July 2007');
INSERT INTO wp_cformsdata VALUES('2661', '99', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2662', '99', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2663', '99', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('2664', '99', 'If no, number of hours in pain', '18 hours');
INSERT INTO wp_cformsdata VALUES('2665', '99', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('2666', '99', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2667', '99', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2668', '99', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2669', '99', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2670', '99', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('2671', '99', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2672', '99', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('2673', '99', 'Comments, Questions', 'I had a pain induction study done in April 2008. Every thing was normal. My orthopedist called it L4 and L5 stenosis.  My chiropractor said I have a back mouse. He explained to me that fat has perforated the fascial tissue and has become trapped. I have a lot of referred pain in my right side. I had an exam by a neurologist in February and he informed me I had.lost 1 of my reflexes in my right leg. He asked if I had had sciatica, which I had on my right side. I had a CT scan with and without contrast on April 6th, 2011. The doctor said everything was normal. \nAre these procedures covered by health insurance? I have Anthem Blue Cross.');
INSERT INTO wp_cformsdata VALUES('2674', '100', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2675', '100', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2676', '100', 'Name', 'Debbie Douglas');
INSERT INTO wp_cformsdata VALUES('2677', '100', 'City/State', 'Apple Valley, Ca');
INSERT INTO wp_cformsdata VALUES('2678', '100', 'Phone', '760-240-4040 work 951-9220274');
INSERT INTO wp_cformsdata VALUES('2679', '100', 'Email', 'ddouglas@banning.k12.ca.us');
INSERT INTO wp_cformsdata VALUES('2680', '100', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2681', '100', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2682', '100', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2683', '100', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2684', '100', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2685', '100', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2686', '100', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('2687', '100', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('2688', '100', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2689', '100', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2690', '100', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2691', '100', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2692', '100', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('2693', '100', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2694', '100', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2695', '100', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2696', '100', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2697', '100', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2698', '100', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2699', '100', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2700', '100', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('2701', '101', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2702', '101', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2703', '101', 'Name', 'ivan');
INSERT INTO wp_cformsdata VALUES('2704', '101', 'City/State', 'Taiwan');
INSERT INTO wp_cformsdata VALUES('2705', '101', 'Phone', '00-0989064380');
INSERT INTO wp_cformsdata VALUES('2706', '101', 'Email', 'aimanalhossini@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2707', '101', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2708', '101', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2709', '101', 'Does the patient have', 'Annular tear');
INSERT INTO wp_cformsdata VALUES('2710', '101', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2711', '101', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2712', '101', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2713', '101', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2714', '101', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('2715', '101', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2716', '101', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2717', '101', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2718', '101', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2719', '101', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('2720', '101', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2721', '101', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2722', '101', 'Date of onset of pain?', 'april 5th 2011');
INSERT INTO wp_cformsdata VALUES('2723', '101', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2724', '101', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2725', '101', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2726', '101', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2727', '101', 'Comments, Questions', 'my case is exactly like the prson in the vedio.
\nplease any help.
\nthanks');
INSERT INTO wp_cformsdata VALUES('2728', '102', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2729', '102', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2730', '102', 'Name', 'Casie Slate');
INSERT INTO wp_cformsdata VALUES('2731', '102', 'City/State', 'Decatur Alabama');
INSERT INTO wp_cformsdata VALUES('2732', '102', 'Phone', '3340-328-2750');
INSERT INTO wp_cformsdata VALUES('2733', '102', 'Email', 'richatc44@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2734', '102', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('2735', '102', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2736', '102', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('2737', '102', 'If yes, when did this occur?', '3 weeks ago');
INSERT INTO wp_cformsdata VALUES('2738', '102', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2739', '102', 'Date of most recent scan', '04/10/2011');
INSERT INTO wp_cformsdata VALUES('2740', '102', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('2741', '102', 'When did the pain begin?', 'lower back right side down the back of right leg');
INSERT INTO wp_cformsdata VALUES('2742', '102', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2743', '102', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2744', '102', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2745', '102', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2746', '102', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('2747', '102', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2748', '102', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2749', '102', 'Date of onset of pain?', 'had herniated disc surgery April 1st');
INSERT INTO wp_cformsdata VALUES('2750', '102', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2751', '102', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2752', '102', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2753', '102', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2754', '102', 'Comments, Questions', 'Please Help\n\n\nDr Robert Ward In Cullman Al did the herniated disc surgery he said she should not be having this pain,All she does is cry from the pain she is in.Can you recommend someone to help us.\n\nPlease we have insurance but can not get to Fl to see u.\nCasie is a nurse at Decatur General and can\'t work right now.\nI just stared a new job.We are at a loss right now.\nThank you for your time\nGod Bless\nRichard Hatcher  ');
INSERT INTO wp_cformsdata VALUES('2755', '103', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2756', '103', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2757', '103', 'Name', 'Colin');
INSERT INTO wp_cformsdata VALUES('2758', '103', 'City/State', 'Seattle, WA');
INSERT INTO wp_cformsdata VALUES('2759', '103', 'Phone', '206-403-7110');
INSERT INTO wp_cformsdata VALUES('2760', '103', 'Email', 'mbsterling@gmail.com');
INSERT INTO wp_cformsdata VALUES('2761', '103', 'How did you hear about us?', 'YouTube');
INSERT INTO wp_cformsdata VALUES('2762', '103', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2763', '103', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('2764', '103', 'If yes, when did this occur?', 'A physical therapist indicates that I most likely have this.');
INSERT INTO wp_cformsdata VALUES('2765', '103', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('2766', '103', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2767', '103', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2768', '103', 'When did the pain begin?', '1997');
INSERT INTO wp_cformsdata VALUES('2769', '103', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2770', '103', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2771', '103', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2772', '103', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2773', '103', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('2774', '103', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2775', '103', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2776', '103', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2777', '103', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2778', '103', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2779', '103', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2780', '103', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2781', '103', 'Comments, Questions', 'I do live in Seattle, Washington.  You should open a clinic up here. :)  I don\'t know if you know of any doctors or other institutes that could help me in Seattle.  I am disabled and also unemployed.  I do my best to work (when I can).  My line of work is an Administrative Sales Assistant (with a marketing background).\n\nI am unable to sit (at most- 5 minutes), sleep, etc.  This is now my 3rd episode and it has been going on since March 5th.  I feel like I\'m dying really.  My body is giving into this more and more each day and I feel like I\'m a piece of foil being rolled up into a ball.  I don\'t want to go through life in this much pain (I\'ve had enough emotional pain already, but now that I\'m so in love- that part of my life is awesome).  I don\'t want this to ever occur again.\n\nIf you can help, please- help.  I need this to cease.  I\'m suffering a lot.\n\nColin\n');
INSERT INTO wp_cformsdata VALUES('2782', '104', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2783', '104', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2784', '104', 'Name', 'Anastasiia Udovenko');
INSERT INTO wp_cformsdata VALUES('2785', '104', 'City/State', 'Calgary, Alberta, Canada');
INSERT INTO wp_cformsdata VALUES('2786', '104', 'Phone', '+1403 9091704');
INSERT INTO wp_cformsdata VALUES('2787', '104', 'Email', 'a_udovenko@hotmail.com');
INSERT INTO wp_cformsdata VALUES('2788', '104', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('2789', '104', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2790', '104', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2791', '104', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2792', '104', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2793', '104', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2794', '104', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2795', '104', 'When did the pain begin?', '4 weeks ago');
INSERT INTO wp_cformsdata VALUES('2796', '104', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2797', '104', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2798', '104', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2799', '104', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2800', '104', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('2801', '104', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2802', '104', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2803', '104', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2804', '104', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('2805', '104', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2806', '104', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2807', '104', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2808', '104', 'Comments, Questions', 'Dear Doctor, I live in Canada, but I\'m very hopefull to have a consultation with one of your specialist. This back pain and sciatica is ruining my life. Thank you so much in advance and I hope you can help me. Anastasiia');
INSERT INTO wp_cformsdata VALUES('2809', '105', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2810', '105', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2811', '105', 'Name', 'Ann Bass');
INSERT INTO wp_cformsdata VALUES('2812', '105', 'City/State', 'San Diego/CA');
INSERT INTO wp_cformsdata VALUES('2813', '105', 'Phone', '6199773754');
INSERT INTO wp_cformsdata VALUES('2814', '105', 'Email', 'abass4792@cox.net');
INSERT INTO wp_cformsdata VALUES('2815', '105', 'How did you hear about us?', 'Radio ad');
INSERT INTO wp_cformsdata VALUES('2816', '105', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2817', '105', 'Does the patient have', 'Bulging Disc,Annular tear');
INSERT INTO wp_cformsdata VALUES('2818', '105', 'If yes, when did this occur?', '1998');
INSERT INTO wp_cformsdata VALUES('2819', '105', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2820', '105', 'Date of most recent scan', 'will be 4 25 11');
INSERT INTO wp_cformsdata VALUES('2821', '105', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('2822', '105', 'When did the pain begin?', '1998');
INSERT INTO wp_cformsdata VALUES('2823', '105', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2824', '105', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2825', '105', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2826', '105', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2827', '105', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves,feet,hands,fingers');
INSERT INTO wp_cformsdata VALUES('2828', '105', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2829', '105', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2830', '105', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2831', '105', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2832', '105', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2833', '105', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2834', '105', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2835', '105', 'Comments, Questions', 'Takes about 2-3 hours to regain regular gait from previous day.
\nHave had numerous back \"injections\" to relieve pain.
\nDiagnoses include autoimmuine disorder, fibromyalgia.
\nAlso, numerous procedures/surgeries on both knees (patellofemoral replacement left, torn menisci (L/R), tendon transplant L, Lateral release R, fractured patella L, torn cartiledge, 5-6 scopes R, 7-10 scopes L.  Ongoing knee problems since torn ligament during cheerleading 1966.)
\nKnees appear to be stable at this time.  
\nBACK PROBLEMS APPEAR TO BE PRIMARY REASON FOR THIS CURRENT REFERRAL. ');
INSERT INTO wp_cformsdata VALUES('2836', '106', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2837', '106', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2838', '106', 'Name', 'Eliot Beltran');
INSERT INTO wp_cformsdata VALUES('2839', '106', 'City/State', 'Elizabethtown, KY');
INSERT INTO wp_cformsdata VALUES('2840', '106', 'Phone', '417-7737429');
INSERT INTO wp_cformsdata VALUES('2841', '106', 'Email', 'ebeltran462@gmail.com');
INSERT INTO wp_cformsdata VALUES('2842', '106', 'How did you hear about us?', 'Research, but mainly watched youtube videos.');
INSERT INTO wp_cformsdata VALUES('2843', '106', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2844', '106', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2845', '106', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2846', '106', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2847', '106', 'Date of most recent scan', 'Have had 2 different x-ray scans within a two month period');
INSERT INTO wp_cformsdata VALUES('2848', '106', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('2849', '106', 'When did the pain begin?', 'January 2011');
INSERT INTO wp_cformsdata VALUES('2850', '106', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2851', '106', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2852', '106', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2853', '106', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2854', '106', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('2855', '106', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2856', '106', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2857', '106', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2858', '106', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2859', '106', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2860', '106', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2861', '106', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2862', '106', 'Comments, Questions', 'I finally checked myself into a hospital today (4/21/11) and told them it was a nerve problem specifically the sciatic nerve. The took x-rays even though I told them x-rays won\'t show anything and they said everything was fine with the x-rays. They gave me a steroid and morphine shot which both did not minimize the the pain at all. My movement is getting more limited as well and the muscle relaxer did not help either. Doctors also perscribed a steroid pack and other medice. Howerver, I feel that it would not help the second time if it did not help the first. I will do anything to get this treatment. I have a good job with insurance and have been the sole income earner for our family of 6  for over 5 years. This is because my wife has stayed home to raise our kids and in the process has developed some health problems to include lyme diasease, and  rheumatoid arthritis. I can take vacation if needed to do a consultation and treatment. This pain has recently intensified now to the point where it is starting to affect my job. I still have time to do something about it and keep our family going. Please contact me tomorrow as I have taken a day off specifically because of the pain. ');
INSERT INTO wp_cformsdata VALUES('2863', '107', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2864', '107', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2865', '107', 'Name', 'Richard Hull');
INSERT INTO wp_cformsdata VALUES('2866', '107', 'City/State', 'Kuala Lumpur, Malaysia');
INSERT INTO wp_cformsdata VALUES('2867', '107', 'Phone', '+603 2168 4251');
INSERT INTO wp_cformsdata VALUES('2868', '107', 'Email', 'richard@rhinvestmentservices.com');
INSERT INTO wp_cformsdata VALUES('2869', '107', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('2870', '107', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2871', '107', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease,Annular tear');
INSERT INTO wp_cformsdata VALUES('2872', '107', 'If yes, when did this occur?', 'June 2010 pain started');
INSERT INTO wp_cformsdata VALUES('2873', '107', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2874', '107', 'Date of most recent scan', 'February 2011');
INSERT INTO wp_cformsdata VALUES('2875', '107', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2876', '107', 'When did the pain begin?', 'June 2010');
INSERT INTO wp_cformsdata VALUES('2877', '107', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2878', '107', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2879', '107', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2880', '107', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2881', '107', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('2882', '107', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('2883', '107', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2884', '107', 'Date of onset of pain?', 'June 2010');
INSERT INTO wp_cformsdata VALUES('2885', '107', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2886', '107', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('2887', '107', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2888', '107', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2889', '107', 'Comments, Questions', 'I have scitica as my bottom two discs have degenerated, are de-hydated and put pressure on my sciatic nerve.  I have pain whenever i stand or walk for more than a few minutes and this has been constant for 10 months.  When I sit or lay down the pain is significantly reduced.');
INSERT INTO wp_cformsdata VALUES('2890', '108', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2891', '108', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2892', '108', 'Name', 'Aida');
INSERT INTO wp_cformsdata VALUES('2893', '108', 'City/State', 'Glendale, CA');
INSERT INTO wp_cformsdata VALUES('2894', '108', 'Phone', '818-667-9242');
INSERT INTO wp_cformsdata VALUES('2895', '108', 'Email', 'Aidamel2002@yahoo.com');
INSERT INTO wp_cformsdata VALUES('2896', '108', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('2897', '108', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2898', '108', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('2899', '108', 'If yes, when did this occur?', '3,5 years');
INSERT INTO wp_cformsdata VALUES('2900', '108', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2901', '108', 'Date of most recent scan', '3years');
INSERT INTO wp_cformsdata VALUES('2902', '108', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2903', '108', 'When did the pain begin?', '3,5 years ago');
INSERT INTO wp_cformsdata VALUES('2904', '108', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('2905', '108', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('2906', '108', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2907', '108', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2908', '108', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('2909', '108', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2910', '108', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2911', '108', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2912', '108', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2913', '108', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2914', '108', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2915', '108', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('2916', '108', 'Comments, Questions', 'What do you think about convesion table. Is it helpful.\nThanks');
INSERT INTO wp_cformsdata VALUES('2917', '109', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2918', '109', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2919', '109', 'Name', 'Ken Carroll');
INSERT INTO wp_cformsdata VALUES('2920', '109', 'City/State', 'Riverside Ca.');
INSERT INTO wp_cformsdata VALUES('2921', '109', 'Phone', '9517801460');
INSERT INTO wp_cformsdata VALUES('2922', '109', 'Email', 'kalken@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('2923', '109', 'How did you hear about us?', 'Internet ');
INSERT INTO wp_cformsdata VALUES('2924', '109', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2925', '109', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('2926', '109', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2927', '109', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('2928', '109', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('2929', '109', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('2930', '109', 'When did the pain begin?', 'week ago');
INSERT INTO wp_cformsdata VALUES('2931', '109', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2932', '109', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2933', '109', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2934', '109', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2935', '109', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('2936', '109', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2937', '109', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2938', '109', 'Date of onset of pain?', '4 -18 2011');
INSERT INTO wp_cformsdata VALUES('2939', '109', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2940', '109', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2941', '109', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2942', '109', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2943', '109', 'Comments, Questions', 'Is there a  qualified INR doctor in Riverside, I also have COPD and it is very hard for me to travel.');
INSERT INTO wp_cformsdata VALUES('2944', '110', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2945', '110', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2946', '110', 'Name', 'Melissa Panesso-Rodriguez');
INSERT INTO wp_cformsdata VALUES('2947', '110', 'City/State', 'Tampa / Florida');
INSERT INTO wp_cformsdata VALUES('2948', '110', 'Phone', '813-735-9395');
INSERT INTO wp_cformsdata VALUES('2949', '110', 'Email', 'Er2178@gmail.com');
INSERT INTO wp_cformsdata VALUES('2950', '110', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('2951', '110', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2952', '110', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2953', '110', 'If yes, when did this occur?', '5 yes ago');
INSERT INTO wp_cformsdata VALUES('2954', '110', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2955', '110', 'Date of most recent scan', 'April 2010');
INSERT INTO wp_cformsdata VALUES('2956', '110', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2957', '110', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('2958', '110', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2959', '110', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2960', '110', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2961', '110', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2962', '110', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('2963', '110', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('2964', '110', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('2965', '110', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('2966', '110', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2967', '110', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2968', '110', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2969', '110', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2970', '110', 'Comments, Questions', 'I am 5 months pregnant, could I still get tretment.\n\n\n');
INSERT INTO wp_cformsdata VALUES('2971', '111', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2972', '111', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('2973', '111', 'Name', 'Richard Jacobs');
INSERT INTO wp_cformsdata VALUES('2974', '111', 'City/State', 'Princeton Junction, NJ');
INSERT INTO wp_cformsdata VALUES('2975', '111', 'Phone', '6097997533');
INSERT INTO wp_cformsdata VALUES('2976', '111', 'Email', 'RichMjacobs@gmail.com');
INSERT INTO wp_cformsdata VALUES('2977', '111', 'How did you hear about us?', 'Web search');
INSERT INTO wp_cformsdata VALUES('2978', '111', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('2979', '111', 'Does the patient have', 'Herniated Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('2980', '111', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('2981', '111', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2982', '111', 'Date of most recent scan', 'March 2011');
INSERT INTO wp_cformsdata VALUES('2983', '111', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('2984', '111', 'When did the pain begin?', '18 months ago');
INSERT INTO wp_cformsdata VALUES('2985', '111', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2986', '111', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('2987', '111', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2988', '111', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('2989', '111', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('2990', '111', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2991', '111', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2992', '111', 'Date of onset of pain?', 'September 2009');
INSERT INTO wp_cformsdata VALUES('2993', '111', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2994', '111', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2995', '111', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('2996', '111', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('2997', '111', 'Comments, Questions', 'Do you treat people who have had unsuccessful back surgery? How does it work? Thank you');
INSERT INTO wp_cformsdata VALUES('2998', '112', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('2999', '112', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3000', '112', 'Name', 'Mark McGEE');
INSERT INTO wp_cformsdata VALUES('3001', '112', 'City/State', 'Livermore CA.');
INSERT INTO wp_cformsdata VALUES('3002', '112', 'Phone', '510-415-5552');
INSERT INTO wp_cformsdata VALUES('3003', '112', 'Email', 'markmcgee6@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3004', '112', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('3005', '112', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3006', '112', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('3007', '112', 'If yes, when did this occur?', '2/23/11');
INSERT INTO wp_cformsdata VALUES('3008', '112', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3009', '112', 'Date of most recent scan', '8/14/07');
INSERT INTO wp_cformsdata VALUES('3010', '112', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('3011', '112', 'When did the pain begin?', '8 weeks ago');
INSERT INTO wp_cformsdata VALUES('3012', '112', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3013', '112', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3014', '112', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3015', '112', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3016', '112', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('3017', '112', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3018', '112', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3019', '112', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3020', '112', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3021', '112', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3022', '112', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3023', '112', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('3024', '112', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3025', '113', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3026', '113', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3027', '113', 'Name', 'Chris repman');
INSERT INTO wp_cformsdata VALUES('3028', '113', 'City/State', 'Midland, tx');
INSERT INTO wp_cformsdata VALUES('3029', '113', 'Phone', '432-520-6070');
INSERT INTO wp_cformsdata VALUES('3030', '113', 'Email', 'Carepman@gmail.com');
INSERT INTO wp_cformsdata VALUES('3031', '113', 'How did you hear about us?', 'YouTube ');
INSERT INTO wp_cformsdata VALUES('3032', '113', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3033', '113', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3034', '113', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3035', '113', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3036', '113', 'Date of most recent scan', '7-6-04');
INSERT INTO wp_cformsdata VALUES('3037', '113', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('3038', '113', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3039', '113', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3040', '113', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3041', '113', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3042', '113', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3043', '113', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('3044', '113', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3045', '113', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3046', '113', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3047', '113', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3048', '113', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3049', '113', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3050', '113', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3051', '113', 'Comments, Questions', 'Been told it\'s sciatica');
INSERT INTO wp_cformsdata VALUES('3052', '114', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3053', '114', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3054', '114', 'Name', 'Melanie Apicella');
INSERT INTO wp_cformsdata VALUES('3055', '114', 'City/State', 'Yorba Linda, CA');
INSERT INTO wp_cformsdata VALUES('3056', '114', 'Phone', '714 606 2710');
INSERT INTO wp_cformsdata VALUES('3057', '114', 'Email', 'mamaem@aol.com');
INSERT INTO wp_cformsdata VALUES('3058', '114', 'How did you hear about us?', 'friend');
INSERT INTO wp_cformsdata VALUES('3059', '114', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3060', '114', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3061', '114', 'If yes, when did this occur?', 'April 2009');
INSERT INTO wp_cformsdata VALUES('3062', '114', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3063', '114', 'Date of most recent scan', 'August 2010');
INSERT INTO wp_cformsdata VALUES('3064', '114', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3065', '114', 'When did the pain begin?', 'May 2010');
INSERT INTO wp_cformsdata VALUES('3066', '114', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3067', '114', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3068', '114', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3069', '114', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3070', '114', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('3071', '114', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3072', '114', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3073', '114', 'Date of onset of pain?', 'May 2010');
INSERT INTO wp_cformsdata VALUES('3074', '114', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3075', '114', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3076', '114', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3077', '114', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3078', '114', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3079', '115', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3080', '115', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3081', '115', 'Name', 'Monika  Chadwick');
INSERT INTO wp_cformsdata VALUES('3082', '115', 'City/State', 'Oro Grande');
INSERT INTO wp_cformsdata VALUES('3083', '115', 'Phone', '760 917 1795');
INSERT INTO wp_cformsdata VALUES('3084', '115', 'Email', 'juppoix@gmail.com');
INSERT INTO wp_cformsdata VALUES('3085', '115', 'How did you hear about us?', 'Net');
INSERT INTO wp_cformsdata VALUES('3086', '115', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3087', '115', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3088', '115', 'If yes, when did this occur?', 'Lumbar degenerative With pinched nerve L4,L5');
INSERT INTO wp_cformsdata VALUES('3089', '115', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3090', '115', 'Date of most recent scan', 'November 2007');
INSERT INTO wp_cformsdata VALUES('3091', '115', 'Is there pain in:', 'Back,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('3092', '115', 'When did the pain begin?', 'August 2007');
INSERT INTO wp_cformsdata VALUES('3093', '115', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('3094', '115', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3095', '115', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3096', '115', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3097', '115', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('3098', '115', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3099', '115', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3100', '115', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3101', '115', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3102', '115', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3103', '115', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3104', '115', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3105', '115', 'Comments, Questions', 'I lOST my JOB,HOUSE AND ALL ELSE OVER THIS');
INSERT INTO wp_cformsdata VALUES('3106', '116', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3107', '116', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3108', '116', 'Name', 'valerie wildman');
INSERT INTO wp_cformsdata VALUES('3109', '116', 'City/State', 'p.o. box 794 lebec, ca. 93243');
INSERT INTO wp_cformsdata VALUES('3110', '116', 'Phone', '661 245-1501');
INSERT INTO wp_cformsdata VALUES('3111', '116', 'Email', 'valerie_wildman@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3112', '116', 'How did you hear about us?', 'yahoo');
INSERT INTO wp_cformsdata VALUES('3113', '116', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3114', '116', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3115', '116', 'If yes, when did this occur?', '1 year');
INSERT INTO wp_cformsdata VALUES('3116', '116', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3117', '116', 'Date of most recent scan', '4-7-2011');
INSERT INTO wp_cformsdata VALUES('3118', '116', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('3119', '116', 'When did the pain begin?', '1 year ago');
INSERT INTO wp_cformsdata VALUES('3120', '116', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3121', '116', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3122', '116', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3123', '116', 'If no, number of hours in pain', '15');
INSERT INTO wp_cformsdata VALUES('3124', '116', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('3125', '116', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3126', '116', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3127', '116', 'Date of onset of pain?', '1 year ago');
INSERT INTO wp_cformsdata VALUES('3128', '116', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3129', '116', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3130', '116', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3131', '116', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3132', '116', 'Comments, Questions', 'I have had  two lumbar epidural steroid injections ');
INSERT INTO wp_cformsdata VALUES('3133', '117', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3134', '117', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3135', '117', 'Name', 'shannon tobar');
INSERT INTO wp_cformsdata VALUES('3136', '117', 'City/State', 'lake balboa , CA');
INSERT INTO wp_cformsdata VALUES('3137', '117', 'Phone', '310-428-1228');
INSERT INTO wp_cformsdata VALUES('3138', '117', 'Email', 'sthiggins32@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3139', '117', 'How did you hear about us?', 'online article');
INSERT INTO wp_cformsdata VALUES('3140', '117', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3141', '117', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3142', '117', 'If yes, when did this occur?', '10 years ago, ongoing');
INSERT INTO wp_cformsdata VALUES('3143', '117', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3144', '117', 'Date of most recent scan', '02.2010');
INSERT INTO wp_cformsdata VALUES('3145', '117', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3146', '117', 'When did the pain begin?', '2001');
INSERT INTO wp_cformsdata VALUES('3147', '117', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3148', '117', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3149', '117', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3150', '117', 'If no, number of hours in pain', '10');
INSERT INTO wp_cformsdata VALUES('3151', '117', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,arms');
INSERT INTO wp_cformsdata VALUES('3152', '117', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3153', '117', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3154', '117', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3155', '117', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3156', '117', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3157', '117', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('3158', '117', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3159', '117', 'Comments, Questions', 'had injury in 2001 playing soccer. damaged l4, l5 s1. have had ongoing issues including out on disability for 2 months in 2005. Have had recent pain ongoing especially in morning when i get up, I can even walk for a good 30 minutes. I have HMO insurance through Anthem blue cross, cedars -sanai medical group in los angeles. Looking for a fix as I have serious pain, gained weight due to lack of movement. ');
INSERT INTO wp_cformsdata VALUES('3160', '118', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3161', '118', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3162', '118', 'Name', 'James S. Farley');
INSERT INTO wp_cformsdata VALUES('3163', '118', 'City/State', 'Carlsbad, CA');
INSERT INTO wp_cformsdata VALUES('3164', '118', 'Phone', '760.533.0459');
INSERT INTO wp_cformsdata VALUES('3165', '118', 'Email', 'jim@leichtag.org');
INSERT INTO wp_cformsdata VALUES('3166', '118', 'How did you hear about us?', 'Richard Marks, Esq.');
INSERT INTO wp_cformsdata VALUES('3167', '118', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3168', '118', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3169', '118', 'If yes, when did this occur?', '? Fragmented disc, 2002 surgery');
INSERT INTO wp_cformsdata VALUES('3170', '118', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3171', '118', 'Date of most recent scan', '2002');
INSERT INTO wp_cformsdata VALUES('3172', '118', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3173', '118', 'When did the pain begin?', '2002');
INSERT INTO wp_cformsdata VALUES('3174', '118', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3175', '118', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3176', '118', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3177', '118', 'If no, number of hours in pain', 'It is severe at times');
INSERT INTO wp_cformsdata VALUES('3178', '118', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('3179', '118', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3180', '118', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3181', '118', 'Date of onset of pain?', '2002');
INSERT INTO wp_cformsdata VALUES('3182', '118', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3183', '118', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3184', '118', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3185', '118', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3186', '118', 'Comments, Questions', 'I am experiencing a sever and episodic event. I have an appointment for this Sat. (4/30) at 2:00 p.m. I am attempting to get medical file from 2002-03 which will document prior surgery');
INSERT INTO wp_cformsdata VALUES('3187', '119', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3188', '119', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3189', '119', 'Name', 'Carolyn R. Jackson');
INSERT INTO wp_cformsdata VALUES('3190', '119', 'City/State', 'New Orleans, Louisiana');
INSERT INTO wp_cformsdata VALUES('3191', '119', 'Phone', '(504)458-1078');
INSERT INTO wp_cformsdata VALUES('3192', '119', 'Email', 'carolynrjackson@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3193', '119', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('3194', '119', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3195', '119', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3196', '119', 'If yes, when did this occur?', 'Two years ago  the pain started.');
INSERT INTO wp_cformsdata VALUES('3197', '119', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3198', '119', 'Date of most recent scan', 'December of 2009');
INSERT INTO wp_cformsdata VALUES('3199', '119', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3200', '119', 'When did the pain begin?', 'It started with the right side approximately two years ago.');
INSERT INTO wp_cformsdata VALUES('3201', '119', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3202', '119', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3203', '119', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3204', '119', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3205', '119', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('3206', '119', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3207', '119', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3208', '119', 'Date of onset of pain?', 'Can\'t remember the exact date but I know I have been in extreem pain for about two years.');
INSERT INTO wp_cformsdata VALUES('3209', '119', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3210', '119', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3211', '119', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3212', '119', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3213', '119', 'Comments, Questions', 'After sitting it is very hard to stand without assistance,but once I stand and start moving I am able to walk freely.');
INSERT INTO wp_cformsdata VALUES('3214', '120', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3215', '120', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3216', '120', 'Name', 'Bryan Williams');
INSERT INTO wp_cformsdata VALUES('3217', '120', 'City/State', 'Highland, CA');
INSERT INTO wp_cformsdata VALUES('3218', '120', 'Phone', '9097339429');
INSERT INTO wp_cformsdata VALUES('3219', '120', 'Email', 'bryan.williams_consulting@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3220', '120', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('3221', '120', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3222', '120', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3223', '120', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3224', '120', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3225', '120', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3226', '120', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('3227', '120', 'When did the pain begin?', '3+ years ago');
INSERT INTO wp_cformsdata VALUES('3228', '120', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3229', '120', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3230', '120', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3231', '120', 'If no, number of hours in pain', '14+');
INSERT INTO wp_cformsdata VALUES('3232', '120', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,arms,fingers');
INSERT INTO wp_cformsdata VALUES('3233', '120', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3234', '120', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3235', '120', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3236', '120', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3237', '120', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('3238', '120', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3239', '120', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('3240', '120', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3241', '121', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3242', '121', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3243', '121', 'Name', 'Diana Whitejohnson');
INSERT INTO wp_cformsdata VALUES('3244', '121', 'City/State', 'Rancho Cucamonga/California');
INSERT INTO wp_cformsdata VALUES('3245', '121', 'Phone', '909-803-8420');
INSERT INTO wp_cformsdata VALUES('3246', '121', 'Email', 'drdwhitejohnson@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3247', '121', 'How did you hear about us?', 'Radio ');
INSERT INTO wp_cformsdata VALUES('3248', '121', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3249', '121', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3250', '121', 'If yes, when did this occur?', 'May 2010');
INSERT INTO wp_cformsdata VALUES('3251', '121', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3252', '121', 'Date of most recent scan', '09/2010');
INSERT INTO wp_cformsdata VALUES('3253', '121', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3254', '121', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3255', '121', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3256', '121', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3257', '121', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3258', '121', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3259', '121', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3260', '121', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3261', '121', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3262', '121', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3263', '121', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3264', '121', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3265', '121', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3266', '121', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3267', '121', 'Comments, Questions', 'Sometimes I need a cane to walk, if I have to stand for long periods of time the pain becomes un bearable. I have had an EMG which showed a hernated disk with a pinched nerve, this causes pain in my buttock,legs running down into my feet. I am taking medication daily that is not helping.......Please help me.');
INSERT INTO wp_cformsdata VALUES('3268', '122', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3269', '122', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3270', '122', 'Name', 'LEA YARDUM');
INSERT INTO wp_cformsdata VALUES('3271', '122', 'City/State', 'STUDIO CITY, CA');
INSERT INTO wp_cformsdata VALUES('3272', '122', 'Phone', '323-956-2817');
INSERT INTO wp_cformsdata VALUES('3273', '122', 'Email', 'LEA.YARDUM@GMAIL.COM');
INSERT INTO wp_cformsdata VALUES('3274', '122', 'How did you hear about us?', 'INTERNET');
INSERT INTO wp_cformsdata VALUES('3275', '122', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3276', '122', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3277', '122', 'If yes, when did this occur?', 'MAY 2010');
INSERT INTO wp_cformsdata VALUES('3278', '122', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3279', '122', 'Date of most recent scan', 'JULY 2010');
INSERT INTO wp_cformsdata VALUES('3280', '122', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3281', '122', 'When did the pain begin?', 'MAY 2010');
INSERT INTO wp_cformsdata VALUES('3282', '122', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3283', '122', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3284', '122', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3285', '122', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3286', '122', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3287', '122', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3288', '122', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3289', '122', 'Date of onset of pain?', 'MAY 2010');
INSERT INTO wp_cformsdata VALUES('3290', '122', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3291', '122', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3292', '122', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3293', '122', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3294', '122', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3295', '123', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3296', '123', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3297', '123', 'Name', 'rachel');
INSERT INTO wp_cformsdata VALUES('3298', '123', 'City/State', 'corona california');
INSERT INTO wp_cformsdata VALUES('3299', '123', 'Phone', '951-285-0679');
INSERT INTO wp_cformsdata VALUES('3300', '123', 'Email', 'huesca.rachel@gmail.com');
INSERT INTO wp_cformsdata VALUES('3301', '123', 'How did you hear about us?', 'webmd');
INSERT INTO wp_cformsdata VALUES('3302', '123', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3303', '123', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3304', '123', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3305', '123', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3306', '123', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3307', '123', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3308', '123', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3309', '123', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3310', '123', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3311', '123', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3312', '123', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3313', '123', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('3314', '123', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3315', '123', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3316', '123', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3317', '123', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3318', '123', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3319', '123', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3320', '123', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3321', '123', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3322', '124', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3323', '124', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3324', '124', 'Name', 'Kimberly');
INSERT INTO wp_cformsdata VALUES('3325', '124', 'City/State', 'California');
INSERT INTO wp_cformsdata VALUES('3326', '124', 'Phone', '415-722-4661');
INSERT INTO wp_cformsdata VALUES('3327', '124', 'Email', 'oursprinkles@hotmail.com');
INSERT INTO wp_cformsdata VALUES('3328', '124', 'How did you hear about us?', 'Friend had rppreocedure done');
INSERT INTO wp_cformsdata VALUES('3329', '124', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3330', '124', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3331', '124', 'If yes, when did this occur?', '12/2009');
INSERT INTO wp_cformsdata VALUES('3332', '124', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3333', '124', 'Date of most recent scan', '3/17/2011');
INSERT INTO wp_cformsdata VALUES('3334', '124', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3335', '124', 'When did the pain begin?', '12/2009');
INSERT INTO wp_cformsdata VALUES('3336', '124', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3337', '124', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3338', '124', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3339', '124', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3340', '124', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('3341', '124', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3342', '124', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3343', '124', 'Date of onset of pain?', '12/2009');
INSERT INTO wp_cformsdata VALUES('3344', '124', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3345', '124', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3346', '124', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3347', '124', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('3348', '124', 'Comments, Questions', 'The pain is mid-lower back which radiates into bottox and down the back top of legs...both right and left side.');
INSERT INTO wp_cformsdata VALUES('3349', '125', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3350', '125', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3351', '125', 'Name', 'RICHARD JACOBS');
INSERT INTO wp_cformsdata VALUES('3352', '125', 'City/State', 'PRINCETON JUNCTION , NJ');
INSERT INTO wp_cformsdata VALUES('3353', '125', 'Phone', '609-799-7533');
INSERT INTO wp_cformsdata VALUES('3354', '125', 'Email', 'RICHMJACOBS@GMAIL.COM');
INSERT INTO wp_cformsdata VALUES('3355', '125', 'How did you hear about us?', 'WEB ');
INSERT INTO wp_cformsdata VALUES('3356', '125', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3357', '125', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3358', '125', 'If yes, when did this occur?', '2009');
INSERT INTO wp_cformsdata VALUES('3359', '125', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3360', '125', 'Date of most recent scan', 'MARCH 2011');
INSERT INTO wp_cformsdata VALUES('3361', '125', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3362', '125', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3363', '125', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3364', '125', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3365', '125', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3366', '125', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3367', '125', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('3368', '125', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3369', '125', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3370', '125', 'Date of onset of pain?', '2009');
INSERT INTO wp_cformsdata VALUES('3371', '125', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3372', '125', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3373', '125', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3374', '125', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('3375', '125', 'Comments, Questions', 'HAD SURGERY APRIL 2010 L3/L4  . EFFECTIVE FOR ABOUT 6 MONTHS , THEN SYMPTOMS AGAIN. ALSO HAD L5/S1 SURGERY IN 1998 AND STILL HAVE SOME RESIDUAL SYMPTOMS. PLEASE CONTACT ME 
\nTHANK YOU ');
INSERT INTO wp_cformsdata VALUES('3376', '126', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3377', '126', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3378', '126', 'Name', 'JUAN DIAZ');
INSERT INTO wp_cformsdata VALUES('3379', '126', 'City/State', 'HIGHLAND CA');
INSERT INTO wp_cformsdata VALUES('3380', '126', 'Phone', '909-425-5518');
INSERT INTO wp_cformsdata VALUES('3381', '126', 'Email', 'jbblje7538@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('3382', '126', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('3383', '126', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3384', '126', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('3385', '126', 'If yes, when did this occur?', '6-02-2006');
INSERT INTO wp_cformsdata VALUES('3386', '126', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3387', '126', 'Date of most recent scan', '11/09/2010');
INSERT INTO wp_cformsdata VALUES('3388', '126', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3389', '126', 'When did the pain begin?', 'getting worse on 3/6/2008');
INSERT INTO wp_cformsdata VALUES('3390', '126', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3391', '126', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3392', '126', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3393', '126', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3394', '126', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3395', '126', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3396', '126', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3397', '126', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3398', '126', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3399', '126', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3400', '126', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3401', '126', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3402', '126', 'Comments, Questions', 'DEAR Doctor..\nthis is too much stress because I have many years with this back pain and Sciatica pain for a long  time NOW the Sciatica pain is killing me so please I need help I have a Workers Compensation Open case.\n  I have received treatment by my Doctor Van H. Vu  epidurals,, a lot of Medicine, Accupunture, a Discogram, physical Therapy and sometimes I feel good but sometimes don\'t..he know that,,\nSo I want to know is this  Procedure  is a GOOD OPTION for me,  BECAUSE I DON\'T  WANT TO TAKE A SURGERY.that\'s the NEUTRAL  Dr. S. Sanford kornblum M.D.,Recommends and  I\'m  so afraid.. to Surgery\'s  \n\nThank you. ');
INSERT INTO wp_cformsdata VALUES('3403', '127', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3404', '127', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3405', '127', 'Name', 'Robert Kim');
INSERT INTO wp_cformsdata VALUES('3406', '127', 'City/State', 'Buena Park, CA');
INSERT INTO wp_cformsdata VALUES('3407', '127', 'Phone', '714-325-1396');
INSERT INTO wp_cformsdata VALUES('3408', '127', 'Email', 'robertjoonkim@gmail.com');
INSERT INTO wp_cformsdata VALUES('3409', '127', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('3410', '127', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3411', '127', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3412', '127', 'If yes, when did this occur?', '8/09');
INSERT INTO wp_cformsdata VALUES('3413', '127', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3414', '127', 'Date of most recent scan', '6/10');
INSERT INTO wp_cformsdata VALUES('3415', '127', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('3416', '127', 'When did the pain begin?', '8/09');
INSERT INTO wp_cformsdata VALUES('3417', '127', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3418', '127', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3419', '127', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3420', '127', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3421', '127', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('3422', '127', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3423', '127', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3424', '127', 'Date of onset of pain?', '8/09');
INSERT INTO wp_cformsdata VALUES('3425', '127', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3426', '127', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3427', '127', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3428', '127', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3429', '127', 'Comments, Questions', 'I visited the UCLA office once before.  My sciatica went away after months of therapy.  It has come back and has not shown any improvement since it reoccured a month ago.  I am looking for immediate relief.');
INSERT INTO wp_cformsdata VALUES('3430', '128', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3431', '128', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3432', '128', 'Name', 'sandra');
INSERT INTO wp_cformsdata VALUES('3433', '128', 'City/State', 'san diego ca. ');
INSERT INTO wp_cformsdata VALUES('3434', '128', 'Phone', '619 698-9257');
INSERT INTO wp_cformsdata VALUES('3435', '128', 'Email', 's.ponce1@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3436', '128', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('3437', '128', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3438', '128', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3439', '128', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3440', '128', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3441', '128', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3442', '128', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('3443', '128', 'When did the pain begin?', '4 days ago');
INSERT INTO wp_cformsdata VALUES('3444', '128', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3445', '128', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3446', '128', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3447', '128', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3448', '128', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('3449', '128', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('3450', '128', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('3451', '128', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3452', '128', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3453', '128', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3454', '128', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3455', '128', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3456', '128', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3457', '129', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3458', '129', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3459', '129', 'Name', 'Rudy Diotale');
INSERT INTO wp_cformsdata VALUES('3460', '129', 'City/State', 'Canton,Ohio');
INSERT INTO wp_cformsdata VALUES('3461', '129', 'Phone', '330-323-4409');
INSERT INTO wp_cformsdata VALUES('3462', '129', 'Email', 'pdq6616@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3463', '129', 'How did you hear about us?', 'found on internet myself');
INSERT INTO wp_cformsdata VALUES('3464', '129', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3465', '129', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3466', '129', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3467', '129', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3468', '129', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3469', '129', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('3470', '129', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3471', '129', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3472', '129', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3473', '129', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3474', '129', 'If no, number of hours in pain', '16');
INSERT INTO wp_cformsdata VALUES('3475', '129', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('3476', '129', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3477', '129', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3478', '129', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3479', '129', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('3480', '129', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3481', '129', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3482', '129', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3483', '129', 'Comments, Questions', 'X ray on spine says some Degenerative signs, which was told is normal for 42 years old and nothing out of the ordinary was found. was told mri was not necessary but still have sciatic pain every day since January of 2010.');
INSERT INTO wp_cformsdata VALUES('3484', '130', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3485', '130', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3486', '130', 'Name', 'Celeste Green');
INSERT INTO wp_cformsdata VALUES('3487', '130', 'City/State', 'Wilmington, CA');
INSERT INTO wp_cformsdata VALUES('3488', '130', 'Phone', '323-543-1151');
INSERT INTO wp_cformsdata VALUES('3489', '130', 'Email', 'Celeste.Green@hotmail.com');
INSERT INTO wp_cformsdata VALUES('3490', '130', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('3491', '130', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3492', '130', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3493', '130', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3494', '130', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3495', '130', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3496', '130', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('3497', '130', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3498', '130', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3499', '130', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3500', '130', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3501', '130', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3502', '130', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3503', '130', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3504', '130', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3505', '130', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3506', '130', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3507', '130', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('3508', '130', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3509', '130', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3510', '130', 'Comments, Questions', 'I have been diagnosed with spino stenosis, sciatica, and  other back pain related conditions.  I have tried spinal decompression, which has offered me temporary relief, but the pain always comes back.  I have also been told core training and weight loss would assist in my relief of pain, but pain limits my ability to be active.  I hope you can help me.');
INSERT INTO wp_cformsdata VALUES('3511', '131', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3512', '131', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3513', '131', 'Name', 'Alfredo Sepulveda');
INSERT INTO wp_cformsdata VALUES('3514', '131', 'City/State', 'Riverside, CA');
INSERT INTO wp_cformsdata VALUES('3515', '131', 'Phone', '9517845831');
INSERT INTO wp_cformsdata VALUES('3516', '131', 'Email', 'primofreddy@msn.com');
INSERT INTO wp_cformsdata VALUES('3517', '131', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('3518', '131', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3519', '131', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3520', '131', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3521', '131', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3522', '131', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3523', '131', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3524', '131', 'When did the pain begin?', '08/10');
INSERT INTO wp_cformsdata VALUES('3525', '131', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3526', '131', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3527', '131', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3528', '131', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3529', '131', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3530', '131', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3531', '131', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3532', '131', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3533', '131', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3534', '131', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3535', '131', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('3536', '131', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3537', '131', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3538', '132', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3539', '132', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3540', '132', 'Name', 'Elvira Rodriguez');
INSERT INTO wp_cformsdata VALUES('3541', '132', 'City/State', 'Fullerotn CA');
INSERT INTO wp_cformsdata VALUES('3542', '132', 'Phone', '562-567-1282');
INSERT INTO wp_cformsdata VALUES('3543', '132', 'Email', 'luya53@aol.com');
INSERT INTO wp_cformsdata VALUES('3544', '132', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('3545', '132', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3546', '132', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3547', '132', 'If yes, when did this occur?', '?');
INSERT INTO wp_cformsdata VALUES('3548', '132', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3549', '132', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3550', '132', 'Is there pain in:', 'Back,Arm');
INSERT INTO wp_cformsdata VALUES('3551', '132', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('3552', '132', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3553', '132', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3554', '132', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3555', '132', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3556', '132', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,arms,hands');
INSERT INTO wp_cformsdata VALUES('3557', '132', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3558', '132', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3559', '132', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3560', '132', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3561', '132', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3562', '132', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3563', '132', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3564', '132', 'Comments, Questions', 'I believe one problem is Siatica specially my right side, I\'ve had a recurring problem with a neck pinch nerve numbness/cramping and pain goes to my right arm to fingers. I was told I have degenerative disc below my neck area and lower back.');
INSERT INTO wp_cformsdata VALUES('3565', '133', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3566', '133', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3567', '133', 'Name', 'scott francis');
INSERT INTO wp_cformsdata VALUES('3568', '133', 'City/State', 'los angeles, CA');
INSERT INTO wp_cformsdata VALUES('3569', '133', 'Phone', '323 665-7319');
INSERT INTO wp_cformsdata VALUES('3570', '133', 'Email', 'swfreply@yahoo.com');
INSERT INTO wp_cformsdata VALUES('3571', '133', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('3572', '133', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3573', '133', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3574', '133', 'If yes, when did this occur?', '1981');
INSERT INTO wp_cformsdata VALUES('3575', '133', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3576', '133', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3577', '133', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('3578', '133', 'When did the pain begin?', '1981');
INSERT INTO wp_cformsdata VALUES('3579', '133', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3580', '133', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('3581', '133', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3582', '133', 'If no, number of hours in pain', '2  will leave when lying or sitting down with good posture');
INSERT INTO wp_cformsdata VALUES('3583', '133', 'Is there pain, tingling, numbness, or weakness in your:', 'feet');
INSERT INTO wp_cformsdata VALUES('3584', '133', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3585', '133', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3586', '133', 'Date of onset of pain?', '1981');
INSERT INTO wp_cformsdata VALUES('3587', '133', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('3588', '133', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('3589', '133', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3590', '133', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3591', '133', 'Comments, Questions', 'Is the tnf relief permanent?  Is there a change in senses in the area?  Numb?  Any disadvantages?  Do you treat ankles?  Old ankle fracture caused poor gait leading to back pain.');
INSERT INTO wp_cformsdata VALUES('3592', '134', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3593', '134', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3594', '134', 'Name', 'rocco passarella');
INSERT INTO wp_cformsdata VALUES('3595', '134', 'City/State', 'valencia');
INSERT INTO wp_cformsdata VALUES('3596', '134', 'Phone', '805-509-1860');
INSERT INTO wp_cformsdata VALUES('3597', '134', 'Email', 'kilo411@ca.rr.com');
INSERT INTO wp_cformsdata VALUES('3598', '134', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('3599', '134', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3600', '134', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3601', '134', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3602', '134', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3603', '134', 'Date of most recent scan', '2 years');
INSERT INTO wp_cformsdata VALUES('3604', '134', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('3605', '134', 'When did the pain begin?', '17 years');
INSERT INTO wp_cformsdata VALUES('3606', '134', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3607', '134', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3608', '134', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3609', '134', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3610', '134', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('3611', '134', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3612', '134', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3613', '134', 'Date of onset of pain?', '2 years');
INSERT INTO wp_cformsdata VALUES('3614', '134', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3615', '134', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3616', '134', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3617', '134', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3618', '134', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3619', '135', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3620', '135', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3621', '135', 'Name', 'Robert Buscher');
INSERT INTO wp_cformsdata VALUES('3622', '135', 'City/State', 'Michigan City, Indiana');
INSERT INTO wp_cformsdata VALUES('3623', '135', 'Phone', '2198719798');
INSERT INTO wp_cformsdata VALUES('3624', '135', 'Email', 'rbuscher@comcast.net');
INSERT INTO wp_cformsdata VALUES('3625', '135', 'How did you hear about us?', 'friend');
INSERT INTO wp_cformsdata VALUES('3626', '135', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3627', '135', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3628', '135', 'If yes, when did this occur?', '1 1/2 year ago');
INSERT INTO wp_cformsdata VALUES('3629', '135', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3630', '135', 'Date of most recent scan', '1 1/2 year ago');
INSERT INTO wp_cformsdata VALUES('3631', '135', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('3632', '135', 'When did the pain begin?', 'started 15 years ago');
INSERT INTO wp_cformsdata VALUES('3633', '135', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3634', '135', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3635', '135', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3636', '135', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3637', '135', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('3638', '135', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3639', '135', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3640', '135', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3641', '135', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3642', '135', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3643', '135', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3644', '135', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3645', '135', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3646', '136', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3647', '136', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3648', '136', 'Name', 'GEORGE O. RAMOS');
INSERT INTO wp_cformsdata VALUES('3649', '136', 'City/State', 'FONTANA, CA');
INSERT INTO wp_cformsdata VALUES('3650', '136', 'Phone', '909-829-9106');
INSERT INTO wp_cformsdata VALUES('3651', '136', 'Email', 'GR9865@AOL.COM');
INSERT INTO wp_cformsdata VALUES('3652', '136', 'How did you hear about us?', 'RADIO ');
INSERT INTO wp_cformsdata VALUES('3653', '136', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3654', '136', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3655', '136', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3656', '136', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3657', '136', 'Date of most recent scan', 'OCTOBER 2010');
INSERT INTO wp_cformsdata VALUES('3658', '136', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('3659', '136', 'When did the pain begin?', '2008');
INSERT INTO wp_cformsdata VALUES('3660', '136', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3661', '136', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3662', '136', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3663', '136', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3664', '136', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('3665', '136', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3666', '136', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3667', '136', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3668', '136', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3669', '136', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3670', '136', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3671', '136', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3672', '136', 'Comments, Questions', 'I HAVE HAD MY LEFT KNEE REPLACED, MY RIGHT KNEE NEEDS TO BE REPLACED, I\'VE HAD TOE SURGERY, BACK SURGERY HAS BEEN RECOMMENDED BECAUSE OF BAD 3rd,4th, & 5th VERTEBREA; RUBBING BONE TO BONE');
INSERT INTO wp_cformsdata VALUES('3673', '137', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3674', '137', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3675', '137', 'Name', 'ANGELICA R. RAMOS');
INSERT INTO wp_cformsdata VALUES('3676', '137', 'City/State', 'FONTANA, CA');
INSERT INTO wp_cformsdata VALUES('3677', '137', 'Phone', '909-829-9106');
INSERT INTO wp_cformsdata VALUES('3678', '137', 'Email', 'GR9865@AOL.COM');
INSERT INTO wp_cformsdata VALUES('3679', '137', 'How did you hear about us?', 'RADIO');
INSERT INTO wp_cformsdata VALUES('3680', '137', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3681', '137', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3682', '137', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3683', '137', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3684', '137', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3685', '137', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3686', '137', 'When did the pain begin?', 'DECEMBER 2009');
INSERT INTO wp_cformsdata VALUES('3687', '137', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('3688', '137', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3689', '137', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('3690', '137', 'If no, number of hours in pain', 'VARIES');
INSERT INTO wp_cformsdata VALUES('3691', '137', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('3692', '137', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3693', '137', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3694', '137', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3695', '137', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('3696', '137', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3697', '137', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3698', '137', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3699', '137', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3700', '138', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3701', '138', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3702', '138', 'Name', 'Priti Sadhir');
INSERT INTO wp_cformsdata VALUES('3703', '138', 'City/State', 'Londonderry, NH');
INSERT INTO wp_cformsdata VALUES('3704', '138', 'Phone', '6034374771');
INSERT INTO wp_cformsdata VALUES('3705', '138', 'Email', 'psadhir@comcast.net');
INSERT INTO wp_cformsdata VALUES('3706', '138', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('3707', '138', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3708', '138', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3709', '138', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3710', '138', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3711', '138', 'Date of most recent scan', 'August 2010');
INSERT INTO wp_cformsdata VALUES('3712', '138', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3713', '138', 'When did the pain begin?', 'August 2010');
INSERT INTO wp_cformsdata VALUES('3714', '138', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3715', '138', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3716', '138', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3717', '138', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3718', '138', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('3719', '138', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3720', '138', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3721', '138', 'Date of onset of pain?', 'June 2005');
INSERT INTO wp_cformsdata VALUES('3722', '138', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3723', '138', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('3724', '138', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3725', '138', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3726', '138', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3727', '139', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3728', '139', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3729', '139', 'Name', 'SANDRA GOJON DE AGUILAR');
INSERT INTO wp_cformsdata VALUES('3730', '139', 'City/State', 'MEXICO CITY');
INSERT INTO wp_cformsdata VALUES('3731', '139', 'Phone', '011 (52) 55 36 23 67 33');
INSERT INTO wp_cformsdata VALUES('3732', '139', 'Email', 'sg_danzco@yahoo.com.mx');
INSERT INTO wp_cformsdata VALUES('3733', '139', 'How did you hear about us?', 'found it in you tube');
INSERT INTO wp_cformsdata VALUES('3734', '139', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3735', '139', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3736', '139', 'If yes, when did this occur?', 'NOT SURE ... ');
INSERT INTO wp_cformsdata VALUES('3737', '139', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3738', '139', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3739', '139', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('3740', '139', 'When did the pain begin?', '3 MONTHS AGO');
INSERT INTO wp_cformsdata VALUES('3741', '139', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3742', '139', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3743', '139', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3744', '139', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3745', '139', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('3746', '139', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3747', '139', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3748', '139', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3749', '139', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3750', '139', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3751', '139', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3752', '139', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3753', '139', 'Comments, Questions', 'I called 2 days ago and the lady that answer told me that you called back that same afternoon ... still watting!!!\nPlease , I am in terrible pain.\n\nBy mistake I left the wrong phone number on your ansewering machine.\n\nAn other number I can be reach is ; 011 (52) 55 56 16 70 88 ');
INSERT INTO wp_cformsdata VALUES('3754', '140', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3755', '140', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3756', '140', 'Name', 'Ramesh');
INSERT INTO wp_cformsdata VALUES('3757', '140', 'City/State', 'Stuart Florida');
INSERT INTO wp_cformsdata VALUES('3758', '140', 'Phone', '561-214-5757');
INSERT INTO wp_cformsdata VALUES('3759', '140', 'Email', 'rayabi@comcast.net');
INSERT INTO wp_cformsdata VALUES('3760', '140', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('3761', '140', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3762', '140', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3763', '140', 'If yes, when did this occur?', 'Three months ago: Have spinal Stenosis');
INSERT INTO wp_cformsdata VALUES('3764', '140', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3765', '140', 'Date of most recent scan', 'three months ago');
INSERT INTO wp_cformsdata VALUES('3766', '140', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3767', '140', 'When did the pain begin?', 'three months ago');
INSERT INTO wp_cformsdata VALUES('3768', '140', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3769', '140', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('3770', '140', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3771', '140', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3772', '140', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('3773', '140', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3774', '140', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3775', '140', 'Date of onset of pain?', 'February 2011');
INSERT INTO wp_cformsdata VALUES('3776', '140', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('3777', '140', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3778', '140', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3779', '140', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3780', '140', 'Comments, Questions', 'I have pain when I get up. I have pain when I walk. Very little pain during sitting but the pain resumes when I getup and walk. When I do excercises the pain is substantially reduced when I stand up and walk, However, the pain resumes if i sit down and getup again.');
INSERT INTO wp_cformsdata VALUES('3781', '141', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('3782', '141', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3783', '141', 'Name', 'Carmen Sill');
INSERT INTO wp_cformsdata VALUES('3784', '141', 'City/State', 'Ventura , CA');
INSERT INTO wp_cformsdata VALUES('3785', '141', 'Phone', '805-797-6172');
INSERT INTO wp_cformsdata VALUES('3786', '141', 'Email', 'Carm64@gmail.com');
INSERT INTO wp_cformsdata VALUES('3787', '141', 'How did you hear about us?', 'Website');
INSERT INTO wp_cformsdata VALUES('3788', '141', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3789', '141', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('3790', '141', 'If yes, when did this occur?', '10/2009');
INSERT INTO wp_cformsdata VALUES('3791', '141', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3792', '141', 'Date of most recent scan', '2/24/2011');
INSERT INTO wp_cformsdata VALUES('3793', '141', 'Is there pain in:', 'Back,Neck,Arm');
INSERT INTO wp_cformsdata VALUES('3794', '141', 'When did the pain begin?', '10/2009');
INSERT INTO wp_cformsdata VALUES('3795', '141', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3796', '141', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3797', '141', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3798', '141', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3799', '141', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('3800', '141', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3801', '141', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3802', '141', 'Date of onset of pain?', '5/2001');
INSERT INTO wp_cformsdata VALUES('3803', '141', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3804', '141', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3805', '141', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('3806', '141', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('3807', '141', 'Comments, Questions', 'Are you accepting new patients? Please reply the patient doesn\'t want another surgery.There has been surgery at C-5,6 and now 10 years later there are C-3,4,7,above and below original fusion. Last two years there has been physical therapy and drug therapy;narcotics and NSAIDS which are now effecting the GI system and provides no relief. The patient has not worked in two years and is only 47. Please help the pain is constant and relentless. Neck, clavicle, shoulders, arms between shoulder blades, elbow, wrists and fingers especially the left side but also involving the right side.  Please contact me.  Thank you ');
INSERT INTO wp_cformsdata VALUES('3808', '142', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3809', '142', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3810', '142', 'Name', 'Deby Zimmerman');
INSERT INTO wp_cformsdata VALUES('3811', '142', 'City/State', 'Boone, Colorado');
INSERT INTO wp_cformsdata VALUES('3812', '142', 'Phone', '719-947-4160');
INSERT INTO wp_cformsdata VALUES('3813', '142', 'Email', 'debyz719@aol.com');
INSERT INTO wp_cformsdata VALUES('3814', '142', 'How did you hear about us?', 'surfing the web for help with sciatic cronic pain');
INSERT INTO wp_cformsdata VALUES('3815', '142', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3816', '142', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3817', '142', 'If yes, when did this occur?', '2002 for the accident that started this.');
INSERT INTO wp_cformsdata VALUES('3818', '142', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3819', '142', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3820', '142', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3821', '142', 'When did the pain begin?', '2002 after being side-swiped in an accident');
INSERT INTO wp_cformsdata VALUES('3822', '142', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3823', '142', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3824', '142', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3825', '142', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3826', '142', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('3827', '142', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3828', '142', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3829', '142', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3830', '142', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3831', '142', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3832', '142', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3833', '142', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3834', '142', 'Comments, Questions', 'TOTALLY unable to walk without either a walker or my two canes and sleeping in a bed is not possible as laying down on either side does not allow any form of rest after no more than 20 min.  Sitting is difficult for long  periods because I  become too stif to walk for a bit....Standing and walking any distance is out of the question because of the intense  pain and inability to move my right leg much.  If alot of walking is done the pain in the evening becomes so intense that I can\'t stop the muscles in my upper thigh from remaining tense and knotted up and the sciatica is constantly throbbing.  Heating pads have brought minimal relief but the stiffness from them is extremely intense and hard to walk out later on.  This is denying me any form of quality of life and at this point where the accident I was in that caused this happened in \'02 and each year has seen things only deteriorating to unable to function in any small semblence near normal....I would rather trade this for cancer...at least they HELP cure that ....and insurances won\'t deny you help.  I really wish that there were financial help for this like there is for OCD.... ');
INSERT INTO wp_cformsdata VALUES('3835', '143', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3836', '143', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3837', '143', 'Name', 'Sara M. Vega-Evans');
INSERT INTO wp_cformsdata VALUES('3838', '143', 'City/State', 'Grandview, WA.');
INSERT INTO wp_cformsdata VALUES('3839', '143', 'Phone', '(509) 882-1158');
INSERT INTO wp_cformsdata VALUES('3840', '143', 'Email', 'peltsaraevans@embarqmail.com');
INSERT INTO wp_cformsdata VALUES('3841', '143', 'How did you hear about us?', 'Internet website');
INSERT INTO wp_cformsdata VALUES('3842', '143', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3843', '143', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3844', '143', 'If yes, when did this occur?', '8/2010');
INSERT INTO wp_cformsdata VALUES('3845', '143', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3846', '143', 'Date of most recent scan', '9/2010');
INSERT INTO wp_cformsdata VALUES('3847', '143', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3848', '143', 'When did the pain begin?', '10/2005');
INSERT INTO wp_cformsdata VALUES('3849', '143', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3850', '143', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3851', '143', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3852', '143', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3853', '143', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3854', '143', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3855', '143', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3856', '143', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3857', '143', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3858', '143', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3859', '143', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3860', '143', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3861', '143', 'Comments, Questions', 'How long does treatment lasts in patients who under go the procedure and is there an adverse reaction from the pharmacuetical used in this precedure.');
INSERT INTO wp_cformsdata VALUES('3862', '144', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3863', '144', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3864', '144', 'Name', 'Nazir');
INSERT INTO wp_cformsdata VALUES('3865', '144', 'City/State', 'London');
INSERT INTO wp_cformsdata VALUES('3866', '144', 'Phone', '+447590977296');
INSERT INTO wp_cformsdata VALUES('3867', '144', 'Email', 'harpal@fromru.com');
INSERT INTO wp_cformsdata VALUES('3868', '144', 'How did you hear about us?', 'www.youtube.com');
INSERT INTO wp_cformsdata VALUES('3869', '144', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3870', '144', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease,Annular tear');
INSERT INTO wp_cformsdata VALUES('3871', '144', 'If yes, when did this occur?', '1.5 years ago');
INSERT INTO wp_cformsdata VALUES('3872', '144', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3873', '144', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3874', '144', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3875', '144', 'When did the pain begin?', '1.5 years ago');
INSERT INTO wp_cformsdata VALUES('3876', '144', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3877', '144', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3878', '144', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3879', '144', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3880', '144', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('3881', '144', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3882', '144', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3883', '144', 'Date of onset of pain?', '01/02/11');
INSERT INTO wp_cformsdata VALUES('3884', '144', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3885', '144', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3886', '144', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3887', '144', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3888', '144', 'Comments, Questions', 'I watched your videos from youtube.com and liked it. I have been in 2 experts in london they both did massage in my back and in disk but didn\'t help now I\'m depressed and don\'t know what to do, I have got my wife and daughter and I\'m due to loose my job because of back pain. I would appreciate if you could help me. Now I\'m lining because of pain :(( ');
INSERT INTO wp_cformsdata VALUES('3889', '145', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3890', '145', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3891', '145', 'Name', 'CJ Harris');
INSERT INTO wp_cformsdata VALUES('3892', '145', 'City/State', 'Canyon Country  CA 91387');
INSERT INTO wp_cformsdata VALUES('3893', '145', 'Phone', '661 252 0968');
INSERT INTO wp_cformsdata VALUES('3894', '145', 'Email', 'Cindy@cjhcpa.com');
INSERT INTO wp_cformsdata VALUES('3895', '145', 'How did you hear about us?', 'Online Research ');
INSERT INTO wp_cformsdata VALUES('3896', '145', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3897', '145', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3898', '145', 'If yes, when did this occur?', 'Car Hit me Walking Age 13-Present');
INSERT INTO wp_cformsdata VALUES('3899', '145', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3900', '145', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3901', '145', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('3902', '145', 'When did the pain begin?', 'Age of 13');
INSERT INTO wp_cformsdata VALUES('3903', '145', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3904', '145', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3905', '145', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3906', '145', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3907', '145', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('3908', '145', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3909', '145', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3910', '145', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3911', '145', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3912', '145', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3913', '145', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3914', '145', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3915', '145', 'Comments, Questions', 'Difficulty walking for a period of time.Increases pain in hips, legs and back pain. So, increased exercise or increased activity generally increases the pain, not only that day but possibly for the next week in overall weakness, hard time thinking correctly, increased sustained pain level, ');
INSERT INTO wp_cformsdata VALUES('3916', '146', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3917', '146', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3918', '146', 'Name', 'Richard Long');
INSERT INTO wp_cformsdata VALUES('3919', '146', 'City/State', 'Stockton, CA');
INSERT INTO wp_cformsdata VALUES('3920', '146', 'Phone', '209-609-1491');
INSERT INTO wp_cformsdata VALUES('3921', '146', 'Email', 'ardensay@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('3922', '146', 'How did you hear about us?', 'Online');
INSERT INTO wp_cformsdata VALUES('3923', '146', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3924', '146', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('3925', '146', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3926', '146', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3927', '146', 'Date of most recent scan', '5/9/2011');
INSERT INTO wp_cformsdata VALUES('3928', '146', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3929', '146', 'When did the pain begin?', '4/1/2011');
INSERT INTO wp_cformsdata VALUES('3930', '146', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3931', '146', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3932', '146', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3933', '146', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3934', '146', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3935', '146', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3936', '146', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3937', '146', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3938', '146', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('3939', '146', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3940', '146', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3941', '146', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3942', '146', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3943', '147', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3944', '147', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3945', '147', 'Name', 'Emily Heagey');
INSERT INTO wp_cformsdata VALUES('3946', '147', 'City/State', 'Santa Clarita, CA');
INSERT INTO wp_cformsdata VALUES('3947', '147', 'Phone', '661-645-9500');
INSERT INTO wp_cformsdata VALUES('3948', '147', 'Email', 'ejf6869@earthlink.net');
INSERT INTO wp_cformsdata VALUES('3949', '147', 'How did you hear about us?', 'KFI640');
INSERT INTO wp_cformsdata VALUES('3950', '147', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3951', '147', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('3952', '147', 'If yes, when did this occur?', 'last 10 years');
INSERT INTO wp_cformsdata VALUES('3953', '147', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3954', '147', 'Date of most recent scan', '6-7 years ago');
INSERT INTO wp_cformsdata VALUES('3955', '147', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('3956', '147', 'When did the pain begin?', 'last 10 years');
INSERT INTO wp_cformsdata VALUES('3957', '147', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3958', '147', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3959', '147', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3960', '147', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3961', '147', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3962', '147', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3963', '147', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('3964', '147', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3965', '147', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3966', '147', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3967', '147', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3968', '147', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3969', '147', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('3970', '148', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3971', '148', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3972', '148', 'Name', 'Joe ');
INSERT INTO wp_cformsdata VALUES('3973', '148', 'City/State', 'Desert Hot Springs, California');
INSERT INTO wp_cformsdata VALUES('3974', '148', 'Phone', '310-864-4052');
INSERT INTO wp_cformsdata VALUES('3975', '148', 'Email', 'crystalklug@hotmail.com');
INSERT INTO wp_cformsdata VALUES('3976', '148', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('3977', '148', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('3978', '148', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('3979', '148', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('3980', '148', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('3981', '148', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('3982', '148', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('3983', '148', 'When did the pain begin?', '3/17/2011');
INSERT INTO wp_cformsdata VALUES('3984', '148', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3985', '148', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('3986', '148', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3987', '148', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('3988', '148', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('3989', '148', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('3990', '148', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3991', '148', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('3992', '148', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3993', '148', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3994', '148', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3995', '148', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('3996', '148', 'Comments, Questions', 'diagnosed with DVT 3/2011 Vasular surgeons cannot understand why leg is so swollen and why there is pain, from lower back down leg...\non coumadin a blood thinner');
INSERT INTO wp_cformsdata VALUES('3997', '149', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('3998', '149', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('3999', '149', 'Name', 'simon hurtado');
INSERT INTO wp_cformsdata VALUES('4000', '149', 'City/State', 'salinas ca ');
INSERT INTO wp_cformsdata VALUES('4001', '149', 'Phone', '8316820980');
INSERT INTO wp_cformsdata VALUES('4002', '149', 'Email', 'hurtado.simon75@gmail.com');
INSERT INTO wp_cformsdata VALUES('4003', '149', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('4004', '149', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4005', '149', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4006', '149', 'If yes, when did this occur?', 'a year ago');
INSERT INTO wp_cformsdata VALUES('4007', '149', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4008', '149', 'Date of most recent scan', '6 months ago');
INSERT INTO wp_cformsdata VALUES('4009', '149', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4010', '149', 'When did the pain begin?', 'a year ago');
INSERT INTO wp_cformsdata VALUES('4011', '149', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4012', '149', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4013', '149', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4014', '149', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4015', '149', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,hands,fingers');
INSERT INTO wp_cformsdata VALUES('4016', '149', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4017', '149', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4018', '149', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4019', '149', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4020', '149', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4021', '149', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4022', '149', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4023', '149', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4024', '150', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4025', '150', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4026', '150', 'Name', 'carlos');
INSERT INTO wp_cformsdata VALUES('4027', '150', 'City/State', 'glendale, az');
INSERT INTO wp_cformsdata VALUES('4028', '150', 'Phone', '6024652824');
INSERT INTO wp_cformsdata VALUES('4029', '150', 'Email', 'toro031982@hotmail.com');
INSERT INTO wp_cformsdata VALUES('4030', '150', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('4031', '150', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4032', '150', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4033', '150', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4034', '150', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('4035', '150', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4036', '150', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4037', '150', 'When did the pain begin?', 'like 3 years ago');
INSERT INTO wp_cformsdata VALUES('4038', '150', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4039', '150', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4040', '150', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4041', '150', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4042', '150', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('4043', '150', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4044', '150', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4045', '150', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4046', '150', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4047', '150', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4048', '150', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4049', '150', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4050', '150', 'Comments, Questions', 'please answer me!! i feel more pain when my body cold down. when i\'m sitting i don\'t feel any pain, the pain comes if i try to get up or move!!\n');
INSERT INTO wp_cformsdata VALUES('4051', '151', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4052', '151', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4053', '151', 'Name', 'Rosa Tellechea');
INSERT INTO wp_cformsdata VALUES('4054', '151', 'City/State', 'Los angeles, california');
INSERT INTO wp_cformsdata VALUES('4055', '151', 'Phone', '2133833587');
INSERT INTO wp_cformsdata VALUES('4056', '151', 'Email', 'Rst3099@gmail.com');
INSERT INTO wp_cformsdata VALUES('4057', '151', 'How did you hear about us?', 'Searching');
INSERT INTO wp_cformsdata VALUES('4058', '151', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4059', '151', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('4060', '151', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4061', '151', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4062', '151', 'Date of most recent scan', 'Month ago');
INSERT INTO wp_cformsdata VALUES('4063', '151', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('4064', '151', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('4065', '151', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('4066', '151', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4067', '151', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4068', '151', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4069', '151', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('4070', '151', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4071', '151', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4072', '151', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4073', '151', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('4074', '151', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4075', '151', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('4076', '151', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4077', '151', 'Comments, Questions', 'Is there any cure for dried discs and herniated out of place and arthritis in discs \nThis is for my mom, she\'s suffered from sciatica fir some years now and can\'t sit for long period of time.?');
INSERT INTO wp_cformsdata VALUES('4078', '152', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4079', '152', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4080', '152', 'Name', 'Caryl Reback');
INSERT INTO wp_cformsdata VALUES('4081', '152', 'City/State', 'Woodland Hills, CA');
INSERT INTO wp_cformsdata VALUES('4082', '152', 'Phone', '8188835884');
INSERT INTO wp_cformsdata VALUES('4083', '152', 'Email', 'Creback@aol.com');
INSERT INTO wp_cformsdata VALUES('4084', '152', 'How did you hear about us?', 'radio comercial');
INSERT INTO wp_cformsdata VALUES('4085', '152', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4086', '152', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4087', '152', 'If yes, when did this occur?', '2007');
INSERT INTO wp_cformsdata VALUES('4088', '152', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4089', '152', 'Date of most recent scan', 'december 2008');
INSERT INTO wp_cformsdata VALUES('4090', '152', 'Is there pain in:', 'Back,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('4091', '152', 'When did the pain begin?', '2008');
INSERT INTO wp_cformsdata VALUES('4092', '152', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4093', '152', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4094', '152', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4095', '152', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4096', '152', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,arms');
INSERT INTO wp_cformsdata VALUES('4097', '152', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4098', '152', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4099', '152', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4100', '152', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4101', '152', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4102', '152', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4103', '152', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4104', '152', 'Comments, Questions', 'I started out suffering from debilitating lower back pain. An MRI of the lower back showed that I had Degen. Disc problems. For 2 years I went in for the epidural to help with the pain.  in 2008 I had a 3 level Cervical Fusion (ACDF) to help put an end to the terrible left arm pain. The throbbing never completed stopped. Today I have terrible lower back pain--excruciatingly painful throbbing down the left leg, and if that wasnt enough...the pain is slowly coming back to my left arm.  I need HELP');
INSERT INTO wp_cformsdata VALUES('4105', '153', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4106', '153', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4107', '153', 'Name', 'Andrea Figueroa');
INSERT INTO wp_cformsdata VALUES('4108', '153', 'City/State', 'Simi Valley Ca');
INSERT INTO wp_cformsdata VALUES('4109', '153', 'Phone', '805-202-9693');
INSERT INTO wp_cformsdata VALUES('4110', '153', 'Email', 'andrea.s.figueroa@live.com');
INSERT INTO wp_cformsdata VALUES('4111', '153', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('4112', '153', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4113', '153', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4114', '153', 'If yes, when did this occur?', '5-2008');
INSERT INTO wp_cformsdata VALUES('4115', '153', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4116', '153', 'Date of most recent scan', '4-2011');
INSERT INTO wp_cformsdata VALUES('4117', '153', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('4118', '153', 'When did the pain begin?', '5-2008');
INSERT INTO wp_cformsdata VALUES('4119', '153', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4120', '153', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4121', '153', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4122', '153', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4123', '153', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('4124', '153', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4125', '153', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4126', '153', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4127', '153', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4128', '153', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4129', '153', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4130', '153', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4131', '153', 'Comments, Questions', 'sometimes while walking my balance becomes unsteady and the feeling of \"being pushed over\" occurs especially when showering and shampooing and rinsing hair with hands above head and running fingers through hair. Also, even though I have been in bed most of the day the bottom of my feet will ache as if I had been walking briskly for hours. I also have severe pain in my tailbone area and it will hurt like I had been riding a horse (I have not rode a horse for at least 30years)! I want to have my life back, get off the pain meds and stay out of bed during waking hours! Thank you');
INSERT INTO wp_cformsdata VALUES('4132', '154', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4133', '154', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4134', '154', 'Name', 'CHARLES MORGAN');
INSERT INTO wp_cformsdata VALUES('4135', '154', 'City/State', 'FONTANA CALIFORNIA ');
INSERT INTO wp_cformsdata VALUES('4136', '154', 'Phone', '323  302 2076');
INSERT INTO wp_cformsdata VALUES('4137', '154', 'Email', 'CHUCKY11660@HOTMAIL.COM');
INSERT INTO wp_cformsdata VALUES('4138', '154', 'How did you hear about us?', 'INTERNET');
INSERT INTO wp_cformsdata VALUES('4139', '154', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4140', '154', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4141', '154', 'If yes, when did this occur?', '9/2010');
INSERT INTO wp_cformsdata VALUES('4142', '154', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4143', '154', 'Date of most recent scan', 'LAST 45.DAYS ');
INSERT INTO wp_cformsdata VALUES('4144', '154', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('4145', '154', 'When did the pain begin?', '9/2010');
INSERT INTO wp_cformsdata VALUES('4146', '154', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('4147', '154', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4148', '154', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4149', '154', 'If no, number of hours in pain', 'MORNING 7 NIGHT ');
INSERT INTO wp_cformsdata VALUES('4150', '154', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands');
INSERT INTO wp_cformsdata VALUES('4151', '154', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4152', '154', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4153', '154', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4154', '154', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4155', '154', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4156', '154', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4157', '154', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4158', '154', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4159', '155', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4160', '155', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4161', '155', 'Name', 'Amanda Domantay');
INSERT INTO wp_cformsdata VALUES('4162', '155', 'City/State', 'Vallejo, California');
INSERT INTO wp_cformsdata VALUES('4163', '155', 'Phone', '(707)696-3100');
INSERT INTO wp_cformsdata VALUES('4164', '155', 'Email', 'ardomantay@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4165', '155', 'How did you hear about us?', 'Family Member');
INSERT INTO wp_cformsdata VALUES('4166', '155', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4167', '155', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4168', '155', 'If yes, when did this occur?', 'May 18, 2010');
INSERT INTO wp_cformsdata VALUES('4169', '155', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4170', '155', 'Date of most recent scan', 'December 2010');
INSERT INTO wp_cformsdata VALUES('4171', '155', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4172', '155', 'When did the pain begin?', 'May 18, 2010');
INSERT INTO wp_cformsdata VALUES('4173', '155', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4174', '155', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4175', '155', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4176', '155', 'If no, number of hours in pain', 'When i\'m standing or walking');
INSERT INTO wp_cformsdata VALUES('4177', '155', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4178', '155', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4179', '155', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4180', '155', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4181', '155', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4182', '155', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4183', '155', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4184', '155', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4185', '155', 'Comments, Questions', 'How much would this cost? And do i need to have health insurance to get this procedure done?');
INSERT INTO wp_cformsdata VALUES('4186', '156', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4187', '156', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4188', '156', 'Name', 'Gilbert Padilla ');
INSERT INTO wp_cformsdata VALUES('4189', '156', 'City/State', 'Chino Hills, CA');
INSERT INTO wp_cformsdata VALUES('4190', '156', 'Phone', '6262906904');
INSERT INTO wp_cformsdata VALUES('4191', '156', 'Email', 'Jenpadilla@hotmail.com');
INSERT INTO wp_cformsdata VALUES('4192', '156', 'How did you hear about us?', 'Im a UCLA employee');
INSERT INTO wp_cformsdata VALUES('4193', '156', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4194', '156', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4195', '156', 'If yes, when did this occur?', '06/09');
INSERT INTO wp_cformsdata VALUES('4196', '156', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4197', '156', 'Date of most recent scan', '5/10');
INSERT INTO wp_cformsdata VALUES('4198', '156', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('4199', '156', 'When did the pain begin?', '04/09');
INSERT INTO wp_cformsdata VALUES('4200', '156', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4201', '156', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4202', '156', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4203', '156', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4204', '156', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('4205', '156', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4206', '156', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4207', '156', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4208', '156', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4209', '156', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4210', '156', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4211', '156', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4212', '156', 'Comments, Questions', 'I was injured at work, and have had steroid injections for the pain, I do a lot of physical activity, and pain happens all the time');
INSERT INTO wp_cformsdata VALUES('4213', '157', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4214', '157', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4215', '157', 'Name', 'dan khani');
INSERT INTO wp_cformsdata VALUES('4216', '157', 'City/State', 'los angeles ca');
INSERT INTO wp_cformsdata VALUES('4217', '157', 'Phone', '310 8297503');
INSERT INTO wp_cformsdata VALUES('4218', '157', 'Email', 'dankhani@hotmail.com');
INSERT INTO wp_cformsdata VALUES('4219', '157', 'How did you hear about us?', 'journal of neurology');
INSERT INTO wp_cformsdata VALUES('4220', '157', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4221', '157', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4222', '157', 'If yes, when did this occur?', '3-5 years');
INSERT INTO wp_cformsdata VALUES('4223', '157', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4224', '157', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('4225', '157', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('4226', '157', 'When did the pain begin?', 'three years ago and recurrent after epidural ');
INSERT INTO wp_cformsdata VALUES('4227', '157', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4228', '157', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4229', '157', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4230', '157', 'If no, number of hours in pain', 'when walking or standing');
INSERT INTO wp_cformsdata VALUES('4231', '157', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('4232', '157', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4233', '157', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4234', '157', 'Date of onset of pain?', 'micro discectomy recurrent pain one year after');
INSERT INTO wp_cformsdata VALUES('4235', '157', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4236', '157', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4237', '157', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4238', '157', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4239', '157', 'Comments, Questions', 'have been strugling with back pain many  years, compression fracture superior plate L4 , protruding 4 mm disc @ L4-5 on right side.');
INSERT INTO wp_cformsdata VALUES('4240', '158', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4241', '158', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4242', '158', 'Name', 'Tanade Muse');
INSERT INTO wp_cformsdata VALUES('4243', '158', 'City/State', 'Portland,ME');
INSERT INTO wp_cformsdata VALUES('4244', '158', 'Phone', '2078780483');
INSERT INTO wp_cformsdata VALUES('4245', '158', 'Email', 'muse.liban@gmail.com');
INSERT INTO wp_cformsdata VALUES('4246', '158', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('4247', '158', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4248', '158', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('4249', '158', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4250', '158', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('4251', '158', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4252', '158', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4253', '158', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('4254', '158', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4255', '158', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4256', '158', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4257', '158', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4258', '158', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms');
INSERT INTO wp_cformsdata VALUES('4259', '158', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4260', '158', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4261', '158', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4262', '158', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4263', '158', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4264', '158', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4265', '158', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4266', '158', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4267', '159', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4268', '159', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4269', '159', 'Name', 'FNU Krishnappa Jagadish');
INSERT INTO wp_cformsdata VALUES('4270', '159', 'City/State', 'Los Angeles');
INSERT INTO wp_cformsdata VALUES('4271', '159', 'Phone', '213-304-6538');
INSERT INTO wp_cformsdata VALUES('4272', '159', 'Email', 'jkyadhav@gmail.com');
INSERT INTO wp_cformsdata VALUES('4273', '159', 'How did you hear about us?', 'web ');
INSERT INTO wp_cformsdata VALUES('4274', '159', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4275', '159', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4276', '159', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4277', '159', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4278', '159', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4279', '159', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4280', '159', 'When did the pain begin?', 'before 2 months');
INSERT INTO wp_cformsdata VALUES('4281', '159', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4282', '159', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4283', '159', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4284', '159', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4285', '159', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4286', '159', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4287', '159', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4288', '159', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4289', '159', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4290', '159', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4291', '159', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4292', '159', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4293', '159', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4294', '160', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4295', '160', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4296', '160', 'Name', 'Hugo  Diaz');
INSERT INTO wp_cformsdata VALUES('4297', '160', 'City/State', 'Tustin  California');
INSERT INTO wp_cformsdata VALUES('4298', '160', 'Phone', '1714-408-5217');
INSERT INTO wp_cformsdata VALUES('4299', '160', 'Email', 'coldwelldiaz@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4300', '160', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('4301', '160', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4302', '160', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4303', '160', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4304', '160', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4305', '160', 'Date of most recent scan', 'April 10/2011');
INSERT INTO wp_cformsdata VALUES('4306', '160', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('4307', '160', 'When did the pain begin?', '6 months ');
INSERT INTO wp_cformsdata VALUES('4308', '160', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4309', '160', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4310', '160', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4311', '160', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4312', '160', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('4313', '160', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4314', '160', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4315', '160', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4316', '160', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4317', '160', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4318', '160', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4319', '160', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4320', '160', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4321', '161', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4322', '161', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4323', '161', 'Name', 'Cynthia Acosta');
INSERT INTO wp_cformsdata VALUES('4324', '161', 'City/State', 'West Covina Ca');
INSERT INTO wp_cformsdata VALUES('4325', '161', 'Phone', '3108197563');
INSERT INTO wp_cformsdata VALUES('4326', '161', 'Email', 'Cynthiavacosta@aol.com');
INSERT INTO wp_cformsdata VALUES('4327', '161', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('4328', '161', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4329', '161', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4330', '161', 'If yes, when did this occur?', 'Diagnosed 1/11');
INSERT INTO wp_cformsdata VALUES('4331', '161', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4332', '161', 'Date of most recent scan', '1/11');
INSERT INTO wp_cformsdata VALUES('4333', '161', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4334', '161', 'When did the pain begin?', '1/10');
INSERT INTO wp_cformsdata VALUES('4335', '161', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4336', '161', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4337', '161', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4338', '161', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4339', '161', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('4340', '161', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4341', '161', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4342', '161', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4343', '161', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4344', '161', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4345', '161', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4346', '161', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4347', '161', 'Comments, Questions', 'L5 disc affected');
INSERT INTO wp_cformsdata VALUES('4348', '162', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4349', '162', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4350', '162', 'Name', 'sid ');
INSERT INTO wp_cformsdata VALUES('4351', '162', 'City/State', 'EDISON');
INSERT INTO wp_cformsdata VALUES('4352', '162', 'Phone', '732-372-5327');
INSERT INTO wp_cformsdata VALUES('4353', '162', 'Email', 'idangerous@gmail.com');
INSERT INTO wp_cformsdata VALUES('4354', '162', 'How did you hear about us?', 'web page');
INSERT INTO wp_cformsdata VALUES('4355', '162', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4356', '162', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('4357', '162', 'If yes, when did this occur?', 'Sept 2010');
INSERT INTO wp_cformsdata VALUES('4358', '162', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4359', '162', 'Date of most recent scan', 'Aug 2010');
INSERT INTO wp_cformsdata VALUES('4360', '162', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4361', '162', 'When did the pain begin?', 'Sept 2010');
INSERT INTO wp_cformsdata VALUES('4362', '162', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4363', '162', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4364', '162', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4365', '162', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4366', '162', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('4367', '162', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4368', '162', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4369', '162', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4370', '162', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4371', '162', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4372', '162', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4373', '162', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4374', '162', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4375', '163', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4376', '163', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4377', '163', 'Name', 'Craig TAines ');
INSERT INTO wp_cformsdata VALUES('4378', '163', 'City/State', 'Los angeles ca 90034');
INSERT INTO wp_cformsdata VALUES('4379', '163', 'Phone', '310-4750113');
INSERT INTO wp_cformsdata VALUES('4380', '163', 'Email', 'Craigtaines@gmail.com');
INSERT INTO wp_cformsdata VALUES('4381', '163', 'How did you hear about us?', 'The net');
INSERT INTO wp_cformsdata VALUES('4382', '163', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4383', '163', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease,Annular tear');
INSERT INTO wp_cformsdata VALUES('4384', '163', 'If yes, when did this occur?', '30 years ago ddd');
INSERT INTO wp_cformsdata VALUES('4385', '163', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4386', '163', 'Date of most recent scan', 'One month');
INSERT INTO wp_cformsdata VALUES('4387', '163', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('4388', '163', 'When did the pain begin?', 'All of the above');
INSERT INTO wp_cformsdata VALUES('4389', '163', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4390', '163', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4391', '163', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4392', '163', 'If no, number of hours in pain', 'twentyfour');
INSERT INTO wp_cformsdata VALUES('4393', '163', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('4394', '163', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4395', '163', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4396', '163', 'Date of onset of pain?', '30+years ago');
INSERT INTO wp_cformsdata VALUES('4397', '163', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4398', '163', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4399', '163', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4400', '163', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4401', '163', 'Comments, Questions', '7+fusions 8 level cervical laminectomy severe arachnoiditis infusion pump \n');
INSERT INTO wp_cformsdata VALUES('4402', '164', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4403', '164', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4404', '164', 'Name', 'Patz Raul Adrian');
INSERT INTO wp_cformsdata VALUES('4405', '164', 'City/State', 'Romania Suceava');
INSERT INTO wp_cformsdata VALUES('4406', '164', 'Phone', '+40/ 0745670488');
INSERT INTO wp_cformsdata VALUES('4407', '164', 'Email', 'patz.raul@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4408', '164', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('4409', '164', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4410', '164', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4411', '164', 'If yes, when did this occur?', 'last part of the first month of this year ');
INSERT INTO wp_cformsdata VALUES('4412', '164', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4413', '164', 'Date of most recent scan', '01.03.2011');
INSERT INTO wp_cformsdata VALUES('4414', '164', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('4415', '164', 'When did the pain begin?', '20.01.2011, ');
INSERT INTO wp_cformsdata VALUES('4416', '164', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4417', '164', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4418', '164', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4419', '164', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4420', '164', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4421', '164', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4422', '164', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4423', '164', 'Date of onset of pain?', '20.01.2011');
INSERT INTO wp_cformsdata VALUES('4424', '164', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4425', '164', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4426', '164', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4427', '164', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4428', '164', 'Comments, Questions', 'Hello,\nMy name is Patz Raul Adrian, i`m from Romania, Suceava and i have a back problem,that started on the middle of ianuary after a very bad flu with serious coughs.i had taken pills and all kind of treatmeant with inflammatorys.On 01.03.2011 i`v taken an IRM Test that confirmed my diagnostic: lombosciatica on the right, degenerativ disc L4-L5 and L5-S1;\nparamedian and foraminal herniated disc L5-S1 right with obvious signs of broken fragment of a conflict right S1 root;\nL4-L5 disc protrusion moderate right foraminal with discrete signs of a conflict right L5 root. \nThe irm test was taken in Romania Suceava, PRIMA MEDICAL BETHESDA SUCEAVA,and read by doctor Eduard Moldovanu .\nI `m desperate i don`t know what to do, i don`t what to do surgery, i`m only 20, and my life had change totaly, i used to play handball, fotball . ping pong. i`m 1.80 m  72kg . i am full of energy and i can`t see me in the future without a bit of joging, fitness or just knowing that i will be a father that can`t play with his cildrens. My highschool was a High School Sports Suceava, and now i`m in the second year of college at International Bussines of Stefan Cel Mare College Suceava. Please I need your help, your incredible treatment. Sunday i will go to Bucharest to meet other 2 doctors, if they will say to do surgery i think i will do it :( the first 2 doctors here in Suceava sayd that i need surgery but to try and push it how much i can. i can`t push it no longer the pain is very strong like in your video of the man with the cap ; \"Improvement within minutes in sciatica\"  This movie. Please answer !!! Till Sunday !!!! Please you are my last non knife way. God Bless You');
INSERT INTO wp_cformsdata VALUES('4429', '165', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4430', '165', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4431', '165', 'Name', 'Randy Vigil');
INSERT INTO wp_cformsdata VALUES('4432', '165', 'City/State', 'Santa Fe, New Mexico');
INSERT INTO wp_cformsdata VALUES('4433', '165', 'Phone', '5054702092');
INSERT INTO wp_cformsdata VALUES('4434', '165', 'Email', 'revigil@lanl.gov');
INSERT INTO wp_cformsdata VALUES('4435', '165', 'How did you hear about us?', 'On line');
INSERT INTO wp_cformsdata VALUES('4436', '165', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4437', '165', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4438', '165', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4439', '165', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4440', '165', 'Date of most recent scan', '072010');
INSERT INTO wp_cformsdata VALUES('4441', '165', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('4442', '165', 'When did the pain begin?', '8 months ago');
INSERT INTO wp_cformsdata VALUES('4443', '165', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4444', '165', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4445', '165', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4446', '165', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4447', '165', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4448', '165', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4449', '165', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4450', '165', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4451', '165', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4452', '165', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4453', '165', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4454', '165', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4455', '165', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4456', '166', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4457', '166', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4458', '166', 'Name', 'BETTE RUZ');
INSERT INTO wp_cformsdata VALUES('4459', '166', 'City/State', 'CAMARILLO');
INSERT INTO wp_cformsdata VALUES('4460', '166', 'Phone', '805-485-0617');
INSERT INTO wp_cformsdata VALUES('4461', '166', 'Email', 'uterpa@gmail.com');
INSERT INTO wp_cformsdata VALUES('4462', '166', 'How did you hear about us?', 'am 640');
INSERT INTO wp_cformsdata VALUES('4463', '166', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4464', '166', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4465', '166', 'If yes, when did this occur?', '2006');
INSERT INTO wp_cformsdata VALUES('4466', '166', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4467', '166', 'Date of most recent scan', 'April 13,2011');
INSERT INTO wp_cformsdata VALUES('4468', '166', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('4469', '166', 'When did the pain begin?', '2006');
INSERT INTO wp_cformsdata VALUES('4470', '166', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4471', '166', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4472', '166', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4473', '166', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4474', '166', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,feet');
INSERT INTO wp_cformsdata VALUES('4475', '166', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4476', '166', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4477', '166', 'Date of onset of pain?', '2006');
INSERT INTO wp_cformsdata VALUES('4478', '166', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4479', '166', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4480', '166', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4481', '166', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4482', '166', 'Comments, Questions', 'Lapedectomy on aug 6 2011.  Hospitalised for intence pain April13, 2011.  Full tests done by Surgean that did operation,Dr. Kapil Moza, then at Los Robles Hospital at that time.  All MRIs Catscans and xrays show no reason for pain.');
INSERT INTO wp_cformsdata VALUES('4483', '167', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4484', '167', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4485', '167', 'Name', 'John D. Knighten');
INSERT INTO wp_cformsdata VALUES('4486', '167', 'City/State', 'Los Angeles, California');
INSERT INTO wp_cformsdata VALUES('4487', '167', 'Phone', '3232588726');
INSERT INTO wp_cformsdata VALUES('4488', '167', 'Email', 'knightenjohn@msn.com');
INSERT INTO wp_cformsdata VALUES('4489', '167', 'How did you hear about us?', 'radio advertisement');
INSERT INTO wp_cformsdata VALUES('4490', '167', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4491', '167', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('4492', '167', 'If yes, when did this occur?', 'December 2010');
INSERT INTO wp_cformsdata VALUES('4493', '167', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4494', '167', 'Date of most recent scan', 'MRI about February 2011');
INSERT INTO wp_cformsdata VALUES('4495', '167', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4496', '167', 'When did the pain begin?', 'December 2010');
INSERT INTO wp_cformsdata VALUES('4497', '167', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4498', '167', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('4499', '167', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4500', '167', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4501', '167', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('4502', '167', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4503', '167', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4504', '167', 'Date of onset of pain?', 'December 2010');
INSERT INTO wp_cformsdata VALUES('4505', '167', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4506', '167', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4507', '167', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4508', '167', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4509', '167', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4510', '168', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4511', '168', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4512', '168', 'Name', 'Cindy Gilliland');
INSERT INTO wp_cformsdata VALUES('4513', '168', 'City/State', 'Reno, NV');
INSERT INTO wp_cformsdata VALUES('4514', '168', 'Phone', '89704');
INSERT INTO wp_cformsdata VALUES('4515', '168', 'Email', 'cindy@dirtkickerpottery.com');
INSERT INTO wp_cformsdata VALUES('4516', '168', 'How did you hear about us?', 'Found via Youtube');
INSERT INTO wp_cformsdata VALUES('4517', '168', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4518', '168', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4519', '168', 'If yes, when did this occur?', 'Over the past several years');
INSERT INTO wp_cformsdata VALUES('4520', '168', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4521', '168', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('4522', '168', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('4523', '168', 'When did the pain begin?', 'lower back');
INSERT INTO wp_cformsdata VALUES('4524', '168', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4525', '168', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4526', '168', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4527', '168', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4528', '168', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('4529', '168', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4530', '168', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4531', '168', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4532', '168', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4533', '168', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4534', '168', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4535', '168', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4536', '168', 'Comments, Questions', 'Lumbar 2 bulging and 1 decenagrated disc.  cervical and thoracic multiple nerve impingment.   4th week of physical theropy with no signs of relief.    ');
INSERT INTO wp_cformsdata VALUES('4537', '169', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4538', '169', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4539', '169', 'Name', 'mr pavan singh khangura');
INSERT INTO wp_cformsdata VALUES('4540', '169', 'City/State', 'united kingdom');
INSERT INTO wp_cformsdata VALUES('4541', '169', 'Phone', '0044 208 737 2629');
INSERT INTO wp_cformsdata VALUES('4542', '169', 'Email', 'pavsingh7@hotmail.co.uk');
INSERT INTO wp_cformsdata VALUES('4543', '169', 'How did you hear about us?', 'from a relative  and reading about the cure');
INSERT INTO wp_cformsdata VALUES('4544', '169', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4545', '169', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4546', '169', 'If yes, when did this occur?', 'november 2010');
INSERT INTO wp_cformsdata VALUES('4547', '169', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4548', '169', 'Date of most recent scan', 'march 2011');
INSERT INTO wp_cformsdata VALUES('4549', '169', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4550', '169', 'When did the pain begin?', 'november 2010 ');
INSERT INTO wp_cformsdata VALUES('4551', '169', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4552', '169', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4553', '169', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4554', '169', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4555', '169', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4556', '169', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4557', '169', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4558', '169', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4559', '169', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4560', '169', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4561', '169', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4562', '169', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4563', '169', 'Comments, Questions', 'hi i am in pain all day and all night. even when i cough and sneez. the pain has taken over my life and i have almost given up , i am on the edge painkillers dont help and i feel sick . please help me.');
INSERT INTO wp_cformsdata VALUES('4564', '170', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('4565', '170', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4566', '170', 'Name', 'LORRAINEMANGOLD');
INSERT INTO wp_cformsdata VALUES('4567', '170', 'City/State', 'SAUGUS,CA');
INSERT INTO wp_cformsdata VALUES('4568', '170', 'Phone', '661 297 2317');
INSERT INTO wp_cformsdata VALUES('4569', '170', 'Email', 'LORRAINEMANGOLD@GMAIL.COM');
INSERT INTO wp_cformsdata VALUES('4570', '170', 'How did you hear about us?', 'INTERNET');
INSERT INTO wp_cformsdata VALUES('4571', '170', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4572', '170', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4573', '170', 'If yes, when did this occur?', 'ON GOING');
INSERT INTO wp_cformsdata VALUES('4574', '170', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4575', '170', 'Date of most recent scan', '1-10');
INSERT INTO wp_cformsdata VALUES('4576', '170', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4577', '170', 'When did the pain begin?', '10-20 YRS');
INSERT INTO wp_cformsdata VALUES('4578', '170', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4579', '170', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4580', '170', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4581', '170', 'If no, number of hours in pain', 'WHEN UP AND WALKING');
INSERT INTO wp_cformsdata VALUES('4582', '170', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('4583', '170', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4584', '170', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4585', '170', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4586', '170', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4587', '170', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4588', '170', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4589', '170', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4590', '170', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4591', '171', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4592', '171', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4593', '171', 'Name', 'Christopher Mead');
INSERT INTO wp_cformsdata VALUES('4594', '171', 'City/State', 'mesa, az');
INSERT INTO wp_cformsdata VALUES('4595', '171', 'Phone', '4805775524');
INSERT INTO wp_cformsdata VALUES('4596', '171', 'Email', 'chris0111@cox.net');
INSERT INTO wp_cformsdata VALUES('4597', '171', 'How did you hear about us?', 'google');
INSERT INTO wp_cformsdata VALUES('4598', '171', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4599', '171', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4600', '171', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4601', '171', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('4602', '171', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4603', '171', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4604', '171', 'When did the pain begin?', '5 years');
INSERT INTO wp_cformsdata VALUES('4605', '171', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('4606', '171', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4607', '171', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4608', '171', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4609', '171', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('4610', '171', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4611', '171', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4612', '171', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4613', '171', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4614', '171', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4615', '171', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4616', '171', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4617', '171', 'Comments, Questions', 'I have had Chronic and severe sciatica for years. I have gone to a chiropractor and I get some relief but it comes back within hours. I have to walk with a cane because my hips hurt constantly. Do you have a doctor in Arizona who can help me? I currently do not have insurance but I am willing to pay if it helps. ');
INSERT INTO wp_cformsdata VALUES('4618', '172', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4619', '172', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4620', '172', 'Name', 'JANICE  KAY  DAVIS');
INSERT INTO wp_cformsdata VALUES('4621', '172', 'City/State', 'YUCAIPA, CA.');
INSERT INTO wp_cformsdata VALUES('4622', '172', 'Phone', '909-797-8950 H---    909-289-85-98 C');
INSERT INTO wp_cformsdata VALUES('4623', '172', 'Email', 'yardsailqueen@aol.com');
INSERT INTO wp_cformsdata VALUES('4624', '172', 'How did you hear about us?', 'online ,looking  up  relief  for  sciatic pain');
INSERT INTO wp_cformsdata VALUES('4625', '172', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4626', '172', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4627', '172', 'If yes, when did this occur?', '2005,fell broke tailbone/since have bursitis/sciatic pain/many cortizone shots/dont sleep  well');
INSERT INTO wp_cformsdata VALUES('4628', '172', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4629', '172', 'Date of most recent scan', '2009- have  had  4 or 5  over  last  6  years, injuury  was  at  work  at  a  casino, there  insurance   kust  have  been  paid  off  as  they  would  not  pay  for  anything  after  2  years.  I  quit  after  7 years  as  pain  is  so  bad');
INSERT INTO wp_cformsdata VALUES('4630', '172', 'Is there pain in:', 'Neck,Leg');
INSERT INTO wp_cformsdata VALUES('4631', '172', 'When did the pain begin?', 'after  fall  in  2004');
INSERT INTO wp_cformsdata VALUES('4632', '172', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4633', '172', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4634', '172', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4635', '172', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4636', '172', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('4637', '172', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4638', '172', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4639', '172', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4640', '172', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4641', '172', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4642', '172', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4643', '172', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4644', '172', 'Comments, Questions', 'Will  drive  to  newport  ASAP...Please  contact  me  ASAP  as  I  can\'t  take  this  pain  anymore...I  have  cash  to  pay  in  full,,,Have  no  insurance... Pills  don\'t  work.  have  had  medical  massage  for  last  3 years for  this   chiropractic  care and accupuncture and  many  cortizone  shots  in  left  hip  for  bursitis... NOTHING  MAKES  IT  GO  AWAY...Makes  life  miserable...PLEASE  CALL  ASAP');
INSERT INTO wp_cformsdata VALUES('4645', '173', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4646', '173', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4647', '173', 'Name', 'Drake');
INSERT INTO wp_cformsdata VALUES('4648', '173', 'City/State', 'San clemente');
INSERT INTO wp_cformsdata VALUES('4649', '173', 'Phone', '949-412-5987');
INSERT INTO wp_cformsdata VALUES('4650', '173', 'Email', 'Drakew39@gmail.com');
INSERT INTO wp_cformsdata VALUES('4651', '173', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('4652', '173', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4653', '173', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4654', '173', 'If yes, when did this occur?', '4 years ago');
INSERT INTO wp_cformsdata VALUES('4655', '173', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4656', '173', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4657', '173', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('4658', '173', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('4659', '173', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4660', '173', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4661', '173', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4662', '173', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4663', '173', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4664', '173', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4665', '173', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4666', '173', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4667', '173', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4668', '173', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4669', '173', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4670', '173', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4671', '173', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4672', '174', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4673', '174', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4674', '174', 'Name', 'shelly');
INSERT INTO wp_cformsdata VALUES('4675', '174', 'City/State', 'inglewood ca.');
INSERT INTO wp_cformsdata VALUES('4676', '174', 'Phone', '3107703024');
INSERT INTO wp_cformsdata VALUES('4677', '174', 'Email', 'shelly.gearring@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4678', '174', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('4679', '174', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4680', '174', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('4681', '174', 'If yes, when did this occur?', 'one year ago');
INSERT INTO wp_cformsdata VALUES('4682', '174', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4683', '174', 'Date of most recent scan', '06/03/11');
INSERT INTO wp_cformsdata VALUES('4684', '174', 'Is there pain in:', 'Neck');
INSERT INTO wp_cformsdata VALUES('4685', '174', 'When did the pain begin?', '06/06/06');
INSERT INTO wp_cformsdata VALUES('4686', '174', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4687', '174', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('4688', '174', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4689', '174', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4690', '174', 'Is there pain, tingling, numbness, or weakness in your:', 'hands,fingers');
INSERT INTO wp_cformsdata VALUES('4691', '174', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4692', '174', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4693', '174', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4694', '174', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4695', '174', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4696', '174', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4697', '174', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4698', '174', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4699', '175', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4700', '175', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4701', '175', 'Name', 'Lorenzo');
INSERT INTO wp_cformsdata VALUES('4702', '175', 'City/State', 'MD');
INSERT INTO wp_cformsdata VALUES('4703', '175', 'Phone', '5413377807');
INSERT INTO wp_cformsdata VALUES('4704', '175', 'Email', 'lorenlamam@gmail.com');
INSERT INTO wp_cformsdata VALUES('4705', '175', 'How did you hear about us?', 'friend send me a youtube video');
INSERT INTO wp_cformsdata VALUES('4706', '175', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4707', '175', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('4708', '175', 'If yes, when did this occur?', 'January 2007');
INSERT INTO wp_cformsdata VALUES('4709', '175', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('4710', '175', 'Date of most recent scan', 'January 2007');
INSERT INTO wp_cformsdata VALUES('4711', '175', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4712', '175', 'When did the pain begin?', 'January 2007');
INSERT INTO wp_cformsdata VALUES('4713', '175', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4714', '175', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4715', '175', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4716', '175', 'If no, number of hours in pain', '5-8');
INSERT INTO wp_cformsdata VALUES('4717', '175', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves');
INSERT INTO wp_cformsdata VALUES('4718', '175', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4719', '175', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4720', '175', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4721', '175', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4722', '175', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4723', '175', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4724', '175', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4725', '175', 'Comments, Questions', 'I was in my soccer practice when I felt the pain in my back and leg, since that time I been having problem  playing soccer, which is the sport that I love. ');
INSERT INTO wp_cformsdata VALUES('4726', '176', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4727', '176', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4728', '176', 'Name', 'Neil Prill');
INSERT INTO wp_cformsdata VALUES('4729', '176', 'City/State', 'Prescott Arizona');
INSERT INTO wp_cformsdata VALUES('4730', '176', 'Phone', '928-772-6995');
INSERT INTO wp_cformsdata VALUES('4731', '176', 'Email', 'neil@prescott4u.com');
INSERT INTO wp_cformsdata VALUES('4732', '176', 'How did you hear about us?', 'radio ');
INSERT INTO wp_cformsdata VALUES('4733', '176', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4734', '176', 'Does the patient have', 'Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4735', '176', 'If yes, when did this occur?', '06-01-2004 fist time');
INSERT INTO wp_cformsdata VALUES('4736', '176', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4737', '176', 'Date of most recent scan', '2004');
INSERT INTO wp_cformsdata VALUES('4738', '176', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4739', '176', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('4740', '176', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('4741', '176', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4742', '176', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4743', '176', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4744', '176', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4745', '176', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4746', '176', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4747', '176', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4748', '176', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4749', '176', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4750', '176', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4751', '176', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4752', '176', 'Comments, Questions', '2004 treatment was 2 series of 3 epadurals 9 months apart.  Last ones caused slight nerve damage to left leg.  Have been able to get by with self treatments ie physical therapy, disc decompression etc until the last mounth.  Now there is severe sciatica pain down both legs.  Treatment now is the use of pain killers.');
INSERT INTO wp_cformsdata VALUES('4753', '177', 'page', '/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4754', '177', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4755', '177', 'Name', 'miguel');
INSERT INTO wp_cformsdata VALUES('4756', '177', 'City/State', 'lancaster ca. 93535');
INSERT INTO wp_cformsdata VALUES('4757', '177', 'Phone', '8184555525');
INSERT INTO wp_cformsdata VALUES('4758', '177', 'Email', 'miguel.diaz@wescoair.com');
INSERT INTO wp_cformsdata VALUES('4759', '177', 'How did you hear about us?', 'radio 106.7');
INSERT INTO wp_cformsdata VALUES('4760', '177', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4761', '177', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4762', '177', 'If yes, when did this occur?', 'long time ago');
INSERT INTO wp_cformsdata VALUES('4763', '177', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4764', '177', 'Date of most recent scan', '2007');
INSERT INTO wp_cformsdata VALUES('4765', '177', 'Is there pain in:', 'Back,Arm');
INSERT INTO wp_cformsdata VALUES('4766', '177', 'When did the pain begin?', 'long ago');
INSERT INTO wp_cformsdata VALUES('4767', '177', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4768', '177', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('4769', '177', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4770', '177', 'If no, number of hours in pain', 'maybe 4,5 if no resting ');
INSERT INTO wp_cformsdata VALUES('4771', '177', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,hands');
INSERT INTO wp_cformsdata VALUES('4772', '177', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4773', '177', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4774', '177', 'Date of onset of pain?', 'dont remember');
INSERT INTO wp_cformsdata VALUES('4775', '177', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4776', '177', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4777', '177', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4778', '177', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4779', '177', 'Comments, Questions', 'The pain is intermitent when playing soçcer or excessive exsorcise dont hurt. however when cool down hurts again. akilles tendont hurt too');
INSERT INTO wp_cformsdata VALUES('4780', '178', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4781', '178', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4782', '178', 'Name', 'Richard Toth');
INSERT INTO wp_cformsdata VALUES('4783', '178', 'City/State', 'Los Alamitos, CA');
INSERT INTO wp_cformsdata VALUES('4784', '178', 'Phone', '562-598-9413 after 3 pm');
INSERT INTO wp_cformsdata VALUES('4785', '178', 'Email', 'rtt.cht@gte.net');
INSERT INTO wp_cformsdata VALUES('4786', '178', 'How did you hear about us?', 'Advertisement');
INSERT INTO wp_cformsdata VALUES('4787', '178', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4788', '178', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4789', '178', 'If yes, when did this occur?', 'Herniated 5/2010; Bulging 5/2011');
INSERT INTO wp_cformsdata VALUES('4790', '178', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4791', '178', 'Date of most recent scan', 'MRI - 5/4/2011');
INSERT INTO wp_cformsdata VALUES('4792', '178', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4793', '178', 'When did the pain begin?', 'Off and on for 30 years; severe within last 3 years');
INSERT INTO wp_cformsdata VALUES('4794', '178', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4795', '178', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4796', '178', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4797', '178', 'If no, number of hours in pain', '12-15');
INSERT INTO wp_cformsdata VALUES('4798', '178', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('4799', '178', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4800', '178', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4801', '178', 'Date of onset of pain?', 'Prior to disc surgery on 5/5/2010');
INSERT INTO wp_cformsdata VALUES('4802', '178', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4803', '178', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4804', '178', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4805', '178', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4806', '178', 'Comments, Questions', 'Last years surgery repaired torn dura and removed \"debris\" from L1 & L2 disintegrating.');
INSERT INTO wp_cformsdata VALUES('4807', '179', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4808', '179', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4809', '179', 'Name', 'Shari Stacy');
INSERT INTO wp_cformsdata VALUES('4810', '179', 'City/State', 'Bakersfield,  Ca.');
INSERT INTO wp_cformsdata VALUES('4811', '179', 'Phone', '661-325-8300 after 10:00am');
INSERT INTO wp_cformsdata VALUES('4812', '179', 'Email', 'sharisugardaddys@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4813', '179', 'How did you hear about us?', 'a friend e-mailed me');
INSERT INTO wp_cformsdata VALUES('4814', '179', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4815', '179', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4816', '179', 'If yes, when did this occur?', '28 years ago ongoing pain');
INSERT INTO wp_cformsdata VALUES('4817', '179', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4818', '179', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('4819', '179', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4820', '179', 'When did the pain begin?', '28 years ago');
INSERT INTO wp_cformsdata VALUES('4821', '179', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4822', '179', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4823', '179', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4824', '179', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4825', '179', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4826', '179', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4827', '179', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4828', '179', 'Date of onset of pain?', '2011 came back after surgery 2008');
INSERT INTO wp_cformsdata VALUES('4829', '179', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4830', '179', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4831', '179', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4832', '179', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4833', '179', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('4834', '180', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4835', '180', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4836', '180', 'Name', 'David Galowitz');
INSERT INTO wp_cformsdata VALUES('4837', '180', 'City/State', 'Palmdale, Ca');
INSERT INTO wp_cformsdata VALUES('4838', '180', 'Phone', '858 752-3019');
INSERT INTO wp_cformsdata VALUES('4839', '180', 'Email', 'poloman850@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4840', '180', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('4841', '180', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4842', '180', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4843', '180', 'If yes, when did this occur?', 'i believe sometime last year');
INSERT INTO wp_cformsdata VALUES('4844', '180', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('4845', '180', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4846', '180', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4847', '180', 'When did the pain begin?', 'march 2010');
INSERT INTO wp_cformsdata VALUES('4848', '180', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4849', '180', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4850', '180', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4851', '180', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4852', '180', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('4853', '180', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4854', '180', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4855', '180', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4856', '180', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4857', '180', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4858', '180', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4859', '180', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4860', '180', 'Comments, Questions', 'severe case of sciatica. Saw your videos on you tube and would be interested in some sort of consultation on a solution to my problem.');
INSERT INTO wp_cformsdata VALUES('4861', '181', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4862', '181', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4863', '181', 'Name', 'Randy Baker');
INSERT INTO wp_cformsdata VALUES('4864', '181', 'City/State', 'Portland, OR');
INSERT INTO wp_cformsdata VALUES('4865', '181', 'Phone', '503-957-5707');
INSERT INTO wp_cformsdata VALUES('4866', '181', 'Email', 'r.baker1000@comcast.net');
INSERT INTO wp_cformsdata VALUES('4867', '181', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('4868', '181', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4869', '181', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('4870', '181', 'If yes, when did this occur?', '10 years ago and getting worse');
INSERT INTO wp_cformsdata VALUES('4871', '181', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4872', '181', 'Date of most recent scan', 'about a year ago');
INSERT INTO wp_cformsdata VALUES('4873', '181', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('4874', '181', 'When did the pain begin?', 'After picking up a heavy piece of furniture');
INSERT INTO wp_cformsdata VALUES('4875', '181', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4876', '181', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('4877', '181', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4878', '181', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4879', '181', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4880', '181', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4881', '181', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4882', '181', 'Date of onset of pain?', 'minimal invasive surgery.pain after picking up furniture');
INSERT INTO wp_cformsdata VALUES('4883', '181', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4884', '181', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4885', '181', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4886', '181', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4887', '181', 'Comments, Questions', 'Tried everything under the sun for this problem.Sciatica is my worst pain.');
INSERT INTO wp_cformsdata VALUES('4888', '182', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4889', '182', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4890', '182', 'Name', 'Jeff Frazin');
INSERT INTO wp_cformsdata VALUES('4891', '182', 'City/State', 'Sherman Oaks');
INSERT INTO wp_cformsdata VALUES('4892', '182', 'Phone', '818 788 2910');
INSERT INTO wp_cformsdata VALUES('4893', '182', 'Email', 'jefffrazin@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4894', '182', 'How did you hear about us?', 'Google');
INSERT INTO wp_cformsdata VALUES('4895', '182', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4896', '182', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('4897', '182', 'If yes, when did this occur?', 'about Jan 2010');
INSERT INTO wp_cformsdata VALUES('4898', '182', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4899', '182', 'Date of most recent scan', 'Oct 2010');
INSERT INTO wp_cformsdata VALUES('4900', '182', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('4901', '182', 'When did the pain begin?', 'about 5-2010');
INSERT INTO wp_cformsdata VALUES('4902', '182', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4903', '182', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4904', '182', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4905', '182', 'If no, number of hours in pain', 'Usually mornings to pm');
INSERT INTO wp_cformsdata VALUES('4906', '182', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('4907', '182', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('4908', '182', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4909', '182', 'Date of onset of pain?', 'around may 2010');
INSERT INTO wp_cformsdata VALUES('4910', '182', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('4911', '182', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4912', '182', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('4913', '182', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('4914', '182', 'Comments, Questions', 'Pain is in lower back, more on left side, slight left leg pain. I Have had 2 steroidal epidurals, Dec. 2010 and Mar. 2011 both lasting only 3-4 weeks. I am Currently scheduled for an RFA on June 24th 2010. Dr. Roy Nini  at the Cedars Spine Institute.\n\nI have Blue Shield PPO.\n\nPlease advise, thanks\n\nJeff Frazin');
INSERT INTO wp_cformsdata VALUES('4915', '183', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4916', '183', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4917', '183', 'Name', 'Melinda Gordon');
INSERT INTO wp_cformsdata VALUES('4918', '183', 'City/State', '16935 Vanowen St #A Lake Balboa Ca 91406');
INSERT INTO wp_cformsdata VALUES('4919', '183', 'Phone', '8187052931');
INSERT INTO wp_cformsdata VALUES('4920', '183', 'Email', 'gordondmd@yahoo.com');
INSERT INTO wp_cformsdata VALUES('4921', '183', 'How did you hear about us?', 'Dr. MarK Gordon');
INSERT INTO wp_cformsdata VALUES('4922', '183', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4923', '183', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('4924', '183', 'If yes, when did this occur?', '1 year ago');
INSERT INTO wp_cformsdata VALUES('4925', '183', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4926', '183', 'Date of most recent scan', '05/18/2011');
INSERT INTO wp_cformsdata VALUES('4927', '183', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('4928', '183', 'When did the pain begin?', 'last year');
INSERT INTO wp_cformsdata VALUES('4929', '183', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4930', '183', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4931', '183', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4932', '183', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4933', '183', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('4934', '183', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('4935', '183', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4936', '183', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4937', '183', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4938', '183', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4939', '183', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4940', '183', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4941', '183', 'Comments, Questions', 'I have scoliosis ');
INSERT INTO wp_cformsdata VALUES('4942', '184', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4943', '184', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4944', '184', 'Name', 'abdulahi');
INSERT INTO wp_cformsdata VALUES('4945', '184', 'City/State', 'bangkok');
INSERT INTO wp_cformsdata VALUES('4946', '184', 'Phone', '66811488718');
INSERT INTO wp_cformsdata VALUES('4947', '184', 'Email', 'shidaaye_10@hotmail.com');
INSERT INTO wp_cformsdata VALUES('4948', '184', 'How did you hear about us?', 'from youtube');
INSERT INTO wp_cformsdata VALUES('4949', '184', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4950', '184', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4951', '184', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4952', '184', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4953', '184', 'Date of most recent scan', '4th may 2010');
INSERT INTO wp_cformsdata VALUES('4954', '184', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('4955', '184', 'When did the pain begin?', '2009');
INSERT INTO wp_cformsdata VALUES('4956', '184', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4957', '184', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4958', '184', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('4959', '184', 'If no, number of hours in pain', '12hour');
INSERT INTO wp_cformsdata VALUES('4960', '184', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('4961', '184', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4962', '184', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('4963', '184', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4964', '184', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4965', '184', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4966', '184', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4967', '184', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4968', '184', 'Comments, Questions', 'Hi Dr. I Just wanna know If my Hip Pain Can Relief ? ');
INSERT INTO wp_cformsdata VALUES('4969', '185', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4970', '185', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4971', '185', 'Name', 'JEFF ARAN');
INSERT INTO wp_cformsdata VALUES('4972', '185', 'City/State', 'SACRAMENTO');
INSERT INTO wp_cformsdata VALUES('4973', '185', 'Phone', '9163956000');
INSERT INTO wp_cformsdata VALUES('4974', '185', 'Email', 'JARANATTY@AOL.COM');
INSERT INTO wp_cformsdata VALUES('4975', '185', 'How did you hear about us?', 'YOUTUBE');
INSERT INTO wp_cformsdata VALUES('4976', '185', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('4977', '185', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('4978', '185', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('4979', '185', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('4980', '185', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('4981', '185', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('4982', '185', 'When did the pain begin?', 'ABOUT 2 WEEKS AGO');
INSERT INTO wp_cformsdata VALUES('4983', '185', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4984', '185', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('4985', '185', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4986', '185', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('4987', '185', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('4988', '185', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('4989', '185', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('4990', '185', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('4991', '185', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4992', '185', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4993', '185', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('4994', '185', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('4995', '185', 'Comments, Questions', 'HAVE NOT HAD MRI, ONLY NORMAL XRAY.  PCP SAYS GIVE IT SOME TIME, TAKE IBUPROFIN AND MUSCLE RELAXANTS TO SEE IF THAT WORKS.  WALKING PROBLEM IS THAT LEFT SIDE OF LEFT FOOT AND HEEL ARE NUMB -- ACTUALLY HYPESENSITVE PERHAPS.  BELIEVE I HAVE PIRIFORMIS PRESSURE ON A NERVE.  CAN\'T FIND A COMFORTABLE SPOT.  AM DOING SOME STRETCHING BUT DOESN\'T RELIEVE THE PAIN AND \"NUMB\" SENSATION.');
INSERT INTO wp_cformsdata VALUES('4996', '186', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('4997', '186', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('4998', '186', 'Name', 'masarat bibi');
INSERT INTO wp_cformsdata VALUES('4999', '186', 'City/State', 'united kingdom');
INSERT INTO wp_cformsdata VALUES('5000', '186', 'Phone', '00441612847161');
INSERT INTO wp_cformsdata VALUES('5001', '186', 'Email', 'masaratbibi@hotmail.co.uk');
INSERT INTO wp_cformsdata VALUES('5002', '186', 'How did you hear about us?', 'on youtube');
INSERT INTO wp_cformsdata VALUES('5003', '186', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5004', '186', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5005', '186', 'If yes, when did this occur?', 'polymiostus ');
INSERT INTO wp_cformsdata VALUES('5006', '186', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5007', '186', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5008', '186', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5009', '186', 'When did the pain begin?', 'in the middle of my back near the discand my leg gets pulled');
INSERT INTO wp_cformsdata VALUES('5010', '186', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5011', '186', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5012', '186', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5013', '186', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5014', '186', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('5015', '186', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5016', '186', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5017', '186', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5018', '186', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5019', '186', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5020', '186', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5021', '186', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5022', '186', 'Comments, Questions', 'i cant walk at all my leg hurt my back total gone with pain i can pick up things or bend down it really affred my life am bed bound at the age of 40 ive had this pain since 7 years now treid all treatment even predisalone i was looking on youtube and found your foundation clinc i khow it will be far to travel but am willing to take that risk to get better i dont khow if they have this treament in the uk i have polymiostus with is the inflamtion of muscle it is a auttoammune disorder i feel in my heart that you are the people that can help me thankyou for your time i will be looking forward from hearing from you');
INSERT INTO wp_cformsdata VALUES('5023', '187', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5024', '187', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5025', '187', 'Name', 'Alex');
INSERT INTO wp_cformsdata VALUES('5026', '187', 'City/State', 'San Jose, California');
INSERT INTO wp_cformsdata VALUES('5027', '187', 'Phone', '408-718-4623');
INSERT INTO wp_cformsdata VALUES('5028', '187', 'Email', 'energyofhope@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5029', '187', 'How did you hear about us?', 'research');
INSERT INTO wp_cformsdata VALUES('5030', '187', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5031', '187', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5032', '187', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5033', '187', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5034', '187', 'Date of most recent scan', 'May, 2011 (Lumbar & Cervical MRI)');
INSERT INTO wp_cformsdata VALUES('5035', '187', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5036', '187', 'When did the pain begin?', 'many years ago');
INSERT INTO wp_cformsdata VALUES('5037', '187', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5038', '187', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5039', '187', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5040', '187', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5041', '187', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('5042', '187', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5043', '187', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5044', '187', 'Date of onset of pain?', '2001');
INSERT INTO wp_cformsdata VALUES('5045', '187', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5046', '187', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5047', '187', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5048', '187', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5049', '187', 'Comments, Questions', 'Multiple failed low back and neck surgeries.  Severe low back and terrible sciatica.  Moderate neck/arm and hand pain.  Presently, fused at C5/C6 and C6/C7 in the neck and L4/L5-L5/S1.  In the back there is a psyudomenigocele with a CSF collection as a complication of the latest lumbar surgery.  Further surgery is not recommended.  Steroid epidural injections (nerve blocks) performed in the past have only made me worse by causing long-lasting flare-ups with no benefit in the post-flare-up stage.  Read research about perispinal Enbrel.  Interested in learning how safe these injections are.  Very excited that this treatment may improve my symptoms, but concerned about the potential for serious adverse effects.  Insurance:  Medicare A,B, &D (no secondary insurance).  Please indicate the cost of the treatment, and if, and what percentage is covered by Medicare.  Thank you!  -Alex');
INSERT INTO wp_cformsdata VALUES('5050', '188', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5051', '188', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5052', '188', 'Name', 'riffat qasim');
INSERT INTO wp_cformsdata VALUES('5053', '188', 'City/State', 'mississauga,ontario.canada');
INSERT INTO wp_cformsdata VALUES('5054', '188', 'Phone', '9059560451');
INSERT INTO wp_cformsdata VALUES('5055', '188', 'Email', 'riffatqasim@gmail.com');
INSERT INTO wp_cformsdata VALUES('5056', '188', 'How did you hear about us?', 'random search on google');
INSERT INTO wp_cformsdata VALUES('5057', '188', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5058', '188', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5059', '188', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5060', '188', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5061', '188', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5062', '188', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5063', '188', 'When did the pain begin?', '1 month ago');
INSERT INTO wp_cformsdata VALUES('5064', '188', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5065', '188', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5066', '188', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5067', '188', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5068', '188', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('5069', '188', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5070', '188', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5071', '188', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5072', '188', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5073', '188', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5074', '188', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5075', '188', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5076', '188', 'Comments, Questions', 'pain is more severe when walking, getting up from bed or chair.....');
INSERT INTO wp_cformsdata VALUES('5077', '189', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5078', '189', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5079', '189', 'Name', 'elizabeth macario');
INSERT INTO wp_cformsdata VALUES('5080', '189', 'City/State', 'chatsworth,california');
INSERT INTO wp_cformsdata VALUES('5081', '189', 'Phone', '8189141286');
INSERT INTO wp_cformsdata VALUES('5082', '189', 'Email', 'emc168@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5083', '189', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('5084', '189', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5085', '189', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5086', '189', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5087', '189', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5088', '189', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5089', '189', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5090', '189', 'When did the pain begin?', '25 years ago');
INSERT INTO wp_cformsdata VALUES('5091', '189', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5092', '189', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5093', '189', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5094', '189', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5095', '189', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('5096', '189', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5097', '189', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5098', '189', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5099', '189', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5100', '189', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5101', '189', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5102', '189', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('5103', '189', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('5104', '190', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5105', '190', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5106', '190', 'Name', 'Makara');
INSERT INTO wp_cformsdata VALUES('5107', '190', 'City/State', 'Fredericksburg tx');
INSERT INTO wp_cformsdata VALUES('5108', '190', 'Phone', '682 7779999');
INSERT INTO wp_cformsdata VALUES('5109', '190', 'Email', 'Makara_luy@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5110', '190', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('5111', '190', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5112', '190', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5113', '190', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5114', '190', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5115', '190', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5116', '190', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5117', '190', 'When did the pain begin?', 'Last 5 year    It was gone coz i took shot . It just came back on last month i took a shot again seem like no help plus i don like no cut that y . Thx');
INSERT INTO wp_cformsdata VALUES('5118', '190', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5119', '190', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5120', '190', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5121', '190', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5122', '190', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5123', '190', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5124', '190', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5125', '190', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5126', '190', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5127', '190', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5128', '190', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5129', '190', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5130', '190', 'Comments, Questions', 'Hey how many shot do i have to get ?\nDoes it expensive  how much ?\n\n');
INSERT INTO wp_cformsdata VALUES('5131', '191', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5132', '191', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5133', '191', 'Name', 'kiran rangani');
INSERT INTO wp_cformsdata VALUES('5134', '191', 'City/State', 'india ');
INSERT INTO wp_cformsdata VALUES('5135', '191', 'Phone', '0919376105474');
INSERT INTO wp_cformsdata VALUES('5136', '191', 'Email', 'kiran_rangani@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5137', '191', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('5138', '191', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5139', '191', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('5140', '191', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5141', '191', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5142', '191', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5143', '191', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5144', '191', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5145', '191', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5146', '191', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5147', '191', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5148', '191', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5149', '191', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs');
INSERT INTO wp_cformsdata VALUES('5150', '191', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5151', '191', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5152', '191', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5153', '191', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5154', '191', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5155', '191', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5156', '191', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5157', '191', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('5158', '192', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5159', '192', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5160', '192', 'Name', 'Miguel ');
INSERT INTO wp_cformsdata VALUES('5161', '192', 'City/State', 'Shelton,WA');
INSERT INTO wp_cformsdata VALUES('5162', '192', 'Phone', '360-359-0952');
INSERT INTO wp_cformsdata VALUES('5163', '192', 'Email', 'mikebrambila@gmail.com');
INSERT INTO wp_cformsdata VALUES('5164', '192', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('5165', '192', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5166', '192', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5167', '192', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5168', '192', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5169', '192', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5170', '192', 'Is there pain in:', 'Back,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5171', '192', 'When did the pain begin?', 'sep 2009');
INSERT INTO wp_cformsdata VALUES('5172', '192', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5173', '192', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5174', '192', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5175', '192', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5176', '192', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,arms');
INSERT INTO wp_cformsdata VALUES('5177', '192', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5178', '192', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5179', '192', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5180', '192', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5181', '192', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5182', '192', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5183', '192', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5184', '192', 'Comments, Questions', 'I live in the state of washington and I want to make an appointment I feel really bad for two years and I say it\'s the sciatic nerve');
INSERT INTO wp_cformsdata VALUES('5185', '193', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5186', '193', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5187', '193', 'Name', 'clive morris');
INSERT INTO wp_cformsdata VALUES('5188', '193', 'City/State', 'alfreton');
INSERT INTO wp_cformsdata VALUES('5189', '193', 'Phone', '07811076613');
INSERT INTO wp_cformsdata VALUES('5190', '193', 'Email', 'c.morris23@ntlworld.com');
INSERT INTO wp_cformsdata VALUES('5191', '193', 'How did you hear about us?', 'utube');
INSERT INTO wp_cformsdata VALUES('5192', '193', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5193', '193', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('5194', '193', 'If yes, when did this occur?', '8 months');
INSERT INTO wp_cformsdata VALUES('5195', '193', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5196', '193', 'Date of most recent scan', '28th april 2011');
INSERT INTO wp_cformsdata VALUES('5197', '193', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5198', '193', 'When did the pain begin?', 'october');
INSERT INTO wp_cformsdata VALUES('5199', '193', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5200', '193', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5201', '193', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5202', '193', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5203', '193', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5204', '193', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5205', '193', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5206', '193', 'Date of onset of pain?', '3 years ago');
INSERT INTO wp_cformsdata VALUES('5207', '193', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5208', '193', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5209', '193', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5210', '193', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('5211', '193', 'Comments, Questions', 'they told me at mri scan don t need surgery but a eapordual injection would do this but on seeing the video it seems i have the same symtoms , do we do this in england ');
INSERT INTO wp_cformsdata VALUES('5212', '194', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5213', '194', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5214', '194', 'Name', 'Chad stokes');
INSERT INTO wp_cformsdata VALUES('5215', '194', 'City/State', 'Northridge, Ca');
INSERT INTO wp_cformsdata VALUES('5216', '194', 'Phone', '818-585-4816');
INSERT INTO wp_cformsdata VALUES('5217', '194', 'Email', 'Uclastokes@me.com');
INSERT INTO wp_cformsdata VALUES('5218', '194', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('5219', '194', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5220', '194', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5221', '194', 'If yes, when did this occur?', '2001');
INSERT INTO wp_cformsdata VALUES('5222', '194', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5223', '194', 'Date of most recent scan', 'Oct. 2010');
INSERT INTO wp_cformsdata VALUES('5224', '194', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5225', '194', 'When did the pain begin?', '2008');
INSERT INTO wp_cformsdata VALUES('5226', '194', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5227', '194', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5228', '194', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5229', '194', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5230', '194', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('5231', '194', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5232', '194', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5233', '194', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5234', '194', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5235', '194', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5236', '194', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5237', '194', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5238', '194', 'Comments, Questions', 'Please help. I have tried everything short of the fusion now being recommend. I am only able to work because of pain pills and can\'t golf at all \n, which is partly occupation. Thank you for taking the time to consider me.');
INSERT INTO wp_cformsdata VALUES('5239', '195', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5240', '195', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5241', '195', 'Name', 'Autumn Deroo');
INSERT INTO wp_cformsdata VALUES('5242', '195', 'City/State', 'Canyon Lake, CA');
INSERT INTO wp_cformsdata VALUES('5243', '195', 'Phone', '9517462256');
INSERT INTO wp_cformsdata VALUES('5244', '195', 'Email', 'autumnderoo@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5245', '195', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('5246', '195', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5247', '195', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5248', '195', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5249', '195', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5250', '195', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5251', '195', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5252', '195', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5253', '195', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5254', '195', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5255', '195', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5256', '195', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5257', '195', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('5258', '195', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5259', '195', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5260', '195', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5261', '195', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5262', '195', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5263', '195', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5264', '195', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5265', '195', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('5266', '196', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('5267', '196', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5268', '196', 'Name', 'keisa');
INSERT INTO wp_cformsdata VALUES('5269', '196', 'City/State', 'north hills ca');
INSERT INTO wp_cformsdata VALUES('5270', '196', 'Phone', '818-221-2338');
INSERT INTO wp_cformsdata VALUES('5271', '196', 'Email', 'ktheusk@aol.com');
INSERT INTO wp_cformsdata VALUES('5272', '196', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('5273', '196', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5274', '196', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5275', '196', 'If yes, when did this occur?', '2008');
INSERT INTO wp_cformsdata VALUES('5276', '196', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5277', '196', 'Date of most recent scan', 'july 2009');
INSERT INTO wp_cformsdata VALUES('5278', '196', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5279', '196', 'When did the pain begin?', 'august 2008');
INSERT INTO wp_cformsdata VALUES('5280', '196', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5281', '196', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5282', '196', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5283', '196', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5284', '196', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('5285', '196', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5286', '196', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5287', '196', 'Date of onset of pain?', 'aug 2008');
INSERT INTO wp_cformsdata VALUES('5288', '196', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5289', '196', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5290', '196', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5291', '196', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5292', '196', 'Comments, Questions', 'i had back surgery august 20, 2009');
INSERT INTO wp_cformsdata VALUES('5293', '197', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5294', '197', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5295', '197', 'Name', 'Eugenie V. Anderson, MD');
INSERT INTO wp_cformsdata VALUES('5296', '197', 'City/State', 'Phoenix, Arizona 85007');
INSERT INTO wp_cformsdata VALUES('5297', '197', 'Phone', '602 463-9752');
INSERT INTO wp_cformsdata VALUES('5298', '197', 'Email', 'evanderson@cox.net');
INSERT INTO wp_cformsdata VALUES('5299', '197', 'How did you hear about us?', 'word of mouth');
INSERT INTO wp_cformsdata VALUES('5300', '197', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5301', '197', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5302', '197', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5303', '197', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5304', '197', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5305', '197', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5306', '197', 'When did the pain begin?', '3-4 years ago');
INSERT INTO wp_cformsdata VALUES('5307', '197', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5308', '197', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5309', '197', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('5310', '197', 'If no, number of hours in pain', 'approximately 8 or so');
INSERT INTO wp_cformsdata VALUES('5311', '197', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('5312', '197', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('5313', '197', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5314', '197', 'Date of onset of pain?', 'repair of ruptured disc 1962');
INSERT INTO wp_cformsdata VALUES('5315', '197', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5316', '197', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('5317', '197', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5318', '197', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5319', '197', 'Comments, Questions', 'Pt has a chronic sciatica or nerve root pain affecting the hip and knee of the same side.  Physical therapy and massage therapy don\'t produce lasting results.  ');
INSERT INTO wp_cformsdata VALUES('5320', '198', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5321', '198', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5322', '198', 'Name', 'SOSCORRO LUNA');
INSERT INTO wp_cformsdata VALUES('5323', '198', 'City/State', 'PARAMOUNT CA');
INSERT INTO wp_cformsdata VALUES('5324', '198', 'Phone', '951-824-9204');
INSERT INTO wp_cformsdata VALUES('5325', '198', 'Email', 'violett562@hotmail.com');
INSERT INTO wp_cformsdata VALUES('5326', '198', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('5327', '198', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5328', '198', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5329', '198', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5330', '198', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5331', '198', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5332', '198', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('5333', '198', 'When did the pain begin?', 'may 9th 2011');
INSERT INTO wp_cformsdata VALUES('5334', '198', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5335', '198', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5336', '198', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5337', '198', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5338', '198', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('5339', '198', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5340', '198', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5341', '198', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5342', '198', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5343', '198', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5344', '198', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5345', '198', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5346', '198', 'Comments, Questions', 'Since, may 9 i started having really bad pain, Starting in my left Botox,  and the pain started getting worse everyday, The pain runs the my Botox through my Calf, im having trouble sleeping, I cant walk, And its getting worse at night, At this point I started having weakness with both of my legs. And i am starting to feel really tired and stresssed through my whole body. 
\n
\nTHANK YOU, Ill Apreciate Your Response.');
INSERT INTO wp_cformsdata VALUES('5347', '199', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_2');
INSERT INTO wp_cformsdata VALUES('5348', '199', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5349', '199', 'Name', 'Dennis Beitzell');
INSERT INTO wp_cformsdata VALUES('5350', '199', 'City/State', 'Redding California');
INSERT INTO wp_cformsdata VALUES('5351', '199', 'Phone', '530-921-2380');
INSERT INTO wp_cformsdata VALUES('5352', '199', 'Email', 'beitzelld@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5353', '199', 'How did you hear about us?', 'a friend');
INSERT INTO wp_cformsdata VALUES('5354', '199', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5355', '199', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('5356', '199', 'If yes, when did this occur?', 'Dec 2007');
INSERT INTO wp_cformsdata VALUES('5357', '199', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5358', '199', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5359', '199', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5360', '199', 'When did the pain begin?', '2009');
INSERT INTO wp_cformsdata VALUES('5361', '199', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5362', '199', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5363', '199', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5364', '199', 'If no, number of hours in pain', '24');
INSERT INTO wp_cformsdata VALUES('5365', '199', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('5366', '199', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5367', '199', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5368', '199', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5369', '199', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5370', '199', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5371', '199', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5372', '199', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5373', '199', 'Comments, Questions', 'Two neck fusions and another one needed right now');
INSERT INTO wp_cformsdata VALUES('5374', '200', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5375', '200', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5376', '200', 'Name', 'maria garcia');
INSERT INTO wp_cformsdata VALUES('5377', '200', 'City/State', 'lomita');
INSERT INTO wp_cformsdata VALUES('5378', '200', 'Phone', '310-325-6102');
INSERT INTO wp_cformsdata VALUES('5379', '200', 'Email', 'garcia6049@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('5380', '200', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('5381', '200', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5382', '200', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('5383', '200', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5384', '200', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5385', '200', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5386', '200', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5387', '200', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5388', '200', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5389', '200', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5390', '200', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5391', '200', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5392', '200', 'Is there pain, tingling, numbness, or weakness in your:', 'fingers');
INSERT INTO wp_cformsdata VALUES('5393', '200', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5394', '200', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5395', '200', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5396', '200', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5397', '200', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5398', '200', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5399', '200', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5400', '200', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('5401', '201', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5402', '201', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5403', '201', 'Name', 'Wilhelmina Castagnetto');
INSERT INTO wp_cformsdata VALUES('5404', '201', 'City/State', 'Cloverdale, CA');
INSERT INTO wp_cformsdata VALUES('5405', '201', 'Phone', '(707) 304-1170');
INSERT INTO wp_cformsdata VALUES('5406', '201', 'Email', 'wcastagnetto@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5407', '201', 'How did you hear about us?', 'Web search & link');
INSERT INTO wp_cformsdata VALUES('5408', '201', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5409', '201', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5410', '201', 'If yes, when did this occur?', 'Deg. Disc disease diagnosed 1996');
INSERT INTO wp_cformsdata VALUES('5411', '201', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5412', '201', 'Date of most recent scan', 'Have had cervical MRIs (1996,2002) new MRI ordered for lumbar 6/9/11');
INSERT INTO wp_cformsdata VALUES('5413', '201', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5414', '201', 'When did the pain begin?', 'Acute/Severe symptoms began 2 weeks ago');
INSERT INTO wp_cformsdata VALUES('5415', '201', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5416', '201', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5417', '201', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5418', '201', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5419', '201', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('5420', '201', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5421', '201', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5422', '201', 'Date of onset of pain?', 'Cervical decompression (3 x) 1997, 1999, 2001');
INSERT INTO wp_cformsdata VALUES('5423', '201', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5424', '201', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5425', '201', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5426', '201', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5427', '201', 'Comments, Questions', 'Xray shows large bone spur L-3, and severe herniated discs 2 levels lumbar, some \'scoliosis\' (sp?) .  I am petite, 115 lbs, have had mod- severe cervical pain since bike accident 1996.  I have had numbness in legs on/off 20 yrs ( broke R. leg in 2 places 1992 standing up from bed w/ numb leg..). This is a new \'pain\' never had before on L. Leg, hip, buttock.  Woke up 2 wks ago, and have 24/7 since.  Unable to walk more than a few minutes due to severe pain mostly in L. Calf (in front, feels like the shin bone us \'breaking\') have been to PCP, Chiropractor & Pain Spec. In past week.  Xray done 6/9 = MRI ordered asap.  Have excellent Health Insurance and Medical (perm disabled since 1998 due to cervical symptoms). see Pain specialist every 30 days.  this procedure sounds too- good- to- be-true!  Please help me walk again.');
INSERT INTO wp_cformsdata VALUES('5428', '202', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5429', '202', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5430', '202', 'Name', 'Michelle Medernach');
INSERT INTO wp_cformsdata VALUES('5431', '202', 'City/State', 'Saint Paul, Minnesota');
INSERT INTO wp_cformsdata VALUES('5432', '202', 'Phone', '651-688-6359');
INSERT INTO wp_cformsdata VALUES('5433', '202', 'Email', 's99mm8@hotmail.com');
INSERT INTO wp_cformsdata VALUES('5434', '202', 'How did you hear about us?', 'friend');
INSERT INTO wp_cformsdata VALUES('5435', '202', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5436', '202', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5437', '202', 'If yes, when did this occur?', 'Failed Ant/Post L4 L5 spinal fusion');
INSERT INTO wp_cformsdata VALUES('5438', '202', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5439', '202', 'Date of most recent scan', 'June 2010');
INSERT INTO wp_cformsdata VALUES('5440', '202', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5441', '202', 'When did the pain begin?', 'originally diagnosed as spondylolithesis');
INSERT INTO wp_cformsdata VALUES('5442', '202', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5443', '202', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5444', '202', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5445', '202', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5446', '202', 'Is there pain, tingling, numbness, or weakness in your:', 'feet');
INSERT INTO wp_cformsdata VALUES('5447', '202', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5448', '202', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5449', '202', 'Date of onset of pain?', 'see above/ Dec 2007');
INSERT INTO wp_cformsdata VALUES('5450', '202', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5451', '202', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5452', '202', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5453', '202', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('5454', '202', 'Comments, Questions', 'I believe the pain is a result of the fusion itself and perhaps the hardware.  Pain is most severe at the top of the fusion.  I also have a severe scar tissue problem which as been partially cleared up via massage.  I also have pain in the front tummy area primarily on the left side (scar side).  Pain is back is primarily on the left (scar) side.  
\nProlonged sitting and standing becomes unbearable.  Have not worked since surgery.  Walking increases the pain.');
INSERT INTO wp_cformsdata VALUES('5455', '203', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5456', '203', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5457', '203', 'Name', 'John W. Hebel');
INSERT INTO wp_cformsdata VALUES('5458', '203', 'City/State', 'San Diego');
INSERT INTO wp_cformsdata VALUES('5459', '203', 'Phone', '858-208-7556');
INSERT INTO wp_cformsdata VALUES('5460', '203', 'Email', 'jhebel2@hotmail.com');
INSERT INTO wp_cformsdata VALUES('5461', '203', 'How did you hear about us?', 'Dr. Bell 619-472-2225');
INSERT INTO wp_cformsdata VALUES('5462', '203', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5463', '203', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5464', '203', 'If yes, when did this occur?', '1990\'s');
INSERT INTO wp_cformsdata VALUES('5465', '203', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5466', '203', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('5467', '203', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5468', '203', 'When did the pain begin?', 'on going for years');
INSERT INTO wp_cformsdata VALUES('5469', '203', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5470', '203', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5471', '203', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5472', '203', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5473', '203', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs');
INSERT INTO wp_cformsdata VALUES('5474', '203', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5475', '203', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5476', '203', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5477', '203', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5478', '203', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5479', '203', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5480', '203', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5481', '203', 'Comments, Questions', 'Dr Bell Reviewed x-rays and recommeded you..I have 6 screws in L4-L5 and disc shinkage in L2-L3. I\'d contact and he can review my diagnosis, which included MyoVision static Graphic');
INSERT INTO wp_cformsdata VALUES('5482', '204', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5483', '204', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5484', '204', 'Name', 'wendy federer');
INSERT INTO wp_cformsdata VALUES('5485', '204', 'City/State', 'albany, ca');
INSERT INTO wp_cformsdata VALUES('5486', '204', 'Phone', '415 845 6846');
INSERT INTO wp_cformsdata VALUES('5487', '204', 'Email', 'meta4investments@gmail.com');
INSERT INTO wp_cformsdata VALUES('5488', '204', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('5489', '204', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5490', '204', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5491', '204', 'If yes, when did this occur?', 'april 2011');
INSERT INTO wp_cformsdata VALUES('5492', '204', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5493', '204', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5494', '204', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5495', '204', 'When did the pain begin?', 'april 2011');
INSERT INTO wp_cformsdata VALUES('5496', '204', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5497', '204', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5498', '204', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('5499', '204', 'If no, number of hours in pain', '18');
INSERT INTO wp_cformsdata VALUES('5500', '204', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5501', '204', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5502', '204', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5503', '204', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5504', '204', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5505', '204', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('5506', '204', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5507', '204', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5508', '204', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('5509', '205', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5510', '205', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5511', '205', 'Name', 'Joanne Slye');
INSERT INTO wp_cformsdata VALUES('5512', '205', 'City/State', 'Canada');
INSERT INTO wp_cformsdata VALUES('5513', '205', 'Phone', '416 456 9479');
INSERT INTO wp_cformsdata VALUES('5514', '205', 'Email', 'joannes@newyyz.com');
INSERT INTO wp_cformsdata VALUES('5515', '205', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('5516', '205', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5517', '205', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('5518', '205', 'If yes, when did this occur?', 'June 2009');
INSERT INTO wp_cformsdata VALUES('5519', '205', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5520', '205', 'Date of most recent scan', 'March 2011');
INSERT INTO wp_cformsdata VALUES('5521', '205', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5522', '205', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5523', '205', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5524', '205', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5525', '205', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5526', '205', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5527', '205', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('5528', '205', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5529', '205', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5530', '205', 'Date of onset of pain?', 'June 2009');
INSERT INTO wp_cformsdata VALUES('5531', '205', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5532', '205', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5533', '205', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5534', '205', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5535', '205', 'Comments, Questions', 'plus i have a new right hip.');
INSERT INTO wp_cformsdata VALUES('5536', '206', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5537', '206', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5538', '206', 'Name', 'John Neil Robertson');
INSERT INTO wp_cformsdata VALUES('5539', '206', 'City/State', 'Stirling, Central Scotland');
INSERT INTO wp_cformsdata VALUES('5540', '206', 'Phone', '+4401786447914');
INSERT INTO wp_cformsdata VALUES('5541', '206', 'Email', 'jomalo@talk21.com');
INSERT INTO wp_cformsdata VALUES('5542', '206', 'How did you hear about us?', 'Surfing the internet');
INSERT INTO wp_cformsdata VALUES('5543', '206', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5544', '206', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('5545', '206', 'If yes, when did this occur?', '(5) Five years ago.');
INSERT INTO wp_cformsdata VALUES('5546', '206', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5547', '206', 'Date of most recent scan', 'Not sure, but about 1 years ago.');
INSERT INTO wp_cformsdata VALUES('5548', '206', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('5549', '206', 'When did the pain begin?', 'Five years ago');
INSERT INTO wp_cformsdata VALUES('5550', '206', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5551', '206', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5552', '206', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5553', '206', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5554', '206', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('5555', '206', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5556', '206', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5557', '206', 'Date of onset of pain?', '5 years ago. No specific date though, sorry.');
INSERT INTO wp_cformsdata VALUES('5558', '206', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5559', '206', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5560', '206', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5561', '206', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5562', '206', 'Comments, Questions', 'My legs get very painful (siatica). Also, my legs go numb after a few minutes. That makes it very difficult to walk. I have fallen over before. The messages from my brain don\'t seem to get to my legs. No surgery because my mental health has not been good. Also, I do, unfurtuately, Smoke !!.  I understand that I am In the UK and that would make it extremely difficult for me to travel to you.  The expense would not allow me to travel at present.  I live on government benifits because I am unable to work.   With this in mind, I do hope I have not wasted your time.  This procedure looks so wonderful.  I suppose I will just put it on my wish list, lol.  Let me ask you, do you have a surgery in the UK?  Or is it the case the UK government won\'t allow it ?  That\'s typical of them.  If you do, please will you let me know about it.  This not only effects me, but has my wife and daughter as well.  I can see how they feel about me not being able to even cut the grass.  My wife has to do all that now. So, HELP MEEEE, lll    PLEASE !.  Any information you can send me will be so good.  Thank you,
\n
\nJohn.');
INSERT INTO wp_cformsdata VALUES('5563', '207', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5564', '207', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5565', '207', 'Name', 'Jane Giberson');
INSERT INTO wp_cformsdata VALUES('5566', '207', 'City/State', 'Morenci Michigan');
INSERT INTO wp_cformsdata VALUES('5567', '207', 'Phone', '5173950664');
INSERT INTO wp_cformsdata VALUES('5568', '207', 'Email', 'jane_cris_2006@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5569', '207', 'How did you hear about us?', 'youtube ');
INSERT INTO wp_cformsdata VALUES('5570', '207', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5571', '207', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('5572', '207', 'If yes, when did this occur?', '2008/2009');
INSERT INTO wp_cformsdata VALUES('5573', '207', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5574', '207', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('5575', '207', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5576', '207', 'When did the pain begin?', '2008/2009');
INSERT INTO wp_cformsdata VALUES('5577', '207', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5578', '207', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5579', '207', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5580', '207', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5581', '207', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('5582', '207', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5583', '207', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5584', '207', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5585', '207', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5586', '207', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5587', '207', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5588', '207', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5589', '207', 'Comments, Questions', 'Pain started when my son was about 6 months old.  I was put on tons of pills and still no relief.  Tried therapy, oral steriods, and many other things.  I am 22 years olds and just wanting some relief to play with my kids and enjoy my life. I was told that surgery was my last option for relief, but they said that it might not work. With me being so young I\'m not going to take the risk of it not helping. Is this something that could help me get my life back? ');
INSERT INTO wp_cformsdata VALUES('5590', '208', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5591', '208', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5592', '208', 'Name', 'TRACI FOX');
INSERT INTO wp_cformsdata VALUES('5593', '208', 'City/State', 'LAS VEGAS, NV');
INSERT INTO wp_cformsdata VALUES('5594', '208', 'Phone', '702-533-9293');
INSERT INTO wp_cformsdata VALUES('5595', '208', 'Email', 'CR8ZYCAKES@YAHOO.COM');
INSERT INTO wp_cformsdata VALUES('5596', '208', 'How did you hear about us?', 'YOU TUBE');
INSERT INTO wp_cformsdata VALUES('5597', '208', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5598', '208', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5599', '208', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5600', '208', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('5601', '208', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5602', '208', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5603', '208', 'When did the pain begin?', '1996');
INSERT INTO wp_cformsdata VALUES('5604', '208', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5605', '208', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5606', '208', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5607', '208', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5608', '208', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('5609', '208', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5610', '208', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5611', '208', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5612', '208', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5613', '208', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5614', '208', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5615', '208', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5616', '208', 'Comments, Questions', 'I HAVE JUST UNGONE A NERVE BLOCK EPIDERAL ONLY 1 MONTH AGO AND ALREADY THE PAIN IS BACK AND SEEMS MORE SEVERE. I REFUSE TO LIVE ON MEDICATION SO I SUFFER THROUGH THE PAIN EVERYDAY. I MISS OUT ON SOCIAL EVENTS WITH FRIENDS AND WITH MY KIDS OFTEN BECAUSE OF PAIN. I AM UNABLE TO EASILY PERFORM EVEYDAY TASKS. I HAVE REACHED A POINT WHERE I MUST DO SOMETHING TO ELEVIATE THE PAIN. IT AFFECTS MY JOB, MY PERSONALITY, MY SOCIAL LIFE, AND I HAVEN\'T SLEPT IN A BED FOR OVER 2 YEARS! PLEASE IF YOU CAN HELP, I WOULD LOVE TO SPEAK WITH YOU.');
INSERT INTO wp_cformsdata VALUES('5617', '209', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5618', '209', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5619', '209', 'Name', 'John Duong');
INSERT INTO wp_cformsdata VALUES('5620', '209', 'City/State', 'Los Angeles/CA');
INSERT INTO wp_cformsdata VALUES('5621', '209', 'Phone', '323 719-8873');
INSERT INTO wp_cformsdata VALUES('5622', '209', 'Email', 'rdly@ucsd.edu');
INSERT INTO wp_cformsdata VALUES('5623', '209', 'How did you hear about us?', 'You tube');
INSERT INTO wp_cformsdata VALUES('5624', '209', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5625', '209', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('5626', '209', 'If yes, when did this occur?', '1 year ago');
INSERT INTO wp_cformsdata VALUES('5627', '209', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5628', '209', 'Date of most recent scan', '1/11/11');
INSERT INTO wp_cformsdata VALUES('5629', '209', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5630', '209', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5631', '209', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5632', '209', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5633', '209', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5634', '209', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5635', '209', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs');
INSERT INTO wp_cformsdata VALUES('5636', '209', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5637', '209', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5638', '209', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5639', '209', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5640', '209', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5641', '209', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5642', '209', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5643', '209', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('5644', '210', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5645', '210', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5646', '210', 'Name', 'Ola Toole');
INSERT INTO wp_cformsdata VALUES('5647', '210', 'City/State', 'Pasadena Ca');
INSERT INTO wp_cformsdata VALUES('5648', '210', 'Phone', '818-968-5481');
INSERT INTO wp_cformsdata VALUES('5649', '210', 'Email', 'Olala628@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5650', '210', 'How did you hear about us?', 'radio station');
INSERT INTO wp_cformsdata VALUES('5651', '210', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5652', '210', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('5653', '210', 'If yes, when did this occur?', ' 2006 & 2009');
INSERT INTO wp_cformsdata VALUES('5654', '210', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5655', '210', 'Date of most recent scan', 'Oct. 2010');
INSERT INTO wp_cformsdata VALUES('5656', '210', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5657', '210', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5658', '210', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5659', '210', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5660', '210', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5661', '210', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5662', '210', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5663', '210', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5664', '210', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5665', '210', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5666', '210', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5667', '210', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5668', '210', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5669', '210', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5670', '210', 'Comments, Questions', 'I\'m using a cane or walker to help with stand straight to walk.  Have touble sleeping sometimes hard to lay down.  ');
INSERT INTO wp_cformsdata VALUES('5671', '211', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5672', '211', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5673', '211', 'Name', 'Chris j Gerdes');
INSERT INTO wp_cformsdata VALUES('5674', '211', 'City/State', 'SCHENECTADY');
INSERT INTO wp_cformsdata VALUES('5675', '211', 'Phone', '5189374423');
INSERT INTO wp_cformsdata VALUES('5676', '211', 'Email', 'mar777y@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5677', '211', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('5678', '211', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5679', '211', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5680', '211', 'If yes, when did this occur?', '1/20/05 also sacroiliac');
INSERT INTO wp_cformsdata VALUES('5681', '211', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5682', '211', 'Date of most recent scan', '2 years ago');
INSERT INTO wp_cformsdata VALUES('5683', '211', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5684', '211', 'When did the pain begin?', '1/20/05');
INSERT INTO wp_cformsdata VALUES('5685', '211', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('5686', '211', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5687', '211', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5688', '211', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5689', '211', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5690', '211', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5691', '211', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5692', '211', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5693', '211', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5694', '211', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5695', '211', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5696', '211', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5697', '211', 'Comments, Questions', 'I have low back pain, and a possible sacroiliac dysfunction and instability, and periformis muscle syndrome, facet pain syndrome, osterarthritis');
INSERT INTO wp_cformsdata VALUES('5698', '212', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5699', '212', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5700', '212', 'Name', 'Jim Cantale');
INSERT INTO wp_cformsdata VALUES('5701', '212', 'City/State', 'Desert Hot Springs,CA');
INSERT INTO wp_cformsdata VALUES('5702', '212', 'Phone', '760-671-6966');
INSERT INTO wp_cformsdata VALUES('5703', '212', 'Email', 'jcantale@earthlink.net');
INSERT INTO wp_cformsdata VALUES('5704', '212', 'How did you hear about us?', 'youtube video / INF Website');
INSERT INTO wp_cformsdata VALUES('5705', '212', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5706', '212', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('5707', '212', 'If yes, when did this occur?', 'Many years ago');
INSERT INTO wp_cformsdata VALUES('5708', '212', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5709', '212', 'Date of most recent scan', '5-7 yrs ago');
INSERT INTO wp_cformsdata VALUES('5710', '212', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5711', '212', 'When did the pain begin?', '3 weeks');
INSERT INTO wp_cformsdata VALUES('5712', '212', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5713', '212', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5714', '212', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5715', '212', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5716', '212', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,calves');
INSERT INTO wp_cformsdata VALUES('5717', '212', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5718', '212', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5719', '212', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5720', '212', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5721', '212', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5722', '212', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5723', '212', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5724', '212', 'Comments, Questions', 'Sciatic Pain in lower back and right Buttocks brought on by a bad chiropractic treatment.');
INSERT INTO wp_cformsdata VALUES('5725', '213', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5726', '213', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5727', '213', 'Name', 'Andrea Van Willigan');
INSERT INTO wp_cformsdata VALUES('5728', '213', 'City/State', 'Long Beach');
INSERT INTO wp_cformsdata VALUES('5729', '213', 'Phone', '9518094312');
INSERT INTO wp_cformsdata VALUES('5730', '213', 'Email', 'chefandivan@gmail.com');
INSERT INTO wp_cformsdata VALUES('5731', '213', 'How did you hear about us?', 'Web u tube ');
INSERT INTO wp_cformsdata VALUES('5732', '213', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5733', '213', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5734', '213', 'If yes, when did this occur?', 'Not sure have not had a MRI ');
INSERT INTO wp_cformsdata VALUES('5735', '213', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5736', '213', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5737', '213', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5738', '213', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('5739', '213', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5740', '213', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5741', '213', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('5742', '213', 'If no, number of hours in pain', '8 when I sleep');
INSERT INTO wp_cformsdata VALUES('5743', '213', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5744', '213', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5745', '213', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5746', '213', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5747', '213', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5748', '213', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5749', '213', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5750', '213', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5751', '213', 'Comments, Questions', 'I have had siatica pain for the last 2 months. I have tried everything acupuncture, physical therapy, stretching, muscle relaxers, cordizone...... I am 31 and used to be very active. I want my life back. ');
INSERT INTO wp_cformsdata VALUES('5752', '214', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5753', '214', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5754', '214', 'Name', 'Daniel Holscher');
INSERT INTO wp_cformsdata VALUES('5755', '214', 'City/State', 'Riverside');
INSERT INTO wp_cformsdata VALUES('5756', '214', 'Phone', '9097213207');
INSERT INTO wp_cformsdata VALUES('5757', '214', 'Email', 'f21310@hotmail.com');
INSERT INTO wp_cformsdata VALUES('5758', '214', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('5759', '214', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5760', '214', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5761', '214', 'If yes, when did this occur?', '4 years ago');
INSERT INTO wp_cformsdata VALUES('5762', '214', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5763', '214', 'Date of most recent scan', '11-2010');
INSERT INTO wp_cformsdata VALUES('5764', '214', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5765', '214', 'When did the pain begin?', '3 years ago');
INSERT INTO wp_cformsdata VALUES('5766', '214', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5767', '214', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5768', '214', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5769', '214', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5770', '214', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5771', '214', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5772', '214', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5773', '214', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5774', '214', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5775', '214', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('5776', '214', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5777', '214', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5778', '214', 'Comments, Questions', 'when I received a cat scan DR. said \"no herniated disc? The pain is very severe and recently has gotten worse. ');
INSERT INTO wp_cformsdata VALUES('5779', '215', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5780', '215', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5781', '215', 'Name', 'Uriel a Garcia');
INSERT INTO wp_cformsdata VALUES('5782', '215', 'City/State', 'highland ca');
INSERT INTO wp_cformsdata VALUES('5783', '215', 'Phone', '9098559031');
INSERT INTO wp_cformsdata VALUES('5784', '215', 'Email', 'udie_s13@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5785', '215', 'How did you hear about us?', 'Web searching ');
INSERT INTO wp_cformsdata VALUES('5786', '215', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5787', '215', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('5788', '215', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5789', '215', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5790', '215', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5791', '215', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('5792', '215', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('5793', '215', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5794', '215', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('5795', '215', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5796', '215', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5797', '215', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5798', '215', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5799', '215', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5800', '215', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5801', '215', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5802', '215', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5803', '215', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5804', '215', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5805', '215', 'Comments, Questions', 'The pain was alot worst about a all almost  a year ago. But now its been slightly better but the back of my calves and thigh and foot and butt have been bothering me so bad that it is effecting my work and I avoid stand on my right leg all day. Sitting down makes my back hurt. All my pain goes straight to my back. I\'ve been given motrin, vicoden, neproxen, tramedol, muscle relaxers,codeine. I have been to chiropractors, accupuncture, regular physicians and nothing at all has relieved any of the pain. I\'m really desperate I use to be a fun loving person and this pain has turned me into a a whole different unhappy grumpy man! Please help. Uriel Garcia ');
INSERT INTO wp_cformsdata VALUES('5806', '216', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5807', '216', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5808', '216', 'Name', 'Larry Zabar');
INSERT INTO wp_cformsdata VALUES('5809', '216', 'City/State', 'Swampscott, MA');
INSERT INTO wp_cformsdata VALUES('5810', '216', 'Phone', '6172812113');
INSERT INTO wp_cformsdata VALUES('5811', '216', 'Email', 'lzabar@newenglandcouncil.com');
INSERT INTO wp_cformsdata VALUES('5812', '216', 'How did you hear about us?', 'Google');
INSERT INTO wp_cformsdata VALUES('5813', '216', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5814', '216', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5815', '216', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5816', '216', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5817', '216', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5818', '216', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('5819', '216', 'When did the pain begin?', '3 weeks ago');
INSERT INTO wp_cformsdata VALUES('5820', '216', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5821', '216', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5822', '216', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5823', '216', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5824', '216', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('5825', '216', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5826', '216', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5827', '216', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5828', '216', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5829', '216', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('5830', '216', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5831', '216', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5832', '216', 'Comments, Questions', '3 Weeks into Sciatica - Lower right leg pain consistently throughout the day. Only time it doesn\'t hurt is lying down and not moving.  Sharp shooting pains throughout the leg. ');
INSERT INTO wp_cformsdata VALUES('5833', '217', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5834', '217', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5835', '217', 'Name', 'George Chan');
INSERT INTO wp_cformsdata VALUES('5836', '217', 'City/State', 'Skokie, Illinois');
INSERT INTO wp_cformsdata VALUES('5837', '217', 'Phone', '8473290328');
INSERT INTO wp_cformsdata VALUES('5838', '217', 'Email', 'pullsalot@yahoo.com');
INSERT INTO wp_cformsdata VALUES('5839', '217', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('5840', '217', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5841', '217', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5842', '217', 'If yes, when did this occur?', 'started 2008');
INSERT INTO wp_cformsdata VALUES('5843', '217', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5844', '217', 'Date of most recent scan', '2009?');
INSERT INTO wp_cformsdata VALUES('5845', '217', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('5846', '217', 'When did the pain begin?', '2008');
INSERT INTO wp_cformsdata VALUES('5847', '217', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5848', '217', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5849', '217', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('5850', '217', 'If no, number of hours in pain', '12');
INSERT INTO wp_cformsdata VALUES('5851', '217', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5852', '217', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5853', '217', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5854', '217', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5855', '217', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5856', '217', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('5857', '217', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5858', '217', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5859', '217', 'Comments, Questions', 'spondylolesthesis  and severe stenosis');
INSERT INTO wp_cformsdata VALUES('5860', '218', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5861', '218', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5862', '218', 'Name', 'craig Doe');
INSERT INTO wp_cformsdata VALUES('5863', '218', 'City/State', 'South Australia');
INSERT INTO wp_cformsdata VALUES('5864', '218', 'Phone', '08 86333 969');
INSERT INTO wp_cformsdata VALUES('5865', '218', 'Email', 'relax@thefoxhatcafe.com.au');
INSERT INTO wp_cformsdata VALUES('5866', '218', 'How did you hear about us?', 'Google');
INSERT INTO wp_cformsdata VALUES('5867', '218', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5868', '218', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5869', '218', 'If yes, when did this occur?', 'approx 20 yrs ago');
INSERT INTO wp_cformsdata VALUES('5870', '218', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5871', '218', 'Date of most recent scan', 'oct 2010');
INSERT INTO wp_cformsdata VALUES('5872', '218', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5873', '218', 'When did the pain begin?', 'approx 20yrs ago');
INSERT INTO wp_cformsdata VALUES('5874', '218', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5875', '218', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5876', '218', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5877', '218', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5878', '218', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,feet');
INSERT INTO wp_cformsdata VALUES('5879', '218', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5880', '218', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5881', '218', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5882', '218', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5883', '218', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5884', '218', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('5885', '218', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('5886', '218', 'Comments, Questions', 'Have tried rhizolysis and cortisone injections but no success.  Obviously I live in Australia, where is the closest practice for this treatment?');
INSERT INTO wp_cformsdata VALUES('5887', '219', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5888', '219', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5889', '219', 'Name', 'tony portillo');
INSERT INTO wp_cformsdata VALUES('5890', '219', 'City/State', 'covina   ca');
INSERT INTO wp_cformsdata VALUES('5891', '219', 'Phone', '626 290 1861');
INSERT INTO wp_cformsdata VALUES('5892', '219', 'Email', 'tbone4971@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('5893', '219', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('5894', '219', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5895', '219', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('5896', '219', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5897', '219', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5898', '219', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5899', '219', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('5900', '219', 'When did the pain begin?', 'last year');
INSERT INTO wp_cformsdata VALUES('5901', '219', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5902', '219', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5903', '219', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5904', '219', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5905', '219', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5906', '219', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5907', '219', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5908', '219', 'Date of onset of pain?', 'end of march');
INSERT INTO wp_cformsdata VALUES('5909', '219', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5910', '219', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5911', '219', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5912', '219', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5913', '219', 'Comments, Questions', 'want to know how much would it cost for the shot?  because i dont have insurance...');
INSERT INTO wp_cformsdata VALUES('5914', '220', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5915', '220', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5916', '220', 'Name', 'Elizabeth Joyce Toler');
INSERT INTO wp_cformsdata VALUES('5917', '220', 'City/State', 'Orange, California');
INSERT INTO wp_cformsdata VALUES('5918', '220', 'Phone', '714 272 5579');
INSERT INTO wp_cformsdata VALUES('5919', '220', 'Email', 'mmckenzie2@socal.rr.com');
INSERT INTO wp_cformsdata VALUES('5920', '220', 'How did you hear about us?', 'my ex husband!');
INSERT INTO wp_cformsdata VALUES('5921', '220', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5922', '220', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5923', '220', 'If yes, when did this occur?', 'severe scoliosis and deg.bone');
INSERT INTO wp_cformsdata VALUES('5924', '220', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5925', '220', 'Date of most recent scan', 'MRI l   6-11-11 at Hoag');
INSERT INTO wp_cformsdata VALUES('5926', '220', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('5927', '220', 'When did the pain begin?', 'years ago, spine compacted and fused');
INSERT INTO wp_cformsdata VALUES('5928', '220', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5929', '220', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5930', '220', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('5931', '220', 'If no, number of hours in pain', 'no pain as long as no moving/walking....');
INSERT INTO wp_cformsdata VALUES('5932', '220', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('5933', '220', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5934', '220', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5935', '220', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5936', '220', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('5937', '220', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5938', '220', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5939', '220', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5940', '220', 'Comments, Questions', 'I\'m 82 and was active until severe scoliosis set in.  I\'ve lost 6\" in height and doctor said surgery is not an option so we\'ve tried all sorts of epidurals and they no longer work. I need to walk, but it\'s too painful. I take 3 percocets daily and my pain level remains around 8\nI\'d give anything to get off these narcodics and be able to spend some quality time with my daughter. As it stands now, we can\'t go anywhere because I\'m always in pain, and I\'m all she\'s got........\n\nPlease, Please help me! Time get\'s more precious,when there\'s less of it to waste......\n\nSincerely\nJoyce Toler');
INSERT INTO wp_cformsdata VALUES('5941', '221', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5942', '221', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5943', '221', 'Name', 'Halina');
INSERT INTO wp_cformsdata VALUES('5944', '221', 'City/State', 'Orange/CA');
INSERT INTO wp_cformsdata VALUES('5945', '221', 'Phone', '7142890032');
INSERT INTO wp_cformsdata VALUES('5946', '221', 'Email', 'hgoetz05@hotmail.com');
INSERT INTO wp_cformsdata VALUES('5947', '221', 'How did you hear about us?', 'on the radio');
INSERT INTO wp_cformsdata VALUES('5948', '221', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5949', '221', 'Does the patient have', 'Bulging Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('5950', '221', 'If yes, when did this occur?', 'many years ago');
INSERT INTO wp_cformsdata VALUES('5951', '221', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5952', '221', 'Date of most recent scan', '3 years ago');
INSERT INTO wp_cformsdata VALUES('5953', '221', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('5954', '221', 'When did the pain begin?', 'many years ago');
INSERT INTO wp_cformsdata VALUES('5955', '221', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5956', '221', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5957', '221', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5958', '221', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5959', '221', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('5960', '221', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5961', '221', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5962', '221', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5963', '221', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5964', '221', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5965', '221', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5966', '221', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5967', '221', 'Comments, Questions', 'The patient has also fibromalagia, and chronic fatigue syndrome.');
INSERT INTO wp_cformsdata VALUES('5968', '222', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5969', '222', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5970', '222', 'Name', 'amy gomez');
INSERT INTO wp_cformsdata VALUES('5971', '222', 'City/State', 'westfield,ma');
INSERT INTO wp_cformsdata VALUES('5972', '222', 'Phone', '4133883956');
INSERT INTO wp_cformsdata VALUES('5973', '222', 'Email', 'mimi82284@aol.com');
INSERT INTO wp_cformsdata VALUES('5974', '222', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('5975', '222', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('5976', '222', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('5977', '222', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('5978', '222', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('5979', '222', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('5980', '222', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('5981', '222', 'When did the pain begin?', 'about 3 weeks ago');
INSERT INTO wp_cformsdata VALUES('5982', '222', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5983', '222', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('5984', '222', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5985', '222', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('5986', '222', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,calves,feet');
INSERT INTO wp_cformsdata VALUES('5987', '222', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('5988', '222', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('5989', '222', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('5990', '222', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5991', '222', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('5992', '222', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5993', '222', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('5994', '222', 'Comments, Questions', 'the only time i dont feel pain is if i am laying on my back.when i first wake up i feel fine,but once i sit to use the bathroom it starts again.please help me!!');
INSERT INTO wp_cformsdata VALUES('5995', '223', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('5996', '223', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('5997', '223', 'Name', 'Kevin Kesler');
INSERT INTO wp_cformsdata VALUES('5998', '223', 'City/State', 'Fountian Valley/CA');
INSERT INTO wp_cformsdata VALUES('5999', '223', 'Phone', '7147913860');
INSERT INTO wp_cformsdata VALUES('6000', '223', 'Email', 'keslerk@rocketmail.com');
INSERT INTO wp_cformsdata VALUES('6001', '223', 'How did you hear about us?', 'website');
INSERT INTO wp_cformsdata VALUES('6002', '223', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6003', '223', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('6004', '223', 'If yes, when did this occur?', 'Dec 2008');
INSERT INTO wp_cformsdata VALUES('6005', '223', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6006', '223', 'Date of most recent scan', 'May 2011');
INSERT INTO wp_cformsdata VALUES('6007', '223', 'Is there pain in:', 'Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('6008', '223', 'When did the pain begin?', 'Dec 2008');
INSERT INTO wp_cformsdata VALUES('6009', '223', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6010', '223', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6011', '223', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6012', '223', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6013', '223', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('6014', '223', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('6015', '223', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6016', '223', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6017', '223', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6018', '223', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6019', '223', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6020', '223', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6021', '223', 'Comments, Questions', 'EMG results show nerve pain comes from the neck and is not associated with arms (i.e ulnar nerve compression).');
INSERT INTO wp_cformsdata VALUES('6022', '224', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6023', '224', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6024', '224', 'Name', 'Justin Lee');
INSERT INTO wp_cformsdata VALUES('6025', '224', 'City/State', 'San Diego, ca');
INSERT INTO wp_cformsdata VALUES('6026', '224', 'Phone', '202-345-1651');
INSERT INTO wp_cformsdata VALUES('6027', '224', 'Email', 'Vcrindc@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6028', '224', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('6029', '224', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6030', '224', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('6031', '224', 'If yes, when did this occur?', 'Unsure');
INSERT INTO wp_cformsdata VALUES('6032', '224', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6033', '224', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6034', '224', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6035', '224', 'When did the pain begin?', 'January');
INSERT INTO wp_cformsdata VALUES('6036', '224', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6037', '224', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6038', '224', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6039', '224', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6040', '224', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('6041', '224', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6042', '224', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6043', '224', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6044', '224', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6045', '224', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6046', '224', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6047', '224', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6048', '224', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6049', '225', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6050', '225', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6051', '225', 'Name', 'Hamlet Geuvjehizian');
INSERT INTO wp_cformsdata VALUES('6052', '225', 'City/State', 'Glendale, CA');
INSERT INTO wp_cformsdata VALUES('6053', '225', 'Phone', '818-288-6198');
INSERT INTO wp_cformsdata VALUES('6054', '225', 'Email', 'hasmikhamlet@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6055', '225', 'How did you hear about us?', 'website');
INSERT INTO wp_cformsdata VALUES('6056', '225', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6057', '225', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6058', '225', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6059', '225', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('6060', '225', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6061', '225', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('6062', '225', 'When did the pain begin?', 'few years ago');
INSERT INTO wp_cformsdata VALUES('6063', '225', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6064', '225', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6065', '225', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6066', '225', 'If no, number of hours in pain', '10');
INSERT INTO wp_cformsdata VALUES('6067', '225', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('6068', '225', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6069', '225', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6070', '225', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6071', '225', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6072', '225', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6073', '225', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6074', '225', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6075', '225', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6076', '226', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6077', '226', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6078', '226', 'Name', 'Trace Klug');
INSERT INTO wp_cformsdata VALUES('6079', '226', 'City/State', 'Laguna beach, ca');
INSERT INTO wp_cformsdata VALUES('6080', '226', 'Phone', '949735-6343');
INSERT INTO wp_cformsdata VALUES('6081', '226', 'Email', 't@streaminghosting.com');
INSERT INTO wp_cformsdata VALUES('6082', '226', 'How did you hear about us?', 't@streaminghosting.com');
INSERT INTO wp_cformsdata VALUES('6083', '226', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6084', '226', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6085', '226', 'If yes, when did this occur?', 'chronic arthritis pain in neck and jaw causing severe  pain in the neck tissues');
INSERT INTO wp_cformsdata VALUES('6086', '226', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('6087', '226', 'Date of most recent scan', 'xrays in april of neck/  jaw in July');
INSERT INTO wp_cformsdata VALUES('6088', '226', 'Is there pain in:', 'Neck');
INSERT INTO wp_cformsdata VALUES('6089', '226', 'When did the pain begin?', '5 yrs ago');
INSERT INTO wp_cformsdata VALUES('6090', '226', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6091', '226', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6092', '226', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6093', '226', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6094', '226', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('6095', '226', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6096', '226', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6097', '226', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6098', '226', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6099', '226', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6100', '226', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6101', '226', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6102', '226', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6103', '227', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6104', '227', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6105', '227', 'Name', 'JOSE LUIS GONZALEZ');
INSERT INTO wp_cformsdata VALUES('6106', '227', 'City/State', 'LAS VEGAS NV');
INSERT INTO wp_cformsdata VALUES('6107', '227', 'Phone', '7022352610');
INSERT INTO wp_cformsdata VALUES('6108', '227', 'Email', '1970JGARCIA@GMAIL.COM');
INSERT INTO wp_cformsdata VALUES('6109', '227', 'How did you hear about us?', 'YOU TUBE');
INSERT INTO wp_cformsdata VALUES('6110', '227', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6111', '227', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('6112', '227', 'If yes, when did this occur?', '1997');
INSERT INTO wp_cformsdata VALUES('6113', '227', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6114', '227', 'Date of most recent scan', '6 YEARS ');
INSERT INTO wp_cformsdata VALUES('6115', '227', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6116', '227', 'When did the pain begin?', '14 YEARS ');
INSERT INTO wp_cformsdata VALUES('6117', '227', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6118', '227', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6119', '227', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6120', '227', 'If no, number of hours in pain', 'THE PAIN GET WORST WHEN IM SEATING DOWN');
INSERT INTO wp_cformsdata VALUES('6121', '227', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('6122', '227', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6123', '227', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6124', '227', 'Date of onset of pain?', 'I WAS PAIN FREE FOR TWO WEEKS AFTER THE SURGERY');
INSERT INTO wp_cformsdata VALUES('6125', '227', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6126', '227', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6127', '227', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6128', '227', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6129', '227', 'Comments, Questions', 'I WANT TO KNOW THE COST FOR THIS TRITMENT CALL ME AT 702 2352610');
INSERT INTO wp_cformsdata VALUES('6130', '228', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6131', '228', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6132', '228', 'Name', 'Denise Watts');
INSERT INTO wp_cformsdata VALUES('6133', '228', 'City/State', 'Graceville, Florida');
INSERT INTO wp_cformsdata VALUES('6134', '228', 'Phone', '817-965-5136');
INSERT INTO wp_cformsdata VALUES('6135', '228', 'Email', 'matthew25vs21@gmail.com');
INSERT INTO wp_cformsdata VALUES('6136', '228', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('6137', '228', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6138', '228', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6139', '228', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6140', '228', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6141', '228', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6142', '228', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('6143', '228', 'When did the pain begin?', '2002 after contracting Lyme');
INSERT INTO wp_cformsdata VALUES('6144', '228', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6145', '228', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6146', '228', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6147', '228', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6148', '228', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,arms');
INSERT INTO wp_cformsdata VALUES('6149', '228', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6150', '228', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6151', '228', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6152', '228', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6153', '228', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6154', '228', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6155', '228', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6156', '228', 'Comments, Questions', 'I contracted lyme in 2002 but not discovered until 2005. I have a lot of nerve pain as a result of the lyme. Healthy and completly painfree before Lyme. My Lyme is dormant not cured. It started with Sciatic pain 24/7 on left side, then moved to pain in shoulders and fingers. Sciatic pain has been daily since 2002 (I deal with it). Shoulders and fingers are intermentant but atleast 3Xweek. When I go to the doctors they just give me fibro type meds or a page of exercises to stretch scatic nerve areas. I take a lot of over the counter pain relievers. I have since dropped going to the doctor for this last 2 years. I saw the video and I am excited that this may help me. Is there a clinic near me where I can get treatment? Graceville Florida but largest city near me is Dothan Alabama.');
INSERT INTO wp_cformsdata VALUES('6157', '229', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6158', '229', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6159', '229', 'Name', 'Ramy Kaufler');
INSERT INTO wp_cformsdata VALUES('6160', '229', 'City/State', 'Encinitas/California');
INSERT INTO wp_cformsdata VALUES('6161', '229', 'Phone', '760-420-9212');
INSERT INTO wp_cformsdata VALUES('6162', '229', 'Email', 'rkaufler@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6163', '229', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('6164', '229', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6165', '229', 'Does the patient have', 'Bulging Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('6166', '229', 'If yes, when did this occur?', '2001');
INSERT INTO wp_cformsdata VALUES('6167', '229', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6168', '229', 'Date of most recent scan', '10/2010');
INSERT INTO wp_cformsdata VALUES('6169', '229', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6170', '229', 'When did the pain begin?', 'Relapse about 1 and 1/2 years ago');
INSERT INTO wp_cformsdata VALUES('6171', '229', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6172', '229', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6173', '229', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6174', '229', 'If no, number of hours in pain', '16');
INSERT INTO wp_cformsdata VALUES('6175', '229', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6176', '229', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6177', '229', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6178', '229', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6179', '229', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6180', '229', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6181', '229', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6182', '229', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6183', '229', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6184', '230', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6185', '230', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6186', '230', 'Name', 'Rimal Singh');
INSERT INTO wp_cformsdata VALUES('6187', '230', 'City/State', 'Irvine CA');
INSERT INTO wp_cformsdata VALUES('6188', '230', 'Phone', '949-351-7473');
INSERT INTO wp_cformsdata VALUES('6189', '230', 'Email', 'rimal.singh@gmail.com');
INSERT INTO wp_cformsdata VALUES('6190', '230', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('6191', '230', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6192', '230', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('6193', '230', 'If yes, when did this occur?', 'Dec 2009');
INSERT INTO wp_cformsdata VALUES('6194', '230', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6195', '230', 'Date of most recent scan', 'Early 2010');
INSERT INTO wp_cformsdata VALUES('6196', '230', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6197', '230', 'When did the pain begin?', 'Dec 2009');
INSERT INTO wp_cformsdata VALUES('6198', '230', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6199', '230', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6200', '230', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6201', '230', 'If no, number of hours in pain', '12 or more');
INSERT INTO wp_cformsdata VALUES('6202', '230', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs');
INSERT INTO wp_cformsdata VALUES('6203', '230', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6204', '230', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6205', '230', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6206', '230', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('6207', '230', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6208', '230', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6209', '230', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6210', '230', 'Comments, Questions', 'Pain get\'s worse with activity, starts out in the back and radiates down to the left ankle.');
INSERT INTO wp_cformsdata VALUES('6211', '231', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6212', '231', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6213', '231', 'Name', 'Enrique Maza');
INSERT INTO wp_cformsdata VALUES('6214', '231', 'City/State', 'Ventura, California');
INSERT INTO wp_cformsdata VALUES('6215', '231', 'Phone', '805-458-6262');
INSERT INTO wp_cformsdata VALUES('6216', '231', 'Email', 'enriquemaza10@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6217', '231', 'How did you hear about us?', 'internet video');
INSERT INTO wp_cformsdata VALUES('6218', '231', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6219', '231', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('6220', '231', 'If yes, when did this occur?', '6 years ago');
INSERT INTO wp_cformsdata VALUES('6221', '231', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6222', '231', 'Date of most recent scan', '06-22-2011');
INSERT INTO wp_cformsdata VALUES('6223', '231', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6224', '231', 'When did the pain begin?', '6 months ago');
INSERT INTO wp_cformsdata VALUES('6225', '231', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6226', '231', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6227', '231', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6228', '231', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6229', '231', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6230', '231', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6231', '231', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6232', '231', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6233', '231', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6234', '231', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6235', '231', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6236', '231', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6237', '231', 'Comments, Questions', 'Symptoms are identical to the patient featured on the sciatica video.');
INSERT INTO wp_cformsdata VALUES('6238', '232', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6239', '232', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6240', '232', 'Name', 'Yvonne Martinez');
INSERT INTO wp_cformsdata VALUES('6241', '232', 'City/State', 'Brownsville Texas');
INSERT INTO wp_cformsdata VALUES('6242', '232', 'Phone', '956-742-8106');
INSERT INTO wp_cformsdata VALUES('6243', '232', 'Email', 'ymartinez364@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6244', '232', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('6245', '232', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6246', '232', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6247', '232', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6248', '232', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6249', '232', 'Date of most recent scan', 'March 2011');
INSERT INTO wp_cformsdata VALUES('6250', '232', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6251', '232', 'When did the pain begin?', '2years');
INSERT INTO wp_cformsdata VALUES('6252', '232', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6253', '232', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6254', '232', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6255', '232', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6256', '232', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6257', '232', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6258', '232', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6259', '232', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6260', '232', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6261', '232', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6262', '232', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6263', '232', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6264', '232', 'Comments, Questions', 'I am not able to walk more than 15 minutes, I have to sit to get relief and If i sit down too long I also have pain, I need to sleep on my right side to get some relief,I need to bend foreward while sitting to get some relief as well. I have been taking pain medicne but still in pain. I have done a MRI and doctor referred me to a pain DR and physical therapy, however; I have seen the patient videos and I know this can help me. I just want the pain to go away, so I can live normal again.');
INSERT INTO wp_cformsdata VALUES('6265', '233', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6266', '233', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6267', '233', 'Name', 'Steve Dunham');
INSERT INTO wp_cformsdata VALUES('6268', '233', 'City/State', 'Westchester, Ca.');
INSERT INTO wp_cformsdata VALUES('6269', '233', 'Phone', '310 306-1119');
INSERT INTO wp_cformsdata VALUES('6270', '233', 'Email', 'dunhamsteve@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6271', '233', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('6272', '233', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6273', '233', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6274', '233', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6275', '233', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6276', '233', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6277', '233', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('6278', '233', 'When did the pain begin?', '6 months ago');
INSERT INTO wp_cformsdata VALUES('6279', '233', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6280', '233', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6281', '233', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6282', '233', 'If no, number of hours in pain', '3');
INSERT INTO wp_cformsdata VALUES('6283', '233', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('6284', '233', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6285', '233', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6286', '233', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6287', '233', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6288', '233', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('6289', '233', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6290', '233', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6291', '233', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6292', '234', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6293', '234', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6294', '234', 'Name', 'luis');
INSERT INTO wp_cformsdata VALUES('6295', '234', 'City/State', 'west covina, ca. 91791');
INSERT INTO wp_cformsdata VALUES('6296', '234', 'Phone', '626592-7459');
INSERT INTO wp_cformsdata VALUES('6297', '234', 'Email', 'proluisha@hotmail.com');
INSERT INTO wp_cformsdata VALUES('6298', '234', 'How did you hear about us?', 'FM Radio (101.1)');
INSERT INTO wp_cformsdata VALUES('6299', '234', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6300', '234', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('6301', '234', 'If yes, when did this occur?', 'Almost all the time but more when lifting heavy and not too heavy');
INSERT INTO wp_cformsdata VALUES('6302', '234', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6303', '234', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6304', '234', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6305', '234', 'When did the pain begin?', '4 yrs.');
INSERT INTO wp_cformsdata VALUES('6306', '234', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6307', '234', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6308', '234', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6309', '234', 'If no, number of hours in pain', '16 hours');
INSERT INTO wp_cformsdata VALUES('6310', '234', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs');
INSERT INTO wp_cformsdata VALUES('6311', '234', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6312', '234', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6313', '234', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6314', '234', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('6315', '234', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6316', '234', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6317', '234', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6318', '234', 'Comments, Questions', 'I have received only sporadic therapies and treatments combined with some medications. Thanks in advance for your attention.');
INSERT INTO wp_cformsdata VALUES('6319', '235', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6320', '235', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6321', '235', 'Name', 'sukhvinder   singh');
INSERT INTO wp_cformsdata VALUES('6322', '235', 'City/State', 'clute ,texas');
INSERT INTO wp_cformsdata VALUES('6323', '235', 'Phone', '832534982');
INSERT INTO wp_cformsdata VALUES('6324', '235', 'Email', 'parsukh@yahoo.co.in');
INSERT INTO wp_cformsdata VALUES('6325', '235', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('6326', '235', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6327', '235', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('6328', '235', 'If yes, when did this occur?', 'three year ago');
INSERT INTO wp_cformsdata VALUES('6329', '235', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6330', '235', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6331', '235', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6332', '235', 'When did the pain begin?', 'two week ago');
INSERT INTO wp_cformsdata VALUES('6333', '235', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6334', '235', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6335', '235', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6336', '235', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6337', '235', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('6338', '235', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6339', '235', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6340', '235', 'Date of onset of pain?', '09/19/2008');
INSERT INTO wp_cformsdata VALUES('6341', '235', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6342', '235', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6343', '235', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6344', '235', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6345', '235', 'Comments, Questions', 'three year ago i have a surgery in india   in  L4-L5   .AFTER THAT THERE IS NO PAIN   LAST YEAR THE PAIN COME AGAIN AND AFTER TAKING HYDROCLORODONE /DIAZPAM FOR A WEEK THE PAIN IS GONE   .NOW FROM  LAST TWO WEEK THE PAIN COME AGAIN THE DOCTOR GIVE ME PREDNISONE FOR  10 DAYS MELOXICAM FOR ONE MONTH   AND HYDROCLORODONE 750MG TWICE A DAY. THE IS NO PAIN AFTER 30 MIN WHEN I TAKE HYDROCLORODONE  .BUT AFTER 4 HOUR   THR PAIN COME AGAIN .THE PAIN OCCUR AT THE BACK NEAR L4 -L5   AND LEFT SIDE OF LEFT LEG BELOW THE KNEE.');
INSERT INTO wp_cformsdata VALUES('6346', '236', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6347', '236', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6348', '236', 'Name', 'tony portillo');
INSERT INTO wp_cformsdata VALUES('6349', '236', 'City/State', 'covina ca');
INSERT INTO wp_cformsdata VALUES('6350', '236', 'Phone', '626 290-1861');
INSERT INTO wp_cformsdata VALUES('6351', '236', 'Email', 'tbone4971@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('6352', '236', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('6353', '236', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6354', '236', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6355', '236', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6356', '236', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6357', '236', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6358', '236', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6359', '236', 'When did the pain begin?', 'march');
INSERT INTO wp_cformsdata VALUES('6360', '236', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6361', '236', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6362', '236', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6363', '236', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6364', '236', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6365', '236', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6366', '236', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6367', '236', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6368', '236', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6369', '236', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6370', '236', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6371', '236', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6372', '236', 'Comments, Questions', 'i dnt have insurance and im curious how much the treatment would cost?');
INSERT INTO wp_cformsdata VALUES('6373', '237', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6374', '237', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6375', '237', 'Name', 'Tony Russell');
INSERT INTO wp_cformsdata VALUES('6376', '237', 'City/State', 'Sydney');
INSERT INTO wp_cformsdata VALUES('6377', '237', 'Phone', '+61 404134963');
INSERT INTO wp_cformsdata VALUES('6378', '237', 'Email', 'russell58@iprimus.com.au');
INSERT INTO wp_cformsdata VALUES('6379', '237', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('6380', '237', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6381', '237', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('6382', '237', 'If yes, when did this occur?', '2001');
INSERT INTO wp_cformsdata VALUES('6383', '237', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('6384', '237', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('6385', '237', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6386', '237', 'When did the pain begin?', 'December 2001');
INSERT INTO wp_cformsdata VALUES('6387', '237', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6388', '237', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6389', '237', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6390', '237', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6391', '237', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6392', '237', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6393', '237', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6394', '237', 'Date of onset of pain?', '2004 - disc replacement L4/5 , L5/S1 ');
INSERT INTO wp_cformsdata VALUES('6395', '237', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6396', '237', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6397', '237', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6398', '237', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6399', '237', 'Comments, Questions', 'I was injured in December 2001, when run over by a tractor. I suffer bulging disc at 
\nCerivical Spine - bulging disc C4/5 & 5/6
\n
\nThoracic Spine
\nanterior wedge at T4 & T5
\ncompression fractures T6 -10, loss of height at T3( 50%),4,7 & 8.
\nbulging disc at T6/7 and lesser level at 8,9 &10.
\n
\nLumbar Spine - Replacement disc at L4/5 and L5/S1. 
\n
\nI\'m seeking relief from pain.
\n
\nHas the procedure been effective over the long term?
\n
\nRegards
\n
\nTony Russell');
INSERT INTO wp_cformsdata VALUES('6400', '238', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6401', '238', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6402', '238', 'Name', 'jack');
INSERT INTO wp_cformsdata VALUES('6403', '238', 'City/State', 'arleta');
INSERT INTO wp_cformsdata VALUES('6404', '238', 'Phone', '8185719748');
INSERT INTO wp_cformsdata VALUES('6405', '238', 'Email', 'mariorivera@live.com');
INSERT INTO wp_cformsdata VALUES('6406', '238', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('6407', '238', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6408', '238', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6409', '238', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6410', '238', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6411', '238', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6412', '238', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('6413', '238', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('6414', '238', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6415', '238', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6416', '238', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6417', '238', 'If no, number of hours in pain', '18');
INSERT INTO wp_cformsdata VALUES('6418', '238', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('6419', '238', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6420', '238', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6421', '238', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6422', '238', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6423', '238', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6424', '238', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6425', '238', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6426', '238', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6427', '239', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6428', '239', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6429', '239', 'Name', 'RICHARD GILBERT');
INSERT INTO wp_cformsdata VALUES('6430', '239', 'City/State', 'SAN CLEMENTE, CA');
INSERT INTO wp_cformsdata VALUES('6431', '239', 'Phone', '(949) 498-5356');
INSERT INTO wp_cformsdata VALUES('6432', '239', 'Email', 'mrpurple62@cox.net');
INSERT INTO wp_cformsdata VALUES('6433', '239', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('6434', '239', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6435', '239', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6436', '239', 'If yes, when did this occur?', 'Diagnosed in November 2010');
INSERT INTO wp_cformsdata VALUES('6437', '239', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6438', '239', 'Date of most recent scan', '06/04/2011');
INSERT INTO wp_cformsdata VALUES('6439', '239', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('6440', '239', 'When did the pain begin?', 'Severe pain November 2010');
INSERT INTO wp_cformsdata VALUES('6441', '239', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6442', '239', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6443', '239', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6444', '239', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6445', '239', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('6446', '239', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6447', '239', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6448', '239', 'Date of onset of pain?', 'Severe pain November 2010');
INSERT INTO wp_cformsdata VALUES('6449', '239', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('6450', '239', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6451', '239', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6452', '239', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6453', '239', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6454', '240', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6455', '240', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6456', '240', 'Name', 'Harish');
INSERT INTO wp_cformsdata VALUES('6457', '240', 'City/State', 'Bangalore, India');
INSERT INTO wp_cformsdata VALUES('6458', '240', 'Phone', '+91-9845616647');
INSERT INTO wp_cformsdata VALUES('6459', '240', 'Email', 'gharishkashyap@rediffmail.com');
INSERT INTO wp_cformsdata VALUES('6460', '240', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('6461', '240', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6462', '240', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6463', '240', 'If yes, when did this occur?', 'NA');
INSERT INTO wp_cformsdata VALUES('6464', '240', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6465', '240', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6466', '240', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6467', '240', 'When did the pain begin?', 'Pain in thigh, down the knee to the toes for the past 6 months');
INSERT INTO wp_cformsdata VALUES('6468', '240', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6469', '240', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6470', '240', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6471', '240', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6472', '240', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('6473', '240', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6474', '240', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6475', '240', 'Date of onset of pain?', 'January 2011');
INSERT INTO wp_cformsdata VALUES('6476', '240', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6477', '240', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6478', '240', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6479', '240', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6480', '240', 'Comments, Questions', 'I am from Bangalore, India. My mother has been suffering from severe sciatic pain for the past 6 months. I saw the videos of Perispinal Etanercept on the internet. My mother wants to have this treatment. Can she have this treatment here in India? Could you please give the address and contact information of physicians in India whom I can consult regarding this treatment who have taken training from you. Please suggest how to go about? We are very much interested in the treatment you provide for sciatic pain relief. Kindly reply at your earliest.
\n
\nThanks and regards
\n
\nHarish Kashyap
\nBangalore, India
\nE-mail: gharishkashyap@rediffmail.com
\nCell: +91-9845616647');
INSERT INTO wp_cformsdata VALUES('6481', '241', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6482', '241', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6483', '241', 'Name', 'Susanna Gatica');
INSERT INTO wp_cformsdata VALUES('6484', '241', 'City/State', 'San Antonio/Texas');
INSERT INTO wp_cformsdata VALUES('6485', '241', 'Phone', '210-547-0407');
INSERT INTO wp_cformsdata VALUES('6486', '241', 'Email', 'jdxx6@msn.com');
INSERT INTO wp_cformsdata VALUES('6487', '241', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('6488', '241', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6489', '241', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6490', '241', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6491', '241', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6492', '241', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6493', '241', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('6494', '241', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('6495', '241', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6496', '241', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6497', '241', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6498', '241', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6499', '241', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6500', '241', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6501', '241', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6502', '241', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6503', '241', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('6504', '241', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6505', '241', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6506', '241', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6507', '241', 'Comments, Questions', 'My wife hurt her back about 2 months ago and the pain has moved from her lower back down the right side of her leg i saw a video on youtube of a man describing his pain and it sound exactly as my wife describes it . Can you send me some info on your poduct  please. Thank you.');
INSERT INTO wp_cformsdata VALUES('6508', '242', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6509', '242', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6510', '242', 'Name', 'Bryan Thomas ');
INSERT INTO wp_cformsdata VALUES('6511', '242', 'City/State', 'Kutztown, Pa.');
INSERT INTO wp_cformsdata VALUES('6512', '242', 'Phone', '484-707-3904');
INSERT INTO wp_cformsdata VALUES('6513', '242', 'Email', 'tomtigertom@hometownu.com');
INSERT INTO wp_cformsdata VALUES('6514', '242', 'How did you hear about us?', 'web');
INSERT INTO wp_cformsdata VALUES('6515', '242', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6516', '242', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6517', '242', 'If yes, when did this occur?', 'pain began 1and a half years ago');
INSERT INTO wp_cformsdata VALUES('6518', '242', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6519', '242', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6520', '242', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('6521', '242', 'When did the pain begin?', 'above');
INSERT INTO wp_cformsdata VALUES('6522', '242', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6523', '242', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6524', '242', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6525', '242', 'If no, number of hours in pain', 'activity, not time related');
INSERT INTO wp_cformsdata VALUES('6526', '242', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6527', '242', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6528', '242', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6529', '242', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6530', '242', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6531', '242', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('6532', '242', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6533', '242', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6534', '242', 'Comments, Questions', 'Saw your info on the web.  Was a runner before this. Sciatica has taken away my stress relief.  Help! ');
INSERT INTO wp_cformsdata VALUES('6535', '243', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6536', '243', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6537', '243', 'Name', 'Nancy Bandura');
INSERT INTO wp_cformsdata VALUES('6538', '243', 'City/State', 'Moreno Valley, Ca  ');
INSERT INTO wp_cformsdata VALUES('6539', '243', 'Phone', '951 232 2601');
INSERT INTO wp_cformsdata VALUES('6540', '243', 'Email', 'princessnb52@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6541', '243', 'How did you hear about us?', 'friend');
INSERT INTO wp_cformsdata VALUES('6542', '243', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6543', '243', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6544', '243', 'If yes, when did this occur?', '10 yr ago or longer');
INSERT INTO wp_cformsdata VALUES('6545', '243', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6546', '243', 'Date of most recent scan', 'over 10 yrs');
INSERT INTO wp_cformsdata VALUES('6547', '243', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('6548', '243', 'When did the pain begin?', '8 months ago, it became worse after falling');
INSERT INTO wp_cformsdata VALUES('6549', '243', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6550', '243', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6551', '243', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6552', '243', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6553', '243', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6554', '243', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6555', '243', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6556', '243', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6557', '243', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6558', '243', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6559', '243', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6560', '243', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6561', '243', 'Comments, Questions', 'I get muscle spasm that wrap around my hips to chest & legs give out & I can\'t stand for hours. Had a nerve block in 2001, seems to be gone now. In Feb 2011, I fell straight down on a cement floor & did the splits landed on left side of butt. Now pain is severe to mild, changes daliy. I have severe cramps through-out my left leg down to toes with a pain in butt, knee hurt on left side everyday. Walking is only thing that helps. It seems like I have a knott or lump in my left butt, that never goes away. Dr. gave me 2 cortiz shots in hip, didnt do much. I have to work, so I try not to pay attention to the pain. I force myself      ');
INSERT INTO wp_cformsdata VALUES('6562', '244', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6563', '244', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6564', '244', 'Name', 'Gustavo Fajardo');
INSERT INTO wp_cformsdata VALUES('6565', '244', 'City/State', 'tijuana Baja California');
INSERT INTO wp_cformsdata VALUES('6566', '244', 'Phone', '664 6082155');
INSERT INTO wp_cformsdata VALUES('6567', '244', 'Email', 'gustavofajardo6@hotmail.com');
INSERT INTO wp_cformsdata VALUES('6568', '244', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('6569', '244', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6570', '244', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6571', '244', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6572', '244', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('6573', '244', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6574', '244', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('6575', '244', 'When did the pain begin?', '2 years ago');
INSERT INTO wp_cformsdata VALUES('6576', '244', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6577', '244', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6578', '244', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6579', '244', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6580', '244', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('6581', '244', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('6582', '244', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('6583', '244', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6584', '244', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6585', '244', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6586', '244', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('6587', '244', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6588', '244', 'Comments, Questions', 'hel me !!!!!!');
INSERT INTO wp_cformsdata VALUES('6589', '245', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6590', '245', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6591', '245', 'Name', 'christine sullivan');
INSERT INTO wp_cformsdata VALUES('6592', '245', 'City/State', 'australia');
INSERT INTO wp_cformsdata VALUES('6593', '245', 'Phone', '+61 413575103');
INSERT INTO wp_cformsdata VALUES('6594', '245', 'Email', 'accessto@hotmail.com');
INSERT INTO wp_cformsdata VALUES('6595', '245', 'How did you hear about us?', 'google search');
INSERT INTO wp_cformsdata VALUES('6596', '245', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6597', '245', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6598', '245', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6599', '245', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6600', '245', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6601', '245', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('6602', '245', 'When did the pain begin?', 'years');
INSERT INTO wp_cformsdata VALUES('6603', '245', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6604', '245', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6605', '245', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6606', '245', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6607', '245', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet,arms,fingers');
INSERT INTO wp_cformsdata VALUES('6608', '245', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6609', '245', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6610', '245', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6611', '245', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6612', '245', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6613', '245', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6614', '245', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6615', '245', 'Comments, Questions', 'can you please advise if there is a physician in australia that has undergone your training.  many thanks');
INSERT INTO wp_cformsdata VALUES('6616', '246', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6617', '246', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6618', '246', 'Name', 'carlos valencia');
INSERT INTO wp_cformsdata VALUES('6619', '246', 'City/State', 'van nuys ca');
INSERT INTO wp_cformsdata VALUES('6620', '246', 'Phone', '18189176168');
INSERT INTO wp_cformsdata VALUES('6621', '246', 'Email', 'cgsskinc@gmail.com');
INSERT INTO wp_cformsdata VALUES('6622', '246', 'How did you hear about us?', 'internet video');
INSERT INTO wp_cformsdata VALUES('6623', '246', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6624', '246', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6625', '246', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6626', '246', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6627', '246', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6628', '246', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6629', '246', 'When did the pain begin?', '1 month ago');
INSERT INTO wp_cformsdata VALUES('6630', '246', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6631', '246', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6632', '246', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6633', '246', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6634', '246', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('6635', '246', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6636', '246', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6637', '246', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6638', '246', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6639', '246', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6640', '246', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6641', '246', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6642', '246', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6643', '247', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6644', '247', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6645', '247', 'Name', 'mike');
INSERT INTO wp_cformsdata VALUES('6646', '247', 'City/State', 'sunrise beach mo');
INSERT INTO wp_cformsdata VALUES('6647', '247', 'Phone', '573-374-0144');
INSERT INTO wp_cformsdata VALUES('6648', '247', 'Email', 'office@riceconcrete.com');
INSERT INTO wp_cformsdata VALUES('6649', '247', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('6650', '247', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6651', '247', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6652', '247', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6653', '247', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6654', '247', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6655', '247', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('6656', '247', 'When did the pain begin?', 'march');
INSERT INTO wp_cformsdata VALUES('6657', '247', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6658', '247', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6659', '247', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6660', '247', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6661', '247', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('6662', '247', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6663', '247', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6664', '247', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6665', '247', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6666', '247', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6667', '247', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6668', '247', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6669', '247', 'Comments, Questions', 'left side in buttocks pain follows down to calf and thigh. Walking with a limp and left side leg falls asleep often.');
INSERT INTO wp_cformsdata VALUES('6670', '248', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6671', '248', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6672', '248', 'Name', 'Donna Ruiz');
INSERT INTO wp_cformsdata VALUES('6673', '248', 'City/State', 'Maywood CA');
INSERT INTO wp_cformsdata VALUES('6674', '248', 'Phone', '323-574-0997');
INSERT INTO wp_cformsdata VALUES('6675', '248', 'Email', 'odonaodona@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6676', '248', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('6677', '248', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6678', '248', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('6679', '248', 'If yes, when did this occur?', '5years 2006');
INSERT INTO wp_cformsdata VALUES('6680', '248', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6681', '248', 'Date of most recent scan', '1/2011');
INSERT INTO wp_cformsdata VALUES('6682', '248', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6683', '248', 'When did the pain begin?', '2006');
INSERT INTO wp_cformsdata VALUES('6684', '248', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6685', '248', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6686', '248', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6687', '248', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6688', '248', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6689', '248', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6690', '248', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6691', '248', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6692', '248', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('6693', '248', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6694', '248', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6695', '248', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6696', '248', 'Comments, Questions', 'will this be covered by insurance?');
INSERT INTO wp_cformsdata VALUES('6697', '249', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6698', '249', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6699', '249', 'Name', 'David Frazier');
INSERT INTO wp_cformsdata VALUES('6700', '249', 'City/State', 'Palmdale');
INSERT INTO wp_cformsdata VALUES('6701', '249', 'Phone', '6615333243');
INSERT INTO wp_cformsdata VALUES('6702', '249', 'Email', 'davidsfrazier@gmail.com');
INSERT INTO wp_cformsdata VALUES('6703', '249', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('6704', '249', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6705', '249', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6706', '249', 'If yes, when did this occur?', 'Not sure');
INSERT INTO wp_cformsdata VALUES('6707', '249', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6708', '249', 'Date of most recent scan', '04/10');
INSERT INTO wp_cformsdata VALUES('6709', '249', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6710', '249', 'When did the pain begin?', 'Disabled 4 years ago');
INSERT INTO wp_cformsdata VALUES('6711', '249', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6712', '249', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6713', '249', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6714', '249', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6715', '249', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('6716', '249', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6717', '249', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6718', '249', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6719', '249', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6720', '249', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6721', '249', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6722', '249', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6723', '249', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6724', '250', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6725', '250', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6726', '250', 'Name', 'gary');
INSERT INTO wp_cformsdata VALUES('6727', '250', 'City/State', 'cranston,rhode island');
INSERT INTO wp_cformsdata VALUES('6728', '250', 'Phone', '4019447777');
INSERT INTO wp_cformsdata VALUES('6729', '250', 'Email', 'mgm700@cox.net');
INSERT INTO wp_cformsdata VALUES('6730', '250', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('6731', '250', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6732', '250', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('6733', '250', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6734', '250', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6735', '250', 'Date of most recent scan', '7/6/11');
INSERT INTO wp_cformsdata VALUES('6736', '250', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('6737', '250', 'When did the pain begin?', '1 month ago');
INSERT INTO wp_cformsdata VALUES('6738', '250', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6739', '250', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6740', '250', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6741', '250', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6742', '250', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('6743', '250', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6744', '250', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6745', '250', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6746', '250', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6747', '250', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6748', '250', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('6749', '250', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6750', '250', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6751', '251', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6752', '251', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6753', '251', 'Name', 'luz e. castellanos');
INSERT INTO wp_cformsdata VALUES('6754', '251', 'City/State', 'perris, california');
INSERT INTO wp_cformsdata VALUES('6755', '251', 'Phone', '951.238.1869');
INSERT INTO wp_cformsdata VALUES('6756', '251', 'Email', 'ezekielc21@msn.com');
INSERT INTO wp_cformsdata VALUES('6757', '251', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('6758', '251', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6759', '251', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6760', '251', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6761', '251', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6762', '251', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6763', '251', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6764', '251', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('6765', '251', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6766', '251', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6767', '251', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6768', '251', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6769', '251', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6770', '251', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6771', '251', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6772', '251', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6773', '251', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6774', '251', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6775', '251', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6776', '251', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6777', '251', 'Comments, Questions', 'I SPEAK SPANISH A LOT BETTER THAN ENGLISH. THANK YOU.');
INSERT INTO wp_cformsdata VALUES('6778', '252', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6779', '252', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6780', '252', 'Name', 'John De Leon');
INSERT INTO wp_cformsdata VALUES('6781', '252', 'City/State', 'salt lake city, Utah');
INSERT INTO wp_cformsdata VALUES('6782', '252', 'Phone', '801-864-1971');
INSERT INTO wp_cformsdata VALUES('6783', '252', 'Email', 'priscilladeleon23@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6784', '252', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('6785', '252', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6786', '252', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6787', '252', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6788', '252', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6789', '252', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6790', '252', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('6791', '252', 'When did the pain begin?', '5/18/2011');
INSERT INTO wp_cformsdata VALUES('6792', '252', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6793', '252', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6794', '252', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6795', '252', 'If no, number of hours in pain', '18');
INSERT INTO wp_cformsdata VALUES('6796', '252', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('6797', '252', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6798', '252', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6799', '252', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6800', '252', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('6801', '252', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('6802', '252', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6803', '252', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6804', '252', 'Comments, Questions', 'i would like to know if i can use my medical insurance to cover for the treatment i receive from your clinic? ');
INSERT INTO wp_cformsdata VALUES('6805', '253', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6806', '253', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6807', '253', 'Name', 'ANTHONY DAHL');
INSERT INTO wp_cformsdata VALUES('6808', '253', 'City/State', 'LOS ANGELES, CA');
INSERT INTO wp_cformsdata VALUES('6809', '253', 'Phone', '(213) 309-3156');
INSERT INTO wp_cformsdata VALUES('6810', '253', 'Email', 'dahlanthony@gmail.com');
INSERT INTO wp_cformsdata VALUES('6811', '253', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('6812', '253', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6813', '253', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6814', '253', 'If yes, when did this occur?', '4/14/2009');
INSERT INTO wp_cformsdata VALUES('6815', '253', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6816', '253', 'Date of most recent scan', '7/8/2010');
INSERT INTO wp_cformsdata VALUES('6817', '253', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('6818', '253', 'When did the pain begin?', '4/1;/2009');
INSERT INTO wp_cformsdata VALUES('6819', '253', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6820', '253', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6821', '253', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6822', '253', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6823', '253', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('6824', '253', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6825', '253', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6826', '253', 'Date of onset of pain?', '4/14/2009');
INSERT INTO wp_cformsdata VALUES('6827', '253', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6828', '253', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6829', '253', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6830', '253', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6831', '253', 'Comments, Questions', 'The recommendation from the treating physician is: a decompressive lumbar laminectomy and facetectomy for nerve root decompression at the L-3-L4 and L4-L5 combined with instrumentation and fusion to stabilize the spine due to the extensive decompression required in the face of congenital and aquired stenosis.');
INSERT INTO wp_cformsdata VALUES('6832', '254', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6833', '254', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6834', '254', 'Name', 'Timothy Oguntayo');
INSERT INTO wp_cformsdata VALUES('6835', '254', 'City/State', 'Lagos, Nigeria');
INSERT INTO wp_cformsdata VALUES('6836', '254', 'Phone', '+234-803-549-0000');
INSERT INTO wp_cformsdata VALUES('6837', '254', 'Email', 'toguntayo@skyebankng.com');
INSERT INTO wp_cformsdata VALUES('6838', '254', 'How did you hear about us?', 'internet search');
INSERT INTO wp_cformsdata VALUES('6839', '254', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6840', '254', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6841', '254', 'If yes, when did this occur?', 'Not sure of what applies above, but i know it is sciatica pain since March 2011');
INSERT INTO wp_cformsdata VALUES('6842', '254', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6843', '254', 'Date of most recent scan', 'May 16, 2011');
INSERT INTO wp_cformsdata VALUES('6844', '254', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6845', '254', 'When did the pain begin?', 'March 2011');
INSERT INTO wp_cformsdata VALUES('6846', '254', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6847', '254', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6848', '254', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('6849', '254', 'If no, number of hours in pain', 'about 6hours on and off');
INSERT INTO wp_cformsdata VALUES('6850', '254', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('6851', '254', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6852', '254', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6853', '254', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6854', '254', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('6855', '254', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('6856', '254', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6857', '254', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6858', '254', 'Comments, Questions', 'there is pain on - and - off especially when getting up from a sitting position or climbing the stairs.\n\nIf it will help, i can send a copy each of the Scan and MRI images to you. From all the information that i have gathered about various forms of back pain, i am certain that what i suffer from is SCIATICA PAIN.');
INSERT INTO wp_cformsdata VALUES('6859', '255', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6860', '255', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6861', '255', 'Name', 'jerry acevedo');
INSERT INTO wp_cformsdata VALUES('6862', '255', 'City/State', 'houston,texas');
INSERT INTO wp_cformsdata VALUES('6863', '255', 'Phone', '281-414-1998');
INSERT INTO wp_cformsdata VALUES('6864', '255', 'Email', 'jacevedo50@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6865', '255', 'How did you hear about us?', 'web-site');
INSERT INTO wp_cformsdata VALUES('6866', '255', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6867', '255', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('6868', '255', 'If yes, when did this occur?', 'about 5 years ago');
INSERT INTO wp_cformsdata VALUES('6869', '255', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6870', '255', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6871', '255', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6872', '255', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('6873', '255', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6874', '255', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6875', '255', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6876', '255', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6877', '255', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet');
INSERT INTO wp_cformsdata VALUES('6878', '255', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6879', '255', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('6880', '255', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6881', '255', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6882', '255', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('6883', '255', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6884', '255', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6885', '255', 'Comments, Questions', 'the pain comes and goes,when I do anything that is phsical like picking-up something heavy it comes back. I had to quit several jobs because I could not take the pain any longer.I have a physical job that requires physical work all day long.  That is the only trade I know and the only trades that pays enough to where I can make a decent living. I have been home for a month now and the pain has almost gone away,but comes back any time I do anything physical. Another words I can not work or else I\'m right back where I started. And yes their have been times where I could not walk or use the r.r.');
INSERT INTO wp_cformsdata VALUES('6886', '256', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6887', '256', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6888', '256', 'Name', 'margo olson');
INSERT INTO wp_cformsdata VALUES('6889', '256', 'City/State', 'santa monica, ca 90401');
INSERT INTO wp_cformsdata VALUES('6890', '256', 'Phone', '310.699.1356');
INSERT INTO wp_cformsdata VALUES('6891', '256', 'Email', 'margaretolson631@gmail.com');
INSERT INTO wp_cformsdata VALUES('6892', '256', 'How did you hear about us?', '101.1fm gary bryant dj');
INSERT INTO wp_cformsdata VALUES('6893', '256', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6894', '256', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('6895', '256', 'If yes, when did this occur?', 'unk');
INSERT INTO wp_cformsdata VALUES('6896', '256', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('6897', '256', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6898', '256', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('6899', '256', 'When did the pain begin?', '101/11/2010');
INSERT INTO wp_cformsdata VALUES('6900', '256', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6901', '256', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6902', '256', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6903', '256', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6904', '256', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6905', '256', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6906', '256', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6907', '256', 'Date of onset of pain?', '10/11/2010');
INSERT INTO wp_cformsdata VALUES('6908', '256', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6909', '256', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6910', '256', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6911', '256', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6912', '256', 'Comments, Questions', 'please email me an appt-preferably or call (last choice) t/you! m olson');
INSERT INTO wp_cformsdata VALUES('6913', '257', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6914', '257', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6915', '257', 'Name', 'Robert Harding');
INSERT INTO wp_cformsdata VALUES('6916', '257', 'City/State', 'Orangevale  CA');
INSERT INTO wp_cformsdata VALUES('6917', '257', 'Phone', '916 225-6064');
INSERT INTO wp_cformsdata VALUES('6918', '257', 'Email', 'inthefire@comcast.net');
INSERT INTO wp_cformsdata VALUES('6919', '257', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('6920', '257', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6921', '257', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('6922', '257', 'If yes, when did this occur?', '1-2010');
INSERT INTO wp_cformsdata VALUES('6923', '257', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6924', '257', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('6925', '257', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('6926', '257', 'When did the pain begin?', 'year ago');
INSERT INTO wp_cformsdata VALUES('6927', '257', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6928', '257', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('6929', '257', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6930', '257', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6931', '257', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('6932', '257', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6933', '257', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6934', '257', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6935', '257', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6936', '257', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6937', '257', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6938', '257', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('6939', '257', 'Comments, Questions', 'I live in sacramento but im willing to drive to nearest office. Iv tried everything, I\'m not overweight im 28 firefighter who cant work because of the pain some days are better than others.');
INSERT INTO wp_cformsdata VALUES('6940', '258', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6941', '258', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6942', '258', 'Name', 'Alene Keenan');
INSERT INTO wp_cformsdata VALUES('6943', '258', 'City/State', 'Fort Lauderdale, FL');
INSERT INTO wp_cformsdata VALUES('6944', '258', 'Phone', '954-873-2869');
INSERT INTO wp_cformsdata VALUES('6945', '258', 'Email', 'alenekeenan@yahoo.com');
INSERT INTO wp_cformsdata VALUES('6946', '258', 'How did you hear about us?', 'YouTube video');
INSERT INTO wp_cformsdata VALUES('6947', '258', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6948', '258', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('6949', '258', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('6950', '258', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('6951', '258', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('6952', '258', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6953', '258', 'When did the pain begin?', '3 weeks ago');
INSERT INTO wp_cformsdata VALUES('6954', '258', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6955', '258', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6956', '258', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6957', '258', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6958', '258', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('6959', '258', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('6960', '258', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6961', '258', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6962', '258', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6963', '258', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6964', '258', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6965', '258', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6966', '258', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6967', '259', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6968', '259', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6969', '259', 'Name', 'Jerome Massey');
INSERT INTO wp_cformsdata VALUES('6970', '259', 'City/State', 'Alpharetta, Georgia');
INSERT INTO wp_cformsdata VALUES('6971', '259', 'Phone', '404-229-1256');
INSERT INTO wp_cformsdata VALUES('6972', '259', 'Email', 'jmassey007@gmail.com');
INSERT INTO wp_cformsdata VALUES('6973', '259', 'How did you hear about us?', 'google');
INSERT INTO wp_cformsdata VALUES('6974', '259', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('6975', '259', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('6976', '259', 'If yes, when did this occur?', '2008');
INSERT INTO wp_cformsdata VALUES('6977', '259', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6978', '259', 'Date of most recent scan', 'May, 2011');
INSERT INTO wp_cformsdata VALUES('6979', '259', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('6980', '259', 'When did the pain begin?', 'June 20, 2011');
INSERT INTO wp_cformsdata VALUES('6981', '259', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6982', '259', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('6983', '259', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6984', '259', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('6985', '259', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('6986', '259', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('6987', '259', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('6988', '259', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('6989', '259', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6990', '259', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6991', '259', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('6992', '259', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('6993', '259', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('6994', '260', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('6995', '260', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('6996', '260', 'Name', 'martha galindo');
INSERT INTO wp_cformsdata VALUES('6997', '260', 'City/State', 'long beach CA');
INSERT INTO wp_cformsdata VALUES('6998', '260', 'Phone', '562 900-1161');
INSERT INTO wp_cformsdata VALUES('6999', '260', 'Email', 'auram4@verizon.net');
INSERT INTO wp_cformsdata VALUES('7000', '260', 'How did you hear about us?', 'KEarth101');
INSERT INTO wp_cformsdata VALUES('7001', '260', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7002', '260', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7003', '260', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7004', '260', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7005', '260', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7006', '260', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('7007', '260', 'When did the pain begin?', 'about 10 years');
INSERT INTO wp_cformsdata VALUES('7008', '260', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7009', '260', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7010', '260', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7011', '260', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7012', '260', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('7013', '260', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7014', '260', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7015', '260', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7016', '260', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('7017', '260', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7018', '260', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7019', '260', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7020', '260', 'Comments, Questions', 'tired of pain, doctors give only pain pills that lower the pain but pain is always there, with time pain is getting worst that pills don\'t work anymore. I don\'t know what to do anymore, I HAVE CHANGE DOCTORS and by what I tell them, they said it might be arthritis, but they haven\'t done any studies or test, I think it might be the sciatic nerve. i NEED HELP, CAN\'T STAND THE PAIN ANYMORE, THERE ARE NIGHTS I CAN\'T SLEEP, TOO MUCH PAIN!');
INSERT INTO wp_cformsdata VALUES('7021', '261', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7022', '261', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7023', '261', 'Name', 'Jerry Faragalli');
INSERT INTO wp_cformsdata VALUES('7024', '261', 'City/State', 'Lake Elsinore');
INSERT INTO wp_cformsdata VALUES('7025', '261', 'Phone', '(714) 421-0891');
INSERT INTO wp_cformsdata VALUES('7026', '261', 'Email', 'goldcoastjerry@earthlink.net');
INSERT INTO wp_cformsdata VALUES('7027', '261', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('7028', '261', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7029', '261', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7030', '261', 'If yes, when did this occur?', '1977');
INSERT INTO wp_cformsdata VALUES('7031', '261', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7032', '261', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7033', '261', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7034', '261', 'When did the pain begin?', '1977');
INSERT INTO wp_cformsdata VALUES('7035', '261', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7036', '261', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7037', '261', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7038', '261', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7039', '261', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('7040', '261', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7041', '261', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7042', '261', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7043', '261', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7044', '261', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7045', '261', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7046', '261', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7047', '261', 'Comments, Questions', 'Pain has become more severe in my right hip and right knee.');
INSERT INTO wp_cformsdata VALUES('7048', '262', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7049', '262', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7050', '262', 'Name', 'monica caballero');
INSERT INTO wp_cformsdata VALUES('7051', '262', 'City/State', 'merced ca,');
INSERT INTO wp_cformsdata VALUES('7052', '262', 'Phone', '209-676-4402');
INSERT INTO wp_cformsdata VALUES('7053', '262', 'Email', 'monica2091978@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7054', '262', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('7055', '262', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7056', '262', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7057', '262', 'If yes, when did this occur?', '2 months');
INSERT INTO wp_cformsdata VALUES('7058', '262', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7059', '262', 'Date of most recent scan', '7-22-11');
INSERT INTO wp_cformsdata VALUES('7060', '262', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7061', '262', 'When did the pain begin?', '2 months');
INSERT INTO wp_cformsdata VALUES('7062', '262', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7063', '262', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7064', '262', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7065', '262', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7066', '262', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('7067', '262', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7068', '262', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7069', '262', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7070', '262', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7071', '262', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7072', '262', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7073', '262', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7074', '262', 'Comments, Questions', 'i need help please call!!!');
INSERT INTO wp_cformsdata VALUES('7075', '263', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7076', '263', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7077', '263', 'Name', 'John Dodd');
INSERT INTO wp_cformsdata VALUES('7078', '263', 'City/State', 'Morris IL');
INSERT INTO wp_cformsdata VALUES('7079', '263', 'Phone', '815-661-1711');
INSERT INTO wp_cformsdata VALUES('7080', '263', 'Email', 'Thunder361@aol.com');
INSERT INTO wp_cformsdata VALUES('7081', '263', 'How did you hear about us?', 'website');
INSERT INTO wp_cformsdata VALUES('7082', '263', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7083', '263', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7084', '263', 'If yes, when did this occur?', '4 months ago');
INSERT INTO wp_cformsdata VALUES('7085', '263', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7086', '263', 'Date of most recent scan', 'x-rays');
INSERT INTO wp_cformsdata VALUES('7087', '263', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7088', '263', 'When did the pain begin?', 'lower back now Butt and L legs lower leg');
INSERT INTO wp_cformsdata VALUES('7089', '263', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7090', '263', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7091', '263', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7092', '263', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7093', '263', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,calves');
INSERT INTO wp_cformsdata VALUES('7094', '263', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7095', '263', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7096', '263', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7097', '263', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7098', '263', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7099', '263', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7100', '263', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('7101', '263', 'Comments, Questions', 'I see your out in CA, is there anyhere in IL to have this done and the cost? I do not have insurance but at the same time I cant handle this pain, I only sleep a few hrs a night and only somewhat better when standing up. Can you help me please. ');
INSERT INTO wp_cformsdata VALUES('7102', '264', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7103', '264', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7104', '264', 'Name', 'Anna Garrett');
INSERT INTO wp_cformsdata VALUES('7105', '264', 'City/State', 'N.C.');
INSERT INTO wp_cformsdata VALUES('7106', '264', 'Phone', '252-746-9197');
INSERT INTO wp_cformsdata VALUES('7107', '264', 'Email', 'aydenanna@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7108', '264', 'How did you hear about us?', 'facebook');
INSERT INTO wp_cformsdata VALUES('7109', '264', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7110', '264', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7111', '264', 'If yes, when did this occur?', '05');
INSERT INTO wp_cformsdata VALUES('7112', '264', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7113', '264', 'Date of most recent scan', '05');
INSERT INTO wp_cformsdata VALUES('7114', '264', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7115', '264', 'When did the pain begin?', '05');
INSERT INTO wp_cformsdata VALUES('7116', '264', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7117', '264', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7118', '264', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7119', '264', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7120', '264', 'Is there pain, tingling, numbness, or weakness in your:', 'feet');
INSERT INTO wp_cformsdata VALUES('7121', '264', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7122', '264', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7123', '264', 'Date of onset of pain?', '05');
INSERT INTO wp_cformsdata VALUES('7124', '264', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('7125', '264', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7126', '264', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7127', '264', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7128', '264', 'Comments, Questions', 'I  HAVE HAD RSD SINCE 05 AFTER NERVE DAMAGE DURING BACK SURGERY.AM NOW ON MEDS. AND AFTER SEEING THESE PEOPLE HAVE THIS PROCEDURE CALLED PERISPINAL ETANERCEPT AND NOW PAIN FREE THIS OF COURSE IS WHAT I WANT. RIGHT FOOT VERY PAINFUL AND NUMB.SOMETIMES I JUST CAN NOT WALK ANYMORE AND I HAVE TERRIBLE ELECTRIC SHOCKS GO THROUGH MY FOOT, THIS IS WHAT I CALL IT. THANKS, ANNA GARRETT');
INSERT INTO wp_cformsdata VALUES('7129', '265', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7130', '265', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7131', '265', 'Name', 'Frank Gonzalez');
INSERT INTO wp_cformsdata VALUES('7132', '265', 'City/State', 'chino ca');
INSERT INTO wp_cformsdata VALUES('7133', '265', 'Phone', '323-816-2827');
INSERT INTO wp_cformsdata VALUES('7134', '265', 'Email', 'fgonzalezpd@aol.com');
INSERT INTO wp_cformsdata VALUES('7135', '265', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('7136', '265', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7137', '265', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7138', '265', 'If yes, when did this occur?', 'On off for past 4 years');
INSERT INTO wp_cformsdata VALUES('7139', '265', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7140', '265', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7141', '265', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7142', '265', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('7143', '265', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7144', '265', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7145', '265', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7146', '265', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7147', '265', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7148', '265', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7149', '265', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7150', '265', 'Date of onset of pain?', '07-19-2011');
INSERT INTO wp_cformsdata VALUES('7151', '265', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7152', '265', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7153', '265', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7154', '265', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7155', '265', 'Comments, Questions', 'Please please help. The pain is horrible. I need to get better to get back to work');
INSERT INTO wp_cformsdata VALUES('7156', '266', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7157', '266', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7158', '266', 'Name', 'krozky libed');
INSERT INTO wp_cformsdata VALUES('7159', '266', 'City/State', 'glendale, ca');
INSERT INTO wp_cformsdata VALUES('7160', '266', 'Phone', '818-2919540');
INSERT INTO wp_cformsdata VALUES('7161', '266', 'Email', 'guggle123@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7162', '266', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('7163', '266', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7164', '266', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7165', '266', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7166', '266', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7167', '266', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7168', '266', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('7169', '266', 'When did the pain begin?', 'july 1, 2011');
INSERT INTO wp_cformsdata VALUES('7170', '266', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7171', '266', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7172', '266', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7173', '266', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7174', '266', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('7175', '266', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7176', '266', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7177', '266', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7178', '266', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('7179', '266', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7180', '266', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7181', '266', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7182', '266', 'Comments, Questions', 'im a single mother and might loss my job because of the pain.  im presently taken vicodin prescribed from usc hospital but the after effect cause not to think properly in terms of my work.\n\npls help me to handle this severe back pain and live normal life and work as well.');
INSERT INTO wp_cformsdata VALUES('7183', '267', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7184', '267', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7185', '267', 'Name', 'elin rodriguez');
INSERT INTO wp_cformsdata VALUES('7186', '267', 'City/State', 'staten island new york , 10305');
INSERT INTO wp_cformsdata VALUES('7187', '267', 'Phone', '917-889-4615');
INSERT INTO wp_cformsdata VALUES('7188', '267', 'Email', 'erodriguez210305@hotmail.com');
INSERT INTO wp_cformsdata VALUES('7189', '267', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('7190', '267', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7191', '267', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7192', '267', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7193', '267', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7194', '267', 'Date of most recent scan', '07-05-2011');
INSERT INTO wp_cformsdata VALUES('7195', '267', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7196', '267', 'When did the pain begin?', 'february. 2011');
INSERT INTO wp_cformsdata VALUES('7197', '267', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7198', '267', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7199', '267', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7200', '267', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7201', '267', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('7202', '267', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7203', '267', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7204', '267', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7205', '267', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7206', '267', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7207', '267', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7208', '267', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7209', '267', 'Comments, Questions', 'i some time i cant walk and work, cant sleep pain 24/7 ');
INSERT INTO wp_cformsdata VALUES('7210', '268', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7211', '268', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7212', '268', 'Name', 'Beth Featheringill');
INSERT INTO wp_cformsdata VALUES('7213', '268', 'City/State', 'Indianapolis, IN');
INSERT INTO wp_cformsdata VALUES('7214', '268', 'Phone', '317-289-7876');
INSERT INTO wp_cformsdata VALUES('7215', '268', 'Email', 'aussiesmom5100@comcast.net');
INSERT INTO wp_cformsdata VALUES('7216', '268', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('7217', '268', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7218', '268', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7219', '268', 'If yes, when did this occur?', '2001, 2008, 2009');
INSERT INTO wp_cformsdata VALUES('7220', '268', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7221', '268', 'Date of most recent scan', '11-2010');
INSERT INTO wp_cformsdata VALUES('7222', '268', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7223', '268', 'When did the pain begin?', '12/09');
INSERT INTO wp_cformsdata VALUES('7224', '268', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7225', '268', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7226', '268', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7227', '268', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7228', '268', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7229', '268', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7230', '268', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7231', '268', 'Date of onset of pain?', '12/09');
INSERT INTO wp_cformsdata VALUES('7232', '268', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7233', '268', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7234', '268', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7235', '268', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7236', '268', 'Comments, Questions', 'I am at the end of my rope.  The ONLY slight relief I have had since 12/09 is from a few 5 day doses of Toradol. This pain is unbearable.  I\'ve had multiple injections, surgery, rehab, you name it. I would like to know what this would cost so I can start raising the money now.');
INSERT INTO wp_cformsdata VALUES('7237', '269', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7238', '269', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7239', '269', 'Name', 'Baila Romm');
INSERT INTO wp_cformsdata VALUES('7240', '269', 'City/State', 'Los Angeles, CA');
INSERT INTO wp_cformsdata VALUES('7241', '269', 'Phone', '310-553-8560');
INSERT INTO wp_cformsdata VALUES('7242', '269', 'Email', 'rommbomm@gmail.com');
INSERT INTO wp_cformsdata VALUES('7243', '269', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('7244', '269', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7245', '269', 'Does the patient have', 'Herniated Disc,Bulging Disc,Annular tear');
INSERT INTO wp_cformsdata VALUES('7246', '269', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7247', '269', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7248', '269', 'Date of most recent scan', '2011');
INSERT INTO wp_cformsdata VALUES('7249', '269', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('7250', '269', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('7251', '269', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7252', '269', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7253', '269', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7254', '269', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7255', '269', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('7256', '269', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7257', '269', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7258', '269', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7259', '269', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7260', '269', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7261', '269', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7262', '269', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('7263', '269', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7264', '270', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_4');
INSERT INTO wp_cformsdata VALUES('7265', '270', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7266', '270', 'Name', 'Sylvia Rushbrooke');
INSERT INTO wp_cformsdata VALUES('7267', '270', 'City/State', 'London');
INSERT INTO wp_cformsdata VALUES('7268', '270', 'Phone', '00442077872227');
INSERT INTO wp_cformsdata VALUES('7269', '270', 'Email', 'info@quecumbar.co.uk');
INSERT INTO wp_cformsdata VALUES('7270', '270', 'How did you hear about us?', 'searched for sciatica relief');
INSERT INTO wp_cformsdata VALUES('7271', '270', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7272', '270', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7273', '270', 'If yes, when did this occur?', '6 years ');
INSERT INTO wp_cformsdata VALUES('7274', '270', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7275', '270', 'Date of most recent scan', 'last week');
INSERT INTO wp_cformsdata VALUES('7276', '270', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7277', '270', 'When did the pain begin?', '9 weeks ago ');
INSERT INTO wp_cformsdata VALUES('7278', '270', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7279', '270', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7280', '270', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7281', '270', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7282', '270', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs,legs');
INSERT INTO wp_cformsdata VALUES('7283', '270', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7284', '270', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7285', '270', 'Date of onset of pain?', '9 weeks ago ');
INSERT INTO wp_cformsdata VALUES('7286', '270', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7287', '270', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7288', '270', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7289', '270', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7290', '270', 'Comments, Questions', 'Please advise wher eot get this treatment in UK my mother of 86 has sciatica and they just keep giving her drugs that don\'t work - she said the pain makes her want to die  - please help ');
INSERT INTO wp_cformsdata VALUES('7291', '271', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7292', '271', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7293', '271', 'Name', 'Randy Bakker');
INSERT INTO wp_cformsdata VALUES('7294', '271', 'City/State', 'surrey BC Canada');
INSERT INTO wp_cformsdata VALUES('7295', '271', 'Phone', '604-763-1485');
INSERT INTO wp_cformsdata VALUES('7296', '271', 'Email', 'randybakker1758@hotmail.com');
INSERT INTO wp_cformsdata VALUES('7297', '271', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('7298', '271', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7299', '271', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7300', '271', 'If yes, when did this occur?', 'After car accident years ago');
INSERT INTO wp_cformsdata VALUES('7301', '271', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7302', '271', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7303', '271', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('7304', '271', 'When did the pain begin?', 'After car accident ');
INSERT INTO wp_cformsdata VALUES('7305', '271', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7306', '271', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7307', '271', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7308', '271', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7309', '271', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7310', '271', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7311', '271', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7312', '271', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7313', '271', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7314', '271', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7315', '271', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7316', '271', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7317', '271', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7318', '272', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_2');
INSERT INTO wp_cformsdata VALUES('7319', '272', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7320', '272', 'Name', 'Louis Dauria');
INSERT INTO wp_cformsdata VALUES('7321', '272', 'City/State', 'sparks NV 89436');
INSERT INTO wp_cformsdata VALUES('7322', '272', 'Phone', '847 404 9135');
INSERT INTO wp_cformsdata VALUES('7323', '272', 'Email', 'eplus@aol.com');
INSERT INTO wp_cformsdata VALUES('7324', '272', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('7325', '272', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7326', '272', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7327', '272', 'If yes, when did this occur?', '2010');
INSERT INTO wp_cformsdata VALUES('7328', '272', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7329', '272', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('7330', '272', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7331', '272', 'When did the pain begin?', '6/11');
INSERT INTO wp_cformsdata VALUES('7332', '272', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7333', '272', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7334', '272', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7335', '272', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7336', '272', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('7337', '272', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7338', '272', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7339', '272', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7340', '272', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7341', '272', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7342', '272', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7343', '272', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7344', '272', 'Comments, Questions', 'Need to know average cost for patient procedures over past year so can determine if patient can go forward');
INSERT INTO wp_cformsdata VALUES('7345', '273', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7346', '273', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7347', '273', 'Name', 'MAUNG TIN HLA');
INSERT INTO wp_cformsdata VALUES('7348', '273', 'City/State', 'SAN DIEGO, CA');
INSERT INTO wp_cformsdata VALUES('7349', '273', 'Phone', '858-455-2519');
INSERT INTO wp_cformsdata VALUES('7350', '273', 'Email', 'maungtinhla2000@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7351', '273', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('7352', '273', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7353', '273', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7354', '273', 'If yes, when did this occur?', 'a few years ago');
INSERT INTO wp_cformsdata VALUES('7355', '273', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7356', '273', 'Date of most recent scan', '7/30/2011');
INSERT INTO wp_cformsdata VALUES('7357', '273', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7358', '273', 'When did the pain begin?', 'a year ago');
INSERT INTO wp_cformsdata VALUES('7359', '273', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('7360', '273', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7361', '273', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7362', '273', 'If no, number of hours in pain', '14 hours');
INSERT INTO wp_cformsdata VALUES('7363', '273', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet,hands,fingers');
INSERT INTO wp_cformsdata VALUES('7364', '273', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7365', '273', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7366', '273', 'Date of onset of pain?', '7/10/2011');
INSERT INTO wp_cformsdata VALUES('7367', '273', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7368', '273', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7369', '273', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7370', '273', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7371', '273', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7372', '274', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7373', '274', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7374', '274', 'Name', 'manjinder singh');
INSERT INTO wp_cformsdata VALUES('7375', '274', 'City/State', 'india');
INSERT INTO wp_cformsdata VALUES('7376', '274', 'Phone', '+918146879777');
INSERT INTO wp_cformsdata VALUES('7377', '274', 'Email', 'rahaljatt@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7378', '274', 'How did you hear about us?', 'on internet');
INSERT INTO wp_cformsdata VALUES('7379', '274', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7380', '274', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7381', '274', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7382', '274', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7383', '274', 'Date of most recent scan', '28 nov 2010');
INSERT INTO wp_cformsdata VALUES('7384', '274', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('7385', '274', 'When did the pain begin?', 'before one year');
INSERT INTO wp_cformsdata VALUES('7386', '274', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7387', '274', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('7388', '274', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7389', '274', 'If no, number of hours in pain', '10 15 hours');
INSERT INTO wp_cformsdata VALUES('7390', '274', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7391', '274', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7392', '274', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7393', '274', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7394', '274', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('7395', '274', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('7396', '274', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7397', '274', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('7398', '274', 'Comments, Questions', 'how can i get rid from this pain???');
INSERT INTO wp_cformsdata VALUES('7399', '275', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7400', '275', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7401', '275', 'Name', 'Krishna Shah');
INSERT INTO wp_cformsdata VALUES('7402', '275', 'City/State', 'Ladera Ranch,  CA');
INSERT INTO wp_cformsdata VALUES('7403', '275', 'Phone', '949-364-5814');
INSERT INTO wp_cformsdata VALUES('7404', '275', 'Email', 'krishney1@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7405', '275', 'How did you hear about us?', '');
INSERT INTO wp_cformsdata VALUES('7406', '275', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7407', '275', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7408', '275', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7409', '275', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7410', '275', 'Date of most recent scan', 'February 2011');
INSERT INTO wp_cformsdata VALUES('7411', '275', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7412', '275', 'When did the pain begin?', 'October 2010');
INSERT INTO wp_cformsdata VALUES('7413', '275', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7414', '275', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7415', '275', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7416', '275', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7417', '275', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,feet');
INSERT INTO wp_cformsdata VALUES('7418', '275', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7419', '275', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7420', '275', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7421', '275', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('7422', '275', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7423', '275', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7424', '275', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7425', '275', 'Comments, Questions', 'Doctor said I have stenosis and need Epidural injection, but I need better opinion...');
INSERT INTO wp_cformsdata VALUES('7426', '276', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7427', '276', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7428', '276', 'Name', 'sam carrubba');
INSERT INTO wp_cformsdata VALUES('7429', '276', 'City/State', 'colorado springs,colorado');
INSERT INTO wp_cformsdata VALUES('7430', '276', 'Phone', '719-646-4324');
INSERT INTO wp_cformsdata VALUES('7431', '276', 'Email', 'samsea1@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7432', '276', 'How did you hear about us?', 'online search');
INSERT INTO wp_cformsdata VALUES('7433', '276', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7434', '276', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7435', '276', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7436', '276', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7437', '276', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7438', '276', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7439', '276', 'When did the pain begin?', '2 weeks');
INSERT INTO wp_cformsdata VALUES('7440', '276', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7441', '276', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7442', '276', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7443', '276', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7444', '276', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('7445', '276', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7446', '276', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7447', '276', 'Date of onset of pain?', 'approx. 7/15');
INSERT INTO wp_cformsdata VALUES('7448', '276', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7449', '276', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7450', '276', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7451', '276', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7452', '276', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7453', '277', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7454', '277', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7455', '277', 'Name', 'Joseph Reinhart');
INSERT INTO wp_cformsdata VALUES('7456', '277', 'City/State', 'San Bernardino, CA');
INSERT INTO wp_cformsdata VALUES('7457', '277', 'Phone', '951-515-2648');
INSERT INTO wp_cformsdata VALUES('7458', '277', 'Email', 'jadecivic@msn.com');
INSERT INTO wp_cformsdata VALUES('7459', '277', 'How did you hear about us?', 'youtube video');
INSERT INTO wp_cformsdata VALUES('7460', '277', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7461', '277', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7462', '277', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7463', '277', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('7464', '277', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7465', '277', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7466', '277', 'When did the pain begin?', 'back');
INSERT INTO wp_cformsdata VALUES('7467', '277', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7468', '277', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7469', '277', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7470', '277', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7471', '277', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7472', '277', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7473', '277', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7474', '277', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7475', '277', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7476', '277', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7477', '277', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7478', '277', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7479', '277', 'Comments, Questions', 'One of my only questions is what\'s the cost on the shot?  I\'m very interested because I\'ve been in pain for over 6 months now and it\'s getting worse, I\'m now having numbness in my calf and foot.  ');
INSERT INTO wp_cformsdata VALUES('7480', '278', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7481', '278', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7482', '278', 'Name', 'rafal kozak');
INSERT INTO wp_cformsdata VALUES('7483', '278', 'City/State', 'selden ny');
INSERT INTO wp_cformsdata VALUES('7484', '278', 'Phone', '6312454844');
INSERT INTO wp_cformsdata VALUES('7485', '278', 'Email', 'snwbrd85@hotmail.com');
INSERT INTO wp_cformsdata VALUES('7486', '278', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('7487', '278', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7488', '278', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7489', '278', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7490', '278', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7491', '278', 'Date of most recent scan', '8/6/2011');
INSERT INTO wp_cformsdata VALUES('7492', '278', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7493', '278', 'When did the pain begin?', '5/1/2011');
INSERT INTO wp_cformsdata VALUES('7494', '278', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7495', '278', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7496', '278', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7497', '278', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7498', '278', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,calves');
INSERT INTO wp_cformsdata VALUES('7499', '278', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7500', '278', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7501', '278', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7502', '278', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('7503', '278', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7504', '278', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7505', '278', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7506', '278', 'Comments, Questions', 'it is the scietic nurve that hurts please call me back at my number i have a couple of questions for you about how i could be helped ');
INSERT INTO wp_cformsdata VALUES('7507', '279', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7508', '279', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7509', '279', 'Name', 'brock harvell');
INSERT INTO wp_cformsdata VALUES('7510', '279', 'City/State', 'las cruces/nm');
INSERT INTO wp_cformsdata VALUES('7511', '279', 'Phone', '5756409318');
INSERT INTO wp_cformsdata VALUES('7512', '279', 'Email', 'b.harvell@exite.com');
INSERT INTO wp_cformsdata VALUES('7513', '279', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('7514', '279', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7515', '279', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7516', '279', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7517', '279', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7518', '279', 'Date of most recent scan', 'negitve');
INSERT INTO wp_cformsdata VALUES('7519', '279', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7520', '279', 'When did the pain begin?', 'several months to a year ago');
INSERT INTO wp_cformsdata VALUES('7521', '279', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7522', '279', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7523', '279', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7524', '279', 'If no, number of hours in pain', '1/2 day');
INSERT INTO wp_cformsdata VALUES('7525', '279', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,feet');
INSERT INTO wp_cformsdata VALUES('7526', '279', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7527', '279', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7528', '279', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7529', '279', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7530', '279', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7531', '279', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7532', '279', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7533', '279', 'Comments, Questions', 'right buttics up to mid lower back is the worst pain.
\nthigh tingles.
\nboth big toes have been tingleing for over a year.');
INSERT INTO wp_cformsdata VALUES('7534', '280', 'page', 'http://www.painbreakthrough.com/request-consultation/#cf_field_5');
INSERT INTO wp_cformsdata VALUES('7535', '280', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7536', '280', 'Name', 'H Kirby Skavdahl');
INSERT INTO wp_cformsdata VALUES('7537', '280', 'City/State', 'Richland,  WA');
INSERT INTO wp_cformsdata VALUES('7538', '280', 'Phone', '509 539 3878');
INSERT INTO wp_cformsdata VALUES('7539', '280', 'Email', 'skavdahldds@aol.com');
INSERT INTO wp_cformsdata VALUES('7540', '280', 'How did you hear about us?', 'internet article research');
INSERT INTO wp_cformsdata VALUES('7541', '280', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7542', '280', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7543', '280', 'If yes, when did this occur?', 'July 30, 2011');
INSERT INTO wp_cformsdata VALUES('7544', '280', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7545', '280', 'Date of most recent scan', 'July 31, 2011');
INSERT INTO wp_cformsdata VALUES('7546', '280', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7547', '280', 'When did the pain begin?', 'immediately after water skiing');
INSERT INTO wp_cformsdata VALUES('7548', '280', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7549', '280', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7550', '280', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7551', '280', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7552', '280', 'Is there pain, tingling, numbness, or weakness in your:', 'thighs');
INSERT INTO wp_cformsdata VALUES('7553', '280', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7554', '280', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7555', '280', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7556', '280', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7557', '280', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7558', '280', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7559', '280', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7560', '280', 'Comments, Questions', 'trying to decide on surgery to decompress nerve or try your technique. please call
\nme at 509 539 3878. thx  Dr Skavdahl');
INSERT INTO wp_cformsdata VALUES('7561', '281', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7562', '281', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7563', '281', 'Name', 'Olga');
INSERT INTO wp_cformsdata VALUES('7564', '281', 'City/State', 'Chula Vista ca.');
INSERT INTO wp_cformsdata VALUES('7565', '281', 'Phone', '619)6918358');
INSERT INTO wp_cformsdata VALUES('7566', '281', 'Email', 'olgapey25@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7567', '281', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('7568', '281', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7569', '281', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7570', '281', 'If yes, when did this occur?', 'Facitis plantal y laxitud ligamntaria de ambs tobillos');
INSERT INTO wp_cformsdata VALUES('7571', '281', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('7572', '281', 'Date of most recent scan', 'Tres meses');
INSERT INTO wp_cformsdata VALUES('7573', '281', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('7574', '281', 'When did the pain begin?', 'Ano y medio');
INSERT INTO wp_cformsdata VALUES('7575', '281', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7576', '281', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7577', '281', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7578', '281', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7579', '281', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,feet');
INSERT INTO wp_cformsdata VALUES('7580', '281', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7581', '281', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7582', '281', 'Date of onset of pain?', 'Marzo/10');
INSERT INTO wp_cformsdata VALUES('7583', '281', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7584', '281', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7585', '281', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7586', '281', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7587', '281', 'Comments, Questions', 'Me gustaria saber si el dr. Podria ayudarme en mi prblema pues me encuentro desesperada uso baston alrededor de tres ans empeze con el nervio ciatico y hace ano y medio me hize un esguince en el pie izq. Me pusieron medi bota yeso y cuando me la quitaron no pude dar paso,fui a diferentes terapias ultrasonido,luz infrarroja, medicamento de todos, corticoides,terapia fisica y acupuntura que es la que me quito el dolor de catica pero segui con la facitis hasta hoy. Empeze una teapia que se llama proloterapia peo al ver lo que hace dr. Me gustaria saber si yo soy candidata a lo que usted inyecta y si me ayudaria a mi problema. Quiciea saber cuanto cesta la consulta con este tratamiento y si tabien son terapias o es unicmente una vez , espero su respuesta de antemano muchas gracias. Vivo en Chula Vista Ca . Gracias');
INSERT INTO wp_cformsdata VALUES('7588', '282', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7589', '282', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7590', '282', 'Name', 'Sharellis');
INSERT INTO wp_cformsdata VALUES('7591', '282', 'City/State', 'Glendale, CA');
INSERT INTO wp_cformsdata VALUES('7592', '282', 'Phone', '8184220087');
INSERT INTO wp_cformsdata VALUES('7593', '282', 'Email', 'sharellis@me.com');
INSERT INTO wp_cformsdata VALUES('7594', '282', 'How did you hear about us?', 'Google');
INSERT INTO wp_cformsdata VALUES('7595', '282', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7596', '282', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7597', '282', 'If yes, when did this occur?', 'March 2011');
INSERT INTO wp_cformsdata VALUES('7598', '282', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7599', '282', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7600', '282', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('7601', '282', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('7602', '282', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7603', '282', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7604', '282', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7605', '282', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7606', '282', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('7607', '282', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7608', '282', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7609', '282', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7610', '282', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7611', '282', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7612', '282', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7613', '282', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7614', '282', 'Comments, Questions', 'I have been going to physical therapy and a doctor via worker\'s comp and the pain is still there. It\'s been 5 months and I can\'t take it anymore! Please, help!');
INSERT INTO wp_cformsdata VALUES('7615', '283', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7616', '283', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7617', '283', 'Name', 'Bethel Picker');
INSERT INTO wp_cformsdata VALUES('7618', '283', 'City/State', 'st louis missouri');
INSERT INTO wp_cformsdata VALUES('7619', '283', 'Phone', '314-9094931');
INSERT INTO wp_cformsdata VALUES('7620', '283', 'Email', 'jaymauman@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('7621', '283', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('7622', '283', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7623', '283', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7624', '283', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7625', '283', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7626', '283', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7627', '283', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7628', '283', 'When did the pain begin?', '2 months');
INSERT INTO wp_cformsdata VALUES('7629', '283', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7630', '283', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7631', '283', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7632', '283', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7633', '283', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('7634', '283', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7635', '283', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7636', '283', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7637', '283', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7638', '283', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7639', '283', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7640', '283', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7641', '283', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7642', '284', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7643', '284', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7644', '284', 'Name', 'tim rus');
INSERT INTO wp_cformsdata VALUES('7645', '284', 'City/State', 'seattle, wa');
INSERT INTO wp_cformsdata VALUES('7646', '284', 'Phone', '425-242-8214');
INSERT INTO wp_cformsdata VALUES('7647', '284', 'Email', 'timthetechnician@gmail.com');
INSERT INTO wp_cformsdata VALUES('7648', '284', 'How did you hear about us?', 'Google Search');
INSERT INTO wp_cformsdata VALUES('7649', '284', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7650', '284', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7651', '284', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7652', '284', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7653', '284', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7654', '284', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7655', '284', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('7656', '284', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7657', '284', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7658', '284', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7659', '284', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7660', '284', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('7661', '284', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7662', '284', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7663', '284', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7664', '284', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7665', '284', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7666', '284', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7667', '284', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7668', '284', 'Comments, Questions', 'severe Pain in lower back and hips; worst after waking up or sitting for long periods of time
\nPain severity is somewhat less while standing.  
\nIt is very difficult to sleep
\nmy muscles seem to be very tense in the area of pain
\nI can temporarily reduce pain by doing streatches, but the pain comes back every time
\n
\nWhat is the price for perispinal etanercept for Sciatica without insurance.
\nHow long is the treatment expected to last
\n');
INSERT INTO wp_cformsdata VALUES('7669', '285', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7670', '285', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7671', '285', 'Name', 'Paul Haas');
INSERT INTO wp_cformsdata VALUES('7672', '285', 'City/State', 'Sacramento, Ca');
INSERT INTO wp_cformsdata VALUES('7673', '285', 'Phone', '805-455-4417');
INSERT INTO wp_cformsdata VALUES('7674', '285', 'Email', 'psispeed@gmail.com');
INSERT INTO wp_cformsdata VALUES('7675', '285', 'How did you hear about us?', 'Youtube');
INSERT INTO wp_cformsdata VALUES('7676', '285', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7677', '285', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7678', '285', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7679', '285', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7680', '285', 'Date of most recent scan', '5 months ago');
INSERT INTO wp_cformsdata VALUES('7681', '285', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7682', '285', 'When did the pain begin?', '3 months ago');
INSERT INTO wp_cformsdata VALUES('7683', '285', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7684', '285', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7685', '285', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7686', '285', 'If no, number of hours in pain', '4');
INSERT INTO wp_cformsdata VALUES('7687', '285', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('7688', '285', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7689', '285', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7690', '285', 'Date of onset of pain?', '2 years back pain');
INSERT INTO wp_cformsdata VALUES('7691', '285', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7692', '285', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7693', '285', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7694', '285', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7695', '285', 'Comments, Questions', 'I have had minor lower back pain for many years, which in the last 3 months has developed into a severe sciatica/piriformis syndrome. MRI of lower back showed no spinal issues, so condition may be muscular/posture related. I did not see any details if the method of pain relief on this site would help address my condition, but would be interested in a consultation to discuss the details.');
INSERT INTO wp_cformsdata VALUES('7696', '286', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7697', '286', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7698', '286', 'Name', 'Stacci Guzman');
INSERT INTO wp_cformsdata VALUES('7699', '286', 'City/State', 'Bell,CA');
INSERT INTO wp_cformsdata VALUES('7700', '286', 'Phone', '323)841-0142');
INSERT INTO wp_cformsdata VALUES('7701', '286', 'Email', 'staccig08@gmail.com');
INSERT INTO wp_cformsdata VALUES('7702', '286', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('7703', '286', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7704', '286', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7705', '286', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7706', '286', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7707', '286', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7708', '286', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7709', '286', 'When did the pain begin?', 'Oct. 2010');
INSERT INTO wp_cformsdata VALUES('7710', '286', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7711', '286', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7712', '286', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7713', '286', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7714', '286', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7715', '286', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7716', '286', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7717', '286', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7718', '286', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7719', '286', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7720', '286', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7721', '286', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7722', '286', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7723', '287', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7724', '287', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7725', '287', 'Name', 'ayad');
INSERT INTO wp_cformsdata VALUES('7726', '287', 'City/State', 'baghdad');
INSERT INTO wp_cformsdata VALUES('7727', '287', 'Phone', '009647800465678');
INSERT INTO wp_cformsdata VALUES('7728', '287', 'Email', 'ayad1_igc@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7729', '287', 'How did you hear about us?', 'email-ytube.com');
INSERT INTO wp_cformsdata VALUES('7730', '287', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7731', '287', 'Does the patient have', 'Herniated Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('7732', '287', 'If yes, when did this occur?', 'befor 2 years');
INSERT INTO wp_cformsdata VALUES('7733', '287', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7734', '287', 'Date of most recent scan', '1 year befor');
INSERT INTO wp_cformsdata VALUES('7735', '287', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('7736', '287', 'When did the pain begin?', '2years');
INSERT INTO wp_cformsdata VALUES('7737', '287', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('7738', '287', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7739', '287', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7740', '287', 'If no, number of hours in pain', '15 hr /day when he come - he stay 1month every 3 month and back approxiemtly');
INSERT INTO wp_cformsdata VALUES('7741', '287', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('7742', '287', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7743', '287', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7744', '287', 'Date of onset of pain?', '2years ago - and he stay 1month and move and back every 3month approximetly');
INSERT INTO wp_cformsdata VALUES('7745', '287', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7746', '287', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7747', '287', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7748', '287', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7749', '287', 'Comments, Questions', 'Dear Sir
\n1.	Do you have branch in Iraq or any country near the Iraq?
\n2.	Dose this (Anti-TNF) dices take every couple month or only one?
\n3.	Is the any side affect for this treatment?
\nWaiting your answer 
\n
\nAyad Mohsen 
\n');
INSERT INTO wp_cformsdata VALUES('7750', '288', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7751', '288', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7752', '288', 'Name', 'RAUL CAUDILLO');
INSERT INTO wp_cformsdata VALUES('7753', '288', 'City/State', 'SOUTH PASADENA CA');
INSERT INTO wp_cformsdata VALUES('7754', '288', 'Phone', '626/441/1609');
INSERT INTO wp_cformsdata VALUES('7755', '288', 'Email', 'francescaudillo@hotmail.com');
INSERT INTO wp_cformsdata VALUES('7756', '288', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('7757', '288', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7758', '288', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7759', '288', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7760', '288', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7761', '288', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7762', '288', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7763', '288', 'When did the pain begin?', 'four years');
INSERT INTO wp_cformsdata VALUES('7764', '288', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7765', '288', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7766', '288', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7767', '288', 'If no, number of hours in pain', 'all day');
INSERT INTO wp_cformsdata VALUES('7768', '288', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('7769', '288', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7770', '288', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7771', '288', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7772', '288', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7773', '288', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7774', '288', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7775', '288', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7776', '288', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7777', '289', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7778', '289', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7779', '289', 'Name', 'Jordan Deseno');
INSERT INTO wp_cformsdata VALUES('7780', '289', 'City/State', 'Malibu/CA');
INSERT INTO wp_cformsdata VALUES('7781', '289', 'Phone', '760.315.6888');
INSERT INTO wp_cformsdata VALUES('7782', '289', 'Email', 'Jordan.Deseno@gmail.com');
INSERT INTO wp_cformsdata VALUES('7783', '289', 'How did you hear about us?', 'Referred by friend');
INSERT INTO wp_cformsdata VALUES('7784', '289', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7785', '289', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('7786', '289', 'If yes, when did this occur?', 'Feb/10');
INSERT INTO wp_cformsdata VALUES('7787', '289', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7788', '289', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7789', '289', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7790', '289', 'When did the pain begin?', 'Feb/10');
INSERT INTO wp_cformsdata VALUES('7791', '289', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7792', '289', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7793', '289', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7794', '289', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7795', '289', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('7796', '289', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7797', '289', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7798', '289', 'Date of onset of pain?', 'Feb/10');
INSERT INTO wp_cformsdata VALUES('7799', '289', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7800', '289', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7801', '289', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7802', '289', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('7803', '289', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('7804', '290', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7805', '290', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7806', '290', 'Name', 'Pamela Pearlstein');
INSERT INTO wp_cformsdata VALUES('7807', '290', 'City/State', 'Sherman');
INSERT INTO wp_cformsdata VALUES('7808', '290', 'Phone', '9032670085');
INSERT INTO wp_cformsdata VALUES('7809', '290', 'Email', 'ppearlstein@cableone.net');
INSERT INTO wp_cformsdata VALUES('7810', '290', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('7811', '290', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7812', '290', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7813', '290', 'If yes, when did this occur?', '1 1/2-2 years pain/acute since 12.10');
INSERT INTO wp_cformsdata VALUES('7814', '290', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7815', '290', 'Date of most recent scan', 'May 2011');
INSERT INTO wp_cformsdata VALUES('7816', '290', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7817', '290', 'When did the pain begin?', 'August 2010 intensified');
INSERT INTO wp_cformsdata VALUES('7818', '290', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7819', '290', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7820', '290', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7821', '290', 'If no, number of hours in pain', '2 to 10');
INSERT INTO wp_cformsdata VALUES('7822', '290', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7823', '290', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7824', '290', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7825', '290', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7826', '290', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7827', '290', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7828', '290', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7829', '290', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('7830', '290', 'Comments, Questions', 'Difficulty walking when pain intensifies. I have pronounced pain in my right hip.\n\nSince I live in the Dallas/Ft. Worth area, I\'d like to know if there are any doctors trained in administration of this injection in this location.\n\nI am currently seeing an orthopedic surgeon at the Texas Back Institute in Plano, TX. I have had two epidural injections with no relief on the first and limited relief with the second.');
INSERT INTO wp_cformsdata VALUES('7831', '291', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7832', '291', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7833', '291', 'Name', 'FAWZIA YEE-LIM');
INSERT INTO wp_cformsdata VALUES('7834', '291', 'City/State', '#157-2691 E 49TH AVE,VANCOUVER,B.C.CANADA,V5S-1J9');
INSERT INTO wp_cformsdata VALUES('7835', '291', 'Phone', '604-209-2390');
INSERT INTO wp_cformsdata VALUES('7836', '291', 'Email', 'babayeelim@hotmail.com');
INSERT INTO wp_cformsdata VALUES('7837', '291', 'How did you hear about us?', 'on youtube');
INSERT INTO wp_cformsdata VALUES('7838', '291', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7839', '291', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7840', '291', 'If yes, when did this occur?', 'JUNE 9TH 1995');
INSERT INTO wp_cformsdata VALUES('7841', '291', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7842', '291', 'Date of most recent scan', '2006');
INSERT INTO wp_cformsdata VALUES('7843', '291', 'Is there pain in:', 'Back,Neck,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('7844', '291', 'When did the pain begin?', 'SAME TIME AFTER FALL 1995');
INSERT INTO wp_cformsdata VALUES('7845', '291', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7846', '291', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7847', '291', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7848', '291', 'If no, number of hours in pain', 'I\'M SO FRUSTRATED WITH PAIN');
INSERT INTO wp_cformsdata VALUES('7849', '291', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('7850', '291', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7851', '291', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7852', '291', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7853', '291', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7854', '291', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7855', '291', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7856', '291', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7857', '291', 'Comments, Questions', 'I have had 7 disc protrusion/budging disc/herniate disc and swelling of the disc and in 2008 Dr.Spencer Liu was so angry he said i re-broke my pelvis and now my whole right leg is de-formed.I\'M IN PAIN 24/7  AND I GET SEVERE NUMBNESS THAT IT TRIES AND STOP MY SECULATION AND IT CAN TAKE ME A WHILE TO GET IT BACK I HAVE TO KEEP MASSAGING IT ....IT WAS BLUEISH/GREY THE FIRST TIME AND ANYTHING I HELD FELL WITHIN FIVE MINS AND FROM HEAD TO TOE THE NUMBNESS I WAS SO SO SCARED.I DID THERAPY FOR 8 YEARS NOT FOR THERAPIST ANDREA I WOULD BE IN A WHEEL CHAIR,ACCUPUNTURE 3 YEARS AND DID MANY OTHERS.I ALSO HAVE CHRONIC ADVANCED FIBROMYALGIA.LAST WEEK DR.RYAN LUNGE SAID I HAD A BLOCKED NERVE AND WAS VERY CONCERNED AND SAID CHANGE MY DOCTOR I TOLD HIM HE SAID WAIT TILL SEPT...I NEED HELP...PLEASE TELL ME THE COST THANK YOU...I HAVE HAD MANY SURGERY IN PAST MY DOCTOR SAID NOT TO HAVE SURGERY I MAY NOT HEAL....I ALSO GET SEIZURE\'S WHEN THE PAIN COME ON EVEN IN MY SLEEP....IN THE BEGINNING WHEN THE PAIN WOULD SHOOT UP MY SPINE I HAD SEIZURE AND MAJOR AND MINOR HAD THREE SMALL ONES AND MY PAIN IS UNBEARABLE AND I TAKE PAINKILLERS AND AT FIST I DID NOT KNOW WHAT NARCOTICS WERE I TAKE 8 PERCOCETS 4 /10 MILOGRAMS SPECAIL OXYCONTIN AND 3 IBUPROFEN AND 900 X4 GABAPENTIN EVERY SIX HOURS AND THOUSANDS OF TIME WITHIN 2 HRS I PAIN JUST COMES BACK SO SO STONG AND I HAVE NOT SLEPT 4 -6 HOUS STRAIT SINCE 1995 AND BEFORE I HAD NO SLEEP FOR DAYS I WOULD JUST SCREAM IN PAIN AND MY MUM WOULD CRY WITH MY KIDS CAUSE OF MY PAIN ...');
INSERT INTO wp_cformsdata VALUES('7858', '292', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7859', '292', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7860', '292', 'Name', 'BONNIE RAMIREZ');
INSERT INTO wp_cformsdata VALUES('7861', '292', 'City/State', 'FILLMORE,CA');
INSERT INTO wp_cformsdata VALUES('7862', '292', 'Phone', '8055242307');
INSERT INTO wp_cformsdata VALUES('7863', '292', 'Email', 'blenr59@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7864', '292', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('7865', '292', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7866', '292', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7867', '292', 'If yes, when did this occur?', '1997');
INSERT INTO wp_cformsdata VALUES('7868', '292', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7869', '292', 'Date of most recent scan', 'dont remember');
INSERT INTO wp_cformsdata VALUES('7870', '292', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('7871', '292', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('7872', '292', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7873', '292', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7874', '292', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7875', '292', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7876', '292', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,feet,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('7877', '292', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7878', '292', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7879', '292', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7880', '292', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('7881', '292', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7882', '292', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7883', '292', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7884', '292', 'Comments, Questions', 'i always have pain at times i cant stand it');
INSERT INTO wp_cformsdata VALUES('7885', '293', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7886', '293', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7887', '293', 'Name', 'TOMMY RAMIREZ');
INSERT INTO wp_cformsdata VALUES('7888', '293', 'City/State', 'FILLMORE,CA');
INSERT INTO wp_cformsdata VALUES('7889', '293', 'Phone', '8055242307');
INSERT INTO wp_cformsdata VALUES('7890', '293', 'Email', 'blenr59@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7891', '293', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('7892', '293', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7893', '293', 'Does the patient have', 'Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('7894', '293', 'If yes, when did this occur?', '2008');
INSERT INTO wp_cformsdata VALUES('7895', '293', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7896', '293', 'Date of most recent scan', 'dont remember');
INSERT INTO wp_cformsdata VALUES('7897', '293', 'Is there pain in:', 'Back,Leg,Arm');
INSERT INTO wp_cformsdata VALUES('7898', '293', 'When did the pain begin?', 'started again about 7 months ago');
INSERT INTO wp_cformsdata VALUES('7899', '293', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7900', '293', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7901', '293', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7902', '293', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7903', '293', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7904', '293', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7905', '293', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7906', '293', 'Date of onset of pain?', 'about 4 years ago');
INSERT INTO wp_cformsdata VALUES('7907', '293', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('7908', '293', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7909', '293', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7910', '293', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7911', '293', 'Comments, Questions', 'the only time i dont have pain is while setting down i can hardly walk it to the point now were i have to hold on to everything my legs give out and i go down the pain is unreal');
INSERT INTO wp_cformsdata VALUES('7912', '294', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7913', '294', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7914', '294', 'Name', 'ayad');
INSERT INTO wp_cformsdata VALUES('7915', '294', 'City/State', 'baghdad');
INSERT INTO wp_cformsdata VALUES('7916', '294', 'Phone', '009647800465678');
INSERT INTO wp_cformsdata VALUES('7917', '294', 'Email', 'ayad1_igc@yahoo.com');
INSERT INTO wp_cformsdata VALUES('7918', '294', 'How did you hear about us?', 'website');
INSERT INTO wp_cformsdata VALUES('7919', '294', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7920', '294', 'Does the patient have', 'Herniated Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('7921', '294', 'If yes, when did this occur?', '2years ago');
INSERT INTO wp_cformsdata VALUES('7922', '294', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7923', '294', 'Date of most recent scan', '1year');
INSERT INTO wp_cformsdata VALUES('7924', '294', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7925', '294', 'When did the pain begin?', '2year- comes and go ');
INSERT INTO wp_cformsdata VALUES('7926', '294', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('7927', '294', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7928', '294', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7929', '294', 'If no, number of hours in pain', '12 hrs- he comes 1 month and go 2 month and retuern come ...etc');
INSERT INTO wp_cformsdata VALUES('7930', '294', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7931', '294', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7932', '294', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7933', '294', 'Date of onset of pain?', 'every 3month');
INSERT INTO wp_cformsdata VALUES('7934', '294', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7935', '294', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('7936', '294', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7937', '294', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7938', '294', 'Comments, Questions', 'Dear Sirs,...please
\n 1. do you have branch in iraq or any country near iraq like jordan or lobnan or imarat ?
\n2.how many times i take this inject drug ?
\n3. is ther any side effect for this medesine ?
\n4. can you export this drug to iraq with method of uesed ? for one personal ?
\nthanks
\n
\nayad mohsen');
INSERT INTO wp_cformsdata VALUES('7939', '295', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7940', '295', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7941', '295', 'Name', 'Martha Saenz ');
INSERT INTO wp_cformsdata VALUES('7942', '295', 'City/State', 'Downey ca');
INSERT INTO wp_cformsdata VALUES('7943', '295', 'Phone', '562-477-0686');
INSERT INTO wp_cformsdata VALUES('7944', '295', 'Email', 'mls0454@lausd.net');
INSERT INTO wp_cformsdata VALUES('7945', '295', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('7946', '295', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7947', '295', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7948', '295', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7949', '295', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7950', '295', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7951', '295', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('7952', '295', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('7953', '295', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7954', '295', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('7955', '295', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7956', '295', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('7957', '295', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('7958', '295', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7959', '295', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7960', '295', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7961', '295', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7962', '295', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7963', '295', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7964', '295', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7965', '295', 'Comments, Questions', 'I\'d also like to know the cost. I have healthnet HMO and kaiser medical insurance in case my med insurance can cover it. Thanks.');
INSERT INTO wp_cformsdata VALUES('7966', '296', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7967', '296', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7968', '296', 'Name', 'Charles A. Baron');
INSERT INTO wp_cformsdata VALUES('7969', '296', 'City/State', 'Encino, CA');
INSERT INTO wp_cformsdata VALUES('7970', '296', 'Phone', '949.310.1653');
INSERT INTO wp_cformsdata VALUES('7971', '296', 'Email', 'baron-charles@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('7972', '296', 'How did you hear about us?', 'mom');
INSERT INTO wp_cformsdata VALUES('7973', '296', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('7974', '296', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('7975', '296', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('7976', '296', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('7977', '296', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('7978', '296', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('7979', '296', 'When did the pain begin?', 'a while back');
INSERT INTO wp_cformsdata VALUES('7980', '296', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7981', '296', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('7982', '296', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('7983', '296', 'If no, number of hours in pain', 'majority of the time');
INSERT INTO wp_cformsdata VALUES('7984', '296', 'Is there pain, tingling, numbness, or weakness in your:', 'feet,hands');
INSERT INTO wp_cformsdata VALUES('7985', '296', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('7986', '296', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('7987', '296', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('7988', '296', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7989', '296', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7990', '296', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('7991', '296', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('7992', '296', 'Comments, Questions', 'Believe issue is muscular vs. skeletal.  Strectching helps.  Sitting can be uncomfortable.  Working on strengthing back muscles at gym.  Have \"knots\" which I am constently massaging.  The larger the know the more discomfort I experience.
\nLoook forward to discussing this further.
\n
\nThanx,
\n
\nChuck');
INSERT INTO wp_cformsdata VALUES('7993', '297', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('7994', '297', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('7995', '297', 'Name', 'Rochelle');
INSERT INTO wp_cformsdata VALUES('7996', '297', 'City/State', 'California');
INSERT INTO wp_cformsdata VALUES('7997', '297', 'Phone', '310 8387992');
INSERT INTO wp_cformsdata VALUES('7998', '297', 'Email', 'kamranro@aol.com');
INSERT INTO wp_cformsdata VALUES('7999', '297', 'How did you hear about us?', 'husband');
INSERT INTO wp_cformsdata VALUES('8000', '297', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8001', '297', 'Does the patient have', 'Herniated Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8002', '297', 'If yes, when did this occur?', '6-8 months');
INSERT INTO wp_cformsdata VALUES('8003', '297', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8004', '297', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8005', '297', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8006', '297', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('8007', '297', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8008', '297', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8009', '297', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8010', '297', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8011', '297', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('8012', '297', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8013', '297', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8014', '297', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8015', '297', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8016', '297', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8017', '297', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8018', '297', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8019', '297', 'Comments, Questions', 'What is the treatment used?  How effective is the treatment, for how long?');
INSERT INTO wp_cformsdata VALUES('8020', '298', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8021', '298', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8022', '298', 'Name', 'clay marohnic');
INSERT INTO wp_cformsdata VALUES('8023', '298', 'City/State', 'oceanside/ca');
INSERT INTO wp_cformsdata VALUES('8024', '298', 'Phone', '7602166686');
INSERT INTO wp_cformsdata VALUES('8025', '298', 'Email', 'cautiousclay@cox.net');
INSERT INTO wp_cformsdata VALUES('8026', '298', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('8027', '298', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8028', '298', 'Does the patient have', 'Annular tear');
INSERT INTO wp_cformsdata VALUES('8029', '298', 'If yes, when did this occur?', '30 years ago');
INSERT INTO wp_cformsdata VALUES('8030', '298', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8031', '298', 'Date of most recent scan', 'unknown');
INSERT INTO wp_cformsdata VALUES('8032', '298', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8033', '298', 'When did the pain begin?', '30');
INSERT INTO wp_cformsdata VALUES('8034', '298', 'Is there pain everyday?', 'No');
INSERT INTO wp_cformsdata VALUES('8035', '298', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8036', '298', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8037', '298', 'If no, number of hours in pain', '5/10');
INSERT INTO wp_cformsdata VALUES('8038', '298', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves');
INSERT INTO wp_cformsdata VALUES('8039', '298', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8040', '298', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8041', '298', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8042', '298', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8043', '298', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('8044', '298', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8045', '298', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8046', '298', 'Comments, Questions', 'I have scoleosis and stenosis
\nwent throuh decompression with some relief');
INSERT INTO wp_cformsdata VALUES('8047', '299', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8048', '299', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8049', '299', 'Name', 'Jody Potiker');
INSERT INTO wp_cformsdata VALUES('8050', '299', 'City/State', 'Orange, CA');
INSERT INTO wp_cformsdata VALUES('8051', '299', 'Phone', '707-484-2066');
INSERT INTO wp_cformsdata VALUES('8052', '299', 'Email', 'cooljode@gmail.com');
INSERT INTO wp_cformsdata VALUES('8053', '299', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('8054', '299', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8055', '299', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8056', '299', 'If yes, when did this occur?', 'chronic. dont know exactly');
INSERT INTO wp_cformsdata VALUES('8057', '299', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8058', '299', 'Date of most recent scan', 'july 2011');
INSERT INTO wp_cformsdata VALUES('8059', '299', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8060', '299', 'When did the pain begin?', 'chronic but fell two months ago and set it off');
INSERT INTO wp_cformsdata VALUES('8061', '299', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8062', '299', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8063', '299', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8064', '299', 'If no, number of hours in pain', '10 if not on dilaudid');
INSERT INTO wp_cformsdata VALUES('8065', '299', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('8066', '299', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8067', '299', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8068', '299', 'Date of onset of pain?', 'fell two months ago');
INSERT INTO wp_cformsdata VALUES('8069', '299', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8070', '299', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8071', '299', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8072', '299', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8073', '299', 'Comments, Questions', 'Pt is 84 with long history of back pain.  He has a significant scoliotic and kyphotic lumbar spine with advanced OA at all levels.  Pain located across L/S joint and into SI joints bilaterally. There is no radicular pain,  Pt is in pain most of the day and is dependent on dilaudid because nothing else has worked.  Recently had epidural injections with no results. There is no pathological muscle weakness present. He was actually getting by without significant amounts of pain until he fell approximately three months ago and set off the lumbar/SI symptoms. He had a compression fracture at L1 from the fall but has had no symptoms at that level.\nI\'m interested to know how you determine whether this treatment is appropriate for a person?  Thank you for your response.  Jody Potiker on behalf of my father, Howard');
INSERT INTO wp_cformsdata VALUES('8074', '300', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8075', '300', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8076', '300', 'Name', 'Jose  Rascon');
INSERT INTO wp_cformsdata VALUES('8077', '300', 'City/State', 'los angeles/ ca');
INSERT INTO wp_cformsdata VALUES('8078', '300', 'Phone', '3235717661');
INSERT INTO wp_cformsdata VALUES('8079', '300', 'Email', 'jose.rascon@gmail.com');
INSERT INTO wp_cformsdata VALUES('8080', '300', 'How did you hear about us?', 'patient');
INSERT INTO wp_cformsdata VALUES('8081', '300', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8082', '300', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8083', '300', 'If yes, when did this occur?', '2000');
INSERT INTO wp_cformsdata VALUES('8084', '300', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8085', '300', 'Date of most recent scan', '2009');
INSERT INTO wp_cformsdata VALUES('8086', '300', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8087', '300', 'When did the pain begin?', '2000');
INSERT INTO wp_cformsdata VALUES('8088', '300', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8089', '300', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8090', '300', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8091', '300', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8092', '300', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves');
INSERT INTO wp_cformsdata VALUES('8093', '300', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8094', '300', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8095', '300', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8096', '300', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('8097', '300', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8098', '300', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8099', '300', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8100', '300', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8101', '301', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8102', '301', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8103', '301', 'Name', 'Nathan king');
INSERT INTO wp_cformsdata VALUES('8104', '301', 'City/State', 'Fullerton ca.');
INSERT INTO wp_cformsdata VALUES('8105', '301', 'Phone', '714 471 7397');
INSERT INTO wp_cformsdata VALUES('8106', '301', 'Email', 'Nateking79@hotmail.com');
INSERT INTO wp_cformsdata VALUES('8107', '301', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('8108', '301', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8109', '301', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8110', '301', 'If yes, when did this occur?', 'Had surgery 4yrs. Ago now pain is back');
INSERT INTO wp_cformsdata VALUES('8111', '301', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8112', '301', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8113', '301', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8114', '301', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('8115', '301', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8116', '301', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8117', '301', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8118', '301', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8119', '301', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8120', '301', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8121', '301', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8122', '301', 'Date of onset of pain?', '4yrs ago');
INSERT INTO wp_cformsdata VALUES('8123', '301', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8124', '301', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8125', '301', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8126', '301', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8127', '301', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8128', '302', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8129', '302', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8130', '302', 'Name', 'ameen    rizk');
INSERT INTO wp_cformsdata VALUES('8131', '302', 'City/State', '1740 n landfair  st');
INSERT INTO wp_cformsdata VALUES('8132', '302', 'Phone', '714  349  3308');
INSERT INTO wp_cformsdata VALUES('8133', '302', 'Email', 'rizkanaheim@aol.com');
INSERT INTO wp_cformsdata VALUES('8134', '302', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('8135', '302', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8136', '302', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8137', '302', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8138', '302', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8139', '302', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8140', '302', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8141', '302', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('8142', '302', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8143', '302', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8144', '302', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8145', '302', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8146', '302', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('8147', '302', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8148', '302', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8149', '302', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8150', '302', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8151', '302', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8152', '302', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8153', '302', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8154', '302', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8155', '303', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8156', '303', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8157', '303', 'Name', 'Bill Martines');
INSERT INTO wp_cformsdata VALUES('8158', '303', 'City/State', 'Albuquerque, New Mexico');
INSERT INTO wp_cformsdata VALUES('8159', '303', 'Phone', '925-570-5505');
INSERT INTO wp_cformsdata VALUES('8160', '303', 'Email', 'wrhsonwheels@gmail.com');
INSERT INTO wp_cformsdata VALUES('8161', '303', 'How did you hear about us?', 'searching for help online(youtube)');
INSERT INTO wp_cformsdata VALUES('8162', '303', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8163', '303', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8164', '303', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8165', '303', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8166', '303', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8167', '303', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('8168', '303', 'When did the pain begin?', 'early july 2011');
INSERT INTO wp_cformsdata VALUES('8169', '303', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8170', '303', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8171', '303', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8172', '303', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8173', '303', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('8174', '303', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8175', '303', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8176', '303', 'Date of onset of pain?', ' late \'80\'s');
INSERT INTO wp_cformsdata VALUES('8177', '303', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8178', '303', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8179', '303', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8180', '303', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8181', '303', 'Comments, Questions', 'I don\'t have constant back pain, but i have a constant pain in my left calve.  It is worse when i sit sometimes or if i walk too much or stand for to long.  It can also go up to my left buttock and some front left thigh pain(Not very often).  I have wondered if it col be the sciatic never because I have driven over a 1000 miles on 2 occasions and the pain is bearable most of the time but it does get the better of me at times also.  I am a 48 yr old male.  Thank you for your time, Bill ');
INSERT INTO wp_cformsdata VALUES('8182', '304', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8183', '304', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8184', '304', 'Name', 'Harkirat K Buttar');
INSERT INTO wp_cformsdata VALUES('8185', '304', 'City/State', 'Fresno,CA');
INSERT INTO wp_cformsdata VALUES('8186', '304', 'Phone', '559-761-1670');
INSERT INTO wp_cformsdata VALUES('8187', '304', 'Email', 'baljeetbuttar@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8188', '304', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('8189', '304', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8190', '304', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8191', '304', 'If yes, when did this occur?', 'Sciatic pain');
INSERT INTO wp_cformsdata VALUES('8192', '304', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8193', '304', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8194', '304', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8195', '304', 'When did the pain begin?', '6 Months');
INSERT INTO wp_cformsdata VALUES('8196', '304', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8197', '304', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8198', '304', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8199', '304', 'If no, number of hours in pain', 'Specially night time all night');
INSERT INTO wp_cformsdata VALUES('8200', '304', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8201', '304', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8202', '304', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8203', '304', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8204', '304', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8205', '304', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8206', '304', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8207', '304', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8208', '304', 'Comments, Questions', 'She cant sleep with siatica nerve pain. She has given Vicodin very strong but she cant take it always. She also has bad knee problem please help her my mother need help real badly. I will really appricate if someone contact us at 559-761-1670 Thank you.');
INSERT INTO wp_cformsdata VALUES('8209', '305', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8210', '305', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8211', '305', 'Name', 'Vertice Williams');
INSERT INTO wp_cformsdata VALUES('8212', '305', 'City/State', 'Los Angeles, CA');
INSERT INTO wp_cformsdata VALUES('8213', '305', 'Phone', '310-751-0327');
INSERT INTO wp_cformsdata VALUES('8214', '305', 'Email', 'muzkmaven@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8215', '305', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('8216', '305', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8217', '305', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8218', '305', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8219', '305', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8220', '305', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8221', '305', 'Is there pain in:', 'Back,Neck,Leg');
INSERT INTO wp_cformsdata VALUES('8222', '305', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('8223', '305', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8224', '305', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8225', '305', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8226', '305', 'If no, number of hours in pain', '10-15; sometimes it is 24 hours.');
INSERT INTO wp_cformsdata VALUES('8227', '305', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs');
INSERT INTO wp_cformsdata VALUES('8228', '305', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8229', '305', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8230', '305', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8231', '305', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8232', '305', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8233', '305', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8234', '305', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8235', '305', 'Comments, Questions', 'Although I answered \"yes\" to some of these questions, it\'s not the case.  However, most of the time it is.  So my best answers is \"yes.\"  I have been told I suffer from siatica.');
INSERT INTO wp_cformsdata VALUES('8236', '306', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8237', '306', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8238', '306', 'Name', 'jeremy alicea');
INSERT INTO wp_cformsdata VALUES('8239', '306', 'City/State', 'baldwin park,ca');
INSERT INTO wp_cformsdata VALUES('8240', '306', 'Phone', '951-999-5296');
INSERT INTO wp_cformsdata VALUES('8241', '306', 'Email', 'iluvbasketball0786@gmail.com');
INSERT INTO wp_cformsdata VALUES('8242', '306', 'How did you hear about us?', 'youtube');
INSERT INTO wp_cformsdata VALUES('8243', '306', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8244', '306', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8245', '306', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8246', '306', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8247', '306', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8248', '306', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8249', '306', 'When did the pain begin?', '5 months ago.');
INSERT INTO wp_cformsdata VALUES('8250', '306', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8251', '306', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8252', '306', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8253', '306', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8254', '306', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8255', '306', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8256', '306', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8257', '306', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8258', '306', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8259', '306', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8260', '306', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8261', '306', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8262', '306', 'Comments, Questions', 'An everyday unending pain and and uncomfortable life because of the sciatic nerve. can not walk at all.');
INSERT INTO wp_cformsdata VALUES('8263', '307', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8264', '307', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8265', '307', 'Name', 'carole miller');
INSERT INTO wp_cformsdata VALUES('8266', '307', 'City/State', 'plymouth mn');
INSERT INTO wp_cformsdata VALUES('8267', '307', 'Phone', '763 559 7192');
INSERT INTO wp_cformsdata VALUES('8268', '307', 'Email', 'stewart.390@gmail.com');
INSERT INTO wp_cformsdata VALUES('8269', '307', 'How did you hear about us?', 'Internet Utube');
INSERT INTO wp_cformsdata VALUES('8270', '307', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8271', '307', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8272', '307', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8273', '307', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('8274', '307', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8275', '307', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('8276', '307', 'When did the pain begin?', '');
INSERT INTO wp_cformsdata VALUES('8277', '307', 'Is there pain everyday?', '');
INSERT INTO wp_cformsdata VALUES('8278', '307', 'Describe the pain?', '');
INSERT INTO wp_cformsdata VALUES('8279', '307', 'Is there pain 24 hours a day?', '');
INSERT INTO wp_cformsdata VALUES('8280', '307', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8281', '307', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('8282', '307', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('8283', '307', 'Previous Back Surgery?', '');
INSERT INTO wp_cformsdata VALUES('8284', '307', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8285', '307', 'Is there have pain at rest?', '');
INSERT INTO wp_cformsdata VALUES('8286', '307', 'Is there pain upon wakening?', '');
INSERT INTO wp_cformsdata VALUES('8287', '307', 'Is there pain below knee?', '');
INSERT INTO wp_cformsdata VALUES('8288', '307', 'Does the patient have difficulty walking?', '');
INSERT INTO wp_cformsdata VALUES('8289', '307', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8290', '308', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8291', '308', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8292', '308', 'Name', 'carole miller');
INSERT INTO wp_cformsdata VALUES('8293', '308', 'City/State', 'plymouth mn');
INSERT INTO wp_cformsdata VALUES('8294', '308', 'Phone', '763 559 7192');
INSERT INTO wp_cformsdata VALUES('8295', '308', 'Email', 'stewart.390@gmail.com');
INSERT INTO wp_cformsdata VALUES('8296', '308', 'How did you hear about us?', 'utube');
INSERT INTO wp_cformsdata VALUES('8297', '308', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8298', '308', 'Does the patient have', 'Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8299', '308', 'If yes, when did this occur?', 'begin 1991');
INSERT INTO wp_cformsdata VALUES('8300', '308', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8301', '308', 'Date of most recent scan', '2006');
INSERT INTO wp_cformsdata VALUES('8302', '308', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8303', '308', 'When did the pain begin?', '1985');
INSERT INTO wp_cformsdata VALUES('8304', '308', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8305', '308', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8306', '308', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8307', '308', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8308', '308', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs');
INSERT INTO wp_cformsdata VALUES('8309', '308', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8310', '308', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8311', '308', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8312', '308', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8313', '308', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8314', '308', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8315', '308', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8316', '308', 'Comments, Questions', 'I have had sij/myofacial pain for so many years.\n\nMuch treatment including present with medex.\n\nVery medication sensitive esp. to steriods/lidocaine.\n\nI would like to know more about you and if I am a candidate for consult.\n\nThank you');
INSERT INTO wp_cformsdata VALUES('8317', '309', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8318', '309', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8319', '309', 'Name', 'Hiram Orange');
INSERT INTO wp_cformsdata VALUES('8320', '309', 'City/State', 'Union City, GA');
INSERT INTO wp_cformsdata VALUES('8321', '309', 'Phone', '770-969-6792');
INSERT INTO wp_cformsdata VALUES('8322', '309', 'Email', 'hlrobinson10@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8323', '309', 'How did you hear about us?', 'YouTube');
INSERT INTO wp_cformsdata VALUES('8324', '309', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8325', '309', 'Does the patient have', 'Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8326', '309', 'If yes, when did this occur?', '3 years gradually');
INSERT INTO wp_cformsdata VALUES('8327', '309', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8328', '309', 'Date of most recent scan', '5/2011');
INSERT INTO wp_cformsdata VALUES('8329', '309', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8330', '309', 'When did the pain begin?', '3 years gradually worsening ');
INSERT INTO wp_cformsdata VALUES('8331', '309', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8332', '309', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8333', '309', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8334', '309', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8335', '309', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8336', '309', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8337', '309', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8338', '309', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8339', '309', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8340', '309', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8341', '309', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8342', '309', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8343', '309', 'Comments, Questions', 'I am a self pay patient and would like to know, approximately, how much the procedure would cost.  Also, do you have a office or affliate in Georgia to avoid the airplane expense?  I look forward to hearing from you.
\n
\nHiram L. Orange');
INSERT INTO wp_cformsdata VALUES('8344', '310', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8345', '310', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8346', '310', 'Name', 'Don Wientjes');
INSERT INTO wp_cformsdata VALUES('8347', '310', 'City/State', 'Camarillo, CA');
INSERT INTO wp_cformsdata VALUES('8348', '310', 'Phone', '805-312-1284');
INSERT INTO wp_cformsdata VALUES('8349', '310', 'Email', 'dwientjes@mac.com');
INSERT INTO wp_cformsdata VALUES('8350', '310', 'How did you hear about us?', 'Google search');
INSERT INTO wp_cformsdata VALUES('8351', '310', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8352', '310', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8353', '310', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8354', '310', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8355', '310', 'Date of most recent scan', 'July 15, 2011');
INSERT INTO wp_cformsdata VALUES('8356', '310', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('8357', '310', 'When did the pain begin?', 'Back');
INSERT INTO wp_cformsdata VALUES('8358', '310', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8359', '310', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8360', '310', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8361', '310', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8362', '310', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('8363', '310', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8364', '310', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8365', '310', 'Date of onset of pain?', 'June 2011');
INSERT INTO wp_cformsdata VALUES('8366', '310', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8367', '310', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8368', '310', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8369', '310', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8370', '310', 'Comments, Questions', 'I had a Facet Joint injection August 16th. The pain is no better probably worse. \nIs your treatment an injection or some other technique?\n');
INSERT INTO wp_cformsdata VALUES('8371', '311', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8372', '311', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8373', '311', 'Name', 'arturo martinez');
INSERT INTO wp_cformsdata VALUES('8374', '311', 'City/State', 'san antonio texas');
INSERT INTO wp_cformsdata VALUES('8375', '311', 'Phone', '2103743532');
INSERT INTO wp_cformsdata VALUES('8376', '311', 'Email', 'arturomtz50@msn.com');
INSERT INTO wp_cformsdata VALUES('8377', '311', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('8378', '311', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8379', '311', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8380', '311', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8381', '311', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8382', '311', 'Date of most recent scan', '9 years ago');
INSERT INTO wp_cformsdata VALUES('8383', '311', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8384', '311', 'When did the pain begin?', '10 years ago');
INSERT INTO wp_cformsdata VALUES('8385', '311', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8386', '311', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8387', '311', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8388', '311', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8389', '311', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8390', '311', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8391', '311', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8392', '311', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8393', '311', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8394', '311', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8395', '311', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8396', '311', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8397', '311', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8398', '312', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8399', '312', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8400', '312', 'Name', 'ANDY');
INSERT INTO wp_cformsdata VALUES('8401', '312', 'City/State', 'Diamond Bar');
INSERT INTO wp_cformsdata VALUES('8402', '312', 'Phone', '951 903-8103');
INSERT INTO wp_cformsdata VALUES('8403', '312', 'Email', 'acrowetbar@aol.com');
INSERT INTO wp_cformsdata VALUES('8404', '312', 'How did you hear about us?', 'radio K-EARTH 101');
INSERT INTO wp_cformsdata VALUES('8405', '312', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8406', '312', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8407', '312', 'If yes, when did this occur?', 'ABOUT A YEAR AGO');
INSERT INTO wp_cformsdata VALUES('8408', '312', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8409', '312', 'Date of most recent scan', '12/6/10');
INSERT INTO wp_cformsdata VALUES('8410', '312', 'Is there pain in:', 'Neck,Arm');
INSERT INTO wp_cformsdata VALUES('8411', '312', 'When did the pain begin?', '10/2010');
INSERT INTO wp_cformsdata VALUES('8412', '312', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8413', '312', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8414', '312', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8415', '312', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8416', '312', 'Is there pain, tingling, numbness, or weakness in your:', 'arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('8417', '312', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8418', '312', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8419', '312', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8420', '312', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8421', '312', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8422', '312', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8423', '312', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8424', '312', 'Comments, Questions', 'Started around 10/2010 had a staroid shot help for three months\nthen it came back Had another shot help for couple weeks.\nthen it came back for about three month. then it went away for about two\nmonths. now it just came backagain please help.');
INSERT INTO wp_cformsdata VALUES('8425', '313', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8426', '313', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8427', '313', 'Name', 'yulonda clark');
INSERT INTO wp_cformsdata VALUES('8428', '313', 'City/State', 'oakland ca');
INSERT INTO wp_cformsdata VALUES('8429', '313', 'Phone', '510-433-0348');
INSERT INTO wp_cformsdata VALUES('8430', '313', 'Email', 'yulonda_clark@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8431', '313', 'How did you hear about us?', 'youtube video');
INSERT INTO wp_cformsdata VALUES('8432', '313', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8433', '313', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('8434', '313', 'If yes, when did this occur?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('8435', '313', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8436', '313', 'Date of most recent scan', '8/8/11');
INSERT INTO wp_cformsdata VALUES('8437', '313', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8438', '313', 'When did the pain begin?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('8439', '313', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8440', '313', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8441', '313', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8442', '313', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8443', '313', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8444', '313', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8445', '313', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8446', '313', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8447', '313', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8448', '313', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8449', '313', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8450', '313', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8451', '313', 'Comments, Questions', 'Im in severe pain..im on morphine and diluided pain pills and im in the emergency room almost every night. I have a four month old baby and had to send him away to family until i can manage. The pain is in my buttocks and right leg. Please help me! I want to be a mom to my kid but cant while im in so much pain');
INSERT INTO wp_cformsdata VALUES('8452', '314', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8453', '314', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8454', '314', 'Name', 'Susan Pittman');
INSERT INTO wp_cformsdata VALUES('8455', '314', 'City/State', 'Pearl River, LA');
INSERT INTO wp_cformsdata VALUES('8456', '314', 'Phone', '504-416-4383');
INSERT INTO wp_cformsdata VALUES('8457', '314', 'Email', 'tax2u@ymail.com');
INSERT INTO wp_cformsdata VALUES('8458', '314', 'How did you hear about us?', 'utube');
INSERT INTO wp_cformsdata VALUES('8459', '314', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8460', '314', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8461', '314', 'If yes, when did this occur?', 'not known');
INSERT INTO wp_cformsdata VALUES('8462', '314', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8463', '314', 'Date of most recent scan', 'March 2011');
INSERT INTO wp_cformsdata VALUES('8464', '314', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8465', '314', 'When did the pain begin?', 'acutely Nov. 2010');
INSERT INTO wp_cformsdata VALUES('8466', '314', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8467', '314', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8468', '314', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8469', '314', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8470', '314', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('8471', '314', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8472', '314', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8473', '314', 'Date of onset of pain?', 'c-5 fusion');
INSERT INTO wp_cformsdata VALUES('8474', '314', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8475', '314', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8476', '314', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8477', '314', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8478', '314', 'Comments, Questions', 'also have avascular necrois of left hip - need hip replacement surgery since 1999');
INSERT INTO wp_cformsdata VALUES('8479', '315', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8480', '315', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8481', '315', 'Name', 'bob richey');
INSERT INTO wp_cformsdata VALUES('8482', '315', 'City/State', 'temecula,ca');
INSERT INTO wp_cformsdata VALUES('8483', '315', 'Phone', '702-994-4446');
INSERT INTO wp_cformsdata VALUES('8484', '315', 'Email', 'bobbybobrichey@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8485', '315', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('8486', '315', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8487', '315', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('8488', '315', 'If yes, when did this occur?', '2008');
INSERT INTO wp_cformsdata VALUES('8489', '315', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8490', '315', 'Date of most recent scan', '2008');
INSERT INTO wp_cformsdata VALUES('8491', '315', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('8492', '315', 'When did the pain begin?', '2008');
INSERT INTO wp_cformsdata VALUES('8493', '315', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8494', '315', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8495', '315', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8496', '315', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8497', '315', 'Is there pain, tingling, numbness, or weakness in your:', 'feet');
INSERT INTO wp_cformsdata VALUES('8498', '315', 'Has disc surgery been recommended?', '');
INSERT INTO wp_cformsdata VALUES('8499', '315', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8500', '315', 'Date of onset of pain?', '2008');
INSERT INTO wp_cformsdata VALUES('8501', '315', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8502', '315', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8503', '315', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8504', '315', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8505', '315', 'Comments, Questions', 'protruding disc L4 L5. pain shoots into top of foot and shin,ankle area.');
INSERT INTO wp_cformsdata VALUES('8506', '316', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8507', '316', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8508', '316', 'Name', 'William Paz');
INSERT INTO wp_cformsdata VALUES('8509', '316', 'City/State', 'warwick R.I.');
INSERT INTO wp_cformsdata VALUES('8510', '316', 'Phone', '401-286-1887');
INSERT INTO wp_cformsdata VALUES('8511', '316', 'Email', 'filomenadapaz@gmail.com');
INSERT INTO wp_cformsdata VALUES('8512', '316', 'How did you hear about us?', 'Search the webb');
INSERT INTO wp_cformsdata VALUES('8513', '316', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8514', '316', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8515', '316', 'If yes, when did this occur?', 'About 2 yrs.');
INSERT INTO wp_cformsdata VALUES('8516', '316', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8517', '316', 'Date of most recent scan', '2010');
INSERT INTO wp_cformsdata VALUES('8518', '316', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8519', '316', 'When did the pain begin?', ' severe pain 5 months ago');
INSERT INTO wp_cformsdata VALUES('8520', '316', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8521', '316', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8522', '316', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8523', '316', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8524', '316', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8525', '316', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8526', '316', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8527', '316', 'Date of onset of pain?', 'Laser treatement (American Institute,Texas');
INSERT INTO wp_cformsdata VALUES('8528', '316', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8529', '316', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8530', '316', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8531', '316', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8532', '316', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8533', '317', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8534', '317', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8535', '317', 'Name', 'William Gamache');
INSERT INTO wp_cformsdata VALUES('8536', '317', 'City/State', 'North York, Ontario  M3M 2W7');
INSERT INTO wp_cformsdata VALUES('8537', '317', 'Phone', '416-633-7708');
INSERT INTO wp_cformsdata VALUES('8538', '317', 'Email', 'williamgamache@sympatico.ca');
INSERT INTO wp_cformsdata VALUES('8539', '317', 'How did you hear about us?', 'utube');
INSERT INTO wp_cformsdata VALUES('8540', '317', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8541', '317', 'Does the patient have', 'Herniated Disc,Bulging Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8542', '317', 'If yes, when did this occur?', 'In the past 5 years');
INSERT INTO wp_cformsdata VALUES('8543', '317', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8544', '317', 'Date of most recent scan', 'Sept.2010');
INSERT INTO wp_cformsdata VALUES('8545', '317', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8546', '317', 'When did the pain begin?', 'July 2010');
INSERT INTO wp_cformsdata VALUES('8547', '317', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8548', '317', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8549', '317', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8550', '317', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8551', '317', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8552', '317', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8553', '317', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8554', '317', 'Date of onset of pain?', 'Approx. one year ago.');
INSERT INTO wp_cformsdata VALUES('8555', '317', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8556', '317', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8557', '317', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8558', '317', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8559', '317', 'Comments, Questions', 'The pain is in the back but mostly in the left hip,calf and foot with numbness in the 3 largest toes. I have a lot of difficulty walking and I use a walker to ease the pain when walking.The pain is not as severe as it was a couple months ago but i have had 3 facet blocks,2 nerve root blocks and 3 epidurals with steriod.\n  I have pagets desease as well.');
INSERT INTO wp_cformsdata VALUES('8560', '318', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8561', '318', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8562', '318', 'Name', 'Scott Penn');
INSERT INTO wp_cformsdata VALUES('8563', '318', 'City/State', 'Apple Valley/CA');
INSERT INTO wp_cformsdata VALUES('8564', '318', 'Phone', '760-948-2899');
INSERT INTO wp_cformsdata VALUES('8565', '318', 'Email', 'scott@scottmpenncpa.com');
INSERT INTO wp_cformsdata VALUES('8566', '318', 'How did you hear about us?', '101.1 Radio');
INSERT INTO wp_cformsdata VALUES('8567', '318', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8568', '318', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('8569', '318', 'If yes, when did this occur?', '1992 and again in 1999');
INSERT INTO wp_cformsdata VALUES('8570', '318', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8571', '318', 'Date of most recent scan', 'CAT around May 2011');
INSERT INTO wp_cformsdata VALUES('8572', '318', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8573', '318', 'When did the pain begin?', '1992');
INSERT INTO wp_cformsdata VALUES('8574', '318', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8575', '318', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8576', '318', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8577', '318', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8578', '318', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('8579', '318', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8580', '318', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8581', '318', 'Date of onset of pain?', '1992');
INSERT INTO wp_cformsdata VALUES('8582', '318', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8583', '318', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8584', '318', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8585', '318', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8586', '318', 'Comments, Questions', 'I have had two herniated disc and two spinal fusions surgeries.  I also have a spinal cord stimulator.  I am in pain most of everyday and I am on a Fetynal Pain Patch every 72 hours along with Morphine and Norco as needed.  I can\'t drive but 30 minutes and some times not even that.  I have no social life and don\'t see my parents or siblings due to distance.  I don\'t have any physical activity though recently I have been going to water therapy and I used to be verry active playing tennis, volleyball and softball.  It affects my sex life and I beleive is a major cause for my having to be on Psych Meds. I have also had epidural treatments with temporary relief.   I am very concerned that I will end up in a wheel chair which will severly affect my earning potential.  I constantly look for a way to elliviate this pain and hope someday, before I die, I will.');
INSERT INTO wp_cformsdata VALUES('8587', '319', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8588', '319', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8589', '319', 'Name', 'Ken Parekh');
INSERT INTO wp_cformsdata VALUES('8590', '319', 'City/State', 'Houston, TX');
INSERT INTO wp_cformsdata VALUES('8591', '319', 'Phone', '2816602797');
INSERT INTO wp_cformsdata VALUES('8592', '319', 'Email', 'kenp@amsysis.com');
INSERT INTO wp_cformsdata VALUES('8593', '319', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('8594', '319', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8595', '319', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('8596', '319', 'If yes, when did this occur?', '4-5 years ago');
INSERT INTO wp_cformsdata VALUES('8597', '319', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8598', '319', 'Date of most recent scan', 'June 2011');
INSERT INTO wp_cformsdata VALUES('8599', '319', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8600', '319', 'When did the pain begin?', '4 years ago');
INSERT INTO wp_cformsdata VALUES('8601', '319', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8602', '319', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8603', '319', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8604', '319', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8605', '319', 'Is there pain, tingling, numbness, or weakness in your:', 'legs,calves');
INSERT INTO wp_cformsdata VALUES('8606', '319', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8607', '319', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8608', '319', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8609', '319', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8610', '319', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8611', '319', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8612', '319', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8613', '319', 'Comments, Questions', 'I would like to know if this treatment is available in Houston, TX ');
INSERT INTO wp_cformsdata VALUES('8614', '320', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8615', '320', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8616', '320', 'Name', 'Mark C. Probus');
INSERT INTO wp_cformsdata VALUES('8617', '320', 'City/State', 'Cibolo, Texas');
INSERT INTO wp_cformsdata VALUES('8618', '320', 'Phone', '830-632-7742');
INSERT INTO wp_cformsdata VALUES('8619', '320', 'Email', 'markprobus@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8620', '320', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('8621', '320', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8622', '320', 'Does the patient have', 'Protruding Disc');
INSERT INTO wp_cformsdata VALUES('8623', '320', 'If yes, when did this occur?', 'MRI determined this in June 2011');
INSERT INTO wp_cformsdata VALUES('8624', '320', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8625', '320', 'Date of most recent scan', 'July 2011');
INSERT INTO wp_cformsdata VALUES('8626', '320', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8627', '320', 'When did the pain begin?', 'February 2011');
INSERT INTO wp_cformsdata VALUES('8628', '320', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8629', '320', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8630', '320', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8631', '320', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8632', '320', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,legs,calves');
INSERT INTO wp_cformsdata VALUES('8633', '320', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8634', '320', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8635', '320', 'Date of onset of pain?', 'February 2011');
INSERT INTO wp_cformsdata VALUES('8636', '320', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8637', '320', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8638', '320', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8639', '320', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8640', '320', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8641', '321', 'page', 'http://www.painbreakthrough.com./request-consultation/');
INSERT INTO wp_cformsdata VALUES('8642', '321', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8643', '321', 'Name', 'Donald Pettifer');
INSERT INTO wp_cformsdata VALUES('8644', '321', 'City/State', 'Gold Coast/Queensland /Australia');
INSERT INTO wp_cformsdata VALUES('8645', '321', 'Phone', '001161755027025');
INSERT INTO wp_cformsdata VALUES('8646', '321', 'Email', 'donny_do_09@yahoo.com.au');
INSERT INTO wp_cformsdata VALUES('8647', '321', 'How did you hear about us?', 'Internet');
INSERT INTO wp_cformsdata VALUES('8648', '321', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8649', '321', 'Does the patient have', 'Bulging Disc,Protruding Disc,Degenerative Disc Disease,Annular tear');
INSERT INTO wp_cformsdata VALUES('8650', '321', 'If yes, when did this occur?', '3 Years ago');
INSERT INTO wp_cformsdata VALUES('8651', '321', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8652', '321', 'Date of most recent scan', 'May/2011');
INSERT INTO wp_cformsdata VALUES('8653', '321', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8654', '321', 'When did the pain begin?', '3 Years ago');
INSERT INTO wp_cformsdata VALUES('8655', '321', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8656', '321', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8657', '321', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8658', '321', 'If no, number of hours in pain', '3-4 Hours');
INSERT INTO wp_cformsdata VALUES('8659', '321', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8660', '321', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8661', '321', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8662', '321', 'Date of onset of pain?', '3 Years ago');
INSERT INTO wp_cformsdata VALUES('8663', '321', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8664', '321', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8665', '321', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8666', '321', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8667', '321', 'Comments, Questions', 'Developed Sciatic pain from heavy lifting 3 Years ago.Had a Laminectomy October 2010, Had a Dural Tear after this operation.Developed Cyst had Disectomy to remove January 2011 still suffer sciatic pain Leg/Foot left buttock area numbness also gets worse as day progresses can be very painfull at end of day.Using cortisone tablets for inflammation if it gets bad enough.');
INSERT INTO wp_cformsdata VALUES('8668', '322', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8669', '322', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8670', '322', 'Name', 'Wilfred Wood');
INSERT INTO wp_cformsdata VALUES('8671', '322', 'City/State', 'Tarin, 32100 BERAUT, France');
INSERT INTO wp_cformsdata VALUES('8672', '322', 'Phone', '00 33 562 28 27 67');
INSERT INTO wp_cformsdata VALUES('8673', '322', 'Email', 'wilfwood@orange.fr');
INSERT INTO wp_cformsdata VALUES('8674', '322', 'How did you hear about us?', 'Friend in Los Angeles');
INSERT INTO wp_cformsdata VALUES('8675', '322', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8676', '322', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8677', '322', 'If yes, when did this occur?', 'August 2009 and previous history');
INSERT INTO wp_cformsdata VALUES('8678', '322', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8679', '322', 'Date of most recent scan', '14th July 2011');
INSERT INTO wp_cformsdata VALUES('8680', '322', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8681', '322', 'When did the pain begin?', 'August 2009');
INSERT INTO wp_cformsdata VALUES('8682', '322', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8683', '322', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8684', '322', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8685', '322', 'If no, number of hours in pain', 'No pain when sleeping 16hrs out of 24');
INSERT INTO wp_cformsdata VALUES('8686', '322', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,arms,hands,fingers');
INSERT INTO wp_cformsdata VALUES('8687', '322', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8688', '322', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8689', '322', 'Date of onset of pain?', 'August 2009 & previous history');
INSERT INTO wp_cformsdata VALUES('8690', '322', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8691', '322', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('8692', '322', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8693', '322', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8694', '322', 'Comments, Questions', 'Spine fusion L5/S1 done December 2009. Pain in left hip and lower back continued and grew worse. Have had phisiotherapy, nerve root block ionjection, spinal injection of hydrocortisone and several other tests too numerous to mention here. Mobility is restricted to a few yards with a stick. I have to lie down flat to get relief. My drug regime knocks me out so that I sleep many hours out of 24.\nI have a written resume which I can send to you with a copy of my last MRI on disc.\nYou are recomended by a friend in L.A., Mr. Bill Brown, who is ex UCLA. He has spoken to someone at your office named Angela so perhaps this helps.');
INSERT INTO wp_cformsdata VALUES('8695', '323', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8696', '323', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8697', '323', 'Name', 'julie  hunton');
INSERT INTO wp_cformsdata VALUES('8698', '323', 'City/State', 'san bernardino ca');
INSERT INTO wp_cformsdata VALUES('8699', '323', 'Phone', '9098555251');
INSERT INTO wp_cformsdata VALUES('8700', '323', 'Email', 'huntonbrat@aol.com');
INSERT INTO wp_cformsdata VALUES('8701', '323', 'How did you hear about us?', 'computer');
INSERT INTO wp_cformsdata VALUES('8702', '323', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8703', '323', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8704', '323', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8705', '323', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8706', '323', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8707', '323', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8708', '323', 'When did the pain begin?', '3 weeks ago');
INSERT INTO wp_cformsdata VALUES('8709', '323', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8710', '323', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8711', '323', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8712', '323', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8713', '323', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('8714', '323', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8715', '323', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8716', '323', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8717', '323', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8718', '323', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8719', '323', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8720', '323', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8721', '323', 'Comments, Questions', 'it started 3 weeks ago on right side lower back and butt  with shouting pains  going down my leg into my calf then yesterday i bent down to pick up something and now the pain is on my left side also  making it hard to walk and sit');
INSERT INTO wp_cformsdata VALUES('8722', '324', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8723', '324', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8724', '324', 'Name', 'Donnie Clyma');
INSERT INTO wp_cformsdata VALUES('8725', '324', 'City/State', 'Coweta/ Okla.');
INSERT INTO wp_cformsdata VALUES('8726', '324', 'Phone', '918-486-4458');
INSERT INTO wp_cformsdata VALUES('8727', '324', 'Email', 'dclyma@gmail.com');
INSERT INTO wp_cformsdata VALUES('8728', '324', 'How did you hear about us?', 'A patient/ from work');
INSERT INTO wp_cformsdata VALUES('8729', '324', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8730', '324', 'Does the patient have', 'Protruding Disc,Degenerative Disc Disease');
INSERT INTO wp_cformsdata VALUES('8731', '324', 'If yes, when did this occur?', 'Had a fall about 20yrs. ago that broke a couple of veribras, and degenerated from there.');
INSERT INTO wp_cformsdata VALUES('8732', '324', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8733', '324', 'Date of most recent scan', 'Little over two years ago');
INSERT INTO wp_cformsdata VALUES('8734', '324', 'Is there pain in:', 'Back,Neck');
INSERT INTO wp_cformsdata VALUES('8735', '324', 'When did the pain begin?', 'At time of injury, and has continued after disx surgery, and now accute spinal arthritis and degeneration');
INSERT INTO wp_cformsdata VALUES('8736', '324', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8737', '324', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8738', '324', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8739', '324', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8740', '324', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('8741', '324', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8742', '324', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8743', '324', 'Date of onset of pain?', 'The pain continued a few days after surgery, and now dianoised with three disk bulges and accute degeneration, an ostioperosis');
INSERT INTO wp_cformsdata VALUES('8744', '324', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8745', '324', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8746', '324', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8747', '324', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8748', '324', 'Comments, Questions', 'The difficulty I have walking is mostly caused from a unsuccessful ancle surgery caused by the same fall many years ago. Its in my right ancle and though a bolt was added during sugery the bone fail to fuse and now it swells some and is sore alot. It also has limited my motion. The degenerative condition of spine causes most pain. It has caused me to half to file for disability and has given me severe pain throughout my back, and sometimes confines me to chair most of day. Please, can you help?');
INSERT INTO wp_cformsdata VALUES('8749', '325', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8750', '325', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8751', '325', 'Name', 'Evelyn Merritt');
INSERT INTO wp_cformsdata VALUES('8752', '325', 'City/State', 'Fullerton Ca.');
INSERT INTO wp_cformsdata VALUES('8753', '325', 'Phone', '714-681-8144');
INSERT INTO wp_cformsdata VALUES('8754', '325', 'Email', 'young_evelyn@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8755', '325', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('8756', '325', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8757', '325', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8758', '325', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8759', '325', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8760', '325', 'Date of most recent scan', 'MRI  7-22-11');
INSERT INTO wp_cformsdata VALUES('8761', '325', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8762', '325', 'When did the pain begin?', 'end of June 2011');
INSERT INTO wp_cformsdata VALUES('8763', '325', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8764', '325', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8765', '325', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8766', '325', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8767', '325', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8768', '325', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8769', '325', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8770', '325', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8771', '325', 'Is there have pain at rest?', 'No');
INSERT INTO wp_cformsdata VALUES('8772', '325', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('8773', '325', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8774', '325', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8775', '325', 'Comments, Questions', 'I have been going to physical therapy 3 times a week and I only feel some relief on that day and then it\'s back to the same pain. On Thursday 9-1-11 I have an appointment to see a pain managment Dr. and my biggest fear is that he is going to say that I have to learn to live with the pain. Or even worse give a bunch of drugs and I become dependent upon them. Currently my Orthopedic Dr. is requesting epidural shots from the pain managment Dr. I came across this video and hope that this is somthing that can help me. I am on the verg of loosing my job and begining to feel hopless');
INSERT INTO wp_cformsdata VALUES('8776', '326', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8777', '326', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8778', '326', 'Name', 'Becky Watkins');
INSERT INTO wp_cformsdata VALUES('8779', '326', 'City/State', 'Durango, CO');
INSERT INTO wp_cformsdata VALUES('8780', '326', 'Phone', '505-417-4310');
INSERT INTO wp_cformsdata VALUES('8781', '326', 'Email', 'beckywat1@ymail.com');
INSERT INTO wp_cformsdata VALUES('8782', '326', 'How did you hear about us?', 'internet');
INSERT INTO wp_cformsdata VALUES('8783', '326', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8784', '326', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8785', '326', 'If yes, when did this occur?', '');
INSERT INTO wp_cformsdata VALUES('8786', '326', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8787', '326', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8788', '326', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('8789', '326', 'When did the pain begin?', '3 yrs ago');
INSERT INTO wp_cformsdata VALUES('8790', '326', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8791', '326', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8792', '326', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8793', '326', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8794', '326', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs');
INSERT INTO wp_cformsdata VALUES('8795', '326', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8796', '326', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8797', '326', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8798', '326', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8799', '326', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8800', '326', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8801', '326', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8802', '326', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8803', '327', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8804', '327', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8805', '327', 'Name', 'Dwayne Ortiz');
INSERT INTO wp_cformsdata VALUES('8806', '327', 'City/State', 'Moreno Valley, CA ');
INSERT INTO wp_cformsdata VALUES('8807', '327', 'Phone', '951-269-5015');
INSERT INTO wp_cformsdata VALUES('8808', '327', 'Email', 'dwaynet.ortiz@hotmail.com');
INSERT INTO wp_cformsdata VALUES('8809', '327', 'How did you hear about us?', 'youtube.com');
INSERT INTO wp_cformsdata VALUES('8810', '327', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8811', '327', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8812', '327', 'If yes, when did this occur?', '2009');
INSERT INTO wp_cformsdata VALUES('8813', '327', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8814', '327', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8815', '327', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8816', '327', 'When did the pain begin?', '2009');
INSERT INTO wp_cformsdata VALUES('8817', '327', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8818', '327', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8819', '327', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8820', '327', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8821', '327', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8822', '327', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8823', '327', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8824', '327', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8825', '327', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8826', '327', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8827', '327', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8828', '327', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8829', '327', 'Comments, Questions', 'This pain has been going on since 2009. Scared to have back surgery and do not want to go to a chiropractor. Can you help?');
INSERT INTO wp_cformsdata VALUES('8830', '328', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8831', '328', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8832', '328', 'Name', 'Alan Cohen');
INSERT INTO wp_cformsdata VALUES('8833', '328', 'City/State', 'Wharton, NJ');
INSERT INTO wp_cformsdata VALUES('8834', '328', 'Phone', '973 442 1576');
INSERT INTO wp_cformsdata VALUES('8835', '328', 'Email', 'mousyie1@optonline.net');
INSERT INTO wp_cformsdata VALUES('8836', '328', 'How did you hear about us?', 'internet search');
INSERT INTO wp_cformsdata VALUES('8837', '328', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8838', '328', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8839', '328', 'If yes, when did this occur?', 'June 30, 2009');
INSERT INTO wp_cformsdata VALUES('8840', '328', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('8841', '328', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8842', '328', 'Is there pain in:', '-');
INSERT INTO wp_cformsdata VALUES('8843', '328', 'When did the pain begin?', 'June 30, 2009');
INSERT INTO wp_cformsdata VALUES('8844', '328', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8845', '328', 'Describe the pain?', 'Moderate');
INSERT INTO wp_cformsdata VALUES('8846', '328', 'Is there pain 24 hours a day?', '');
INSERT INTO wp_cformsdata VALUES('8847', '328', 'If no, number of hours in pain', '5');
INSERT INTO wp_cformsdata VALUES('8848', '328', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('8849', '328', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8850', '328', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8851', '328', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8852', '328', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8853', '328', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8854', '328', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8855', '328', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8856', '328', 'Comments, Questions', 'On June 30, 2009 I had radio frequency on my temporal mandibular ligament and temporal tendon by a dentist. This is called Ernest Syndrome. I had jaw pain a few times a week for many years before the procedure. Unfortunately, I got worse. I have pain every morning now. I probably didn\'t even have Ernest Syndrome. I found out I have a venous anomaly in the brain near the trigeminal nerves. I had facial pain and headaches since I was 25 but I managed to cure myself except for the jaw pain with nutrients. I don\'t know what I have now or what can help. I have taken gabapentin and Klonipin and they eliminated my pain but belieive it or not I know this medicine will be my demise and have stopped it. I suffer every day. I try different nutrients every day for two years. I am a very healthy 63 year old but may die soon from this pain or medicine instead of living a full life. that is the way I feel. I\'ve taken 25 years off my life spain unless somebody can help me. Would you like to consider learning more about my case?');
INSERT INTO wp_cformsdata VALUES('8857', '329', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8858', '329', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8859', '329', 'Name', 'Bruce Kallaher');
INSERT INTO wp_cformsdata VALUES('8860', '329', 'City/State', 'Westlake Village, Ca');
INSERT INTO wp_cformsdata VALUES('8861', '329', 'Phone', '805-551-6777');
INSERT INTO wp_cformsdata VALUES('8862', '329', 'Email', 'bkallaher@yahoo.com');
INSERT INTO wp_cformsdata VALUES('8863', '329', 'How did you hear about us?', 'TV, and Radio');
INSERT INTO wp_cformsdata VALUES('8864', '329', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8865', '329', 'Does the patient have', 'Herniated Disc,Bulging Disc,Protruding Disc');
INSERT INTO wp_cformsdata VALUES('8866', '329', 'If yes, when did this occur?', '12 years ago in a motorcycle accident');
INSERT INTO wp_cformsdata VALUES('8867', '329', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8868', '329', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8869', '329', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8870', '329', 'When did the pain begin?', '1.5 years ago');
INSERT INTO wp_cformsdata VALUES('8871', '329', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8872', '329', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8873', '329', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8874', '329', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8875', '329', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('8876', '329', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8877', '329', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8878', '329', 'Date of onset of pain?', 'June, 2010');
INSERT INTO wp_cformsdata VALUES('8879', '329', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8880', '329', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8881', '329', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8882', '329', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8883', '329', 'Comments, Questions', 'I am a 38 year old athlete, very physical with my body.  I raced Motorcycles for many years and had several horrible accidents on the bike.  6 years ago I started surfing competitively and set aside the dirt bike.  In short I started having major back pain then it took over my right leg completely shutting it down.  I couldn’t walk.   I had minimally evasive surgery in Sept, 2010 on my L4-L5.  Coming out of surgery was the worst pain I have ever experienced and took several months before I could function properly.  I have numbness and tingling down my right leg to my foot and toes to this day.  My progress seems to be worsening and at this time I am unable to do any physical activity at all; I can barely get out of bed.  Thank you.');
INSERT INTO wp_cformsdata VALUES('8884', '330', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8885', '330', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8886', '330', 'Name', 'Joshua Reyes');
INSERT INTO wp_cformsdata VALUES('8887', '330', 'City/State', 'Sylmar, CA');
INSERT INTO wp_cformsdata VALUES('8888', '330', 'Phone', '8185819537');
INSERT INTO wp_cformsdata VALUES('8889', '330', 'Email', 'joshareyes@gmail.com');
INSERT INTO wp_cformsdata VALUES('8890', '330', 'How did you hear about us?', 'radio');
INSERT INTO wp_cformsdata VALUES('8891', '330', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8892', '330', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('8893', '330', 'If yes, when did this occur?', 'September 2009');
INSERT INTO wp_cformsdata VALUES('8894', '330', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8895', '330', 'Date of most recent scan', 'NA');
INSERT INTO wp_cformsdata VALUES('8896', '330', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8897', '330', 'When did the pain begin?', 'September 2009');
INSERT INTO wp_cformsdata VALUES('8898', '330', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8899', '330', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('8900', '330', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8901', '330', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8902', '330', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks');
INSERT INTO wp_cformsdata VALUES('8903', '330', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8904', '330', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8905', '330', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8906', '330', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8907', '330', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8908', '330', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8909', '330', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8910', '330', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8911', '331', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8912', '331', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8913', '331', 'Name', 'karla tosta');
INSERT INTO wp_cformsdata VALUES('8914', '331', 'City/State', 'miami, fl');
INSERT INTO wp_cformsdata VALUES('8915', '331', 'Phone', '3052006828');
INSERT INTO wp_cformsdata VALUES('8916', '331', 'Email', 'karttos@gmail.com');
INSERT INTO wp_cformsdata VALUES('8917', '331', 'How did you hear about us?', 'online');
INSERT INTO wp_cformsdata VALUES('8918', '331', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8919', '331', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('8920', '331', 'If yes, when did this occur?', 'i have a surgery and after 7 years i have sciatic');
INSERT INTO wp_cformsdata VALUES('8921', '331', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8922', '331', 'Date of most recent scan', 'one mont');
INSERT INTO wp_cformsdata VALUES('8923', '331', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8924', '331', 'When did the pain begin?', '3 months ago');
INSERT INTO wp_cformsdata VALUES('8925', '331', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8926', '331', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8927', '331', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8928', '331', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8929', '331', 'Is there pain, tingling, numbness, or weakness in your:', 'legs');
INSERT INTO wp_cformsdata VALUES('8930', '331', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8931', '331', 'Previous Back Surgery?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8932', '331', 'Date of onset of pain?', '7 years ');
INSERT INTO wp_cformsdata VALUES('8933', '331', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8934', '331', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8935', '331', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8936', '331', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8937', '331', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8938', '332', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8939', '332', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8940', '332', 'Name', 'Sam Granados');
INSERT INTO wp_cformsdata VALUES('8941', '332', 'City/State', 'Carpinteria, Ca');
INSERT INTO wp_cformsdata VALUES('8942', '332', 'Phone', '8059019737');
INSERT INTO wp_cformsdata VALUES('8943', '332', 'Email', 'sgranados78@gmail.com');
INSERT INTO wp_cformsdata VALUES('8944', '332', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('8945', '332', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8946', '332', 'Does the patient have', 'Herniated Disc,Bulging Disc');
INSERT INTO wp_cformsdata VALUES('8947', '332', 'If yes, when did this occur?', '2 months ago');
INSERT INTO wp_cformsdata VALUES('8948', '332', 'Has the patient had an MRI or CAT scan for this?', 'No');
INSERT INTO wp_cformsdata VALUES('8949', '332', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8950', '332', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('8951', '332', 'When did the pain begin?', 'August 15th 2011');
INSERT INTO wp_cformsdata VALUES('8952', '332', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8953', '332', 'Describe the pain?', 'Mild');
INSERT INTO wp_cformsdata VALUES('8954', '332', 'Is there pain 24 hours a day?', 'No');
INSERT INTO wp_cformsdata VALUES('8955', '332', 'If no, number of hours in pain', '7-9');
INSERT INTO wp_cformsdata VALUES('8956', '332', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,feet,fingers');
INSERT INTO wp_cformsdata VALUES('8957', '332', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8958', '332', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8959', '332', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8960', '332', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8961', '332', 'Is there pain upon wakening?', 'No');
INSERT INTO wp_cformsdata VALUES('8962', '332', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8963', '332', 'Does the patient have difficulty walking?', 'No');
INSERT INTO wp_cformsdata VALUES('8964', '332', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8965', '333', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8966', '333', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8967', '333', 'Name', 'Thanh vu');
INSERT INTO wp_cformsdata VALUES('8968', '333', 'City/State', 'Garden grove/ ca');
INSERT INTO wp_cformsdata VALUES('8969', '333', 'Phone', '714-867-4913');
INSERT INTO wp_cformsdata VALUES('8970', '333', 'Email', 'Thanhvu9481@sbcglobal.net');
INSERT INTO wp_cformsdata VALUES('8971', '333', 'How did you hear about us?', 'Radio');
INSERT INTO wp_cformsdata VALUES('8972', '333', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('8973', '333', 'Does the patient have', '-');
INSERT INTO wp_cformsdata VALUES('8974', '333', 'If yes, when did this occur?', 'None');
INSERT INTO wp_cformsdata VALUES('8975', '333', 'Has the patient had an MRI or CAT scan for this?', '');
INSERT INTO wp_cformsdata VALUES('8976', '333', 'Date of most recent scan', '');
INSERT INTO wp_cformsdata VALUES('8977', '333', 'Is there pain in:', 'Back');
INSERT INTO wp_cformsdata VALUES('8978', '333', 'When did the pain begin?', 'About 9 months ago');
INSERT INTO wp_cformsdata VALUES('8979', '333', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8980', '333', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('8981', '333', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8982', '333', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('8983', '333', 'Is there pain, tingling, numbness, or weakness in your:', '-');
INSERT INTO wp_cformsdata VALUES('8984', '333', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('8985', '333', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('8986', '333', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('8987', '333', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8988', '333', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8989', '333', 'Is there pain below knee?', 'No');
INSERT INTO wp_cformsdata VALUES('8990', '333', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('8991', '333', 'Comments, Questions', '');
INSERT INTO wp_cformsdata VALUES('8992', '334', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('8993', '334', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('8994', '334', 'Name', 'Oscar Aviles');
INSERT INTO wp_cformsdata VALUES('8995', '334', 'City/State', 'Pomona CA');
INSERT INTO wp_cformsdata VALUES('8996', '334', 'Phone', '6263675833');
INSERT INTO wp_cformsdata VALUES('8997', '334', 'Email', 'aviles626@live.com');
INSERT INTO wp_cformsdata VALUES('8998', '334', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('8999', '334', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('9000', '334', 'Does the patient have', 'Herniated Disc');
INSERT INTO wp_cformsdata VALUES('9001', '334', 'If yes, when did this occur?', '5/28/2011');
INSERT INTO wp_cformsdata VALUES('9002', '334', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9003', '334', 'Date of most recent scan', '7/14/2011');
INSERT INTO wp_cformsdata VALUES('9004', '334', 'Is there pain in:', 'Leg');
INSERT INTO wp_cformsdata VALUES('9005', '334', 'When did the pain begin?', '5/30/2011');
INSERT INTO wp_cformsdata VALUES('9006', '334', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9007', '334', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('9008', '334', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9009', '334', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('9010', '334', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves');
INSERT INTO wp_cformsdata VALUES('9011', '334', 'Has disc surgery been recommended?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9012', '334', 'Previous Back Surgery?', 'No');
INSERT INTO wp_cformsdata VALUES('9013', '334', 'Date of onset of pain?', '');
INSERT INTO wp_cformsdata VALUES('9014', '334', 'Is there have pain at rest?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9015', '334', 'Is there pain upon wakening?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9016', '334', 'Is there pain below knee?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9017', '334', 'Does the patient have difficulty walking?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9018', '334', 'Comments, Questions', 'I have a L4 L5 herniated disc 9mm * 15mm i have been doing some inversion theropy. the pain did decrease after a couple of weeks of using the inversion table');
INSERT INTO wp_cformsdata VALUES('9019', '335', 'page', 'http://www.painbreakthrough.com/request-consultation/');
INSERT INTO wp_cformsdata VALUES('9020', '335', 'Fieldset1', 'Contact Information');
INSERT INTO wp_cformsdata VALUES('9021', '335', 'Name', 'Maria');
INSERT INTO wp_cformsdata VALUES('9022', '335', 'City/State', 'London');
INSERT INTO wp_cformsdata VALUES('9023', '335', 'Phone', '+447809431359');
INSERT INTO wp_cformsdata VALUES('9024', '335', 'Email', 'chrisovalantia@msn.com');
INSERT INTO wp_cformsdata VALUES('9025', '335', 'How did you hear about us?', 'you tube');
INSERT INTO wp_cformsdata VALUES('9026', '335', 'Fieldset2', 'Medical History Information');
INSERT INTO wp_cformsdata VALUES('9027', '335', 'Does the patient have', 'Bulging Disc');
INSERT INTO wp_cformsdata VALUES('9028', '335', 'If yes, when did this occur?', 'march 2011');
INSERT INTO wp_cformsdata VALUES('9029', '335', 'Has the patient had an MRI or CAT scan for this?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9030', '335', 'Date of most recent scan', 'july 2011');
INSERT INTO wp_cformsdata VALUES('9031', '335', 'Is there pain in:', 'Back,Leg');
INSERT INTO wp_cformsdata VALUES('9032', '335', 'When did the pain begin?', 'march 2011');
INSERT INTO wp_cformsdata VALUES('9033', '335', 'Is there pain everyday?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9034', '335', 'Describe the pain?', 'Severe');
INSERT INTO wp_cformsdata VALUES('9035', '335', 'Is there pain 24 hours a day?', 'Yes');
INSERT INTO wp_cformsdata VALUES('9036', '335', 'If no, number of hours in pain', '');
INSERT INTO wp_cformsdata VALUES('9037', '335', 'Is there pain, tingling, numbness, or weakness in your:', 'buttocks,thighs,legs,calves,feet');
INSERT INTO wp_cformsdata VALUES('9038', '335', 'Has disc surgery been recommended?', 'No');
INSERT INTO wp_cformsdata VALUES('9039', '335', 'Previous Back Surgery?'