<?php
/*
Plugin Name: Altra Web Design Support Pages
Plugin URI: http://www.altramarketing.com
Description: Altra Web Design Support Pages Menu for client instructions
Author: Larry Tartisel
Author URI: http://www.altramarketing.com
*/

// Hook for adding admin menus
add_action('admin_menu', 'mt_add_pages');

// action function for above hook
function mt_add_pages() {

    // Add a new top-level menu (ill-advised):
    add_menu_page(__('Support Pages','support-page'), __('Support Pages','support-page'), 'manage_options', 'mt-top-level-handle', 'mt_toplevel_page' );

    // Add a submenu to the custom top-level menu:
    add_submenu_page('mt-top-level-handle', __('Editing Pages','menu-test'), __('Editing Pages','menu-test'), 'manage_options', 'sub-page', 'mt_sublevel_page');

    // Add a second submenu to the custom top-level menu:
    add_submenu_page('mt-top-level-handle', __('Working with Images','menu-test'), __('Working with Images','menu-test'), 'manage_options', 'sub-page2', 'mt_sublevel_page2');
}


// mt_toplevel_page() displays the page content for the custom Test Toplevel menu
function mt_toplevel_page() {
    echo "<h2>" . __( 'Website Support', 'support-page' ) . "</h2>";

}

// mt_sublevel_page() displays the page content for the first submenu
// of the custom Test Toplevel menu
function mt_sublevel_page() {
    echo "<h2>" . __( 'Editing Pages', 'menu-test' ) . "</h2>";
}

// mt_sublevel_page2() displays the page content for the second submenu
// of the custom Test Toplevel menu
function mt_sublevel_page2() {
    echo "<h2>" . __( 'Working with Images', 'menu-test' ) . "</h2>";
}

?>